/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.api.conformance;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.dao.DaoConfig;
import ca.uhn.fhir.jpa.dao.IFhirSystemDao;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.util.CoverageIgnore;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.hl7.fhir.dstu3.hapi.rest.server.ServerCapabilityStatementProvider;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.CapabilityStatement;
import org.hl7.fhir.dstu3.model.DecimalType;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.Meta;
import org.hl7.fhir.instance.model.api.IBaseDatatype;

public class TempJpaConformanceProviderStu3
extends ServerCapabilityStatementProvider {
    private volatile CapabilityStatement myCachedValue;
    private DaoConfig myDaoConfig;
    private String myImplementationDescription;
    private RestfulServer myRestfulServer;
    private IFhirSystemDao<Bundle, Meta> mySystemDao;

    @CoverageIgnore
    public TempJpaConformanceProviderStu3() {
        super.setCache(false);
    }

    public TempJpaConformanceProviderStu3(RestfulServer theRestfulServer, IFhirSystemDao<Bundle, Meta> theSystemDao, DaoConfig theDaoConfig) {
        super(theRestfulServer);
        this.myRestfulServer = theRestfulServer;
        this.mySystemDao = theSystemDao;
        this.myDaoConfig = theDaoConfig;
        super.setCache(false);
    }

    public CapabilityStatement getServerConformance(HttpServletRequest theRequest) {
        CapabilityStatement retVal = this.myCachedValue;
        Map counts = this.mySystemDao.getResourceCounts();
        FhirContext ctx = this.myRestfulServer.getFhirContext();
        retVal = super.getServerConformance(theRequest);
        for (CapabilityStatement.CapabilityStatementRestComponent nextRest : retVal.getRest()) {
            for (CapabilityStatement.CapabilityStatementRestResourceComponent nextResource : nextRest.getResource()) {
                Long count;
                nextResource.setVersioning(CapabilityStatement.ResourceVersionPolicy.VERSIONEDUPDATE);
                CapabilityStatement.ConditionalDeleteStatus conditionalDelete = nextResource.getConditionalDelete();
                if (conditionalDelete == CapabilityStatement.ConditionalDeleteStatus.MULTIPLE && !this.myDaoConfig.isAllowMultipleDelete()) {
                    nextResource.setConditionalDelete(CapabilityStatement.ConditionalDeleteStatus.SINGLE);
                }
                if ((count = (Long)counts.get(nextResource.getTypeElement().getValueAsString())) != null) {
                    nextResource.addExtension(new Extension("http://hl7api.sourceforge.net/hapi-fhir/res/extdefs.html#resourceCount", (IBaseDatatype)new DecimalType(count.longValue())));
                }
                for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent nextParam : nextResource.getSearchParam()) {
                    if (nextParam.getType() != Enumerations.SearchParamType.REFERENCE) continue;
                }
            }
        }
        this.massage(retVal);
        retVal.getImplementation().setDescription(this.myImplementationDescription);
        this.myCachedValue = retVal;
        return retVal;
    }

    protected void massage(CapabilityStatement theStatement) {
    }

    public void setDaoConfig(DaoConfig myDaoConfig) {
        this.myDaoConfig = myDaoConfig;
    }

    @CoverageIgnore
    public void setImplementationDescription(String theImplDesc) {
        this.myImplementationDescription = theImplDesc;
    }

    public void setRestfulServer(RestfulServer theRestfulServer) {
        this.myRestfulServer = theRestfulServer;
        super.setRestfulServer(theRestfulServer);
    }

    @CoverageIgnore
    public void setSystemDao(IFhirSystemDao<Bundle, Meta> mySystemDao) {
        this.mySystemDao = mySystemDao;
    }
}

