/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.api.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.rest.server.interceptor.InterceptorAdapter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hl7.fhir.dstu3.model.CarePlan;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.HumanName;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Subscription;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SubscriptionSupportBase
extends InterceptorAdapter
implements IServerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionSupportBase.class);

    public void handleSubscriptionResource(Subscription subscription, String subscriptionEndpoint) {
        LOGGER.info(this.prepareLogStatement((IBaseResource)subscription));
        this.sendViaHTTP((IBaseResource)subscription, subscriptionEndpoint);
    }

    public void handleResource(IBaseResource resource, String resourceEndpoint) {
        if (resource instanceof Patient || resource instanceof Observation || resource instanceof CarePlan) {
            if (resourceEndpoint != null) {
                this.sendViaHTTP(resource, resourceEndpoint);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resource messaging is not configured for: " + resource);
            }
        }
    }

    private String prepareLogStatement(IBaseResource iBaseResource) {
        String logString;
        if (iBaseResource instanceof Patient) {
            logString = "\n\r" + ((Object)((Object)this)).getClass().getSimpleName() + " handling Patient " + ((Patient)iBaseResource).getId();
            try {
                logString = logString + "\n\r    with last name " + ((HumanName)((Patient)iBaseResource).getName().get(0)).getFamily();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                logString = logString + "\n\r    birth date " + ((Patient)iBaseResource).getBirthDate().toString();
            }
            catch (Exception exception) {}
        } else if (iBaseResource instanceof Observation) {
            logString = "\n\r" + ((Object)((Object)this)).getClass().getSimpleName() + " handling Observation " + ((Observation)iBaseResource).getId();
            try {
                logString = logString + "\n\r    with code " + ((Coding)((Observation)iBaseResource).getCode().getCoding().get(0)).getCode();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                logString = logString + "\n\r    effective date " + ((Observation)iBaseResource).getEffective().toString();
            }
            catch (Exception exception) {}
        } else if (iBaseResource instanceof Subscription) {
            logString = "\n\r" + ((Object)((Object)this)).getClass().getSimpleName() + " handling Subscription Id:" + ((Subscription)iBaseResource).getId();
            try {
                logString = logString + "\n\r    with criteria " + ((Subscription)iBaseResource).getCriteria();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                logString = logString + "\n\r    status " + ((Subscription)iBaseResource).getStatus();
            }
            catch (Exception exception) {}
        } else {
            logString = "\n\r" + ((Object)((Object)this)).getClass().getSimpleName() + " handling Resource " + iBaseResource.toString();
        }
        return logString;
    }

    private void sendViaHTTP(IBaseResource iBaseResource, String endpoint) {
        HttpPost postRequest = new HttpPost(endpoint);
        postRequest.addHeader("Content-Type", "application/json");
        StringEntity entity = null;
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(bytes);
            FhirContext.forDstu3().newJsonParser().encodeResourceToWriter(iBaseResource, (Writer)writer);
            String jsonString = bytes.toString();
            entity = new StringEntity(bytes.toString());
            postRequest.setEntity((HttpEntity)entity);
        }
        catch (IOException e) {
            LOGGER.error("Error Sending Resource", (Throwable)e);
            return;
        }
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionTimeToLive(30L, TimeUnit.SECONDS).build();
        try {
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)postRequest);
            if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                LOGGER.error("Error Sending Resource.  Status Code: " + closeableHttpResponse.getStatusLine().getStatusCode());
            }
            closeableHttpResponse.close();
        }
        catch (IOException e) {
            LOGGER.error("Error Sending Resource", (Throwable)e);
        }
    }
}

