/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.api.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.hspconsortium.platform.api.model.Sandbox;
import org.hspconsortium.platform.api.service.SandboxService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.stereotype.Component;

@Component
public class TenantInfoRequestMatcher
implements RequestMatcher {
    private static final Logger logger = LoggerFactory.getLogger(TenantInfoRequestMatcher.class);
    private String openContextPath;
    @Autowired
    @Lazy
    private SandboxService sandboxService;
    private List<String> openTeamIds = null;
    private Map<String, RequestMatcher> requestMatcherMap = null;

    public TenantInfoRequestMatcher() {
        logger.info("Configuring TenantInfoRequestMatcher");
    }

    public void reset() {
        this.openTeamIds = null;
        this.requestMatcherMap = null;
        logger.info("TenantInfoRequestMatcher reset");
    }

    public String getOpenContextPath() {
        return this.openContextPath;
    }

    public TenantInfoRequestMatcher setOpenContextPath(String openContextPath) {
        if (this.openContextPath != null && !this.openContextPath.equals(openContextPath)) {
            throw new RuntimeException("Open Context Path cannot be changed once set");
        }
        this.openContextPath = openContextPath;
        return this;
    }

    public boolean isInitialized() {
        return this.openTeamIds != null;
    }

    public void resetOpenTeamIds() {
        if (this.isInitialized()) {
            this.openTeamIds.clear();
            this.requestMatcherMap.clear();
        }
        this.openTeamIds = null;
        this.requestMatcherMap = null;
    }

    public void initOpenTeamIds() {
        this.resetOpenTeamIds();
        this.openTeamIds = new ArrayList<String>();
        this.requestMatcherMap = new HashMap<String, RequestMatcher>();
    }

    public void loadOpenTeamIds() {
        this.initOpenTeamIds();
        for (String teamId : this.findOpenTeamIds(this.sandboxService)) {
            this.addOpenTeamId(teamId);
        }
    }

    public List<String> getOpenTeamIds() {
        if (!this.isInitialized()) {
            this.initOpenTeamIds();
        }
        return this.openTeamIds;
    }

    private Collection<String> findOpenTeamIds(SandboxService sandboxService) {
        return sandboxService.all().stream().filter(teamId -> {
            Sandbox sandbox = sandboxService.get((String)teamId);
            return sandbox.isAllowOpenAccess();
        }).collect(Collectors.toList());
    }

    public RequestMatcher addOpenTeamId(String teamId) {
        if (!this.isInitialized()) {
            this.initOpenTeamIds();
        }
        if (this.requestMatcherMap.containsKey(teamId)) {
            return this.requestMatcherMap.get(teamId);
        }
        this.openTeamIds.add(teamId);
        RequestMatcher result = this.createAntPathRequestMatcher(teamId);
        this.requestMatcherMap.put(teamId, result);
        return result;
    }

    private RequestMatcher createAntPathRequestMatcher(String teamId) {
        return new AntPathRequestMatcher("/" + teamId + "/" + this.openContextPath + "/**", null);
    }

    public void removeOpenTeamId(String teamId) {
        boolean removed;
        if (this.isInitialized() && (removed = this.openTeamIds.remove(teamId))) {
            this.requestMatcherMap.remove(teamId);
        }
    }

    public boolean matches(HttpServletRequest request) {
        logger.info("Evaluating TenantInfoRequestMatcher...");
        boolean result = false;
        if (this.openContextPath != null && this.openContextPath.length() > 0) {
            if (!this.isInitialized()) {
                this.loadOpenTeamIds();
            }
            result = this.requestMatcherMap.values().stream().anyMatch(r -> r.matches(request));
        }
        return result;
    }
}

