/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.api.interceptor;

import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import org.hl7.fhir.dstu3.model.Subscription;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hspconsortium.platform.api.interceptor.SubscriptionSupportBase;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SubscriptionSupportInterceptor
extends SubscriptionSupportBase
implements IServerInterceptor {
    @Value(value="${hspc.platform.messaging.subscriptionSupport.subscriptionEndpoint}")
    private String subscriptionEndpoint;
    @Value(value="${hspc.platform.messaging.subscriptionSupport.resourceEndpoint}")
    private String resourceEndpoint;
    @Value(value="${hspc.platform.messaging.subscriptionSupport.enabled}")
    private String enabled;

    public void incomingRequestPreHandled(RestOperationTypeEnum theOperation, IServerInterceptor.ActionRequestDetails theProcessedRequest) {
        IBaseResource iBaseResource;
        if (Boolean.valueOf(this.enabled).booleanValue() && (iBaseResource = theProcessedRequest.getResource()) != null) {
            if (iBaseResource instanceof Subscription) {
                super.handleSubscriptionResource((Subscription)iBaseResource, this.subscriptionEndpoint);
            } else {
                super.handleResource(iBaseResource, this.resourceEndpoint);
            }
        }
        super.incomingRequestPreHandled(theOperation, theProcessedRequest);
    }
}

