/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hswebframework.ezorm.core.PropertyWrapper;
import org.hswebframework.ezorm.core.SimplePropertyWrapper;
import org.hswebframework.ezorm.core.param.SqlTerm;
import org.hswebframework.ezorm.core.param.Term;

public class Correlation
implements Cloneable,
Comparable<Correlation> {
    private String targetTable;
    private String alias;
    private boolean one2one = true;
    private List<Term> terms = new LinkedList<Term>();
    private Integer index = 0;
    private JOIN join = JOIN.LEFT;
    private String comment;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public Correlation() {
    }

    public Correlation(String target, String alias, String condition) {
        this.targetTable = target;
        this.alias = alias;
        this.terms = new ArrayList<Term>();
        SqlTerm term = new SqlTerm();
        term.setColumn(condition);
        term.setValue((Object)condition);
        term.setSql(condition);
        this.terms.add((Term)term);
    }

    public PropertyWrapper getProperty(String name) {
        return new SimplePropertyWrapper(this.properties.get(name));
    }

    public PropertyWrapper getProperty(String name, Object defaultValue) {
        return new SimplePropertyWrapper(this.properties.getOrDefault(name, defaultValue));
    }

    public PropertyWrapper removeProperty(String name) {
        return new SimplePropertyWrapper(this.properties.remove(name));
    }

    public <T> T setProperty(String property, T value) {
        this.properties.put(property, value);
        return value;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(String targetTable) {
        this.targetTable = targetTable;
    }

    public String getAlias() {
        if (this.alias == null) {
            this.alias = this.targetTable;
        }
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean isOne2one() {
        return this.one2one;
    }

    public void setOne2one(boolean one2one) {
        this.one2one = one2one;
    }

    public List<Term> getTerms() {
        return this.terms;
    }

    public void setTerms(List<Term> terms) {
        this.terms = terms;
    }

    public JOIN getJoin() {
        return this.join;
    }

    public void setJoin(JOIN join) {
        this.join = join;
    }

    public Correlation leftJoin() {
        this.join = JOIN.LEFT;
        return this;
    }

    public Correlation rightJoin() {
        this.join = JOIN.RIGHT;
        return this;
    }

    public Correlation InnerJoin() {
        this.join = JOIN.INNER;
        return this;
    }

    public Correlation FullJoin() {
        this.join = JOIN.FULL;
        return this;
    }

    public Correlation addTerm(Term term) {
        this.terms.add(term);
        return this;
    }

    protected Correlation clone() {
        Correlation correlation = new Correlation();
        correlation.setAlias(this.alias);
        correlation.setJoin(this.join);
        correlation.setOne2one(this.one2one);
        correlation.setIndex(this.index);
        correlation.setTargetTable(this.targetTable);
        this.terms.forEach(term -> correlation.addTerm(term.clone()));
        return correlation;
    }

    @Override
    public int compareTo(Correlation o) {
        return this.index.compareTo(o.index);
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public Integer getIndex() {
        return this.index;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public static enum JOIN {
        LEFT{

            public String toString() {
                return "LEFT JOIN";
            }
        }
        ,
        RIGHT{

            public String toString() {
                return "RIGHT JOIN";
            }
        }
        ,
        FULL{

            public String toString() {
                return "FULL JOIN";
            }
        }
        ,
        INNER{

            public String toString() {
                return "JOIN";
            }
        };

    }
}

