/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.meta.converter;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.Blob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialBlob;
import org.hswebframework.ezorm.core.ValueConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobValueConverter
implements ValueConverter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public Object getData(Object value) {
        if (value instanceof String) {
            value = ((String)value).getBytes();
        }
        if (value instanceof byte[]) {
            try {
                return new SerialBlob((byte[])value);
            }
            catch (SQLException e) {
                return value;
            }
        }
        return value;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getValue(Object data) {
        if (data == null) {
            return null;
        }
        if (!(data instanceof Blob)) return data;
        Blob blobValue = (Blob)data;
        try {
            Throwable throwable = null;
            try (InputStream inputStream = blobValue.getBinaryStream();){
                ObjectInputStream inputStream1 = new ObjectInputStream(inputStream);
                Object object = inputStream1.readObject();
                return object;
            }
            catch (IOException inputStream1) {
                block20: {
                    break block20;
                    catch (ClassNotFoundException e) {
                        this.logger.warn("blob is class,but class not found!", (Throwable)e);
                    }
                }
                byte[] byArray = blobValue.getBytes(0L, (int)blobValue.length());
                return byArray;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            this.logger.warn("blob data error", (Throwable)e);
        }
        return data;
    }
}

