/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.dialect;

import java.sql.JDBCType;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.ezorm.rdb.meta.parser.SqlServer2012TableMetaParser;
import org.hswebframework.ezorm.rdb.meta.parser.TableMetaParser;
import org.hswebframework.ezorm.rdb.render.dialect.DefaultDialect;
import org.hswebframework.utils.StringUtils;

public class MSSQLDialect
extends DefaultDialect {
    public MSSQLDialect() {
        this.defaultDataTypeMapper = meta -> meta.getJdbcType().getName().toLowerCase();
        this.setDataTypeMapper(JDBCType.CHAR, meta -> StringUtils.concat((Object[])new Object[]{"char(", meta.getLength(), ")"}));
        this.setDataTypeMapper(JDBCType.NCHAR, meta -> StringUtils.concat((Object[])new Object[]{"nchar(", meta.getLength(), ")"}));
        this.setDataTypeMapper(JDBCType.VARCHAR, meta -> StringUtils.concat((Object[])new Object[]{"varchar(", meta.getLength(), ")"}));
        this.setDataTypeMapper(JDBCType.NVARCHAR, meta -> StringUtils.concat((Object[])new Object[]{"nvarchar(", meta.getLength(), ")"}));
        this.setDataTypeMapper(JDBCType.TIMESTAMP, meta -> "datetime");
        this.setDataTypeMapper(JDBCType.TIME, meta -> "time");
        this.setDataTypeMapper(JDBCType.DATE, meta -> "date");
        this.setDataTypeMapper(JDBCType.CLOB, meta -> "text");
        this.setDataTypeMapper(JDBCType.LONGVARBINARY, meta -> "varbinary(max)");
        this.setDataTypeMapper(JDBCType.LONGVARCHAR, meta -> "text");
        this.setDataTypeMapper(JDBCType.BLOB, meta -> "varbinary(max)");
        this.setDataTypeMapper(JDBCType.BIGINT, meta -> "bigint");
        this.setDataTypeMapper(JDBCType.DOUBLE, meta -> "double");
        this.setDataTypeMapper(JDBCType.INTEGER, meta -> "int");
        this.setDataTypeMapper(JDBCType.NUMERIC, meta -> StringUtils.concat((Object[])new Object[]{"numeric(", meta.getPrecision(), ",", meta.getScale(), ")"}));
        this.setDataTypeMapper(JDBCType.DECIMAL, meta -> StringUtils.concat((Object[])new Object[]{"numeric(", meta.getPrecision(), ",", meta.getScale(), ")"}));
        this.setDataTypeMapper(JDBCType.TINYINT, meta -> "tinyint");
        this.setDataTypeMapper(JDBCType.BIGINT, meta -> "bigint");
        this.setDataTypeMapper(JDBCType.OTHER, meta -> "other");
        this.setDataTypeMapper(JDBCType.REAL, meta -> "real");
    }

    @Override
    public String getQuoteStart() {
        return "[";
    }

    @Override
    public String getQuoteEnd() {
        return "]";
    }

    @Override
    public String doPaging(String sql, int pageIndex, int pageSize) {
        if (!sql.contains("order") && !sql.contains("ORDER")) {
            sql = sql.concat(" order by 1");
        }
        return sql.concat(" OFFSET " + pageIndex * pageSize + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY");
    }

    @Override
    public boolean columnToUpperCase() {
        return false;
    }

    @Override
    public TableMetaParser getDefaultParser(SqlExecutor sqlExecutor) {
        return new SqlServer2012TableMetaParser(sqlExecutor);
    }
}

