/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.support.mysql;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.hswebframework.ezorm.rdb.executor.EmptySQL;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.render.SqlAppender;
import org.hswebframework.ezorm.rdb.render.SqlRender;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleSQL;
import org.hswebframework.utils.StringUtils;

public class MysqlMetaAlterRender
implements SqlRender<Boolean> {
    private RDBDatabaseMetaData databaseMetaData;

    public MysqlMetaAlterRender(RDBDatabaseMetaData databaseMetaData) {
        this.databaseMetaData = databaseMetaData;
    }

    @Override
    public SQL render(RDBTableMetaData metaData, Boolean executeRemove) {
        RDBTableMetaData old = this.databaseMetaData.getTableMetaData(metaData.getName());
        if (old == null) {
            throw new UnsupportedOperationException("\u65e7\u8868\u4e0d\u5b58\u5728!");
        }
        ArrayList changedField = new ArrayList();
        ArrayList addedField = new ArrayList();
        ArrayList deletedField = new ArrayList();
        RDBTableMetaData oldMeta = old;
        if (executeRemove.booleanValue()) {
            oldMeta.getColumns().forEach(oldField -> {
                RDBColumnMetaData newMeta = metaData.findColumn(oldField.getName());
                if (newMeta == null) {
                    try {
                        newMeta = metaData.getColumns().stream().filter(fieldMetaData -> oldField.getName().equals(fieldMetaData.getProperty("old-name").getValue())).findFirst().get();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                }
                if (newMeta == null || !newMeta.getName().equals(oldField.getName())) {
                    deletedField.add(oldField);
                }
            });
        }
        metaData.getColumns().forEach(newField -> {
            RDBColumnMetaData oldField;
            String oldName = (String)newField.getProperty("old-name").getValue();
            if (oldName == null) {
                oldName = newField.getName();
            }
            if ((oldField = oldMeta.findColumn(oldName)) == null) {
                addedField.add(newField);
            } else if (!(newField.getName().equals(oldField.getName()) && newField.getDataType().equals(oldField.getDataType()) && newField.getComment().equals(oldField.getComment()) && oldField.isNotNull() == newField.isNotNull())) {
                changedField.add(newField);
            }
        });
        ArrayList<String> comments = new ArrayList<String>();
        String newTableComment = metaData.getComment();
        String oldTableComment = old.getComment();
        if (newTableComment == null) {
            newTableComment = "";
        }
        if (oldTableComment == null) {
            oldTableComment = "";
        }
        if (!newTableComment.equals(oldTableComment)) {
            comments.add(String.format("comment='%s'", newTableComment));
        }
        if (addedField.isEmpty() && changedField.isEmpty() && deletedField.isEmpty() && comments.isEmpty()) {
            return new EmptySQL();
        }
        LinkedList addSql = new LinkedList();
        LinkedList changedSql = new LinkedList();
        LinkedList deleteSql = new LinkedList();
        addedField.forEach(field -> {
            SqlAppender append = new SqlAppender();
            append.add("add column ", field.getName(), " ", field.getDataType());
            if (!StringUtils.isNullOrEmpty((Object)field.getProperty("default-value").getValue())) {
                append.add(" default '", field.getProperty("default-value").getValue(), "'");
            }
            if (field.isNotNull()) {
                append.add(" not null ");
            } else {
                append.add(" null ");
            }
            if (!StringUtils.isNullOrEmpty((Object)field.getComment())) {
                append.add(" comment '", field.getComment(), "'");
            }
            addSql.add(append);
        });
        changedField.forEach(field -> {
            String oldName = (String)field.getProperty("old-name").getValue();
            if (oldName == null) {
                oldName = field.getName();
            }
            SqlAppender append = new SqlAppender();
            append.addSpc("change", oldName, field.getName(), field.getDataType());
            if (!StringUtils.isNullOrEmpty((Object)field.getProperty("default-value").getValue())) {
                append.add("default '", field.getProperty("default-value").getValue(), "'");
            }
            if (field.isNotNull()) {
                append.add(" not null ");
            } else {
                append.add(" null ");
            }
            if (!StringUtils.isNullOrEmpty((Object)field.getComment())) {
                append.add(" comment '", field.getComment(), "'");
            }
            changedSql.add(append);
        });
        deletedField.forEach(field -> deleteSql.add(new SqlAppender().add("drop column ", field.getName())));
        LinkedList<SqlAppender> allSql = new LinkedList<SqlAppender>();
        allSql.add(new SqlAppender().addSpc(String.format("alter table `%s`", metaData.getName())));
        allSql.addAll(deleteSql);
        allSql.addAll(addSql);
        allSql.addAll(changedSql);
        if (!comments.isEmpty()) {
            allSql.add(new SqlAppender().add(comments.toArray()));
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < allSql.size(); ++i) {
            SqlAppender sql = (SqlAppender)allSql.get(i);
            if (i > 1) {
                builder.append(",");
            }
            builder.append(sql.toString());
        }
        return new SimpleSQL(builder.toString());
    }
}

