/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import io.helidon.http.ClientResponseHeaders;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.Method;
import io.helidon.webclient.api.ClientRequest;
import io.helidon.webclient.api.HttpClientRequest;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.api.WebClientConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.http4k.client.ExtKt;
import org.http4k.core.Body;
import org.http4k.core.BodyMode;
import org.http4k.core.ParametersKt;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.core.Uri;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JA\u0010\u0004\u001a!\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005j\u0002`\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0087\u0002\u00a2\u0006\u0002\b\u0010J#\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012*\u00020\r2\u0006\u0010\t\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/http4k/client/HelidonClient;", "", "<init>", "()V", "invoke", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "client", "Lio/helidon/webclient/api/WebClient;", "bodyMode", "Lorg/http4k/core/BodyMode;", "create", "makeHelidonRequest", "Lio/helidon/webclient/api/HttpClientRequest;", "kotlin.jvm.PlatformType", "makeHelidonRequest$http4k_client_helidon", "(Lio/helidon/webclient/api/WebClient;Lorg/http4k/core/Request;)Lio/helidon/webclient/api/HttpClientRequest;", "http4k-client-helidon"})
@SourceDebugExtension(value={"SMAP\nHelidonClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelidonClient.kt\norg/http4k/client/HelidonClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,71:1\n216#2:72\n217#2:79\n1557#3:73\n1628#3,3:74\n1485#3:80\n1510#3,3:81\n1513#3,3:91\n1797#3,2:94\n1557#3:96\n1628#3,3:97\n1799#3:100\n37#4,2:77\n381#5,7:84\n*S KotlinDebug\n*F\n+ 1 HelidonClient.kt\norg/http4k/client/HelidonClient\n*L\n62#1:72\n62#1:79\n64#1:73\n64#1:74,3\n66#1:80\n66#1:81,3\n66#1:91,3\n66#1:94,2\n67#1:96\n67#1:97,3\n66#1:100\n64#1:77,2\n66#1:84,7\n*E\n"})
public final class HelidonClient {
    @NotNull
    public static final HelidonClient INSTANCE = new HelidonClient();

    private HelidonClient() {
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final Function1<Request, Response> create(@NotNull WebClient client, @NotNull BodyMode bodyMode) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)bodyMode, (String)"bodyMode");
        return (Function1)new Function1<Request, Response>(client, bodyMode){
            final /* synthetic */ WebClient $client;
            final /* synthetic */ BodyMode $bodyMode;
            {
                this.$client = $client;
                this.$bodyMode = $bodyMode;
            }

            public Response invoke(Request request) {
                Response response;
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                try {
                    HttpClientResponse httpClientResponse = HelidonClient.INSTANCE.makeHelidonRequest$http4k_client_helidon(this.$client, request).submit((Object)request.getBody().getPayload().array());
                    Intrinsics.checkNotNullExpressionValue((Object)httpClientResponse, (String)"submit(...)");
                    response = this.asHttp4k(httpClientResponse);
                }
                catch (IllegalArgumentException e) {
                    String string = e.getLocalizedMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"Failed to get address", (boolean)false, (int)2, null)) {
                        throw e;
                    }
                    response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.UNKNOWN_HOST, (Exception)e), null, (int)2, null);
                }
                catch (UncheckedIOException e) {
                    Response response2;
                    IOException iOException = e.getCause();
                    if (iOException instanceof UnknownHostException) {
                        response2 = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.UNKNOWN_HOST, (Exception)e), null, (int)2, null);
                    } else if (iOException instanceof ConnectException) {
                        response2 = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.UNKNOWN_HOST, (Exception)e), null, (int)2, null);
                    } else if (iOException instanceof SocketTimeoutException) {
                        response2 = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.CLIENT_TIMEOUT, (Exception)e), null, (int)2, null);
                    } else {
                        throw e;
                    }
                    response = response2;
                }
                return response;
            }

            /*
             * WARNING - void declaration
             */
            private final Response asHttp4k(HttpClientResponse $this$asHttp4k) {
                void $this$fold$iv;
                ClientResponseHeaders clientResponseHeaders = $this$asHttp4k.headers();
                Intrinsics.checkNotNullExpressionValue((Object)clientResponseHeaders, (String)"headers(...)");
                Iterable iterable = (Iterable)clientResponseHeaders;
                Response initial$iv = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)new Status($this$asHttp4k.status().code(), $this$asHttp4k.status().reasonPhrase()), null, (int)2, null);
                boolean $i$f$fold = false;
                Response accumulator$iv = initial$iv;
                for (T element$iv : $this$fold$iv) {
                    void header;
                    Header header2 = (Header)element$iv;
                    Response acc = accumulator$iv;
                    boolean bl = false;
                    List list = header.allValues();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"allValues(...)");
                    Iterable $this$fold$iv2 = list;
                    boolean $i$f$fold2 = false;
                    Response accumulator$iv2 = acc;
                    for (T element$iv2 : $this$fold$iv2) {
                        void value;
                        String string = (String)element$iv2;
                        Response acc2 = accumulator$iv2;
                        boolean bl2 = false;
                        String string2 = header.name();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name(...)");
                        accumulator$iv2 = acc2.header(string2, (String)value);
                    }
                    accumulator$iv = accumulator$iv2;
                }
                InputStream inputStream = $this$asHttp4k.inputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream(...)");
                return accumulator$iv.body((Body)this.$bodyMode.invoke((Object)inputStream));
            }
        };
    }

    public static /* synthetic */ Function1 create$default(WebClient webClient, BodyMode bodyMode, int n, Object object) {
        if ((n & 1) != 0) {
            webClient = ((WebClientConfig.Builder)WebClient.builder().followRedirects(false)).build();
        }
        if ((n & 2) != 0) {
            bodyMode = (BodyMode)BodyMode.Memory.INSTANCE;
        }
        return HelidonClient.create(webClient, bodyMode);
    }

    /*
     * WARNING - void declaration
     */
    public final HttpClientRequest makeHelidonRequest$http4k_client_helidon(@NotNull WebClient $this$makeHelidonRequest, @NotNull Request request) {
        Object $this$getOrPut$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Object object;
        HttpClientRequest httpClientRequest;
        Intrinsics.checkNotNullParameter((Object)$this$makeHelidonRequest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ClientRequest clientRequest = ((HttpClientRequest)$this$makeHelidonRequest.method(Method.create((String)request.getMethod().name()))).uri(Uri.copy$default((Uri)request.getUri(), null, null, null, null, null, (String)"", null, (int)95, null).toString());
        HttpClientRequest $this$makeHelidonRequest_u24lambda_u245 = (HttpClientRequest)clientRequest;
        boolean bl = false;
        Map $this$forEach$iv = ParametersKt.toParametersMap((List)ParametersKt.queries((Uri)request.getUri()));
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv.entrySet().iterator();
        while (object2.hasNext()) {
            void $this$toTypedArray$iv;
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = object2.next();
            boolean bl2 = false;
            String name = (String)entry.getKey();
            List values = (List)entry.getValue();
            Iterable iterable = values;
            String string = name;
            HttpClientRequest httpClientRequest2 = $this$makeHelidonRequest_u24lambda_u245;
            boolean $i$f$map = false;
            httpClientRequest = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                void v0 = it;
                collection.add(v0 != null ? StringsKt.replace$default((String)v0, (char)' ', (char)'+', (boolean)false, (int)4, null) : null);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            object = thisCollection$iv.toArray(new String[0]);
            httpClientRequest2.queryParam(string, Arrays.copyOf(object, ((String[])object).length));
        }
        Iterable $this$groupBy$iv = request.getHeaders();
        boolean $i$f$groupBy = false;
        object2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object3;
            Pair it = (Pair)element$iv$iv;
            boolean bl4 = false;
            String key$iv$iv = (String)it.getFirst();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl5 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$fold$iv = destination$iv$iv.entrySet();
        boolean $i$f$fold = false;
        HttpClientRequest accumulator$iv = $this$makeHelidonRequest_u24lambda_u245;
        for (Object element$iv : $this$fold$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry entry = (Map.Entry)element$iv;
            HttpClientRequest acc = accumulator$iv;
            boolean bl6 = false;
            String key = (String)entry.getKey();
            List parameters = (List)entry.getValue();
            String string = key.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            $this$getOrPut$iv$iv$iv = parameters;
            HeaderName headerName = HeaderNames.create((String)string, (String)key);
            httpClientRequest = acc;
            boolean $i$f$map = false;
            void $i$f$mapTo = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair bl3 = (Pair)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl7 = false;
                object.add((String)it.getSecond());
            }
            object = (List)destination$iv$iv2;
            accumulator$iv = (HttpClientRequest)httpClientRequest.header(headerName, (List)object);
        }
        return (HttpClientRequest)clientRequest;
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final Function1<Request, Response> create(@NotNull WebClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return HelidonClient.create$default(client, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final Function1<Request, Response> create() {
        return HelidonClient.create$default(null, null, 3, null);
    }
}

