/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.io.InputStream;
import java.net.ConnectException;
import java.net.CookieStore;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.util.HttpCookieStore;
import org.http4k.client.DualSyncAsyncHttpHandler;
import org.http4k.client.ExtKt;
import org.http4k.client.JettyClient;
import org.http4k.client.JettyClient$invoke$2$sendAsync$;
import org.http4k.core.BodyMode;
import org.http4k.core.HttpMessage;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J3\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\t2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bH\u0086\u0002\u00a8\u0006\r"}, d2={"Lorg/http4k/client/JettyClient;", "", "()V", "defaultHttpClient", "Lorg/eclipse/jetty/client/HttpClient;", "invoke", "Lorg/http4k/client/DualSyncAsyncHttpHandler;", "client", "bodyMode", "Lorg/http4k/core/BodyMode;", "requestModifier", "Lkotlin/Function1;", "Lorg/eclipse/jetty/client/api/Request;", "http4k-client-jetty"})
public final class JettyClient {
    public static final JettyClient INSTANCE;

    @NotNull
    public final DualSyncAsyncHttpHandler invoke(@NotNull HttpClient client, @NotNull BodyMode bodyMode, @NotNull Function1<? super org.eclipse.jetty.client.api.Request, ? extends org.eclipse.jetty.client.api.Request> requestModifier) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)bodyMode, (String)"bodyMode");
        Intrinsics.checkParameterIsNotNull(requestModifier, (String)"requestModifier");
        if (!client.isStarted() && !client.isStarting()) {
            client.start();
        }
        return new DualSyncAsyncHttpHandler(client, bodyMode, requestModifier){
            final /* synthetic */ HttpClient $client;
            final /* synthetic */ BodyMode $bodyMode;
            final /* synthetic */ Function1 $requestModifier;

            public void close() {
                this.$client.stop();
            }

            @NotNull
            public Response invoke(@NotNull Request request) {
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                return this.send(this.$client, request);
            }

            public void invoke(@NotNull Request request, @NotNull Function1<? super Response, Unit> fn) {
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                this.sendAsync(this.$client, request, fn);
            }

            private final Response send(@NotNull HttpClient $this$send, Request request) {
                BodyMode bodyMode;
                org.eclipse.jetty.client.api.Request request2 = this.newRequest($this$send, request);
                boolean bl = false;
                boolean bl2 = false;
                org.eclipse.jetty.client.api.Request $this$with = request2;
                boolean bl3 = false;
                try {
                    Response response;
                    boolean bl4;
                    boolean bl5;
                    ContentResponse contentResponse;
                    bodyMode = this.$bodyMode;
                    if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Memory.INSTANCE)) {
                        contentResponse = $this$with.send();
                        bl5 = false;
                        bl4 = false;
                        ContentResponse it = contentResponse;
                        boolean bl6 = false;
                        ContentResponse contentResponse2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)contentResponse2, (String)"it");
                        Response response2 = this.toHttp4kResponse((org.eclipse.jetty.client.api.Response)contentResponse2);
                        String string = it.getContentAsString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.contentAsString");
                        response = response2.body(string);
                    } else if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Stream.INSTANCE)) {
                        contentResponse = new InputStreamResponseListener();
                        bl5 = false;
                        bl4 = false;
                        ContentResponse $this$run = contentResponse;
                        boolean bl7 = false;
                        $this$with.send((Response.CompleteListener)$this$run);
                        org.eclipse.jetty.client.api.Response response3 = $this$run.get(this.timeoutOrMax($this$with), TimeUnit.MILLISECONDS);
                        Intrinsics.checkExpressionValueIsNotNull((Object)response3, (String)"get(timeoutOrMax(), MILLISECONDS)");
                        Response response4 = this.toHttp4kResponse(response3);
                        InputStream inputStream = $this$run.getInputStream();
                        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"inputStream");
                        response = (Response)HttpMessage.DefaultImpls.body$default((HttpMessage)response4, (InputStream)inputStream, null, (int)2, null);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    bodyMode = response;
                }
                catch (ExecutionException e) {
                    Response response;
                    Throwable throwable = e.getCause();
                    if (throwable instanceof UnknownHostException) {
                        response = Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.Companion.getUNKNOWN_HOST(), (Exception)e), null, (int)2, null);
                    } else if (throwable instanceof ConnectException) {
                        response = Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.Companion.getCONNECTION_REFUSED(), (Exception)e), null, (int)2, null);
                    } else {
                        throw (Throwable)e;
                    }
                    bodyMode = response;
                }
                catch (TimeoutException e) {
                    bodyMode = Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.Companion.getCLIENT_TIMEOUT(), (Exception)e), null, (int)2, null);
                }
                return bodyMode;
            }

            private final void sendAsync(@NotNull HttpClient $this$sendAsync, Request request, Function1<? super Response, Unit> fn) {
                org.eclipse.jetty.client.api.Request request2 = this.newRequest($this$sendAsync, request);
                boolean bl = false;
                boolean bl2 = false;
                org.eclipse.jetty.client.api.Request $this$with = request2;
                boolean bl3 = false;
                BodyMode bodyMode = this.$bodyMode;
                if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Memory.INSTANCE)) {
                    $this$with.send((Response.CompleteListener)new BufferingResponseListener(this, $this$sendAsync, fn){
                        final /* synthetic */ invoke.2 this$0;
                        final /* synthetic */ HttpClient $this_sendAsync$inlined;
                        final /* synthetic */ Function1 $fn$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$this_sendAsync$inlined = httpClient;
                            this.$fn$inlined = function1;
                        }

                        public void onComplete(@NotNull Result result) {
                            Response response;
                            Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                            if (result.isFailed()) {
                                Throwable throwable = result.getFailure();
                                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"result.failure");
                                response = invoke.2.access$asHttp4kResponse(this.this$0, throwable);
                            } else {
                                org.eclipse.jetty.client.api.Response response2 = result.getResponse();
                                Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"result.response");
                                Response response3 = invoke.2.access$toHttp4kResponse(this.this$0, response2);
                                String string = this.getContentAsString();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"contentAsString");
                                response = response3.body(string);
                            }
                            Response response4 = response;
                            this.$fn$inlined.invoke((Object)response4);
                        }
                    });
                } else if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Stream.INSTANCE)) {
                    $this$with.send((Response.CompleteListener)new InputStreamResponseListener(this, $this$sendAsync, fn){
                        final /* synthetic */ invoke.2 this$0;
                        final /* synthetic */ HttpClient $this_sendAsync$inlined;
                        final /* synthetic */ Function1 $fn$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$this_sendAsync$inlined = httpClient;
                            this.$fn$inlined = function1;
                        }

                        public void onHeaders(@NotNull org.eclipse.jetty.client.api.Response response) {
                            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                            super.onHeaders(response);
                            this.$this_sendAsync$inlined.getExecutor().execute(new Runnable(this, response){
                                final /* synthetic */ invoke$2$sendAsync$$inlined$with$lambda$2 this$0;
                                final /* synthetic */ org.eclipse.jetty.client.api.Response $response;
                                {
                                    this.this$0 = var1_1;
                                    this.$response = response;
                                }

                                public final void run() {
                                    Function1 function1 = this.this$0.$fn$inlined;
                                    Response response = invoke.2.access$toHttp4kResponse(this.this$0.this$0, this.$response);
                                    InputStream inputStream = this.this$0.getInputStream();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"inputStream");
                                    function1.invoke((Object)((Response)HttpMessage.DefaultImpls.body$default((HttpMessage)response, (InputStream)inputStream, null, (int)2, null)));
                                }
                            });
                        }

                        public void onFailure(@NotNull org.eclipse.jetty.client.api.Response response, @NotNull Throwable failure) {
                            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                            Intrinsics.checkParameterIsNotNull((Object)failure, (String)"failure");
                            super.onFailure(response, failure);
                            this.$fn$inlined.invoke((Object)invoke.2.access$asHttp4kResponse(this.this$0, failure));
                        }
                    });
                }
            }

            /*
             * WARNING - void declaration
             */
            private final org.eclipse.jetty.client.api.Request newRequest(@NotNull HttpClient $this$newRequest, Request request) {
                void $this$fold$iv;
                Iterable iterable = request.getHeaders();
                org.eclipse.jetty.client.api.Request initial$iv = $this$newRequest.newRequest(request.getUri().toString()).method(request.getMethod().name());
                boolean $i$f$fold = false;
                org.eclipse.jetty.client.api.Request accumulator$iv = initial$iv;
                for (T element$iv : $this$fold$iv) {
                    void $dstr$key$value;
                    Pair pair = (Pair)element$iv;
                    org.eclipse.jetty.client.api.Request memo = accumulator$iv;
                    boolean bl = false;
                    String key = (String)$dstr$key$value.component1();
                    String value = (String)$dstr$key$value.component2();
                    accumulator$iv = memo.header(key, value);
                }
                iterable = accumulator$iv.content((ContentProvider)new InputStreamContentProvider(request.getBody().getStream()));
                Function1 function1 = this.$requestModifier;
                boolean bl = false;
                boolean bl2 = false;
                return (org.eclipse.jetty.client.api.Request)function1.invoke((Object)iterable);
            }

            private final long timeoutOrMax(@NotNull org.eclipse.jetty.client.api.Request $this$timeoutOrMax) {
                return $this$timeoutOrMax.getTimeout() <= 0L ? Long.MAX_VALUE : $this$timeoutOrMax.getTimeout();
            }

            private final Response toHttp4kResponse(@NotNull org.eclipse.jetty.client.api.Response $this$toHttp4kResponse) {
                int n = $this$toHttp4kResponse.getStatus();
                String string = $this$toHttp4kResponse.getReason();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reason");
                Response response = Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)new Status(n, string), null, (int)2, null);
                HttpFields httpFields = $this$toHttp4kResponse.getHeaders();
                Intrinsics.checkExpressionValueIsNotNull((Object)httpFields, (String)"headers");
                return response.headers(this.toHttp4kHeaders(httpFields));
            }

            /*
             * WARNING - void declaration
             */
            private final List<Pair<String, String>> toHttp4kHeaders(@NotNull HttpFields $this$toHttp4kHeaders) {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = (Iterable)$this$toHttp4kHeaders;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    void $this$mapTo$iv$iv;
                    String[] $this$map$iv;
                    HttpField it = (HttpField)element$iv$iv;
                    boolean bl = false;
                    HttpField httpField = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)httpField, (String)"it");
                    Intrinsics.checkExpressionValueIsNotNull((Object)httpField.getValues(), (String)"it.values");
                    boolean $i$f$map = false;
                    String[] stringArray = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    void var16_16 = $this$mapTo$iv$iv;
                    int n = ((void)var16_16).length;
                    for (int i = 0; i < n; ++i) {
                        void hValue;
                        void item$iv$iv;
                        void var20_20 = item$iv$iv = var16_16[i];
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        Pair pair = TuplesKt.to((Object)it.getName(), (Object)hValue);
                        collection.add(pair);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return (List)destination$iv$iv;
            }

            private final Response asHttp4kResponse(@NotNull Throwable $this$asHttp4kResponse) {
                Throwable throwable = $this$asHttp4kResponse;
                return Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)(throwable instanceof TimeoutException ? Status.Companion.getCLIENT_TIMEOUT() : Status.Companion.getSERVICE_UNAVAILABLE()).description("Client Error: caused by " + $this$asHttp4kResponse.getLocalizedMessage()), null, (int)2, null);
            }
            {
                this.$client = $captured_local_variable$0;
                this.$bodyMode = $captured_local_variable$1;
                this.$requestModifier = $captured_local_variable$2;
            }

            public static final /* synthetic */ Response access$asHttp4kResponse(invoke.2 $this, Throwable $this$access_u24asHttp4kResponse) {
                return $this.asHttp4kResponse($this$access_u24asHttp4kResponse);
            }

            public static final /* synthetic */ Response access$toHttp4kResponse(invoke.2 $this, org.eclipse.jetty.client.api.Response $this$access_u24toHttp4kResponse) {
                return $this.toHttp4kResponse($this$access_u24toHttp4kResponse);
            }
        };
    }

    public static /* synthetic */ DualSyncAsyncHttpHandler invoke$default(JettyClient jettyClient, HttpClient httpClient, BodyMode bodyMode, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            httpClient = jettyClient.defaultHttpClient();
        }
        if ((n & 2) != 0) {
            bodyMode = (BodyMode)BodyMode.Memory.INSTANCE;
        }
        if ((n & 4) != 0) {
            function1 = invoke.1.INSTANCE;
        }
        return jettyClient.invoke(httpClient, bodyMode, (Function1<? super org.eclipse.jetty.client.api.Request, ? extends org.eclipse.jetty.client.api.Request>)function1);
    }

    private final HttpClient defaultHttpClient() {
        HttpClient httpClient = new HttpClient();
        boolean bl = false;
        boolean bl2 = false;
        HttpClient $this$apply = httpClient;
        boolean bl3 = false;
        $this$apply.setFollowRedirects(false);
        $this$apply.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        return httpClient;
    }

    private JettyClient() {
    }

    static {
        JettyClient jettyClient;
        INSTANCE = jettyClient = new JettyClient();
    }
}

