/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.io.InputStream;
import java.net.CookieStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.util.HttpCookieStore;
import org.http4k.client.AsyncHttpClient;
import org.http4k.client.ExtKt;
import org.http4k.client.JettyClient$sendAsync$;
import org.http4k.core.BodyMode;
import org.http4k.core.HttpMessage;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u00042\u00020\u0005:\u0001\"B/\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0001\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0002H\u0096\u0002J%\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00022\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\u0001H\u0096\u0002J\f\u0010\u0012\u001a\u00020\u0003*\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J\u0014\u0010\u0015\u001a\u00020\u0003*\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J(\u0010\u0016\u001a\u00020\u000e*\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00022\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\u0001H\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u000bH\u0002J(\u0010\u0019\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001bj\u0002`\u001d0\u001aj\u0002`\u001e*\u00020\u001fH\u0002J\f\u0010 \u001a\u00020\u0003*\u00020!H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/http4k/client/JettyClient;", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "Lorg/http4k/client/AsyncHttpClient;", "client", "Lorg/eclipse/jetty/client/HttpClient;", "bodyMode", "Lorg/http4k/core/BodyMode;", "requestModifier", "Lorg/eclipse/jetty/client/api/Request;", "(Lorg/eclipse/jetty/client/HttpClient;Lorg/http4k/core/BodyMode;Lkotlin/jvm/functions/Function1;)V", "close", "", "invoke", "request", "fn", "asHttp4kResponse", "", "newRequest", "send", "sendAsync", "timeoutOrMax", "", "toHttp4kHeaders", "", "Lkotlin/Pair;", "", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "Lorg/eclipse/jetty/http/HttpFields;", "toHttp4kResponse", "Lorg/eclipse/jetty/client/api/Response;", "Companion", "http4k-client-jetty"})
public final class JettyClient
implements Function1<Request, Response>,
AsyncHttpClient {
    private final HttpClient client;
    private final BodyMode bodyMode;
    private final Function1<org.eclipse.jetty.client.api.Request, org.eclipse.jetty.client.api.Request> requestModifier;
    public static final Companion Companion = new Companion(null);

    public void close() {
        this.client.stop();
    }

    @NotNull
    public Response invoke(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return this.send(this.client, request);
    }

    public void invoke(@NotNull Request request, @NotNull Function1<? super Response, Unit> fn) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
        this.sendAsync(this.client, request, fn);
    }

    private final Response send(@NotNull HttpClient $receiver, Request request) {
        BodyMode bodyMode;
        org.eclipse.jetty.client.api.Request request2;
        org.eclipse.jetty.client.api.Request $receiver2 = request2 = this.newRequest($receiver, request);
        try {
            Response response;
            ContentResponse contentResponse;
            bodyMode = this.bodyMode;
            if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Memory.INSTANCE)) {
                ContentResponse it;
                ContentResponse contentResponse2 = it = (contentResponse = $receiver2.send());
                Intrinsics.checkExpressionValueIsNotNull((Object)contentResponse2, (String)"it");
                Response response2 = this.toHttp4kResponse((org.eclipse.jetty.client.api.Response)contentResponse2);
                String string = it.getContentAsString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.contentAsString");
                response = response2.body(string);
            } else if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Stream.INSTANCE)) {
                ContentResponse $receiver3 = contentResponse = new InputStreamResponseListener();
                $receiver2.send((Response.CompleteListener)$receiver3);
                org.eclipse.jetty.client.api.Response response3 = $receiver3.get(this.timeoutOrMax($receiver2), TimeUnit.MILLISECONDS);
                Intrinsics.checkExpressionValueIsNotNull((Object)response3, (String)"get(timeoutOrMax(), MILLISECONDS)");
                Response response4 = this.toHttp4kResponse(response3);
                InputStream inputStream = $receiver3.getInputStream();
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"inputStream");
                response = (Response)HttpMessage.DefaultImpls.body$default((HttpMessage)response4, (InputStream)inputStream, null, (int)2, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            bodyMode = response;
        }
        catch (TimeoutException e) {
            bodyMode = Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)ExtKt.describeClientError((Status)Status.Companion.getCLIENT_TIMEOUT(), (Exception)e), null, (int)2, null);
        }
        return bodyMode;
    }

    private final void sendAsync(@NotNull HttpClient $receiver, Request request, Function1<? super Response, Unit> fn) {
        org.eclipse.jetty.client.api.Request request2;
        org.eclipse.jetty.client.api.Request $receiver2 = request2 = this.newRequest($receiver, request);
        BodyMode bodyMode = this.bodyMode;
        if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Memory.INSTANCE)) {
            $receiver2.send((Response.CompleteListener)new BufferingResponseListener(this, $receiver, fn){
                final /* synthetic */ JettyClient this$0;
                final /* synthetic */ HttpClient receiver$0$inlined;
                final /* synthetic */ Function1 $fn$inlined;
                {
                    this.this$0 = jettyClient;
                    this.receiver$0$inlined = httpClient;
                    this.$fn$inlined = function1;
                }

                public void onComplete(@NotNull Result result) {
                    Response response;
                    Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                    if (result.isFailed()) {
                        Throwable throwable = result.getFailure();
                        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"result.failure");
                        response = JettyClient.access$asHttp4kResponse(this.this$0, throwable);
                    } else {
                        org.eclipse.jetty.client.api.Response response2 = result.getResponse();
                        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"result.response");
                        Response response3 = JettyClient.access$toHttp4kResponse(this.this$0, response2);
                        String string = this.getContentAsString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"contentAsString");
                        response = response3.body(string);
                    }
                    Response response4 = response;
                    this.$fn$inlined.invoke((Object)response4);
                }
            });
        } else if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Stream.INSTANCE)) {
            $receiver2.send((Response.CompleteListener)new InputStreamResponseListener(this, $receiver, fn){
                final /* synthetic */ JettyClient this$0;
                final /* synthetic */ HttpClient receiver$0$inlined;
                final /* synthetic */ Function1 $fn$inlined;
                {
                    this.this$0 = jettyClient;
                    this.receiver$0$inlined = httpClient;
                    this.$fn$inlined = function1;
                }

                public void onHeaders(@NotNull org.eclipse.jetty.client.api.Response response) {
                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                    super.onHeaders(response);
                    this.receiver$0$inlined.getExecutor().execute(new Runnable(this, response){
                        final /* synthetic */ sendAsync$$inlined$with$lambda$2 this$0;
                        final /* synthetic */ org.eclipse.jetty.client.api.Response $response;
                        {
                            this.this$0 = var1_1;
                            this.$response = response;
                        }

                        public final void run() {
                            Function1 function1 = this.this$0.$fn$inlined;
                            Response response = JettyClient.access$toHttp4kResponse(this.this$0.this$0, this.$response);
                            InputStream inputStream = this.this$0.getInputStream();
                            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"inputStream");
                            function1.invoke((Object)((Response)HttpMessage.DefaultImpls.body$default((HttpMessage)response, (InputStream)inputStream, null, (int)2, null)));
                        }
                    });
                }

                public void onFailure(@NotNull org.eclipse.jetty.client.api.Response response, @NotNull Throwable failure) {
                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                    Intrinsics.checkParameterIsNotNull((Object)failure, (String)"failure");
                    super.onFailure(response, failure);
                    this.$fn$inlined.invoke((Object)JettyClient.access$asHttp4kResponse(this.this$0, failure));
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final org.eclipse.jetty.client.api.Request newRequest(@NotNull HttpClient $receiver, Request request) {
        void $receiver$iv;
        void initial$iv;
        Iterable iterable = request.getHeaders();
        Function1<org.eclipse.jetty.client.api.Request, org.eclipse.jetty.client.api.Request> function1 = $receiver.newRequest(request.getUri().toString()).method(request.getMethod().name());
        org.eclipse.jetty.client.api.Request accumulator$iv = initial$iv;
        for (Object element$iv : $receiver$iv) {
            void $key_value;
            Pair pair = (Pair)element$iv;
            void memo = accumulator$iv;
            String key = (String)$key_value.component1();
            String value = (String)$key_value.component2();
            accumulator$iv = memo.header(key, value);
        }
        iterable = accumulator$iv.content((ContentProvider)new InputStreamContentProvider(request.getBody().getStream()));
        function1 = this.requestModifier;
        return (org.eclipse.jetty.client.api.Request)function1.invoke((Object)iterable);
    }

    private final long timeoutOrMax(@NotNull org.eclipse.jetty.client.api.Request $receiver) {
        return $receiver.getTimeout() <= 0L ? Long.MAX_VALUE : $receiver.getTimeout();
    }

    private final Response toHttp4kResponse(@NotNull org.eclipse.jetty.client.api.Response $receiver) {
        int n = $receiver.getStatus();
        String string = $receiver.getReason();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reason");
        Response response = Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)new Status(n, string), null, (int)2, null);
        HttpFields httpFields = $receiver.getHeaders();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpFields, (String)"headers");
        return response.headers(this.toHttp4kHeaders(httpFields));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, String>> toHttp4kHeaders(@NotNull HttpFields $receiver) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)$receiver;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            void $receiver$iv$iv2;
            Object[] $receiver$iv2;
            HttpField it;
            HttpField httpField = it = (HttpField)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)httpField, (String)"it");
            String[] stringArray = httpField.getValues();
            Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"it.values");
            Object[] objectArray = $receiver$iv2 = (Object[])stringArray;
            Collection destination$iv$iv2 = new ArrayList($receiver$iv2.length);
            for (void item$iv$iv : $receiver$iv$iv2) {
                void hValue;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                Pair pair = TuplesKt.to((Object)it.getName(), (Object)hValue);
                collection.add(pair);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Response asHttp4kResponse(@NotNull Throwable $receiver) {
        Throwable throwable = $receiver;
        Status status = throwable instanceof TimeoutException ? Status.Companion.getCLIENT_TIMEOUT() : Status.Companion.getSERVICE_UNAVAILABLE();
        Throwable throwable2 = $receiver;
        if (throwable2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Exception");
        }
        return Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)ExtKt.describeClientError((Status)status, (Exception)((Exception)throwable2)), null, (int)2, null);
    }

    public JettyClient(@NotNull HttpClient client, @NotNull BodyMode bodyMode, @NotNull Function1<? super org.eclipse.jetty.client.api.Request, ? extends org.eclipse.jetty.client.api.Request> requestModifier) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)bodyMode, (String)"bodyMode");
        Intrinsics.checkParameterIsNotNull(requestModifier, (String)"requestModifier");
        this.client = client;
        this.bodyMode = bodyMode;
        this.requestModifier = requestModifier;
        if (!this.client.isStarted() && !this.client.isStarting()) {
            this.client.start();
        }
    }

    public /* synthetic */ JettyClient(HttpClient httpClient, BodyMode bodyMode, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            httpClient = JettyClient.Companion.defaultHttpClient();
        }
        if ((n & 2) != 0) {
            bodyMode = (BodyMode)BodyMode.Memory.INSTANCE;
        }
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(httpClient, bodyMode, (Function1<? super org.eclipse.jetty.client.api.Request, ? extends org.eclipse.jetty.client.api.Request>)function1);
    }

    public JettyClient() {
        this(null, null, null, 7, null);
    }

    @NotNull
    public static final /* synthetic */ Response access$asHttp4kResponse(JettyClient $this, @NotNull Throwable $receiver) {
        return $this.asHttp4kResponse($receiver);
    }

    @NotNull
    public static final /* synthetic */ Response access$toHttp4kResponse(JettyClient $this, @NotNull org.eclipse.jetty.client.api.Response $receiver) {
        return $this.toHttp4kResponse($receiver);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lorg/http4k/client/JettyClient$Companion;", "", "()V", "defaultHttpClient", "Lorg/eclipse/jetty/client/HttpClient;", "http4k-client-jetty"})
    public static final class Companion {
        private final HttpClient defaultHttpClient() {
            HttpClient httpClient;
            HttpClient $receiver = httpClient = new HttpClient();
            $receiver.setFollowRedirects(false);
            $receiver.setCookieStore((CookieStore)new HttpCookieStore.Empty());
            return httpClient;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

