/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.http4k;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.format.EventDeserializationException;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.format.EventSerializationException;
import io.cloudevents.jackson.JsonFormat;
import io.cloudevents.rw.CloudEventDataMapper;
import io.cloudevents.rw.CloudEventRWException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.CloudeventsExtensionsKt;
import org.http4k.core.ContentType;
import org.http4k.format.ConfigurableJackson;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u0003"}, d2={"cloudEventsFormat", "Lio/cloudevents/core/format/EventFormat;", "Lorg/http4k/format/ConfigurableJackson;", "http4k-cloudevents"})
public final class JacksonFormatKt {
    @NotNull
    public static final EventFormat cloudEventsFormat(@NotNull ConfigurableJackson $this$cloudEventsFormat) {
        Intrinsics.checkNotNullParameter((Object)$this$cloudEventsFormat, (String)"<this>");
        $this$cloudEventsFormat.getMapper().registerModule((Module)JsonFormat.getCloudEventJacksonModule());
        return new EventFormat($this$cloudEventsFormat){
            final /* synthetic */ ConfigurableJackson $this_cloudEventsFormat;
            {
                this.$this_cloudEventsFormat = $receiver;
            }

            public byte[] serialize(@NotNull CloudEvent event) {
                byte[] byArray;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                try {
                    byArray = this.$this_cloudEventsFormat.getMapper().writeValueAsBytes((Object)event);
                }
                catch (JsonProcessingException e) {
                    throw new EventSerializationException((Throwable)e);
                }
                return byArray;
            }

            public CloudEvent deserialize(@NotNull byte[] bytes) {
                CloudEvent cloudEvent2;
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                try {
                    cloudEvent2 = (CloudEvent)this.$this_cloudEventsFormat.getMapper().readValue(bytes, CloudEvent.class);
                }
                catch (IOException e) {
                    throw new EventDeserializationException((Throwable)e);
                }
                return cloudEvent2;
            }

            @NotNull
            public CloudEvent deserialize(@NotNull byte[] bytes, @NotNull CloudEventDataMapper<? extends CloudEventData> mapper) {
                CloudEvent cloudEvent2;
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
                CloudEvent deserialized = this.deserialize(bytes);
                CloudEventData data2 = deserialized.getData();
                if (data2 == null) {
                    Intrinsics.checkNotNull((Object)deserialized);
                    cloudEvent2 = deserialized;
                } else {
                    CloudEvent cloudEvent3;
                    try {
                        cloudEvent3 = CloudEventBuilder.from((CloudEvent)deserialized).withData(mapper.map(data2)).build();
                    }
                    catch (CloudEventRWException e) {
                        throw new EventDeserializationException((Throwable)e);
                    }
                    CloudEvent cloudEvent4 = cloudEvent3;
                    Intrinsics.checkNotNull((Object)cloudEvent4);
                    cloudEvent2 = cloudEvent4;
                }
                return cloudEvent2;
            }

            @NotNull
            public String serializedContentType() {
                return CloudeventsExtensionsKt.getCLOUD_EVENT_JSON(ContentType.Companion).getValue();
            }
        };
    }
}

