// Code generated by Kotshi. Do not edit.
package org.http4k.connect.openai.action

import com.squareup.moshi.JsonAdapter
import com.squareup.moshi.JsonDataException
import com.squareup.moshi.JsonReader
import com.squareup.moshi.JsonWriter
import com.squareup.moshi.Moshi
import com.squareup.moshi.Types.newParameterizedType
import java.io.IOException
import java.lang.StringBuilder
import java.lang.reflect.Constructor
import kotlin.Any
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.apply
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.collections.setOf
import kotlin.jvm.Throws
import kotlin.jvm.Volatile
import kotlin.jvm.`internal`.DefaultConstructorMarker
import org.http4k.connect.model.ModelName
import org.http4k.connect.openai.TokenId
import org.http4k.connect.openai.User
import se.ansman.kotshi.InternalKotshiApi
import se.ansman.kotshi.KotshiUtils.appendNullableError
import se.ansman.kotshi.NamedJsonAdapter

@InternalKotshiApi
@Suppress(
  "DEPRECATION",
  "unused",
  "ClassName",
  "REDUNDANT_PROJECTION",
  "RedundantExplicitType",
  "LocalVariableName",
  "RedundantVisibilityModifier",
  "PLATFORM_CLASS_MAPPED_TO_KOTLIN",
  "IMPLICIT_NOTHING_TYPE_ARGUMENT_IN_RETURN_POSITION",
  "EXPERIMENTAL_API_USAGE",
  "OPT_IN_USAGE",
)
internal class KotshiChatCompletionJsonAdapter(
  moshi: Moshi,
) : NamedJsonAdapter<ChatCompletion>("KotshiJsonAdapter(ChatCompletion)") {
  private val modelAdapter: JsonAdapter<ModelName> = moshi.adapter(
      ModelName::class.javaObjectType,
      setOf(),
      "model"
  )

  private val messagesAdapter: JsonAdapter<List<Message>> = moshi.adapter(
      newParameterizedType(List::class.javaObjectType, Message::class.javaObjectType),
      setOf(),
      "messages"
  )

  private val stopAdapter: JsonAdapter<List<String>?> = moshi.adapter(
      newParameterizedType(List::class.javaObjectType, String::class.javaObjectType),
      setOf(),
      "stop"
  )

  private val logit_biasAdapter: JsonAdapter<Map<TokenId, Double>?> = moshi.adapter(
      newParameterizedType(Map::class.javaObjectType, TokenId::class.javaObjectType,
          Double::class.javaObjectType),
      setOf(),
      "logit_bias"
  )

  private val userAdapter: JsonAdapter<User?> = moshi.adapter(
      User::class.javaObjectType,
      setOf(),
      "user"
  )

  private val response_formatAdapter: JsonAdapter<ResponseFormat?> = moshi.adapter(
      ResponseFormat::class.javaObjectType,
      setOf(),
      "response_format"
  )

  private val toolsAdapter: JsonAdapter<List<Tool>?> = moshi.adapter(
      newParameterizedType(List::class.javaObjectType, Tool::class.javaObjectType),
      setOf(),
      "tools"
  )

  private val tool_choiceAdapter: JsonAdapter<Any?> = moshi.adapter(
      Any::class.javaObjectType,
      setOf(),
      "tool_choice"
  )

  private val stream_optionsAdapter: JsonAdapter<StreamOptions?> = moshi.adapter(
      StreamOptions::class.javaObjectType,
      setOf(),
      "stream_options"
  )

  private val options: JsonReader.Options = JsonReader.Options.of(
      "model",
      "messages",
      "max_tokens",
      "temperature",
      "top_p",
      "n",
      "stop",
      "presence_penalty",
      "frequency_penalty",
      "logit_bias",
      "user",
      "stream",
      "response_format",
      "tools",
      "tool_choice",
      "parallel_tool_calls",
      "service_tier",
      "seed",
      "stream_options"
  )

  @Volatile
  private var defaultConstructor: Constructor<ChatCompletion>? = null

  @Throws(IOException::class)
  override fun toJson(writer: JsonWriter, `value`: ChatCompletion?) {
    if (`value` == null) {
      writer.nullValue()
      return
    }
    writer
      .beginObject()
      .name("model").apply {
        modelAdapter.toJson(this, `value`.model)
      }
      .name("messages").apply {
        messagesAdapter.toJson(this, `value`.messages)
      }
      .name("max_tokens").value(`value`.max_tokens)
      .name("temperature").value(`value`.temperature)
      .name("top_p").value(`value`.top_p)
      .name("n").value(`value`.n)
      .name("stop").apply {
        stopAdapter.toJson(this, `value`.stop)
      }
      .name("presence_penalty").value(`value`.presence_penalty)
      .name("frequency_penalty").value(`value`.frequency_penalty)
      .name("logit_bias").apply {
        logit_biasAdapter.toJson(this, `value`.logit_bias)
      }
      .name("user").apply {
        userAdapter.toJson(this, `value`.user)
      }
      .name("stream").value(`value`.stream)
      .name("response_format").apply {
        response_formatAdapter.toJson(this, `value`.response_format)
      }
      .name("tools").apply {
        toolsAdapter.toJson(this, `value`.tools)
      }
      .name("tool_choice").apply {
        tool_choiceAdapter.toJson(this, `value`.tool_choice)
      }
      .name("parallel_tool_calls").value(`value`.parallel_tool_calls)
      .name("service_tier").value(`value`.service_tier)
      .name("seed").value(`value`.seed)
      .name("stream_options").apply {
        stream_optionsAdapter.toJson(this, `value`.stream_options)
      }
      .endObject()
  }

  @Throws(IOException::class)
  override fun fromJson(reader: JsonReader): ChatCompletion? {
    if (reader.peek() == JsonReader.Token.NULL) return reader.nextNull()

    var mask = -1
    var model: ModelName? = null
    var messages: List<Message>? = null
    var max_tokens: Int? = null
    var temperature: Double = 0.0
    var top_p: Double = 0.0
    var n: Int = 0
    var stop: List<String>? = null
    var presence_penalty: Double = 0.0
    var frequency_penalty: Double = 0.0
    var logit_bias: Map<TokenId, Double>? = null
    var user: User? = null
    var stream: Boolean = false
    var response_format: ResponseFormat? = null
    var tools: List<Tool>? = null
    var tool_choice: Any? = null
    var parallel_tool_calls: Boolean? = null
    var service_tier: String? = null
    var seed: Int? = null
    var stream_options: StreamOptions? = null

    reader.beginObject()
    while (reader.hasNext()) {
      when (reader.selectName(options)) {
        0 -> {
          model = modelAdapter.fromJson(reader)
        }
        1 -> {
          messages = messagesAdapter.fromJson(reader)
        }
        2 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            max_tokens = reader.nextInt()
          }
          // $mask = $mask and (1 shl 2).inv()
          mask = mask and 0xfffffffb.toInt()
        }
        3 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            temperature = reader.nextDouble()
            // $mask = $mask and (1 shl 3).inv()
            mask = mask and 0xfffffff7.toInt()
          }
        }
        4 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            top_p = reader.nextDouble()
            // $mask = $mask and (1 shl 4).inv()
            mask = mask and 0xffffffef.toInt()
          }
        }
        5 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            n = reader.nextInt()
            // $mask = $mask and (1 shl 5).inv()
            mask = mask and 0xffffffdf.toInt()
          }
        }
        6 -> {
          stop = stopAdapter.fromJson(reader)
          // $mask = $mask and (1 shl 6).inv()
          mask = mask and 0xffffffbf.toInt()
        }
        7 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            presence_penalty = reader.nextDouble()
            // $mask = $mask and (1 shl 7).inv()
            mask = mask and 0xffffff7f.toInt()
          }
        }
        8 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            frequency_penalty = reader.nextDouble()
            // $mask = $mask and (1 shl 8).inv()
            mask = mask and 0xfffffeff.toInt()
          }
        }
        9 -> {
          logit_bias = logit_biasAdapter.fromJson(reader)
          // $mask = $mask and (1 shl 9).inv()
          mask = mask and 0xfffffdff.toInt()
        }
        10 -> {
          user = userAdapter.fromJson(reader)
          // $mask = $mask and (1 shl 10).inv()
          mask = mask and 0xfffffbff.toInt()
        }
        11 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            stream = reader.nextBoolean()
            // $mask = $mask and (1 shl 11).inv()
            mask = mask and 0xfffff7ff.toInt()
          }
        }
        12 -> {
          response_format = response_formatAdapter.fromJson(reader)
          // $mask = $mask and (1 shl 12).inv()
          mask = mask and 0xffffefff.toInt()
        }
        13 -> {
          tools = toolsAdapter.fromJson(reader)
          // $mask = $mask and (1 shl 13).inv()
          mask = mask and 0xffffdfff.toInt()
        }
        14 -> {
          tool_choice = tool_choiceAdapter.fromJson(reader)
          // $mask = $mask and (1 shl 14).inv()
          mask = mask and 0xffffbfff.toInt()
        }
        15 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            parallel_tool_calls = reader.nextBoolean()
          }
          // $mask = $mask and (1 shl 15).inv()
          mask = mask and 0xffff7fff.toInt()
        }
        16 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            service_tier = reader.nextString()
          }
          // $mask = $mask and (1 shl 16).inv()
          mask = mask and 0xfffeffff.toInt()
        }
        17 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            seed = reader.nextInt()
          }
          // $mask = $mask and (1 shl 17).inv()
          mask = mask and 0xfffdffff.toInt()
        }
        18 -> {
          stream_options = stream_optionsAdapter.fromJson(reader)
          // $mask = $mask and (1 shl 18).inv()
          mask = mask and 0xfffbffff.toInt()
        }
        -1 -> {
          reader.skipName()
          reader.skipValue()
        }
      }
    }
    reader.endObject()

    var errorBuilder: StringBuilder? = null
    if (model == null) {
      errorBuilder = errorBuilder.appendNullableError("model")
    }
    if (messages == null) {
      errorBuilder = errorBuilder.appendNullableError("messages")
    }
    if (errorBuilder != null) {
      errorBuilder.append(" (at path ").append(reader.path).append(')')
      throw JsonDataException(errorBuilder.toString())
    }

    return if (mask == 0xfff80003.toInt()) {
      ChatCompletion(
          model = model!!,
          messages = messages!!,
          max_tokens = max_tokens,
          temperature = temperature,
          top_p = top_p,
          n = n,
          stop = stop,
          presence_penalty = presence_penalty,
          frequency_penalty = frequency_penalty,
          logit_bias = logit_bias,
          user = user,
          stream = stream,
          response_format = response_format,
          tools = tools,
          tool_choice = tool_choice,
          parallel_tool_calls = parallel_tool_calls,
          service_tier = service_tier,
          seed = seed,
          stream_options = stream_options
      )
    } else {
      // Reflectively invoke the synthetic defaults constructor
      @Suppress("UNCHECKED_CAST")
      val localConstructor: Constructor<ChatCompletion> = this.defaultConstructor ?:
          ChatCompletion::class.java.getDeclaredConstructor(
            ModelName::class.java,
            List::class.java,
            Int::class.javaObjectType,
            Double::class.javaPrimitiveType,
            Double::class.javaPrimitiveType,
            Int::class.javaPrimitiveType,
            List::class.java,
            Double::class.javaPrimitiveType,
            Double::class.javaPrimitiveType,
            Map::class.java,
            User::class.java,
            Boolean::class.javaPrimitiveType,
            ResponseFormat::class.java,
            List::class.java,
            Any::class.java,
            Boolean::class.javaObjectType,
            String::class.java,
            Int::class.javaObjectType,
            StreamOptions::class.java,
            Int::class.javaPrimitiveType,
            DefaultConstructorMarker::class.java
          ).also { this.defaultConstructor = it }
      localConstructor.newInstance(
          model,
          messages,
          max_tokens,
          temperature,
          top_p,
          n,
          stop,
          presence_penalty,
          frequency_penalty,
          logit_bias,
          user,
          stream,
          response_format,
          tools,
          tool_choice,
          parallel_tool_calls,
          service_tier,
          seed,
          stream_options,
          mask,
          /* DefaultConstructorMarker */ null
      )
    }
  }
}
