package org.http4k.connect.openai

import dev.forkhandles.result4k.Result
import kotlin.Any
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.sequences.Sequence
import org.http4k.connect.RemoteFailure
import org.http4k.connect.model.ModelName
import org.http4k.connect.openai.action.ChatCompletion
import org.http4k.connect.openai.action.CompletionResponse
import org.http4k.connect.openai.action.CreateEmbeddings
import org.http4k.connect.openai.action.Embeddings
import org.http4k.connect.openai.action.GenerateImage
import org.http4k.connect.openai.action.GeneratedImage
import org.http4k.connect.openai.action.GetModels
import org.http4k.connect.openai.action.ImageResponseFormat
import org.http4k.connect.openai.action.Message
import org.http4k.connect.openai.action.Models
import org.http4k.connect.openai.action.ResponseFormat
import org.http4k.connect.openai.action.Size
import org.http4k.connect.openai.action.StreamOptions
import org.http4k.connect.openai.action.Tool

/**
 * @see org.http4k.connect.openai.action.ChatCompletion
 */
public fun OpenAI.chatCompletion(
  model: ModelName,
  messages: List<Message>,
  max_tokens: Int? = null,
  temperature: Double,
  top_p: Double,
  n: Int,
  stop: List<String>? = null,
  presence_penalty: Double,
  frequency_penalty: Double,
  logit_bias: Map<TokenId, Double>? = null,
  user: User? = null,
  stream: Boolean,
  response_format: ResponseFormat? = null,
  tools: List<Tool>? = null,
  tool_choice: Any? = null,
  parallel_tool_calls: Boolean? = null,
  service_tier: String? = null,
  seed: Int? = null,
  stream_options: StreamOptions? = null,
): Result<Sequence<CompletionResponse>, RemoteFailure> = invoke(ChatCompletion(model, messages,
    max_tokens, temperature, top_p, n, stop, presence_penalty, frequency_penalty, logit_bias, user,
    stream, response_format, tools, tool_choice, parallel_tool_calls, service_tier, seed,
    stream_options))

/**
 * @see org.http4k.connect.openai.action.ChatCompletion
 */
public fun OpenAI.chatCompletion(
  model: ModelName,
  messages: List<Message>,
  max_tokens: Int,
  stream: Boolean,
): Result<Sequence<CompletionResponse>, RemoteFailure> = invoke(ChatCompletion(model, messages,
    max_tokens, stream))

/**
 * @see org.http4k.connect.openai.action.ChatCompletion
 */
public fun OpenAI.chatCompletion(
  model: ModelName,
  message: Message,
  max_tokens: Int,
  stream: Boolean,
): Result<Sequence<CompletionResponse>, RemoteFailure> = invoke(ChatCompletion(model, message,
    max_tokens, stream))

/**
 * @see org.http4k.connect.openai.action.CreateEmbeddings
 */
public fun OpenAI.createEmbeddings(model: ModelName, input: List<String>):
    Result<Embeddings, RemoteFailure> = invoke(CreateEmbeddings(model, input))

/**
 * @see org.http4k.connect.openai.action.GenerateImage
 */
public fun OpenAI.generateImage(
  prompt: String,
  size: Size,
  response_format: ImageResponseFormat,
  n: Int,
  quality: Quality,
  style: Style,
  user: User? = null,
): Result<GeneratedImage, RemoteFailure> = invoke(GenerateImage(prompt, size, response_format, n,
    quality, style, user))

/**
 * @see org.http4k.connect.openai.action.GenerateImage
 */
public fun OpenAI.generateImage(prompt: String, size: Size): Result<GeneratedImage, RemoteFailure> =
    invoke(GenerateImage(prompt, size))

/**
 * @see org.http4k.connect.openai.action.GetModels
 */
public fun OpenAI.getModels(): Result<Models, RemoteFailure> = invoke(GetModels)
