package org.http4k.connect.amazon.s3

import dev.forkhandles.result4k.Result
import java.io.InputStream
import kotlin.Int
import kotlin.String
import kotlin.Unit
import kotlin.collections.List
import kotlin.sequences.Sequence
import org.http4k.connect.RemoteFailure
import org.http4k.connect.amazon.s3.action.CopyObject
import org.http4k.connect.amazon.s3.action.DeleteBucket
import org.http4k.connect.amazon.s3.action.DeleteObject
import org.http4k.connect.amazon.s3.action.GetObject
import org.http4k.connect.amazon.s3.action.HeadBucket
import org.http4k.connect.amazon.s3.action.HeadObject
import org.http4k.connect.amazon.s3.action.ListObjectsV2
import org.http4k.connect.amazon.s3.action.ObjectList
import org.http4k.connect.amazon.s3.action.PutObject
import org.http4k.connect.amazon.s3.model.BucketKey
import org.http4k.connect.amazon.s3.model.BucketName
import org.http4k.connect.amazon.s3.model.ObjectSummary
import org.http4k.core.Headers

/**
 * @see org.http4k.connect.amazon.s3.action.CopyObject
 */
public fun S3Bucket.copyObject(
  sourceBucket: BucketName,
  source: BucketKey,
  destination: BucketKey,
): Result<Unit, RemoteFailure> = invoke(CopyObject(sourceBucket, source, destination))

/**
 * @see org.http4k.connect.amazon.s3.action.DeleteBucket
 */
public fun S3Bucket.deleteBucket(): Result<Unit?, RemoteFailure> = invoke(DeleteBucket())

/**
 * @see org.http4k.connect.amazon.s3.action.DeleteObject
 */
public fun S3Bucket.deleteObject(key: BucketKey): Result<Unit?, RemoteFailure> =
    invoke(DeleteObject(key))

/**
 * @see org.http4k.connect.amazon.s3.action.GetObject
 */
public fun S3Bucket.getObject(key: BucketKey): Result<InputStream?, RemoteFailure> =
    invoke(GetObject(key))

/**
 * @see org.http4k.connect.amazon.s3.action.HeadBucket
 */
public fun S3Bucket.headBucket(expectedBucketOwner: String? = null): Result<Unit?, RemoteFailure> =
    invoke(HeadBucket(expectedBucketOwner))

/**
 * @see org.http4k.connect.amazon.s3.action.HeadObject
 */
public fun S3Bucket.headObject(key: BucketKey): Result<Unit?, RemoteFailure> =
    invoke(HeadObject(key))

/**
 * @see org.http4k.connect.amazon.s3.action.ListObjectsV2
 */
public fun S3Bucket.listObjectsV2(
  continuationToken: String? = null,
  maxKeys: Int? = null,
  prefix: String? = null,
  delimiter: String? = null,
  encodingType: String? = null,
  expectedBucketOwner: String? = null,
  requestPayer: String? = null,
): Result<ObjectList, RemoteFailure> = invoke(ListObjectsV2(continuationToken, maxKeys, prefix,
    delimiter, encodingType, expectedBucketOwner, requestPayer))

/**
 * @see org.http4k.connect.amazon.s3.action.ListObjectsV2
 */
public fun S3Bucket.listObjectsV2Paginated(
  continuationToken: String? = null,
  maxKeys: Int? = null,
  prefix: String? = null,
  delimiter: String? = null,
  encodingType: String? = null,
  expectedBucketOwner: String? = null,
  requestPayer: String? = null,
): Sequence<Result<List<ObjectSummary>, RemoteFailure>> = org.http4k.connect.paginated(::invoke,
    ListObjectsV2(continuationToken, maxKeys, prefix, delimiter, encodingType, expectedBucketOwner,
    requestPayer))

/**
 * @see org.http4k.connect.amazon.s3.action.PutObject
 */
public fun S3Bucket.putObject(
  key: BucketKey,
  content: InputStream,
  headers: Headers,
): Result<Unit, RemoteFailure> = invoke(PutObject(key, content, headers))
