// Code generated by Kotshi. Do not edit.
package org.http4k.connect.openai.action

import com.squareup.moshi.JsonAdapter
import com.squareup.moshi.JsonDataException
import com.squareup.moshi.JsonReader
import com.squareup.moshi.JsonWriter
import com.squareup.moshi.Moshi
import com.squareup.moshi.Types.newParameterizedType
import java.io.IOException
import java.lang.StringBuilder
import java.lang.reflect.Constructor
import kotlin.Any
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.apply
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.collections.setOf
import kotlin.jvm.Throws
import kotlin.jvm.Volatile
import kotlin.jvm.`internal`.DefaultConstructorMarker
import org.http4k.connect.openai.ModelName
import org.http4k.connect.openai.TokenId
import org.http4k.connect.openai.User
import se.ansman.kotshi.InternalKotshiApi
import se.ansman.kotshi.KotshiUtils.appendNullableError
import se.ansman.kotshi.NamedJsonAdapter

@InternalKotshiApi
@Suppress(
  "DEPRECATION",
  "unused",
  "ClassName",
  "REDUNDANT_PROJECTION",
  "RedundantExplicitType",
  "LocalVariableName",
  "RedundantVisibilityModifier",
  "PLATFORM_CLASS_MAPPED_TO_KOTLIN",
  "IMPLICIT_NOTHING_TYPE_ARGUMENT_IN_RETURN_POSITION",
  "EXPERIMENTAL_API_USAGE",
  "OPT_IN_USAGE",
)
internal class KotshiChatCompletionJsonAdapter(
  moshi: Moshi,
) : NamedJsonAdapter<ChatCompletion>("KotshiJsonAdapter(ChatCompletion)") {
  private val modelAdapter: JsonAdapter<ModelName> = moshi.adapter(
      ModelName::class.javaObjectType,
      setOf(),
      "model"
  )

  private val messagesAdapter: JsonAdapter<List<Message>> = moshi.adapter(
      newParameterizedType(List::class.javaObjectType, Message::class.javaObjectType),
      setOf(),
      "messages"
  )

  private val stopAdapter: JsonAdapter<Any?> = moshi.adapter(
      Any::class.javaObjectType,
      setOf(),
      "stop"
  )

  private val logit_biasAdapter: JsonAdapter<Map<TokenId, Double>?> = moshi.adapter(
      newParameterizedType(Map::class.javaObjectType, TokenId::class.javaObjectType,
          Double::class.javaObjectType),
      setOf(),
      "logit_bias"
  )

  private val userAdapter: JsonAdapter<User?> = moshi.adapter(
      User::class.javaObjectType,
      setOf(),
      "user"
  )

  private val options: JsonReader.Options = JsonReader.Options.of(
      "model",
      "messages",
      "max_tokens",
      "temperature",
      "top_p",
      "n",
      "stream",
      "stop",
      "presence_penalty",
      "frequency_penalty",
      "logit_bias",
      "user"
  )

  @Volatile
  private var defaultConstructor: Constructor<ChatCompletion>? = null

  @Throws(IOException::class)
  public override fun toJson(writer: JsonWriter, `value`: ChatCompletion?): Unit {
    if (`value` == null) {
      writer.nullValue()
      return
    }
    writer
      .beginObject()
      .name("model").apply {
        modelAdapter.toJson(this, `value`.model)
      }
      .name("messages").apply {
        messagesAdapter.toJson(this, `value`.messages)
      }
      .name("max_tokens").value(`value`.max_tokens)
      .name("temperature").value(`value`.temperature)
      .name("top_p").value(`value`.top_p)
      .name("n").value(`value`.n)
      .name("stream").value(`value`.stream)
      .name("stop").apply {
        stopAdapter.toJson(this, `value`.stop)
      }
      .name("presence_penalty").value(`value`.presence_penalty)
      .name("frequency_penalty").value(`value`.frequency_penalty)
      .name("logit_bias").apply {
        logit_biasAdapter.toJson(this, `value`.logit_bias)
      }
      .name("user").apply {
        userAdapter.toJson(this, `value`.user)
      }
      .endObject()
  }

  @Throws(IOException::class)
  public override fun fromJson(reader: JsonReader): ChatCompletion? {
    if (reader.peek() == JsonReader.Token.NULL) return reader.nextNull()

    var mask = -1
    var model: ModelName? = null
    var messages: List<Message>? = null
    var max_tokens: Int = 0
    var temperature: Double = 0.0
    var top_p: Double = 0.0
    var n: Int = 0
    var stream: Boolean = false
    var stop: Any? = null
    var presence_penalty: Double = 0.0
    var frequency_penalty: Double = 0.0
    var logit_bias: Map<TokenId, Double>? = null
    var user: User? = null

    reader.beginObject()
    while (reader.hasNext()) {
      when (reader.selectName(options)) {
        0 -> {
          model = modelAdapter.fromJson(reader)
        }
        1 -> {
          messages = messagesAdapter.fromJson(reader)
        }
        2 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            max_tokens = reader.nextInt()
            // $mask = $mask and (1 shl 2).inv()
            mask = mask and 0xfffffffb.toInt()
          }
        }
        3 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            temperature = reader.nextDouble()
            // $mask = $mask and (1 shl 3).inv()
            mask = mask and 0xfffffff7.toInt()
          }
        }
        4 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            top_p = reader.nextDouble()
            // $mask = $mask and (1 shl 4).inv()
            mask = mask and 0xffffffef.toInt()
          }
        }
        5 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            n = reader.nextInt()
            // $mask = $mask and (1 shl 5).inv()
            mask = mask and 0xffffffdf.toInt()
          }
        }
        6 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            stream = reader.nextBoolean()
            // $mask = $mask and (1 shl 6).inv()
            mask = mask and 0xffffffbf.toInt()
          }
        }
        7 -> {
          stop = stopAdapter.fromJson(reader)
        }
        8 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            presence_penalty = reader.nextDouble()
            // $mask = $mask and (1 shl 8).inv()
            mask = mask and 0xfffffeff.toInt()
          }
        }
        9 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            frequency_penalty = reader.nextDouble()
            // $mask = $mask and (1 shl 9).inv()
            mask = mask and 0xfffffdff.toInt()
          }
        }
        10 -> {
          logit_bias = logit_biasAdapter.fromJson(reader)
          // $mask = $mask and (1 shl 10).inv()
          mask = mask and 0xfffffbff.toInt()
        }
        11 -> {
          user = userAdapter.fromJson(reader)
          // $mask = $mask and (1 shl 11).inv()
          mask = mask and 0xfffff7ff.toInt()
        }
        -1 -> {
          reader.skipName()
          reader.skipValue()
        }
      }
    }
    reader.endObject()

    var errorBuilder: StringBuilder? = null
    if (model == null) {
      errorBuilder = errorBuilder.appendNullableError("model")
    }
    if (messages == null) {
      errorBuilder = errorBuilder.appendNullableError("messages")
    }
    if (errorBuilder != null) {
      errorBuilder.append(" (at path ").append(reader.path).append(')')
      throw JsonDataException(errorBuilder.toString())
    }

    return if (mask == 0xfffff083.toInt()) {
      ChatCompletion(
          model = model!!,
          messages = messages!!,
          max_tokens = max_tokens,
          temperature = temperature,
          top_p = top_p,
          n = n,
          stream = stream,
          stop = stop,
          presence_penalty = presence_penalty,
          frequency_penalty = frequency_penalty,
          logit_bias = logit_bias,
          user = user
      )
    } else {
      // Reflectively invoke the synthetic defaults constructor
      @Suppress("UNCHECKED_CAST")
      val localConstructor: Constructor<ChatCompletion> = this.defaultConstructor ?:
          ChatCompletion::class.java.getDeclaredConstructor(
            ModelName::class.java,
            List::class.java,
            Int::class.javaPrimitiveType,
            Double::class.javaPrimitiveType,
            Double::class.javaPrimitiveType,
            Int::class.javaPrimitiveType,
            Boolean::class.javaPrimitiveType,
            Any::class.java,
            Double::class.javaPrimitiveType,
            Double::class.javaPrimitiveType,
            Map::class.java,
            User::class.java,
            Int::class.javaPrimitiveType,
            DefaultConstructorMarker::class.java
          ).also { this.defaultConstructor = it }
      localConstructor.newInstance(
          model,
          messages,
          max_tokens,
          temperature,
          top_p,
          n,
          stream,
          stop,
          presence_penalty,
          frequency_penalty,
          logit_bias,
          user,
          mask,
          /* DefaultConstructorMarker */ null
      )
    }
  }
}
