package org.http4k.connect.openai

import kotlin.Any
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.collections.List
import kotlin.collections.Map
import org.http4k.connect.openai.action.ChatCompletion
import org.http4k.connect.openai.action.GenerateImage
import org.http4k.connect.openai.action.GetModels
import org.http4k.connect.openai.action.ImageResponseFormat
import org.http4k.connect.openai.action.Message
import org.http4k.connect.openai.action.Size

/**
 * @see org.http4k.connect.openai.action.ChatCompletion
 */
public fun OpenAI.chatCompletion(
  model: ModelName,
  messages: List<Message>,
  max_tokens: Int,
  temperature: Double,
  top_p: Double,
  n: Int,
  stream: Boolean,
  stop: Any? = null,
  presence_penalty: Double,
  frequency_penalty: Double,
  logit_bias: Map<TokenId, Double>? = null,
  user: User? = null,
) = invoke(ChatCompletion(model, messages, max_tokens, temperature, top_p, n, stream, stop,
    presence_penalty, frequency_penalty, logit_bias, user))

/**
 * @see org.http4k.connect.openai.action.ChatCompletion
 */
public fun OpenAI.chatCompletion(model: ModelName, messages: List<Message>) =
    invoke(ChatCompletion(model, messages))

/**
 * @see org.http4k.connect.openai.action.GenerateImage
 */
public fun OpenAI.generateImage(
  prompt: Content,
  size: Size,
  response_format: ImageResponseFormat,
  n: Int,
  user: User? = null,
) = invoke(GenerateImage(prompt, size, response_format, n, user))

/**
 * @see org.http4k.connect.openai.action.GenerateImage
 */
public fun OpenAI.generateImage(prompt: Content, size: Size) = invoke(GenerateImage(prompt, size))

/**
 * @see org.http4k.connect.openai.action.GetModels
 */
public fun OpenAI.getModels() = invoke(GetModels)
