/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.jsonrpc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.core.ContentType;
import org.http4k.core.Filter;
import org.http4k.core.Http4kKt;
import org.http4k.core.HttpKt;
import org.http4k.core.HttpMessage;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.filter.ServerFilters;
import org.http4k.format.Json;
import org.http4k.format.JsonType;
import org.http4k.jsonrpc.ErrorMessage;
import org.http4k.jsonrpc.JsonRpcMethodBinding;
import org.http4k.jsonrpc.JsonRpcRequest;
import org.http4k.lens.BiDiBodyLens;
import org.http4k.lens.ContentNegotiation;
import org.http4k.lens.Failure;
import org.http4k.lens.Header;
import org.http4k.lens.LensFailure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022!\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\tBG\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0003j\u0002`\u000f\u0012\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u00120\u0011\u00a2\u0006\u0002\u0010\u0013J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u00c2\u0003J\u001b\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0003j\u0002`\u000fH\u00c2\u0003J\u001b\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u00120\u0011H\u00c2\u0003JW\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u001a\b\u0002\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0003j\u0002`\u000f2\u001a\b\u0002\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u00120\u0011H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\u0011\u0010$\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0004H\u0096\u0002J\u0017\u0010%\u001a\u0004\u0018\u00018\u00002\u0006\u0010&\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010'J\u001d\u0010(\u001a\u0004\u0018\u00018\u00002\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000*H\u0002\u00a2\u0006\u0002\u0010+J#\u0010,\u001a\u0004\u0018\u00018\u00002\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00028\u00000\u0018H\u0002\u00a2\u0006\u0002\u0010.J!\u0010/\u001a\u00028\u00002\u0006\u00100\u001a\u00020\u000e2\n\b\u0002\u00101\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u00102J\u001d\u00103\u001a\u00028\u00002\u0006\u00104\u001a\u00028\u00002\u0006\u00101\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00105J\t\u00106\u001a\u00020\u0019H\u00d6\u0001J5\u00107\u001a\u0004\u0018\u00018\u0000*\b\u0012\u0004\u0012\u00028\u0000082\u001a\u00109\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u000008\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0003H\u0002\u00a2\u0006\u0002\u0010:J\u0019\u0010;\u001a\u0004\u0018\u00018\u0000*\b\u0012\u0004\u0012\u00028\u00000*H\u0002\u00a2\u0006\u0002\u0010+R \u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0003j\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0014\u001a!\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0017\u001a*\u0012\u0004\u0012\u00020\u0019\u0012 \u0012\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0003j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000`\u001a0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/http4k/jsonrpc/JsonRpcService;", "NODE", "", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "json", "Lorg/http4k/format/Json;", "errorHandler", "", "Lorg/http4k/jsonrpc/ErrorMessage;", "Lorg/http4k/jsonrpc/ErrorHandler;", "bindings", "", "Lorg/http4k/jsonrpc/JsonRpcMethodBinding;", "(Lorg/http4k/format/Json;Lkotlin/jvm/functions/Function1;Ljava/lang/Iterable;)V", "handler", "jsonLens", "Lorg/http4k/lens/BiDiBodyLens;", "methods", "", "", "Lorg/http4k/jsonrpc/JsonRpcHandler;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "invoke", "process", "requestJson", "(Ljava/lang/Object;)Ljava/lang/Object;", "processBatchRequest", "elements", "", "(Ljava/util/List;)Ljava/lang/Object;", "processSingleRequest", "fields", "(Ljava/util/Map;)Ljava/lang/Object;", "renderError", "errorMessage", "id", "(Lorg/http4k/jsonrpc/ErrorMessage;Ljava/lang/Object;)Ljava/lang/Object;", "renderResult", "result", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "toString", "mapIfValid", "Lorg/http4k/jsonrpc/JsonRpcRequest;", "block", "(Lorg/http4k/jsonrpc/JsonRpcRequest;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "processEachAsSingleRequest", "http4k-jsonrpc"})
@SourceDebugExtension(value={"SMAP\nJsonRpcService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonRpcService.kt\norg/http4k/jsonrpc/JsonRpcService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n1549#2:140\n1620#2,3:141\n*S KotlinDebug\n*F\n+ 1 JsonRpcService.kt\norg/http4k/jsonrpc/JsonRpcService\n*L\n35#1:140\n35#1:141,3\n*E\n"})
public final class JsonRpcService<NODE>
implements Function1<Request, Response> {
    @NotNull
    private final Json<NODE> json;
    @NotNull
    private final Function1<Throwable, ErrorMessage> errorHandler;
    @NotNull
    private final Iterable<JsonRpcMethodBinding<NODE, NODE>> bindings;
    @NotNull
    private final BiDiBodyLens<NODE> jsonLens;
    @NotNull
    private final Map<String, Function1<NODE, NODE>> methods;
    @NotNull
    private final Function1<Request, Response> handler;

    /*
     * WARNING - void declaration
     */
    public JsonRpcService(@NotNull Json<NODE> json, @NotNull Function1<? super Throwable, ? extends ErrorMessage> errorHandler, @NotNull Iterable<JsonRpcMethodBinding<NODE, NODE>> bindings) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(json, (String)"json");
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        Intrinsics.checkNotNullParameter(bindings, (String)"bindings");
        this.json = json;
        this.errorHandler = errorHandler;
        this.bindings = bindings;
        this.jsonLens = this.json.body("JSON-RPC request", ContentNegotiation.Companion.getStrictNoDirective()).toLens();
        Iterable<JsonRpcMethodBinding<NODE, NODE>> iterable = this.bindings;
        JsonRpcService jsonRpcService = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonRpcMethodBinding jsonRpcMethodBinding = (JsonRpcMethodBinding)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getName(), it.getHandler()));
        }
        jsonRpcService.methods = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        this.handler = Http4kKt.then((Filter)Http4kKt.then((Filter)ServerFilters.INSTANCE.CatchLensFailure((Function1)new Function1<LensFailure, Response>(this){
            final /* synthetic */ JsonRpcService<NODE> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Response invoke(@NotNull LensFailure lensFailure) {
                Intrinsics.checkNotNullParameter((Object)lensFailure, (String)"<anonymous parameter 0>");
                Function1[] function1Array = new Function1[]{JsonRpcService.access$getJsonLens$p(this.this$0).of(JsonRpcService.renderError$default(this.this$0, ErrorMessage.Companion.getParseError(), null, 2, null))};
                return (Response)HttpKt.with((HttpMessage)((HttpMessage)Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.OK, null, (int)2, null)), (Function1[])function1Array);
            }
        }), JsonRpcService::handler$lambda$1), (Function1)((Function1)new Function1<Request, Response>(this){
            final /* synthetic */ JsonRpcService<NODE> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Response invoke(@NotNull Request it) {
                Response response;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object responseJson = JsonRpcService.access$process(this.this$0, JsonRpcService.access$getJsonLens$p(this.this$0).invoke((HttpMessage)it));
                if (responseJson == null) {
                    Function1[] function1Array = new Function1[]{Header.INSTANCE.getCONTENT_TYPE().of((Object)ContentType.Companion.getAPPLICATION_JSON())};
                    response = (Response)HttpKt.with((HttpMessage)((HttpMessage)Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.NO_CONTENT, null, (int)2, null)), (Function1[])function1Array);
                } else {
                    Function1[] function1Array = new Function1[]{JsonRpcService.access$getJsonLens$p(this.this$0).of(responseJson)};
                    response = (Response)HttpKt.with((HttpMessage)((HttpMessage)Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.OK, null, (int)2, null)), (Function1[])function1Array);
                }
                return response;
            }
        }));
    }

    @NotNull
    public Response invoke(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return (Response)this.handler.invoke((Object)request);
    }

    private final NODE process(NODE requestJson) {
        Object object;
        switch (WhenMappings.$EnumSwitchMapping$0[this.json.typeOf(requestJson).ordinal()]) {
            case 1: {
                object = this.processSingleRequest(MapsKt.toMap((Iterable)this.json.fields(requestJson)));
                break;
            }
            case 2: {
                object = this.processBatchRequest(CollectionsKt.toList((Iterable)this.json.elements(requestJson)));
                break;
            }
            default: {
                object = JsonRpcService.renderError$default(this, ErrorMessage.Companion.getInvalidRequest(), null, 2, null);
            }
        }
        return object;
    }

    private final NODE processSingleRequest(Map<String, ? extends NODE> fields) {
        return this.mapIfValid(new JsonRpcRequest<NODE>(this.json, fields), (Function1)new Function1<JsonRpcRequest<NODE>, NODE>(this){
            final /* synthetic */ JsonRpcService<NODE> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final NODE invoke(@NotNull JsonRpcRequest<NODE> request) {
                Object object;
                Intrinsics.checkNotNullParameter(request, (String)"request");
                try {
                    Object object2;
                    Function1 method = (Function1)JsonRpcService.access$getMethods$p(this.this$0).get(request.getMethod());
                    if (method == null) {
                        object2 = JsonRpcService.access$renderError(this.this$0, ErrorMessage.Companion.getMethodNotFound(), request.getId());
                    } else {
                        Object object3 = request.getParams();
                        if (object3 == null) {
                            object3 = JsonRpcService.access$getJson$p(this.this$0).nullNode();
                        }
                        Object object4 = method.invoke(object3);
                        JsonRpcService<NODE> jsonRpcService = this.this$0;
                        Object $this$invoke_u24lambda_u241 = object4;
                        boolean bl = false;
                        NODE NODE = request.getId();
                        if (NODE != null) {
                            NODE it = NODE;
                            boolean bl2 = false;
                            object2 = JsonRpcService.access$renderResult(jsonRpcService, $this$invoke_u24lambda_u241, it);
                        } else {
                            object2 = null;
                        }
                    }
                    object = object2;
                }
                catch (Exception e) {
                    Object object5;
                    if (e instanceof LensFailure) {
                        ErrorMessage errorMessage;
                        Function1 function1 = JsonRpcService.access$getErrorHandler$p(this.this$0);
                        Exception exception = ((LensFailure)e).getCause();
                        if (exception == null) {
                            exception = e;
                        }
                        if ((errorMessage = (ErrorMessage)function1.invoke((Object)exception)) == null) {
                            errorMessage = ((LensFailure)e).overall() == Failure.Type.Invalid ? ErrorMessage.Companion.getInvalidParams() : ErrorMessage.Companion.getInternalError();
                        }
                        ErrorMessage errorMessage2 = errorMessage;
                        object5 = JsonRpcService.access$renderError(this.this$0, errorMessage2, request.getId());
                    } else {
                        ErrorMessage errorMessage = (ErrorMessage)JsonRpcService.access$getErrorHandler$p(this.this$0).invoke((Object)e);
                        if (errorMessage == null) {
                            errorMessage = ErrorMessage.Companion.getInternalError();
                        }
                        object5 = JsonRpcService.access$renderError(this.this$0, errorMessage, request.getId());
                    }
                    object = object5;
                }
                return (NODE)object;
            }
        });
    }

    private final NODE mapIfValid(JsonRpcRequest<NODE> $this$mapIfValid, Function1<? super JsonRpcRequest<NODE>, ? extends NODE> block) {
        return (NODE)($this$mapIfValid.valid() ? block.invoke($this$mapIfValid) : this.renderError(ErrorMessage.Companion.getInvalidRequest(), $this$mapIfValid.getId()));
    }

    private final NODE processBatchRequest(List<? extends NODE> elements) {
        List<? extends NODE> $this$processBatchRequest_u24lambda_u242 = elements;
        boolean bl = false;
        return (NODE)(!((Collection)$this$processBatchRequest_u24lambda_u242).isEmpty() ? this.processEachAsSingleRequest($this$processBatchRequest_u24lambda_u242) : JsonRpcService.renderError$default(this, ErrorMessage.Companion.getInvalidRequest(), null, 2, null));
    }

    private final NODE processEachAsSingleRequest(List<? extends NODE> $this$processEachAsSingleRequest) {
        return (NODE)this.json.invoke(new Function1<Json<NODE>, NODE>($this$processEachAsSingleRequest, this){
            final /* synthetic */ List<NODE> $this_processEachAsSingleRequest;
            final /* synthetic */ JsonRpcService<NODE> this$0;
            {
                this.$this_processEachAsSingleRequest = $receiver;
                this.this$0 = $receiver2;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final NODE invoke(@NotNull Json<NODE> $this$invoke) {
                Object object;
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Intrinsics.checkNotNullParameter($this$invoke, (String)"$this$invoke");
                Iterable<T> iterable = (Iterable<T>)this.$this_processEachAsSingleRequest;
                JsonRpcService<NODE> jsonRpcService = this.this$0;
                boolean $i$f$mapNotNull = false;
                void var5_5 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    T it = element$iv$iv;
                    boolean bl2 = false;
                    if (JsonRpcService.access$processSingleRequest(jsonRpcService, $this$invoke.typeOf(it) == JsonType.Object ? MapsKt.toMap((Iterable)$this$invoke.fields(it)) : MapsKt.emptyMap()) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable<T> it = iterable = (List)destination$iv$iv;
                boolean bl = false;
                Iterable<T> iterable2 = !((Collection)it).isEmpty() ? iterable : null;
                if (iterable2 != null) {
                    it = iterable2;
                    boolean bl4 = false;
                    object = $this$invoke.array((Iterable)it);
                } else {
                    object = null;
                }
                return (NODE)object;
            }
        });
    }

    private final NODE renderResult(NODE result, NODE id) {
        return (NODE)this.json.invoke(new Function1<Json<NODE>, NODE>(result, id){
            final /* synthetic */ NODE $result;
            final /* synthetic */ NODE $id;
            {
                this.$result = $result;
                this.$id = $id;
                super(1);
            }

            @NotNull
            public final NODE invoke(@NotNull Json<NODE> $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, (String)"$this$invoke");
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"jsonrpc", (Object)$this$invoke.string("2.0")), TuplesKt.to((Object)"result", this.$result), TuplesKt.to((Object)"id", this.$id)};
                return (NODE)$this$invoke.obj(pairArray);
            }
        });
    }

    private final NODE renderError(ErrorMessage errorMessage, NODE id) {
        return (NODE)this.json.invoke(new Function1<Json<NODE>, NODE>(errorMessage, id){
            final /* synthetic */ ErrorMessage $errorMessage;
            final /* synthetic */ NODE $id;
            {
                this.$errorMessage = $errorMessage;
                this.$id = $id;
                super(1);
            }

            @NotNull
            public final NODE invoke(@NotNull Json<NODE> $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, (String)"$this$invoke");
                Pair[] pairArray = new Pair[3];
                pairArray[0] = TuplesKt.to((Object)"jsonrpc", (Object)$this$invoke.string("2.0"));
                pairArray[1] = TuplesKt.to((Object)"error", this.$errorMessage.invoke($this$invoke));
                Object object = this.$id;
                if (object == null) {
                    object = $this$invoke.nullNode();
                }
                pairArray[2] = TuplesKt.to((Object)"id", object);
                return (NODE)$this$invoke.obj(pairArray);
            }
        });
    }

    static /* synthetic */ Object renderError$default(JsonRpcService jsonRpcService, ErrorMessage errorMessage, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return jsonRpcService.renderError(errorMessage, object);
    }

    private final Json<NODE> component1() {
        return this.json;
    }

    private final Function1<Throwable, ErrorMessage> component2() {
        return this.errorHandler;
    }

    private final Iterable<JsonRpcMethodBinding<NODE, NODE>> component3() {
        return this.bindings;
    }

    @NotNull
    public final JsonRpcService<NODE> copy(@NotNull Json<NODE> json, @NotNull Function1<? super Throwable, ? extends ErrorMessage> errorHandler, @NotNull Iterable<JsonRpcMethodBinding<NODE, NODE>> bindings) {
        Intrinsics.checkNotNullParameter(json, (String)"json");
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        Intrinsics.checkNotNullParameter(bindings, (String)"bindings");
        return new JsonRpcService<NODE>(json, errorHandler, bindings);
    }

    public static /* synthetic */ JsonRpcService copy$default(JsonRpcService jsonRpcService, Json json, Function1 function1, Iterable iterable, int n, Object object) {
        if ((n & 1) != 0) {
            json = jsonRpcService.json;
        }
        if ((n & 2) != 0) {
            function1 = jsonRpcService.errorHandler;
        }
        if ((n & 4) != 0) {
            iterable = jsonRpcService.bindings;
        }
        return jsonRpcService.copy(json, function1, iterable);
    }

    @NotNull
    public String toString() {
        return "JsonRpcService(json=" + this.json + ", errorHandler=" + this.errorHandler + ", bindings=" + this.bindings + ')';
    }

    public int hashCode() {
        int result = this.json.hashCode();
        result = result * 31 + this.errorHandler.hashCode();
        result = result * 31 + this.bindings.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JsonRpcService)) {
            return false;
        }
        JsonRpcService jsonRpcService = (JsonRpcService)other;
        if (!Intrinsics.areEqual(this.json, jsonRpcService.json)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.errorHandler, jsonRpcService.errorHandler)) {
            return false;
        }
        return Intrinsics.areEqual(this.bindings, jsonRpcService.bindings);
    }

    private static final Function1 handler$lambda$1(Function1 next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return (Function1)new Function1<Request, Response>((Function1<? super Request, ? extends Response>)next){
            final /* synthetic */ Function1<Request, Response> $next;
            {
                this.$next = $next;
                super(1);
            }

            @NotNull
            public final Response invoke(@NotNull Request it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getMethod() == Method.POST ? (Response)this.$next.invoke((Object)it) : Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.METHOD_NOT_ALLOWED, null, (int)2, null);
            }
        };
    }

    public static final /* synthetic */ Map access$getMethods$p(JsonRpcService $this) {
        return $this.methods;
    }

    public static final /* synthetic */ Object access$renderError(JsonRpcService $this, ErrorMessage errorMessage, Object id) {
        return $this.renderError(errorMessage, id);
    }

    public static final /* synthetic */ Json access$getJson$p(JsonRpcService $this) {
        return $this.json;
    }

    public static final /* synthetic */ Function1 access$getErrorHandler$p(JsonRpcService $this) {
        return $this.errorHandler;
    }

    public static final /* synthetic */ Object access$renderResult(JsonRpcService $this, Object result, Object id) {
        return $this.renderResult(result, id);
    }

    public static final /* synthetic */ Object access$processSingleRequest(JsonRpcService $this, Map fields) {
        return $this.processSingleRequest(fields);
    }

    public static final /* synthetic */ BiDiBodyLens access$getJsonLens$p(JsonRpcService $this) {
        return $this.jsonLens;
    }

    public static final /* synthetic */ Object access$process(JsonRpcService $this, Object requestJson) {
        return $this.process(requestJson);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonType.values().length];
            try {
                nArray[JsonType.Object.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonType.Array.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

