/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.server.Http4kChannelHandler;
import org.http4k.server.Http4kServer;
import org.http4k.server.Netty;
import org.http4k.server.PolyServerConfig;
import org.http4k.server.WebSocketServerHandler;
import org.http4k.sse.Sse;
import org.http4k.websocket.Websocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\u0084\u0001\u0010\u000e\u001a\u00020\u000f2\u001a\u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0011j\u0004\u0018\u0001`\u00142.\u0010\u0015\u001a*\u0012\u0004\u0012\u00020\u0012\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0011j\u0004\u0018\u0001`\u0018\u0018\u00010\u0011j\u0004\u0018\u0001`\u00192.\u0010\u001a\u001a*\u0012\u0004\u0012\u00020\u0012\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0011j\u0004\u0018\u0001`\u001c\u0018\u00010\u0011j\u0004\u0018\u0001`\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"Lorg/http4k/server/Netty;", "Lorg/http4k/server/PolyServerConfig;", "port", "", "(I)V", "getPort", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toServer", "Lorg/http4k/server/Http4kServer;", "httpHandler", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "wsHandler", "Lorg/http4k/websocket/Websocket;", "", "Lorg/http4k/websocket/WsConsumer;", "Lorg/http4k/websocket/WsHandler;", "sse", "Lorg/http4k/sse/Sse;", "Lorg/http4k/sse/SseConsumer;", "Lorg/http4k/sse/SseHandler;", "toString", "", "http4k-server-netty"})
public final class Netty
implements PolyServerConfig {
    private final int port;

    @NotNull
    public Http4kServer toServer(@Nullable Function1<? super Request, ? extends Response> httpHandler, @Nullable Function1<? super Request, ? extends Function1<? super Websocket, Unit>> wsHandler, @Nullable Function1<? super Request, ? extends Function1<? super Sse, Unit>> sse) {
        return new Http4kServer(this, wsHandler, httpHandler, sse){
            private final NioEventLoopGroup masterGroup;
            private final NioEventLoopGroup workerGroup;
            private ChannelFuture closeFuture;
            private InetSocketAddress address;
            final /* synthetic */ Netty this$0;
            final /* synthetic */ Function1 $wsHandler;
            final /* synthetic */ Function1 $httpHandler;
            final /* synthetic */ Function1 $sse;

            @NotNull
            public Http4kServer start() {
                toServer.1 var1_1 = this;
                boolean bl = false;
                boolean bl2 = false;
                toServer.1 $this$apply = var1_1;
                boolean bl3 = false;
                ServerBootstrap bootstrap = new ServerBootstrap();
                ((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)$this$apply.masterGroup, (EventLoopGroup)$this$apply.workerGroup).channelFactory((ChannelFactory)toServer.start.1.1.INSTANCE)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this){
                    final /* synthetic */ toServer.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public void initChannel(@NotNull SocketChannel ch) {
                        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                        ch.pipeline().addLast("codec", (ChannelHandler)new HttpServerCodec());
                        ch.pipeline().addLast("keepAlive", (ChannelHandler)new HttpServerKeepAliveHandler());
                        ch.pipeline().addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(Integer.MAX_VALUE));
                        if (this.this$0.$wsHandler != null) {
                            ch.pipeline().addLast("websocket", (ChannelHandler)new WebSocketServerHandler((Function1<? super Request, ? extends Function1<? super Websocket, Unit>>)this.this$0.$wsHandler));
                        }
                        ch.pipeline().addLast("streamer", (ChannelHandler)new ChunkedWriteHandler());
                        if (this.this$0.$httpHandler != null) {
                            ch.pipeline().addLast("httpHandler", (ChannelHandler)new Http4kChannelHandler((Function1<? super Request, ? extends Response>)this.this$0.$httpHandler));
                        }
                    }
                }).option(ChannelOption.SO_BACKLOG, (Object)1000)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
                Channel channel = bootstrap.bind(this.this$0.getPort()).sync().channel();
                SocketAddress socketAddress = channel.localAddress();
                if (socketAddress == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.net.InetSocketAddress");
                }
                $this$apply.address = (InetSocketAddress)socketAddress;
                $this$apply.closeFuture = channel.closeFuture();
                return var1_1;
            }

            @NotNull
            public toServer.1 stop() {
                toServer.1 var1_1 = this;
                boolean bl = false;
                boolean bl2 = false;
                toServer.1 $this$apply = var1_1;
                boolean bl3 = false;
                ChannelFuture channelFuture = $this$apply.closeFuture;
                if (channelFuture != null) {
                    channelFuture.cancel(false);
                }
                $this$apply.workerGroup.shutdownGracefully();
                $this$apply.masterGroup.shutdownGracefully();
                return var1_1;
            }

            public int port() {
                int n;
                if (this.this$0.getPort() > 0) {
                    n = this.this$0.getPort();
                } else {
                    InetSocketAddress inetSocketAddress = this.address;
                    if (inetSocketAddress == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"address");
                    }
                    n = inetSocketAddress.getPort();
                }
                return n;
            }
            {
                this.this$0 = this$0;
                this.$wsHandler = $captured_local_variable$1;
                this.$httpHandler = $captured_local_variable$2;
                this.$sse = $captured_local_variable$3;
                if ($captured_local_variable$3 != null) {
                    throw (Throwable)new UnsupportedOperationException("Netty does not support sse");
                }
                this.masterGroup = new NioEventLoopGroup();
                this.workerGroup = new NioEventLoopGroup();
            }

            public void block() {
                Http4kServer.DefaultImpls.block((Http4kServer)this);
            }

            public void close() {
                Http4kServer.DefaultImpls.close((Http4kServer)this);
            }
        };
    }

    public final int getPort() {
        return this.port;
    }

    public Netty(int port) {
        this.port = port;
    }

    public /* synthetic */ Netty(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 8000;
        }
        this(n);
    }

    public Netty() {
        this(0, 1, null);
    }

    @NotNull
    public Http4kServer toServer(@NotNull Function1<? super Request, ? extends Response> http) {
        Intrinsics.checkNotNullParameter(http, (String)"http");
        return PolyServerConfig.DefaultImpls.toServer((PolyServerConfig)this, http);
    }

    @NotNull
    public Http4kServer toSseServer(@NotNull Function1<? super Request, ? extends Function1<? super Sse, Unit>> sse) {
        Intrinsics.checkNotNullParameter(sse, (String)"sse");
        return PolyServerConfig.DefaultImpls.toSseServer((PolyServerConfig)this, sse);
    }

    @NotNull
    public Http4kServer toWsServer(@NotNull Function1<? super Request, ? extends Function1<? super Websocket, Unit>> ws) {
        Intrinsics.checkNotNullParameter(ws, (String)"ws");
        return PolyServerConfig.DefaultImpls.toWsServer((PolyServerConfig)this, ws);
    }

    public final int component1() {
        return this.port;
    }

    @NotNull
    public final Netty copy(int port) {
        return new Netty(port);
    }

    public static /* synthetic */ Netty copy$default(Netty netty, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = netty.port;
        }
        return netty.copy(n);
    }

    @NotNull
    public String toString() {
        return "Netty(port=" + this.port + ")";
    }

    public int hashCode() {
        return Integer.hashCode(this.port);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Netty)) break block3;
                Netty netty = (Netty)object;
                if (this.port != netty.port) break block3;
            }
            return true;
        }
        return false;
    }
}

