/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Body;
import org.http4k.core.Filter;
import org.http4k.core.HeadersKt;
import org.http4k.core.Http4kKt;
import org.http4k.core.MemoryBody;
import org.http4k.core.Method;
import org.http4k.core.ParametersKt;
import org.http4k.core.Request;
import org.http4k.core.RequestSource;
import org.http4k.core.Response;
import org.http4k.core.Uri;
import org.http4k.filter.ServerFilters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0016\u0010\u000f\u001a\u00020\u0005*\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/http4k/server/Http4kChannelHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lio/netty/handler/codec/http/FullHttpRequest;", "handler", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "(Lkotlin/jvm/functions/Function1;)V", "safeHandler", "channelRead0", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "request", "asRequest", "address", "Ljava/net/InetSocketAddress;", "http4k-server-netty"})
public final class Http4kChannelHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    @NotNull
    private final Function1<Request, Response> safeHandler;

    public Http4kChannelHandler(@NotNull Function1<? super Request, ? extends Response> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.safeHandler = Http4kKt.then((Filter)ServerFilters.CatchAll.invoke$default((ServerFilters.CatchAll)ServerFilters.CatchAll.INSTANCE, null, (int)1, null), handler);
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        SocketAddress socketAddress = ctx.channel().remoteAddress();
        InetSocketAddress address = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        Response response = (Response)this.safeHandler.invoke((Object)this.asRequest(request, address));
        if (response.getBody() instanceof MemoryBody) {
            DefaultFullHttpResponse defaultFullHttpResponse;
            ByteBuf byteBuf = Unpooled.wrappedBuffer((ByteBuffer)response.getBody().getPayload());
            DefaultFullHttpResponse $this$channelRead0_u24lambda_u2d1 = defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(response.getStatus().getCode(), response.getStatus().getDescription()), byteBuf);
            boolean bl = false;
            Map $this$forEach$iv = ParametersKt.toParametersMap((List)response.getHeaders());
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl2 = false;
                String key = (String)entry.getKey();
                List values = (List)entry.getValue();
                $this$channelRead0_u24lambda_u2d1.headers().set(key, (Iterable)values);
            }
            $this$channelRead0_u24lambda_u2d1.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)byteBuf.readableBytes());
            $this$channelRead0_u24lambda_u2d1.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            DefaultFullHttpResponse httpResponse = defaultFullHttpResponse;
            ctx.writeAndFlush((Object)httpResponse);
        } else {
            DefaultHttpResponse defaultHttpResponse;
            DefaultHttpResponse $this$channelRead0_u24lambda_u2d3 = defaultHttpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(response.getStatus().getCode(), response.getStatus().getDescription()));
            boolean bl = false;
            Map $this$forEach$iv = ParametersKt.toParametersMap((List)response.getHeaders());
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl3 = false;
                String key = (String)entry.getKey();
                List values = (List)entry.getValue();
                $this$channelRead0_u24lambda_u2d3.headers().set(key, (Iterable)values);
            }
            $this$channelRead0_u24lambda_u2d3.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            DefaultHttpResponse httpResponse = defaultHttpResponse;
            ctx.write((Object)httpResponse);
            ctx.write((Object)new ChunkedStream(response.getBody().getStream()));
            ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Request asRequest(FullHttpRequest $this$asRequest, InetSocketAddress address) {
        InetSocketAddress inetSocketAddress;
        block4: {
            Request baseRequest;
            block3: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                String string = $this$asRequest.method().name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method().name()");
                Method method = Method.valueOf((String)string);
                String string2 = $this$asRequest.uri();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri()");
                Request request = Request.Companion.create$default((Request.Companion)Request.Companion, (Method)method, (Uri)Uri.Companion.of(string2), null, (int)4, null);
                HttpHeaders httpHeaders = $this$asRequest.headers();
                Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"headers()");
                Iterable iterable = (Iterable)httpHeaders;
                Request request2 = request;
                boolean $i$f$map = false;
                void var6_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Map.Entry entry = (Map.Entry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(TuplesKt.to(it.getKey(), it.getValue()));
                }
                baseRequest = request2.headers((List)destination$iv$iv).body(Body.Companion.create((InputStream)new ByteBufInputStream($this$asRequest.content()), HeadersKt.safeLong((String)$this$asRequest.headers().get("Content-Length"))));
                inetSocketAddress = address;
                if (inetSocketAddress == null) break block3;
                InetSocketAddress it = inetSocketAddress;
                boolean bl = false;
                String string3 = it.getAddress().getHostAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.address.hostAddress");
                Request request3 = baseRequest.source(new RequestSource(string3, Integer.valueOf(it.getPort()), null, 4, null));
                inetSocketAddress = request3;
                if (request3 != null) break block4;
            }
            inetSocketAddress = baseRequest;
        }
        return inetSocketAddress;
    }
}

