/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Body;
import org.http4k.core.Request;
import org.http4k.core.StreamBody;
import org.http4k.server.Http4kWsChannelHandler;
import org.http4k.websocket.PushPullAdaptingWebSocket;
import org.http4k.websocket.Websocket;
import org.http4k.websocket.WsMessage;
import org.http4k.websocket.WsStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/http4k/server/Http4kWsChannelHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lio/netty/handler/codec/http/websocketx/WebSocketFrame;", "wSocket", "Lkotlin/Function1;", "Lorg/http4k/websocket/Websocket;", "", "Lorg/http4k/websocket/WsConsumer;", "upgradeRequest", "Lorg/http4k/core/Request;", "(Lkotlin/jvm/functions/Function1;Lorg/http4k/core/Request;)V", "normalClose", "", "websocket", "Lorg/http4k/websocket/PushPullAdaptingWebSocket;", "channelRead0", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "msg", "exceptionCaught", "cause", "", "handlerAdded", "handlerRemoved", "http4k-server-netty"})
public final class Http4kWsChannelHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    @NotNull
    private final Function1<Websocket, Unit> wSocket;
    @NotNull
    private final Request upgradeRequest;
    @Nullable
    private PushPullAdaptingWebSocket websocket;
    private boolean normalClose;

    public Http4kWsChannelHandler(@NotNull Function1<? super Websocket, Unit> wSocket, @NotNull Request upgradeRequest) {
        Intrinsics.checkNotNullParameter(wSocket, (String)"wSocket");
        Intrinsics.checkNotNullParameter((Object)upgradeRequest, (String)"upgradeRequest");
        this.wSocket = wSocket;
        this.upgradeRequest = upgradeRequest;
    }

    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Object object = this.upgradeRequest;
        object = new PushPullAdaptingWebSocket(ctx, this, (Request)object){
            final /* synthetic */ ChannelHandlerContext $ctx;
            final /* synthetic */ Http4kWsChannelHandler this$0;
            {
                this.$ctx = $ctx;
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void send(@NotNull WsMessage message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                if (message.getBody() instanceof StreamBody) {
                    ByteBuf byteBuf;
                    Closeable closeable = message.getBody().getStream();
                    ChannelHandlerContext channelHandlerContext = this.$ctx;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl = false;
                        byteBuf = Unpooled.wrappedBuffer((byte[])ByteStreamsKt.readBytes((InputStream)it));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    ByteBuf byteBuf2 = byteBuf;
                    channelHandlerContext.writeAndFlush((Object)new BinaryWebSocketFrame(byteBuf2));
                } else {
                    this.$ctx.writeAndFlush((Object)new TextWebSocketFrame(message.bodyString()));
                }
            }

            public void close(@NotNull WsStatus status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                GenericFutureListener[] genericFutureListenerArray = new GenericFutureListener[]{(GenericFutureListener)((ChannelFutureListener)arg_0 -> handlerAdded.1.close$lambda-1(this.this$0, status, arg_0)), (GenericFutureListener)ChannelFutureListener.CLOSE};
                this.$ctx.writeAndFlush((Object)new CloseWebSocketFrame(status.getCode(), status.getDescription())).addListeners(genericFutureListenerArray);
            }

            private static final void close$lambda-1(Http4kWsChannelHandler this$0, WsStatus $status, ChannelFuture it) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$status, (String)"$status");
                    Http4kWsChannelHandler.access$setNormalClose$p(this$0, true);
                    PushPullAdaptingWebSocket pushPullAdaptingWebSocket = Http4kWsChannelHandler.access$getWebsocket$p(this$0);
                    if (pushPullAdaptingWebSocket == null) break block0;
                    pushPullAdaptingWebSocket.triggerClose($status);
                }
            }
        };
        this.wSocket.invoke(object);
        this.websocket = (PushPullAdaptingWebSocket)object;
    }

    public void handlerRemoved(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (!this.normalClose) {
            GenericFutureListener[] genericFutureListenerArray = new GenericFutureListener[]{(GenericFutureListener)((ChannelFutureListener)arg_0 -> Http4kWsChannelHandler.handlerRemoved$lambda-0(this, arg_0)), (GenericFutureListener)ChannelFutureListener.CLOSE};
            ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListeners(genericFutureListenerArray);
        }
        this.websocket = null;
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull WebSocketFrame msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        WebSocketFrame webSocketFrame = msg;
        if (webSocketFrame instanceof TextWebSocketFrame) {
            PushPullAdaptingWebSocket pushPullAdaptingWebSocket = this.websocket;
            if (pushPullAdaptingWebSocket != null) {
                String string = ((TextWebSocketFrame)msg).text();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"msg.text()");
                pushPullAdaptingWebSocket.triggerMessage(new WsMessage(Body.Companion.create(string)));
            }
        } else if (webSocketFrame instanceof BinaryWebSocketFrame) {
            PushPullAdaptingWebSocket pushPullAdaptingWebSocket = this.websocket;
            if (pushPullAdaptingWebSocket != null) {
                pushPullAdaptingWebSocket.triggerMessage(new WsMessage(Body.Companion.create$default((Body.Companion)Body.Companion, (InputStream)((InputStream)new ByteBufInputStream(msg.content())), null, (int)2, null)));
            }
        } else if (webSocketFrame instanceof CloseWebSocketFrame) {
            ((CloseWebSocketFrame)msg).retain();
            GenericFutureListener[] genericFutureListenerArray = new GenericFutureListener[]{(GenericFutureListener)((ChannelFutureListener)arg_0 -> Http4kWsChannelHandler.channelRead0$lambda-1(this, msg, arg_0)), (GenericFutureListener)ChannelFutureListener.CLOSE};
            ctx.writeAndFlush((Object)msg).addListeners(genericFutureListenerArray);
        }
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            PushPullAdaptingWebSocket pushPullAdaptingWebSocket = this.websocket;
            if (pushPullAdaptingWebSocket == null) break block0;
            pushPullAdaptingWebSocket.triggerError(cause);
        }
    }

    private static final void handlerRemoved$lambda-0(Http4kWsChannelHandler this$0, ChannelFuture it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            PushPullAdaptingWebSocket pushPullAdaptingWebSocket = this$0.websocket;
            if (pushPullAdaptingWebSocket == null) break block0;
            pushPullAdaptingWebSocket.triggerClose(WsStatus.Companion.getNOCODE());
        }
    }

    private static final void channelRead0$lambda-1(Http4kWsChannelHandler this$0, WebSocketFrame $msg, ChannelFuture it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$msg, (String)"$msg");
            this$0.normalClose = true;
            PushPullAdaptingWebSocket pushPullAdaptingWebSocket = this$0.websocket;
            if (pushPullAdaptingWebSocket == null) break block0;
            int n = ((CloseWebSocketFrame)$msg).statusCode();
            String string = ((CloseWebSocketFrame)$msg).reasonText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"msg.reasonText()");
            pushPullAdaptingWebSocket.triggerClose(new WsStatus(n, string));
        }
    }

    public static final /* synthetic */ void access$setNormalClose$p(Http4kWsChannelHandler $this, boolean bl) {
        $this.normalClose = bl;
    }

    public static final /* synthetic */ PushPullAdaptingWebSocket access$getWebsocket$p(Http4kWsChannelHandler $this) {
        return $this.websocket;
    }
}

