/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.RequestSource;
import org.http4k.core.Uri;
import org.http4k.server.Http4kWsChannelHandler;
import org.http4k.websocket.Websocket;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012*\u0010\u0002\u001a&\u0012\u0004\u0012\u00020\u0004\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003j\u0004\u0018\u0001`\u00070\u0003j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0013\u001a\u00020\u0004*\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R2\u0010\u0002\u001a&\u0012\u0004\u0012\u00020\u0004\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003j\u0004\u0018\u0001`\u00070\u0003j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/http4k/server/WebSocketServerHandler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "wsHandler", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/websocket/Websocket;", "", "Lorg/http4k/websocket/WsConsumer;", "Lorg/http4k/websocket/WsHandler;", "(Lkotlin/jvm/functions/Function1;)V", "channelRead", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "msg", "", "requiresWsUpgrade", "", "httpRequest", "Lio/netty/handler/codec/http/HttpRequest;", "asRequest", "address", "Ljava/net/InetSocketAddress;", "http4k-server-netty"})
public final class WebSocketServerHandler
extends ChannelInboundHandlerAdapter {
    private final Function1<Request, Function1<Websocket, Unit>> wsHandler;

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (msg instanceof HttpRequest) {
            if (this.requiresWsUpgrade((HttpRequest)msg)) {
                SocketAddress socketAddress = ctx.channel().remoteAddress();
                if (socketAddress == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.net.InetSocketAddress");
                }
                InetSocketAddress address = (InetSocketAddress)socketAddress;
                Request upgradeRequest = this.asRequest((HttpRequest)msg, address);
                Function1 wsConsumer = (Function1)this.wsHandler.invoke((Object)upgradeRequest);
                if (wsConsumer != null) {
                    WebSocketServerProtocolConfig config = WebSocketServerProtocolConfig.newBuilder().handleCloseFrames(false).websocketPath(upgradeRequest.getUri().toString()).checkStartsWith(true).build();
                    ctx.pipeline().addAfter(ctx.name(), "handshakeListener", (ChannelHandler)new ChannelInboundHandlerAdapter(wsConsumer, upgradeRequest){
                        final /* synthetic */ Function1 $wsConsumer;
                        final /* synthetic */ Request $upgradeRequest;

                        public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
                            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                            Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                            if (evt instanceof WebSocketServerProtocolHandler.HandshakeComplete) {
                                ctx.pipeline().addAfter(ctx.name(), Http4kWsChannelHandler.class.getName(), (ChannelHandler)new Http4kWsChannelHandler((Function1<? super Websocket, Unit>)this.$wsConsumer, this.$upgradeRequest));
                            }
                        }
                        {
                            this.$wsConsumer = $captured_local_variable$0;
                            this.$upgradeRequest = $captured_local_variable$1;
                        }
                    });
                    ctx.pipeline().addAfter(ctx.name(), WebSocketServerProtocolHandler.class.getName(), (ChannelHandler)new WebSocketServerProtocolHandler(config));
                } else {
                    ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SERVICE_UNAVAILABLE));
                }
                ctx.fireChannelRead(msg);
            } else {
                ctx.fireChannelRead(msg);
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private final boolean requiresWsUpgrade(HttpRequest httpRequest) {
        return httpRequest.headers().containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.UPGRADE, true) && httpRequest.headers().containsValue((CharSequence)HttpHeaderValues.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true);
    }

    /*
     * WARNING - void declaration
     */
    private final Request asRequest(HttpRequest $this$asRequest, InetSocketAddress address) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string = $this$asRequest.method().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method().name()");
        Method method = Method.valueOf((String)string);
        String string2 = $this$asRequest.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri()");
        Request request = Request.Companion.create$default((Request.Companion)Request.Companion, (Method)method, (Uri)Uri.Companion.of(string2), null, (int)4, null);
        HttpHeaders httpHeaders = $this$asRequest.headers();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"headers()");
        Iterable iterable = (Iterable)httpHeaders;
        Request request2 = request;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getKey(), it.getValue());
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        Request request3 = request2.headers((List)collection);
        InetAddress inetAddress = address.getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"address.address");
        String string3 = inetAddress.getHostAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"address.address.hostAddress");
        return request3.source(new RequestSource(string3, Integer.valueOf(address.getPort()), null, 4, null));
    }

    public WebSocketServerHandler(@NotNull Function1<? super Request, ? extends Function1<? super Websocket, Unit>> wsHandler) {
        Intrinsics.checkNotNullParameter(wsHandler, (String)"wsHandler");
        this.wsHandler = wsHandler;
    }
}

