/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.server;

import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Body;
import org.http4k.core.Request;
import org.http4k.core.StreamBody;
import org.http4k.server.Http4kUndertowWebSocketCallbackKt;
import org.http4k.server.Http4kWebSocketCallback;
import org.http4k.websocket.PushPullAdaptingWebSocket;
import org.http4k.websocket.Websocket;
import org.http4k.websocket.WsMessage;
import org.http4k.websocket.WsStatus;
import org.jetbrains.annotations.NotNull;
import org.xnio.ChannelListener;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012&\u0010\u0002\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003j\u0002`\u00070\u0003j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R.\u0010\u0002\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003j\u0002`\u00070\u0003j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/http4k/server/Http4kWebSocketCallback;", "Lio/undertow/websockets/WebSocketConnectionCallback;", "ws", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/websocket/Websocket;", "", "Lorg/http4k/websocket/WsConsumer;", "Lorg/http4k/websocket/WsHandler;", "(Lkotlin/jvm/functions/Function1;)V", "onConnect", "exchange", "Lio/undertow/websockets/spi/WebSocketHttpExchange;", "channel", "Lio/undertow/websockets/core/WebSocketChannel;", "http4k-server-undertow"})
public final class Http4kWebSocketCallback
implements WebSocketConnectionCallback {
    @NotNull
    private final Function1<Request, Function1<Websocket, Unit>> ws;

    public Http4kWebSocketCallback(@NotNull Function1<? super Request, ? extends Function1<? super Websocket, Unit>> ws) {
        Intrinsics.checkNotNullParameter(ws, (String)"ws");
        this.ws = ws;
    }

    public void onConnect(@NotNull WebSocketHttpExchange exchange, @NotNull WebSocketChannel channel) {
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Request upgradeRequest = Http4kUndertowWebSocketCallbackKt.access$asRequest(exchange);
        PushPullAdaptingWebSocket pushPullAdaptingWebSocket = new PushPullAdaptingWebSocket(upgradeRequest, channel){
            final /* synthetic */ WebSocketChannel $channel;
            {
                this.$channel = $channel;
                super($upgradeRequest);
            }

            public void send(@NotNull WsMessage message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                if (message.getBody() instanceof StreamBody) {
                    WebSockets.sendBinary((ByteBuffer)message.getBody().getPayload(), (WebSocketChannel)this.$channel, null);
                } else {
                    WebSockets.sendText((String)message.bodyString(), (WebSocketChannel)this.$channel, null);
                }
            }

            public void close(@NotNull WsStatus status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                WebSockets.sendClose((int)status.getCode(), (String)status.getDescription(), (WebSocketChannel)this.$channel, null);
            }
        };
        ((Function1)this.ws.invoke((Object)upgradeRequest)).invoke((Object)pushPullAdaptingWebSocket);
        PushPullAdaptingWebSocket socket2 = pushPullAdaptingWebSocket;
        channel.addCloseTask(arg_0 -> Http4kWebSocketCallback.onConnect$lambda$0(socket2, arg_0));
        channel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(socket2){
            final /* synthetic */ onConnect.socket.1 $socket;
            {
                this.$socket = $socket;
            }

            protected void onFullTextMessage(@NotNull WebSocketChannel channel, @NotNull BufferedTextMessage message) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                try {
                    String string = message.getData();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message.data");
                    this.$socket.triggerMessage(new WsMessage(Body.Companion.create(string)));
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.$socket.triggerError(e);
                    throw e;
                }
            }

            /*
             * WARNING - void declaration
             */
            protected void onFullBinaryMessage(@NotNull WebSocketChannel channel, @NotNull BufferedBinaryMessage message) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Object object = message.getData().getResource();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"message.data.resource");
                Object[] objectArray = (Object[])object;
                onConnect.socket.1 var4_4 = this.$socket;
                boolean $i$f$forEach = false;
                for (void element$iv : $this$forEach$iv) {
                    ByteBuffer it = (ByteBuffer)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    var4_4.triggerMessage(new WsMessage(Body.Companion.create(it)));
                }
            }

            protected void onError(@NotNull WebSocketChannel channel, @NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                this.$socket.triggerError(error);
            }
        });
        channel.resumeReceives();
    }

    private static final void onConnect$lambda$0(onConnect.socket.1 $socket, WebSocketChannel it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$socket), (String)"$socket");
        int n = it.getCloseCode();
        String string = it.getCloseReason();
        if (string == null) {
            string = "unknown";
        }
        $socket.triggerClose(new WsStatus(n, string));
    }
}

