/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.http4s.blaze.http.http2.BufferUnderflow$;
import org.http4s.blaze.http.http2.Continue$;
import org.http4s.blaze.http.http2.Error;
import org.http4s.blaze.http.http2.FrameDecoder$;
import org.http4s.blaze.http.http2.FrameListener;
import org.http4s.blaze.http.http2.Http2Exception;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2Settings;
import org.http4s.blaze.http.http2.MaybeError;
import org.http4s.blaze.http.http2.Priority;
import org.http4s.blaze.http.http2.Priority$NoPriority$;
import org.http4s.blaze.http.http2.Result;
import org.http4s.blaze.http.http2.SettingsDecoder;
import org.http4s.blaze.http.http2.SettingsDecoder$;
import org.http4s.blaze.http.http2.bits$;
import org.http4s.blaze.http.http2.bits$Flags$;
import org.http4s.blaze.http.http2.bits$FrameTypes$;
import org.http4s.blaze.http.http2.bits$Masks$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\t5\u0011AB\u0012:b[\u0016$UmY8eKJT!a\u0001\u0003\u0002\u000b!$H\u000f\u001d\u001a\u000b\u0005\u00151\u0011\u0001\u00025uiBT!a\u0002\u0005\u0002\u000b\td\u0017M_3\u000b\u0005%Q\u0011A\u00025uiB$4OC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u0005iAn\\2bYN+G\u000f^5oON\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003\u001b!#H\u000f\u001d\u001aTKR$\u0018N\\4t\u0011!Y\u0002A!A!\u0002\u0013a\u0012\u0001\u00037jgR,g.\u001a:\u0011\u0005]i\u0012B\u0001\u0010\u0003\u000551%/Y7f\u0019&\u001cH/\u001a8fe\")\u0001\u0005\u0001C\u0001C\u00051A(\u001b8jiz\"2AI\u0012%!\t9\u0002\u0001C\u0003\u0016?\u0001\u0007a\u0003C\u0003\u001c?\u0001\u0007A\u0004C\u0003'\u0001\u0011\u0015q%\u0001\u0007eK\u000e|G-\u001a\"vM\u001a,'\u000f\u0006\u0002)WA\u0011q#K\u0005\u0003U\t\u0011aAU3tk2$\b\"\u0002\u0017&\u0001\u0004i\u0013A\u00022vM\u001a,'\u000f\u0005\u0002/g5\tqF\u0003\u00021c\u0005\u0019a.[8\u000b\u0003I\nAA[1wC&\u0011Ag\f\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bB\u0002\u001c\u0001A\u0013%q'\u0001\be_\u0012+7m\u001c3f\u0005V4g-\u001a:\u0015\u0005!B\u0004\"\u0002\u00176\u0001\u0004i\u0003\"\u0002\u001e\u0001\t\u0003Y\u0014\u0001E8o\u000bb$XM\\:j_:4%/Y7f)\u0015AC(\u0011$I\u0011\u0015i\u0014\b1\u0001?\u0003\u0011\u0019w\u000eZ3\u0011\u0005=y\u0014B\u0001!\u0011\u0005\u0011\u0011\u0015\u0010^3\t\u000b\tK\u0004\u0019A\"\u0002\u0011M$(/Z1n\u0013\u0012\u0004\"a\u0004#\n\u0005\u0015\u0003\"aA%oi\")q)\u000fa\u0001}\u0005)a\r\\1hg\")A&\u000fa\u0001[!1!\n\u0001Q\u0005\n-\u000bq\u0002Z3d_\u0012,G)\u0019;b\rJ\fW.\u001a\u000b\u0005Q1ke\nC\u0003-\u0013\u0002\u0007Q\u0006C\u0003C\u0013\u0002\u00071\tC\u0003H\u0013\u0002\u0007a\b\u0003\u0004Q\u0001\u0001&I!U\u0001\u0012I\u0016\u001cw\u000eZ3IK\u0006$WM\u001d$sC6,G\u0003\u0002\u0015S'RCQ\u0001L(A\u00025BQAQ(A\u0002\rCQaR(A\u0002yBaA\u0016\u0001!\n\u00139\u0016a\u00053fG>$W\r\u0015:j_JLG/\u001f$sC6,G\u0003\u0002\u0015Y3jCQ\u0001L+A\u00025BQAQ+A\u0002\rCQaR+A\u0002yBa\u0001\u0018\u0001!\n\u0013i\u0016\u0001\u00063fG>$WMU:u'R\u0014X-Y7Ge\u0006lW\rF\u0002)=~CQ\u0001L.A\u00025BQAQ.A\u0002\rCa!\u0019\u0001!\n\u0013\u0011\u0017a\u00053fG>$WmU3ui&twm\u001d$sC6,G\u0003\u0002\u0015dI\u0016DQ\u0001\f1A\u00025BQA\u00111A\u0002\rCQa\u00121A\u0002yBaa\u001a\u0001!\n\u0013A\u0017A\u00063fG>$W\rU;tQB\u0013x.\\5tK\u001a\u0013\u0018-\\3\u0015\t!J'n\u001b\u0005\u0006Y\u0019\u0004\r!\f\u0005\u0006\u0005\u001a\u0004\ra\u0011\u0005\u0006\u000f\u001a\u0004\rA\u0010\u0005\u0007[\u0002\u0001K\u0011\u00028\u0002\u001f\u0011,7m\u001c3f!&twM\u0012:b[\u0016$B\u0001K8qc\")A\u0006\u001ca\u0001[!)!\t\u001ca\u0001\u0007\")q\t\u001ca\u0001}!11\u000f\u0001Q\u0005\nQ\f\u0011\u0003Z3d_\u0012,wi\\!xCf4%/Y7f)\rASO\u001e\u0005\u0006YI\u0004\r!\f\u0005\u0006\u0005J\u0004\ra\u0011\u0005\u0007q\u0002\u0001K\u0011B=\u0002/\u0011,7m\u001c3f/&tGm\\<Va\u0012\fG/\u001a$sC6,Gc\u0001\u0015{w\")Af\u001ea\u0001[!)!i\u001ea\u0001\u0007\"1Q\u0010\u0001Q\u0005\ny\fq\u0003Z3d_\u0012,7i\u001c8uS:,\u0018\r^5p]\u001a\u0013\u0018-\\3\u0015\r!z\u0018\u0011AA\u0002\u0011\u0015aC\u00101\u0001.\u0011\u0015\u0011E\u00101\u0001D\u0011\u00159E\u00101\u0001?\u000f\u001d\t9A\u0001E\u0005\u0003\u0013\tAB\u0012:b[\u0016$UmY8eKJ\u00042aFA\u0006\r\u0019\t!\u0001#\u0003\u0002\u000eM\u0019\u00111\u0002\b\t\u000f\u0001\nY\u0001\"\u0001\u0002\u0012Q\u0011\u0011\u0011\u0002\u0005\t\u0003+\tY\u0001\"\u0001\u0002\u0018\u0005qq-\u001a;MK:<G\u000f\u001b$jK2$GcA\"\u0002\u001a!1A&a\u0005A\u00025B\u0001\"!\b\u0002\f\u0011\u0005\u0011qD\u0001\fO\u0016$8\u000b\u001e:fC6LE\rF\u0002D\u0003CAa\u0001LA\u000e\u0001\u0004i\u0003\u0002CA\u0013\u0003\u0017!I!a\n\u0002\u0017\u001d,G\u000f\u0015:j_JLG/\u001f\u000b\u0005\u0003S\t9\u0004\u0005\u0003\u0002,\u0005EbbA\f\u0002.%\u0019\u0011q\u0006\u0002\u0002\u0011A\u0013\u0018n\u001c:jifLA!a\r\u00026\tIA)\u001a9f]\u0012,g\u000e\u001e\u0006\u0004\u0003_\u0011\u0001B\u0002\u0017\u0002$\u0001\u0007Q\u0006\u0003\u0005\u0002<\u0005-A\u0011BA\u001f\u00031a\u0017.\\5u!\u0006$G-\u001b8h)\u0019\ty$!\u0012\u0002JA\u0019q#!\u0011\n\u0007\u0005\r#A\u0001\u0006NCf\u0014W-\u0012:s_JDq!a\u0012\u0002:\u0001\u00071)A\u0004qC\u0012$\u0017N\\4\t\r1\nI\u00041\u0001.\u0011!\ti%a\u0003\u0005\u0002\u0005=\u0013A\u00025fqN#(\u000f\u0006\u0003\u0002R\u0005}\u0003\u0003BA*\u00033r1aDA+\u0013\r\t9\u0006E\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0013Q\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]\u0003\u0003C\u0004\u0002b\u0005-\u0003\u0019A\"\u0002\u0003%\u0004")
public class FrameDecoder {
    private final Http2Settings localSettings;
    private final FrameListener listener;

    public static String hexStr(int n) {
        return FrameDecoder$.MODULE$.hexStr(n);
    }

    public static int getStreamId(ByteBuffer byteBuffer) {
        return FrameDecoder$.MODULE$.getStreamId(byteBuffer);
    }

    public static int getLengthField(ByteBuffer byteBuffer) {
        return FrameDecoder$.MODULE$.getLengthField(byteBuffer);
    }

    public final Result decodeBuffer(ByteBuffer buffer) {
        return buffer.remaining() < bits$.MODULE$.HeaderSize() ? BufferUnderflow$.MODULE$ : this.doDecodeBuffer(buffer);
    }

    private Result doDecodeBuffer(ByteBuffer buffer) {
        Result result;
        buffer.mark();
        int len = FrameDecoder$.MODULE$.getLengthField(buffer);
        byte frameType = buffer.get();
        byte flags = buffer.get();
        int streamId = FrameDecoder$.MODULE$.getStreamId(buffer);
        if (this.localSettings.maxFrameSize() < len) {
            result = new Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HTTP2 packet is too large to handle. Stream: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)streamId)}))));
        } else if (frameType != bits$FrameTypes$.MODULE$.CONTINUATION() && this.listener.inHeaderSequence()) {
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received frame type ", " while in HEADERS sequence"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FrameDecoder$.MODULE$.hexStr(frameType)}));
            result = new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(msg));
        } else if (frameType == bits$FrameTypes$.MODULE$.CONTINUATION() && !this.listener.inHeaderSequence()) {
            result = new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received CONTINUATION frame outside of a HEADERS sequence"})).s((Seq)Nil$.MODULE$)));
        } else if (buffer.remaining() < len) {
            buffer.reset();
            result = BufferUnderflow$.MODULE$;
        } else {
            int oldLimit = buffer.limit();
            int endOfFrame = buffer.position() + len;
            buffer.limit(endOfFrame);
            try {
                try {
                    byte by = frameType;
                    Result result2 = bits$FrameTypes$.MODULE$.DATA() == by ? this.decodeDataFrame(buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.HEADERS() == by ? this.decodeHeaderFrame(buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.PRIORITY() == by ? this.decodePriorityFrame(buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.RST_STREAM() == by ? this.decodeRstStreamFrame(buffer, streamId) : (bits$FrameTypes$.MODULE$.SETTINGS() == by ? this.decodeSettingsFrame(buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.PUSH_PROMISE() == by ? this.decodePushPromiseFrame(buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.PING() == by ? this.decodePingFrame(buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.GOAWAY() == by ? this.decodeGoAwayFrame(buffer, streamId) : (bits$FrameTypes$.MODULE$.WINDOW_UPDATE() == by ? this.decodeWindowUpdateFrame(buffer, streamId) : (bits$FrameTypes$.MODULE$.CONTINUATION() == by ? this.decodeContinuationFrame(buffer, streamId, flags) : this.onExtensionFrame(by, streamId, flags, buffer.slice()))))))))));
                    result = result2;
                }
                catch (BufferUnderflowException bufferUnderflowException) {
                    result = new Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Frame type ", " and size ", " underflowed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FrameDecoder$.MODULE$.hexStr(frameType), BoxesRunTime.boxToInteger((int)len)}))));
                }
            }
            finally {
                buffer.limit(oldLimit);
                buffer.position(endOfFrame);
            }
        }
        return result;
    }

    public Result onExtensionFrame(byte code, int streamId, byte flags, ByteBuffer buffer) {
        return Continue$.MODULE$;
    }

    private Result decodeDataFrame(ByteBuffer buffer, int streamId, byte flags) {
        Result result;
        if (streamId == 0) {
            result = new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Data frame with stream id 0x0"));
        } else {
            MaybeError maybeError;
            int flowBytes = buffer.remaining();
            if (bits$Flags$.MODULE$.PADDED(flags)) {
                int padding = buffer.get() & 0xFF;
                maybeError = FrameDecoder$.MODULE$.org$http4s$blaze$http$http2$FrameDecoder$$limitPadding(padding, buffer);
            } else {
                maybeError = Continue$.MODULE$;
            }
            Continue$ r = maybeError;
            result = r.success() ? this.listener.onDataFrame(streamId, bits$Flags$.MODULE$.END_STREAM(flags), buffer.slice(), flowBytes) : r;
        }
        return result;
    }

    private Result decodeHeaderFrame(ByteBuffer buffer, int streamId, byte flags) {
        Result result;
        if (streamId == 0) {
            result = new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Headers frame with stream id 0x0"));
        } else {
            int padding = bits$Flags$.MODULE$.PADDED(flags) ? buffer.get() & 0xFF : 0;
            Priority$NoPriority$ priority = bits$Flags$.MODULE$.PRIORITY(flags) ? FrameDecoder$.MODULE$.org$http4s$blaze$http$http2$FrameDecoder$$getPriority(buffer) : Priority$NoPriority$.MODULE$;
            MaybeError r = FrameDecoder$.MODULE$.org$http4s$blaze$http$http2$FrameDecoder$$limitPadding(padding, buffer);
            if (r.success()) {
                Priority.Dependent dependent;
                int dep;
                Priority$NoPriority$ priority$NoPriority$ = priority;
                Result result2 = priority$NoPriority$ instanceof Priority.Dependent && (dep = (dependent = (Priority.Dependent)((Object)priority$NoPriority$)).dependentStreamId()) == streamId ? new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Header stream id ", " depends on itself."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FrameDecoder$.MODULE$.hexStr(streamId)})))) : this.listener.onHeadersFrame(streamId, priority, bits$Flags$.MODULE$.END_HEADERS(flags), bits$Flags$.MODULE$.END_STREAM(flags), buffer.slice());
                result = result2;
            } else {
                result = r;
            }
        }
        return result;
    }

    private Result decodePriorityFrame(ByteBuffer buffer, int streamId, byte flags) {
        Result result;
        if (streamId == 0) {
            result = new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Priority frame with stream id 0x0"));
        } else if (buffer.remaining() != 5) {
            String msg = new StringBuilder().append((Object)"Invalid PRIORITY frame size, required 5, received").append((Object)BoxesRunTime.boxToInteger((int)buffer.remaining())).toString();
            result = new Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().rst(streamId, msg));
        } else {
            Priority.Dependent priority = FrameDecoder$.MODULE$.org$http4s$blaze$http$http2$FrameDecoder$$getPriority(buffer);
            result = priority.dependentStreamId() == streamId ? new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(streamId, "Priority frame depends on itself")) : this.listener.onPriorityFrame(streamId, priority);
        }
        return result;
    }

    private Result decodeRstStreamFrame(ByteBuffer buffer, int streamId) {
        Result result;
        if (streamId == 0) {
            result = new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("RST_STREAM frame with stream id 0x0"));
        } else if (buffer.remaining() != 4) {
            String msg = new StringBuilder().append((Object)"Invalid RST_STREAM frame size. Required 4 bytes, received ").append((Object)BoxesRunTime.boxToInteger((int)buffer.remaining())).toString();
            result = new Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(msg));
        } else {
            long code = (long)buffer.getInt() & bits$Masks$.MODULE$.INT32();
            result = this.listener.onRstStreamFrame(streamId, code);
        }
        return result;
    }

    private Result decodeSettingsFrame(ByteBuffer buffer, int streamId, byte flags) {
        Either<Http2Exception, SettingsDecoder.SettingsFrame> either;
        block4: {
            Result result;
            block3: {
                block2: {
                    Right right;
                    SettingsDecoder.SettingsFrame settingsFrame;
                    either = SettingsDecoder$.MODULE$.decodeSettingsFrame(buffer, streamId, flags);
                    if (!(either instanceof Right) || (settingsFrame = (SettingsDecoder.SettingsFrame)(right = (Right)either).b()) == null) break block2;
                    Option<Seq<Http2Settings.Setting>> settings = settingsFrame.settings();
                    result = this.listener.onSettingsFrame(settings);
                    break block3;
                }
                if (!(either instanceof Left)) break block4;
                Left left = (Left)either;
                Http2Exception ex = (Http2Exception)left.a();
                result = new Error(ex);
            }
            return result;
        }
        throw new MatchError(either);
    }

    private Result decodePushPromiseFrame(ByteBuffer buffer, int streamId, byte flags) {
        Result result;
        if (streamId == 0) {
            result = new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("PUSH_PROMISE frame with stream id 0x0"));
        } else {
            MaybeError r;
            int padding = bits$Flags$.MODULE$.PADDED(flags) ? buffer.get() & 0xFF : 0;
            int promisedId = FrameDecoder$.MODULE$.getStreamId(buffer);
            result = promisedId == 0 ? new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("PUSH_PROMISE frame with promised stream id 0x0")) : (promisedId == streamId ? new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PUSH_PROMISE frame with promised stream of the same stream ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FrameDecoder$.MODULE$.hexStr(streamId)})))) : ((r = FrameDecoder$.MODULE$.org$http4s$blaze$http$http2$FrameDecoder$$limitPadding(padding, buffer)).success() ? this.listener.onPushPromiseFrame(streamId, promisedId, bits$Flags$.MODULE$.END_HEADERS(flags), buffer.slice()) : r));
        }
        return result;
    }

    private Result decodePingFrame(ByteBuffer buffer, int streamId, byte flags) {
        Result result;
        int PingSize = 8;
        if (streamId != 0) {
            result = new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PING frame with stream id ", " != 0x0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FrameDecoder$.MODULE$.hexStr(streamId)}))));
        } else if (buffer.remaining() != PingSize) {
            String msg = new StringBuilder().append((Object)"Invalid PING frame size. Expected 8, received ").append((Object)BoxesRunTime.boxToInteger((int)buffer.remaining())).toString();
            result = new Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(msg));
        } else {
            byte[] pingBytes = new byte[PingSize];
            buffer.get(pingBytes);
            result = this.listener.onPingFrame(bits$Flags$.MODULE$.ACK(flags), pingBytes);
        }
        return result;
    }

    private Result decodeGoAwayFrame(ByteBuffer buffer, int streamId) {
        Result result;
        if (streamId != 0) {
            result = new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GOAWAY frame with stream id ", " != 0x0."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FrameDecoder$.MODULE$.hexStr(streamId)}))));
        } else {
            int lastStream = bits$Flags$.MODULE$.DepID(buffer.getInt());
            long code = (long)buffer.getInt() & bits$Masks$.MODULE$.INT32();
            byte[] data = new byte[buffer.remaining()];
            buffer.get(data);
            result = this.listener.onGoAwayFrame(lastStream, code, data);
        }
        return result;
    }

    private Result decodeWindowUpdateFrame(ByteBuffer buffer, int streamId) {
        Result result;
        if (buffer.remaining() != 4) {
            result = new Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WindowUpdate with invalid frame size. Expected 4, found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)buffer.remaining())}))));
        } else {
            int size = buffer.getInt() & bits$Masks$.MODULE$.INT31();
            if (size != 0) {
                result = this.listener.onWindowUpdateFrame(streamId, size);
            } else {
                String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WINDOW_UPDATE with invalid update size 0"})).s((Seq)Nil$.MODULE$);
                Http2Exception http2Exception = streamId == 0 ? Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(msg) : Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(streamId, msg);
                result = new Error(http2Exception);
            }
        }
        return result;
    }

    private Result decodeContinuationFrame(ByteBuffer buffer, int streamId, byte flags) {
        Result result;
        if (streamId == 0) {
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CONTINUATION frame with invalid stream dependency on 0x0"})).s((Seq)Nil$.MODULE$);
            result = new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(msg));
        } else {
            result = this.listener.onContinuationFrame(streamId, bits$Flags$.MODULE$.END_HEADERS(flags), buffer.slice());
        }
        return result;
    }

    public FrameDecoder(Http2Settings localSettings, FrameListener listener) {
        this.localSettings = localSettings;
        this.listener = listener;
    }
}

