/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.http4s.blaze.http.HeaderNames$;
import org.http4s.blaze.http.util.HeaderLike;
import org.http4s.blaze.http.util.HeaderLike$;
import org.http4s.blaze.http.util.HeaderTools;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class HeaderTools$ {
    public static final HeaderTools$ MODULE$;
    private final DateTimeFormatter dateFormat;
    private volatile HeaderTools.CachedDateHeader dateTime;

    static {
        new HeaderTools$();
    }

    private DateTimeFormatter dateFormat() {
        return this.dateFormat;
    }

    private HeaderTools.CachedDateHeader dateTime() {
        return this.dateTime;
    }

    private void dateTime_$eq(HeaderTools.CachedDateHeader x$1) {
        this.dateTime = x$1;
    }

    private String getDateHeader() {
        String string;
        HeaderTools.CachedDateHeader cached = this.dateTime();
        long current = System.currentTimeMillis();
        if (current - cached.acquired() <= 1000L) {
            string = cached.header();
        } else {
            String next = new StringBuilder().append((Object)"date: ").append((Object)this.dateFormat().format(Instant.now())).append((Object)"\r\n").toString();
            this.dateTime_$eq(new HeaderTools.CachedDateHeader(current, next));
            string = next;
        }
        return string;
    }

    public boolean isKeepAlive(Option<String> connectionHeader, int minorVersion) {
        Option<String> option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = connectionHeader;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String headerValue = (String)some.x();
                    bl = headerValue.equalsIgnoreCase("keep-alive") ? true : (headerValue.equalsIgnoreCase("close") ? false : headerValue.equalsIgnoreCase("upgrade"));
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                bl = minorVersion != 0;
            }
            return bl;
        }
        throw new MatchError(option);
    }

    public <H> HeaderTools.SpecialHeaders renderHeaders(StringBuilder sb, Iterable<H> headers, HeaderLike<H> evidence$1) {
        None$ transferEncoding = None$.MODULE$;
        None$ contentLength = None$.MODULE$;
        None$ connection = None$.MODULE$;
        boolean hasDateheader = false;
        HeaderLike<H> hl = HeaderLike$.MODULE$.apply(evidence$1);
        for (Object header : headers) {
            BoxedUnit boxedUnit;
            String k = hl.getKey(header);
            String v = hl.getValue(header);
            if (k.equalsIgnoreCase(HeaderNames$.MODULE$.TransferEncoding())) {
                transferEncoding = new Some((Object)v);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (k.equalsIgnoreCase(HeaderNames$.MODULE$.ContentLength())) {
                contentLength = new Some((Object)v);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (k.equalsIgnoreCase(HeaderNames$.MODULE$.Connection())) {
                connection = new Some((Object)v);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (!hasDateheader && k.equalsIgnoreCase(HeaderNames$.MODULE$.Date())) {
                hasDateheader = true;
            }
            sb.append(k);
            Object object = v.length() > 0 ? sb.append(": ").append(v) : BoxedUnit.UNIT;
            boxedUnit = sb.append("\r\n");
        }
        Object object = hasDateheader ? BoxedUnit.UNIT : sb.append(this.getDateHeader());
        return new HeaderTools.SpecialHeaders((Option<String>)transferEncoding, (Option<String>)contentLength, (Option<String>)connection);
    }

    private HeaderTools$() {
        MODULE$ = this;
        this.dateFormat = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz").withLocale(Locale.US).withZone(ZoneId.of("GMT"));
        this.dateTime = new HeaderTools.CachedDateHeader(0L, "");
    }
}

