/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http_parser;

import java.nio.ByteBuffer;
import org.http4s.blaze.http.http_parser.BaseExceptions;

public abstract class ParserBase {
    private final boolean _isLenient;
    private int _bufferPosition = 0;
    private char[] _internalBuffer;
    private boolean _cr;
    private int _segmentByteLimit;
    private int _segmentBytePosition;

    ParserBase(int n, boolean bl) {
        this._internalBuffer = new char[n];
        this._isLenient = bl;
        this.clearBuffer();
    }

    public void shutdownParser() {
        this.clearBuffer();
    }

    void reset() {
        this.clearBuffer();
    }

    protected final void putChar(char c) {
        int n = this._internalBuffer.length;
        if (n == this._bufferPosition) {
            char[] cArray = new char[2 * n + 1];
            System.arraycopy(this._internalBuffer, 0, cArray, 0, this._bufferPosition);
            this._internalBuffer = cArray;
        }
        this._internalBuffer[this._bufferPosition++] = c;
    }

    protected final int bufferPosition() {
        return this._bufferPosition;
    }

    protected final boolean isLenient() {
        return this._isLenient;
    }

    protected final void clearBuffer() {
        this._bufferPosition = 0;
    }

    protected final String getString() {
        return this.getString(0, this._bufferPosition);
    }

    protected final String getString(int n) {
        return this.getString(0, n);
    }

    protected final String getString(int n, int n2) {
        if (n2 > this._bufferPosition) {
            throw new IndexOutOfBoundsException("Requested: " + n2 + ", max: " + this._bufferPosition);
        }
        String string = new String(this._internalBuffer, n, n2);
        return string;
    }

    protected final String getTrimmedString() throws BaseExceptions.BadRequest {
        int n;
        int n2;
        if (this._bufferPosition == 0) {
            return "";
        }
        boolean bl = false;
        for (n2 = 0; n2 < this._bufferPosition; ++n2) {
            n = this._internalBuffer[n2];
            if (n == 34) {
                bl = true;
                break;
            }
            if (n != 32 && n != 9) break;
        }
        for (n = this._bufferPosition; n > n2; --n) {
            char c = this._internalBuffer[n - 1];
            if (bl) {
                if (c == '\"') break;
                if (c == ' ' || c == '\t') continue;
                throw new BaseExceptions.BadRequest("String might not quoted correctly: '" + this.getString() + "'");
            }
            if (c != ' ' && c != '\t') break;
        }
        String string = new String(this._internalBuffer, n2, n - n2);
        return string;
    }

    protected final boolean arrayMatches(char[] cArray) {
        if (cArray.length != this._bufferPosition) {
            return false;
        }
        for (int i = 0; i < this._bufferPosition; ++i) {
            if (cArray[i] == this._internalBuffer[i]) continue;
            return false;
        }
        return true;
    }

    protected final void resetLimit(int n) {
        this._segmentByteLimit = n;
        this._segmentBytePosition = 0;
    }

    protected final char next(ByteBuffer byteBuffer, boolean bl) throws BaseExceptions.BadRequest {
        if (!byteBuffer.hasRemaining()) {
            return '\uffff';
        }
        if (this._segmentByteLimit <= this._segmentBytePosition) {
            this.shutdownParser();
            throw new BaseExceptions.BadRequest("Request length limit exceeded: " + this._segmentByteLimit);
        }
        byte by = byteBuffer.get();
        ++this._segmentBytePosition;
        if (this._cr) {
            if (by != 10) {
                throw new BaseExceptions.BadCharacter("Invalid sequence: LF didn't follow CR: " + by);
            }
            this._cr = false;
            return (char)by;
        }
        if (by < 32) {
            if (by == 13) {
                this._cr = true;
                return this.next(byteBuffer, bl);
            }
            if (by == 9 || bl && by < 0) {
                return (char)(by & 0xFF);
            }
            if (by == 10) {
                return (char)by;
            }
            if (this.isLenient()) {
                return '\ufffd';
            }
            this.shutdownParser();
            throw new BaseExceptions.BadCharacter("Invalid char: '" + (char)(by & 0xFF) + "', 0x" + Integer.toHexString(by));
        }
        return (char)by;
    }
}

