/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A3AAC\u0006\u0007-!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005C\u0003'\u0001\u0011\u0005q\u0005\u0003\u0004,\u0001\u0001\u0006K\u0001\f\u0005\u0006e\u0001!\te\r\u0005\u0006e\u0001!\t\u0005\u000e\u0005\u0006\u0003\u0002!\te\r\u0005\u0006\u0005\u0002!\te\u0011\u0005\u0006\u0013\u0002!\tE\u0013\u0005\u0006\u0017\u0002!\t\u0005\u0014\u0002\u0016\u0005f$XMQ;gM\u0016\u0014\u0018J\u001c9viN#(/Z1n\u0015\taQ\"A\u0003iiR\u0004(G\u0003\u0002\u000f\u001f\u0005!\u0001\u000e\u001e;q\u0015\t\u0001\u0012#A\u0003cY\u0006TXM\u0003\u0002\u0013'\u00051\u0001\u000e\u001e;qiMT\u0011\u0001F\u0001\u0004_J<7\u0001A\n\u0003\u0001]\u0001\"\u0001G\u000f\u000e\u0003eQ!AG\u000e\u0002\u0005%|'\"\u0001\u000f\u0002\t)\fg/Y\u0005\u0003=e\u00111\"\u00138qkR\u001cFO]3b[\u00061!-\u001e4gKJ\u0004\"!\t\u0013\u000e\u0003\tR!aI\u000e\u0002\u00079Lw.\u0003\u0002&E\tQ!)\u001f;f\u0005V4g-\u001a:\u0002\rqJg.\u001b;?)\tA#\u0006\u0005\u0002*\u00015\t1\u0002C\u0003 \u0005\u0001\u0007\u0001%\u0001\u0005nCJ\\7+\u001b>f!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\rIe\u000e^\u0001\u0005e\u0016\fG\rF\u0001-)\u0011aS'P \t\u000bY*\u0001\u0019A\u001c\u0002\u0003\t\u00042!\f\u001d;\u0013\tIdFA\u0003BeJ\f\u0017\u0010\u0005\u0002.w%\u0011AH\f\u0002\u0005\u0005f$X\rC\u0003?\u000b\u0001\u0007A&A\u0002pM\u001aDQ\u0001Q\u0003A\u00021\n1\u0001\\3o\u0003%\tg/Y5mC\ndW-\u0001\u0003nCJ\\GC\u0001#H!\tiS)\u0003\u0002G]\t!QK\\5u\u0011\u0015Au\u00011\u0001-\u0003%\u0011X-\u00193mS6LG/A\u0003sKN,G\u000fF\u0001E\u00035i\u0017M]6TkB\u0004xN\u001d;fIR\tQ\n\u0005\u0002.\u001d&\u0011qJ\f\u0002\b\u0005>|G.Z1o\u0001")
public final class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer;
    private int markSize;

    @Override
    public int read() {
        if (this.buffer.hasRemaining()) {
            --this.markSize;
            return this.buffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        int readSize = package$.MODULE$.min(len, this.buffer.remaining());
        this.markSize -= readSize;
        this.buffer.get(b, off, readSize);
        return readSize;
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }

    @Override
    public void mark(int readlimit) {
        this.markSize = readlimit;
        this.buffer.mark();
    }

    @Override
    public void reset() {
        if (this.markSize >= 0) {
            this.markSize = -1;
            this.buffer.reset();
            return;
        }
        throw new IOException("Invalid mark");
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
        this.markSize = -1;
    }
}

