/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.http4s.blaze.http.http2.PingManager$;
import org.http4s.blaze.http.http2.PingManager$Idle$;
import org.http4s.blaze.http.http2.SessionCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t]d\u0001\u0002$H\tIC\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\u0006=\u0002!\ta\u0018\u0005\u0007E\u0002\u0001\u000b\u0011B2\t\r%\u0004\u0001\u0015)\u0003k\u0011\u001d\u0011y\u0005\u0001C\u0001\u0005#BqA!\u0017\u0001\t\u0003\u0011Y\u0006C\u0004\u0003t\u0001!\tA!\u001e\b\u000b1<\u0005\u0012B7\u0007\u000b\u0019;\u0005\u0012\u00028\t\u000byKA\u0011A8\u0007\u000fAL\u0001\u0013aI\u0015c\u001e9\u0011q`\u0005\t\n\u0006eeaBAJ\u0013!%\u0015Q\u0013\u0005\u0007=6!\t!a&\t\u0013\u0005uR\"!A\u0005B\u0005}\u0002\"CA)\u001b\u0005\u0005I\u0011AA*\u0011%\tY&DA\u0001\n\u0003\tY\nC\u0005\u0002j5\t\t\u0011\"\u0011\u0002l!I\u0011\u0011P\u0007\u0002\u0002\u0013\u0005\u0011q\u0014\u0005\n\u0003\u000bk\u0011\u0011!C!\u0003\u000fC\u0011\"!#\u000e\u0003\u0003%\t%a#\t\u0013\u0005\rV\"!A\u0005\n\u0005\u0015fABAW\u0013\u0011\u000by\u000b\u0003\u0006\u00022^\u0011)\u001a!C\u0001\u0003gC!\"a/\u0018\u0005#\u0005\u000b\u0011BA[\u0011)\til\u0006BK\u0002\u0013\u0005\u0011q\u0018\u0005\u000b\u00033<\"\u0011#Q\u0001\n\u0005\u0005\u0007B\u00020\u0018\t\u0003\tY\u000eC\u0005\u0002 ]\t\t\u0011\"\u0001\u0002d\"I\u0011QE\f\u0012\u0002\u0013\u0005\u0011\u0011\u001e\u0005\n\u0003[<\u0012\u0013!C\u0001\u0003_D\u0011\"!\u0010\u0018\u0003\u0003%\t%a\u0010\t\u0013\u0005Es#!A\u0005\u0002\u0005M\u0003\"CA./\u0005\u0005I\u0011AAz\u0011%\tIgFA\u0001\n\u0003\nY\u0007C\u0005\u0002z]\t\t\u0011\"\u0001\u0002x\"I\u0011QQ\f\u0002\u0002\u0013\u0005\u0013q\u0011\u0005\n\u0003\u0013;\u0012\u0011!C!\u0003\u0017C\u0011\"!$\u0018\u0003\u0003%\t%a?\b\u0013\t\u0005\u0011\"!A\t\n\t\ra!CAW\u0013\u0005\u0005\t\u0012\u0002B\u0003\u0011\u0019q\u0016\u0006\"\u0001\u0003\u0014!I\u0011\u0011R\u0015\u0002\u0002\u0013\u0015\u00131\u0012\u0005\n\u0005+I\u0013\u0011!CA\u0005/A\u0011B!\b*\u0003\u0003%\tIa\b\t\u0013\u0005\r\u0016&!A\u0005\n\u0005\u0015f\u0001B:\n\tRD\u0001\"`\u0018\u0003\u0016\u0004%\tA \u0005\n\u0003/y#\u0011#Q\u0001\n}DaAX\u0018\u0005\u0002\u0005e\u0001\"CA\u0010_\u0005\u0005I\u0011AA\u0011\u0011%\t)cLI\u0001\n\u0003\t9\u0003C\u0005\u0002>=\n\t\u0011\"\u0011\u0002@!I\u0011\u0011K\u0018\u0002\u0002\u0013\u0005\u00111\u000b\u0005\n\u00037z\u0013\u0011!C\u0001\u0003;B\u0011\"!\u001b0\u0003\u0003%\t%a\u001b\t\u0013\u0005et&!A\u0005\u0002\u0005m\u0004\"CAC_\u0005\u0005I\u0011IAD\u0011%\tIiLA\u0001\n\u0003\nY\tC\u0005\u0002\u000e>\n\t\u0011\"\u0011\u0002\u0010\u001eI!\u0011G\u0005\u0002\u0002#%!1\u0007\u0004\tg&\t\t\u0011#\u0003\u00036!1aL\u0010C\u0001\u0005{A\u0011\"!#?\u0003\u0003%)%a#\t\u0013\tUa(!A\u0005\u0002\n}\u0002\"\u0003B\u000f}\u0005\u0005I\u0011\u0011B\"\u0011%\t\u0019KPA\u0001\n\u0013\t)\u000bC\u0005\u0003J%\u0011\r\u0011\"\u0003\u0003L!A!QJ\u0005!\u0002\u0013\tYBA\u0006QS:<W*\u00198bO\u0016\u0014(B\u0001%J\u0003\u0015AG\u000f\u001e93\u0015\tQ5*\u0001\u0003iiR\u0004(B\u0001'N\u0003\u0015\u0011G.\u0019>f\u0015\tqu*\u0001\u0004iiR\u0004Hg\u001d\u0006\u0002!\u0006\u0019qN]4\u0004\u0001M\u0011\u0001a\u0015\t\u0003)^k\u0011!\u0016\u0006\u0002-\u0006)1oY1mC&\u0011\u0001,\u0016\u0002\u0007\u0003:L(+\u001a4\u0002\u000fM,7o]5p]B\u00111\fX\u0007\u0002\u000f&\u0011Ql\u0012\u0002\f'\u0016\u001c8/[8o\u0007>\u0014X-\u0001\u0004=S:LGO\u0010\u000b\u0003A\u0006\u0004\"a\u0017\u0001\t\u000be\u0013\u0001\u0019\u0001.\u0002\r1|wmZ3s!\t!w-D\u0001f\u0015\t1w*A\u0003m_\u001e$4/\u0003\u0002iK\n1Aj\\4hKJ\fQa\u001d;bi\u0016\u0004\"a[\u0006\u000f\u0005mC\u0011a\u0003)j]\u001el\u0015M\\1hKJ\u0004\"aW\u0005\u0014\u0005%\u0019F#A7\u0003\u000bM#\u0018\r^3\u0014\u0005-\u0019\u0016\u0006B\u00060\u001b]\u0011aa\u00117pg\u0016$7#B\u0018Tk^T\bC\u0001<\f\u001b\u0005I\u0001C\u0001+y\u0013\tIXKA\u0004Qe>$Wo\u0019;\u0011\u0005Q[\u0018B\u0001?V\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\t)\u00070F\u0001\u0000!\u0011\t\t!!\u0005\u000f\t\u0005\r\u0011Q\u0002\b\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011B)\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0016bAA\b+\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\n\u0003+\u0011\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005=Q+A\u0002fq\u0002\"B!a\u0007\u0002\u001eA\u0011ao\f\u0005\u0006{J\u0002\ra`\u0001\u0005G>\u0004\u0018\u0010\u0006\u0003\u0002\u001c\u0005\r\u0002bB?4!\u0003\u0005\ra`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tICK\u0002\u0000\u0003WY#!!\f\u0011\t\u0005=\u0012\u0011H\u0007\u0003\u0003cQA!a\r\u00026\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003o)\u0016AC1o]>$\u0018\r^5p]&!\u00111HA\u0019\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0005\u0003\u0003BA\"\u0003\u001bj!!!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\u0005Y\u0006twM\u0003\u0002\u0002L\u0005!!.\u0019<b\u0013\u0011\ty%!\u0012\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)\u0006E\u0002U\u0003/J1!!\u0017V\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ty&!\u001a\u0011\u0007Q\u000b\t'C\u0002\u0002dU\u00131!\u00118z\u0011%\t9gNA\u0001\u0002\u0004\t)&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003[\u0002b!a\u001c\u0002v\u0005}SBAA9\u0015\r\t\u0019(V\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA<\u0003c\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QPAB!\r!\u0016qP\u0005\u0004\u0003\u0003+&a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003OJ\u0014\u0011!a\u0001\u0003?\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003+\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0003\na!Z9vC2\u001cH\u0003BA?\u0003#C\u0011\"a\u001a=\u0003\u0003\u0005\r!a\u0018\u0003\t%#G.Z\n\u0006\u001bM+xO\u001f\u000b\u0003\u00033\u0003\"A^\u0007\u0015\t\u0005}\u0013Q\u0014\u0005\n\u0003O\n\u0012\u0011!a\u0001\u0003+\"B!! \u0002\"\"I\u0011qM\n\u0002\u0002\u0003\u0007\u0011qL\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002(B!\u00111IAU\u0013\u0011\tY+!\u0012\u0003\r=\u0013'.Z2u\u0005\u001d\u0001\u0016N\\4j]\u001e\u001cRaF*voj\fqa\u001d;beR,G-\u0006\u0002\u00026B\u0019A+a.\n\u0007\u0005eVK\u0001\u0003M_:<\u0017\u0001C:uCJ$X\r\u001a\u0011\u0002\u0003A,\"!!1\u0011\r\u0005\r\u0017\u0011ZAg\u001b\t\t)MC\u0002\u0002HV\u000b!bY8oGV\u0014(/\u001a8u\u0013\u0011\tY-!2\u0003\u000fA\u0013x.\\5tKB!\u0011qZAk\u001b\t\t\tN\u0003\u0003\u0002T\u0006\u0015\u0017\u0001\u00033ve\u0006$\u0018n\u001c8\n\t\u0005]\u0017\u0011\u001b\u0002\t\tV\u0014\u0018\r^5p]\u0006\u0011\u0001\u000f\t\u000b\u0007\u0003;\fy.!9\u0011\u0005Y<\u0002bBAY9\u0001\u0007\u0011Q\u0017\u0005\b\u0003{c\u0002\u0019AAa)\u0019\ti.!:\u0002h\"I\u0011\u0011W\u000f\u0011\u0002\u0003\u0007\u0011Q\u0017\u0005\n\u0003{k\u0002\u0013!a\u0001\u0003\u0003,\"!a;+\t\u0005U\u00161F\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t\tP\u000b\u0003\u0002B\u0006-B\u0003BA0\u0003kD\u0011\"a\u001a#\u0003\u0003\u0005\r!!\u0016\u0015\t\u0005u\u0014\u0011 \u0005\n\u0003O\"\u0013\u0011!a\u0001\u0003?\"B!! \u0002~\"I\u0011qM\u0014\u0002\u0002\u0003\u0007\u0011qL\u0001\u0005\u0013\u0012dW-A\u0004QS:<\u0017N\\4\u0011\u0005YL3\u0003B\u0015\u0003\bi\u0004\"B!\u0003\u0003\u0010\u0005U\u0016\u0011YAo\u001b\t\u0011YAC\u0002\u0003\u000eU\u000bqA];oi&lW-\u0003\u0003\u0003\u0012\t-!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!1A\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003;\u0014IBa\u0007\t\u000f\u0005EF\u00061\u0001\u00026\"9\u0011Q\u0018\u0017A\u0002\u0005\u0005\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0005C\u0011i\u0003E\u0003U\u0005G\u00119#C\u0002\u0003&U\u0013aa\u00149uS>t\u0007c\u0002+\u0003*\u0005U\u0016\u0011Y\u0005\u0004\u0005W)&A\u0002+va2,'\u0007C\u0005\u000305\n\t\u00111\u0001\u0002^\u0006\u0019\u0001\u0010\n\u0019\u0002\r\rcwn]3e!\t1hh\u0005\u0003?\u0005oQ\bc\u0002B\u0005\u0005sy\u00181D\u0005\u0005\u0005w\u0011YAA\tBEN$(/Y2u\rVt7\r^5p]F\"\"Aa\r\u0015\t\u0005m!\u0011\t\u0005\u0006{\u0006\u0003\ra \u000b\u0005\u0005\u000b\u00129\u0005\u0005\u0003U\u0005Gy\b\"\u0003B\u0018\u0005\u0006\u0005\t\u0019AA\u000e\u000399%/Y2fMVd7\t\\8tK\u0012,\"!a\u0007\u0002\u001f\u001d\u0013\u0018mY3gk2\u001cEn\\:fI\u0002\nA\u0001]5oOR\u0011!1\u000b\t\u0007\u0003\u0007\u0014)&!4\n\t\t]\u0013Q\u0019\u0002\u0007\rV$XO]3\u0002\u001fALgnZ!dWJ+7-Z5wK\u0012$BA!\u0018\u0003dA\u0019AKa\u0018\n\u0007\t\u0005TK\u0001\u0003V]&$\bb\u0002B3\r\u0001\u0007!qM\u0001\u0005I\u0006$\u0018\rE\u0003U\u0005S\u0012i'C\u0002\u0003lU\u0013Q!\u0011:sCf\u00042\u0001\u0016B8\u0013\r\u0011\t(\u0016\u0002\u0005\u0005f$X-A\u0003dY>\u001cX\r\u0006\u0002\u0003^\u0001")
public class PingManager {
    private final SessionCore session;
    private final Logger logger;
    private State state;

    public Future<Duration> ping() {
        long time = System.currentTimeMillis();
        State state = this.state;
        if (PingManager$Idle$.MODULE$.equals(state)) {
            byte[] data = new byte[8];
            ByteBuffer.wrap(data).putLong(time);
            ByteBuffer pingFrame = this.session.http2Encoder().pingFrame(data);
            if (this.session.writeController().write(pingFrame)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(new StringBuilder(18).append("PING initiated at ").append(time).toString());
                }
                Promise p = Promise$.MODULE$.apply();
                this.state = new Pinging(time, (Promise<Duration>)p);
                return p.future();
            }
            Exception ex = new Exception("Socket closed");
            this.state = new Closed(ex);
            return Future$.MODULE$.failed((Throwable)ex);
        }
        if (state instanceof Pinging) {
            IllegalStateException ex = new IllegalStateException("Ping already in progress");
            return Future$.MODULE$.failed((Throwable)ex);
        }
        if (state instanceof Closed) {
            Closed closed = (Closed)state;
            Exception ex = closed.ex();
            return Future$.MODULE$.failed((Throwable)ex);
        }
        throw new MatchError((Object)state);
    }

    public void pingAckReceived(byte[] data) {
        State state = this.state;
        if (state instanceof Pinging) {
            Pinging pinging = (Pinging)state;
            long sent = pinging.started();
            Promise<Duration> continuation = pinging.p();
            this.state = PingManager$Idle$.MODULE$;
            if (ByteBuffer.wrap(data).getLong() != sent) {
                String msg = "Received ping response with unknown data.";
                Exception ex = new Exception(msg);
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn(msg, (Throwable)ex);
                }
                continuation.tryFailure((Throwable)ex);
                return;
            }
            FiniteDuration duration = Duration$.MODULE$.create(package$.MODULE$.max(0L, System.currentTimeMillis() - sent), TimeUnit.MILLISECONDS);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(new StringBuilder(15).append("Ping duration: ").append(duration).toString());
            }
            continuation.trySuccess((Object)duration);
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(new StringBuilder(20).append("Ping ACKed in state ").append(state).toString());
            return;
        }
    }

    public void close() {
        State state = this.state;
        if (state instanceof Closed) {
            return;
        }
        if (PingManager$Idle$.MODULE$.equals(state)) {
            this.state = PingManager$.MODULE$.org$http4s$blaze$http$http2$PingManager$$GracefulClosed();
            return;
        }
        if (state instanceof Pinging) {
            Pinging pinging = (Pinging)state;
            Promise<Duration> p = pinging.p();
            this.state = PingManager$.MODULE$.org$http4s$blaze$http$http2$PingManager$$GracefulClosed();
            p.failure((Throwable)new Exception("PING interrupted"));
            return;
        }
        throw new MatchError((Object)state);
    }

    public PingManager(SessionCore session) {
        this.session = session;
        this.logger = LoggerFactory.getLogger(PingManager.class);
        this.state = PingManager$Idle$.MODULE$;
    }

    private static class Closed
    implements State,
    Product,
    Serializable {
        private final Exception ex;

        public Exception ex() {
            return this.ex;
        }

        public Closed copy(Exception ex) {
            return new Closed(ex);
        }

        public Exception copy$default$1() {
            return this.ex();
        }

        public String productPrefix() {
            return "Closed";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.ex();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Closed;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Closed)) return false;
            boolean bl = true;
            if (!bl) return false;
            Closed closed = (Closed)x$1;
            Exception exception = this.ex();
            Exception exception2 = closed.ex();
            if (exception == null) {
                if (exception2 != null) {
                    return false;
                }
            } else if (!exception.equals(exception2)) return false;
            if (!closed.canEqual(this)) return false;
            return true;
        }

        public Closed(Exception ex) {
            this.ex = ex;
            Product.$init$((Product)this);
        }
    }

    private static class Pinging
    implements State,
    Product,
    Serializable {
        private final long started;
        private final Promise<Duration> p;

        public long started() {
            return this.started;
        }

        public Promise<Duration> p() {
            return this.p;
        }

        public Pinging copy(long started, Promise<Duration> p) {
            return new Pinging(started, p);
        }

        public long copy$default$1() {
            return this.started();
        }

        public Promise<Duration> copy$default$2() {
            return this.p();
        }

        public String productPrefix() {
            return "Pinging";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.started());
                }
                case 1: {
                    return this.p();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Pinging;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.started()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.p()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Pinging)) return false;
            boolean bl = true;
            if (!bl) return false;
            Pinging pinging = (Pinging)x$1;
            if (this.started() != pinging.started()) return false;
            Promise<Duration> promise = this.p();
            Promise<Duration> promise2 = pinging.p();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            if (!pinging.canEqual(this)) return false;
            return true;
        }

        public Pinging(long started, Promise<Duration> p) {
            this.started = started;
            this.p = p;
            Product.$init$((Product)this);
        }
    }

    private static interface State {
    }
}

