/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.blaze;

import cats.ApplicativeError;
import cats.Apply;
import cats.FlatMap;
import cats.data.Kleisli;
import cats.effect.Sync;
import cats.implicits$;
import cats.syntax.ApplicativeErrorOps$;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.client.Client;
import org.http4s.client.Connection;
import org.http4s.client.ConnectionManager;
import org.http4s.client.DisposableResponse;
import org.http4s.client.RequestKey;
import org.http4s.client.RequestKey$;
import org.http4s.client.blaze.BlazeClientConfig;
import org.http4s.client.blaze.BlazeConnection;
import org.http4s.client.blaze.ClientTimeoutStage;
import org.http4s.client.blaze.bits$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BlazeClient$ {
    public static BlazeClient$ MODULE$;
    private final Logger logger;

    static {
        new BlazeClient$();
    }

    public <F, A extends BlazeConnection<F>> Client<F> apply(ConnectionManager<F, A> manager, BlazeClientConfig config, F onShutdown, Sync<F> F) {
        return new Client(new Kleisli((Function1 & Serializable & scala.Serializable)req -> F.suspend((Function0 & Serializable & scala.Serializable)() -> {
            RequestKey key = RequestKey$.MODULE$.fromRequest(req);
            Instant submitTime = Instant.now();
            return implicits$.MODULE$.toFlatMapOps(manager.borrow(key), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)next -> BlazeClient$.loop$1(next, manager, config, F, key, submitTime, req));
        })), onShutdown, F);
    }

    private static final Object invalidate$1(BlazeConnection connection, ConnectionManager manager$1, Sync F$1) {
        return ApplicativeErrorOps$.MODULE$.handleError$extension(implicits$.MODULE$.catsSyntaxApplicativeError(manager$1.invalidate((Connection)connection), (ApplicativeError)F$1), (Function1 & Serializable & scala.Serializable)e -> {
            BlazeClient$.MODULE$.logger.error("Error invalidating connection", e);
            return BoxedUnit.UNIT;
        }, (ApplicativeError)F$1);
    }

    private static final Object loop$1(ConnectionManager.NextConnection next, ConnectionManager manager$1, BlazeClientConfig config$1, Sync F$1, RequestKey key$1, Instant submitTime$1, Request req$1) {
        FiniteDuration elapsed = new package.DurationLong(package$.MODULE$.DurationLong(Instant.now().toEpochMilli() - submitTime$1.toEpochMilli())).millis();
        ClientTimeoutStage ts = new ClientTimeoutStage((Duration)(elapsed.$greater((Object)config$1.responseHeaderTimeout()) ? new package.DurationInt(package$.MODULE$.DurationInt(0)).milli() : config$1.responseHeaderTimeout().$minus((Duration)elapsed)), config$1.idleTimeout(), (Duration)(elapsed.$greater((Object)config$1.requestTimeout()) ? new package.DurationInt(package$.MODULE$.DurationInt(0)).milli() : config$1.requestTimeout().$minus((Duration)elapsed)), bits$.MODULE$.ClientTickWheel());
        ((Tail)next.connection()).spliceBefore((MidStage)ts);
        ts.initialize();
        return implicits$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(implicits$.MODULE$.catsSyntaxApplicativeError(((BlazeConnection)next.connection()).runRequest(req$1), (ApplicativeError)F$1), (ApplicativeError)F$1), (FlatMap)F$1).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            Left left = null;
            Either either = x0$1;
            if (either instanceof Right) {
                Right right = (Right)either;
                Response r = (Response)right.value();
                Object dispose = implicits$.MODULE$.toFlatMapOps(F$1.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ts.removeStage((Predef.$eq$colon$eq<MidStage<ByteBuffer, ByteBuffer>, MidStage<ByteBuffer, ByteBuffer>>)Predef.$eq$colon$eq$.MODULE$.tpEquals())), (FlatMap)F$1).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> manager$1.release(next.connection()));
                return F$1.pure((Object)new DisposableResponse(r, dispose));
            }
            if (either instanceof Left) {
                bl = true;
                left = (Left)either;
                Throwable throwable = (Throwable)left.value();
                if (Command.EOF$.MODULE$.equals(throwable)) {
                    return implicits$.MODULE$.toFlatMapOps(BlazeClient$.invalidate$1((BlazeConnection)next.connection(), manager$1, F$1), (FlatMap)F$1).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> next.fresh() ? F$1.raiseError((Object)new IOException(new StringBuilder(31).append("Failed to connect to endpoint: ").append(key$1).toString())) : implicits$.MODULE$.toFlatMapOps(manager$1.borrow(key$1), (FlatMap)F$1).flatMap((Function1 & Serializable & scala.Serializable)newConn -> BlazeClient$.loop$1(newConn, manager$1, config$1, F$1, key$1, submitTime$1, req$1)));
                }
            }
            if (!bl) throw new MatchError((Object)either);
            Throwable e = (Throwable)left.value();
            return implicits$.MODULE$.catsSyntaxApply(BlazeClient$.invalidate$1((BlazeConnection)next.connection(), manager$1, F$1), (Apply)F$1).$times$greater(F$1.raiseError((Object)e));
        });
    }

    private BlazeClient$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.client.blaze.BlazeClient");
    }
}

