/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import java.util.concurrent.TimeUnit;
import org.http4s.Method;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.Status$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class RetryPolicy$ {
    public static final RetryPolicy$ MODULE$;
    private final Set<Status> RetriableStatuses;

    static {
        new RetryPolicy$();
    }

    public <F> Function3<Request<F>, Either<Throwable, Response<F>>, Object, Option<FiniteDuration>> apply(Function1<Object, Option<FiniteDuration>> backoff, Function2<Request<F>, Either<Throwable, Response<F>>, Object> retriable) {
        return new Serializable(backoff, retriable){
            public static final long serialVersionUID = 0L;
            private final Function1 backoff$1;
            private final Function2 retriable$1;

            public final Option<FiniteDuration> apply(Request<F> req, Either<Throwable, Response<F>> result, int retries) {
                return BoxesRunTime.unboxToBoolean((Object)this.retriable$1.apply(req, result)) ? (Option)this.backoff$1.apply((Object)BoxesRunTime.boxToInteger((int)retries)) : None$.MODULE$;
            }
            {
                this.backoff$1 = backoff$1;
                this.retriable$1 = retriable$1;
            }
        };
    }

    public <F> Function2<Request<F>, Either<Throwable, Response<F>>, Object> apply$default$2() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Request<F> req, Either<Throwable, Response<F>> result) {
                return RetryPolicy$.MODULE$.defaultRetriable(req, result);
            }
        };
    }

    public Set<Status> RetriableStatuses() {
        return this.RetriableStatuses;
    }

    public <F> boolean defaultRetriable(Request<F> req, Either<Throwable, Response<F>> result) {
        return req.method() instanceof Method.NoBody ? this.isErrorOrRetriableStatus(result) : false;
    }

    public <F> boolean unsafeRetriable(Request<F> req, Either<Throwable, Response<F>> result) {
        return req.method().isIdempotent() ? this.isErrorOrRetriableStatus(result) : false;
    }

    public <F> boolean recklesslyRetriable(Either<Throwable, Response<F>> result) {
        return this.isErrorOrRetriableStatus(result);
    }

    private <F> boolean isErrorOrRetriableStatus(Either<Throwable, Response<F>> result) {
        Either<Throwable, Response<F>> either;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    either = result;
                    if (!(either instanceof Left)) break block2;
                    bl = true;
                    break block3;
                }
                if (!(either instanceof Right)) break block4;
                Right right = (Right)either;
                Response resp = (Response)right.b();
                bl = this.RetriableStatuses().apply((Object)resp.status());
            }
            return bl;
        }
        throw new MatchError(either);
    }

    public Function1<Object, Option<FiniteDuration>> exponentialBackoff(Duration maxWait, int maxRetry) {
        long maxInMillis = maxWait.toMillis();
        return new Serializable(maxRetry, maxInMillis){
            public static final long serialVersionUID = 0L;
            private final int maxRetry$1;
            private final long maxInMillis$1;

            public final Option<FiniteDuration> apply(int k) {
                return k > this.maxRetry$1 ? None$.MODULE$ : new Some((Object)RetryPolicy$.MODULE$.org$http4s$client$middleware$RetryPolicy$$expBackoff(k, this.maxInMillis$1));
            }
            {
                this.maxRetry$1 = maxRetry$1;
                this.maxInMillis$1 = maxInMillis$1;
            }
        };
    }

    public FiniteDuration org$http4s$client$middleware$RetryPolicy$$expBackoff(int k, long maxInMillis) {
        double millis = (package$.MODULE$.pow(2.0, (double)k) - 1.0) * 1000.0;
        double interval = package$.MODULE$.min(millis, (double)maxInMillis);
        return FiniteDuration$.MODULE$.apply((long)(package$.MODULE$.random() * interval), TimeUnit.MILLISECONDS);
    }

    private RetryPolicy$() {
        MODULE$ = this;
        this.RetriableStatuses = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Status[]{Status$.MODULE$.RequestTimeout(), Status$.MODULE$.InternalServerError(), Status$.MODULE$.ServiceUnavailable(), Status$.MODULE$.BadGateway(), Status$.MODULE$.GatewayTimeout()}));
    }
}

