/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.data.Kleisli;
import fs2.Scheduler;
import fs2.Strategy;
import fs2.Strategy$;
import fs2.Task;
import fs2.Task$;
import java.io.Serializable;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Service$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.client.Client;
import org.http4s.client.DisposableResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Retry$ {
    public static Retry$ MODULE$;
    private final Logger logger;
    private final Set<Status> RetriableStatuses;

    static {
        new Retry$();
    }

    public Client apply(Function1<Object, Option<FiniteDuration>> backoff, Client client, ExecutionContext ec, Scheduler scheduler) {
        Strategy s = Strategy$.MODULE$.fromExecutionContext(ec);
        return client.copy((Kleisli<Task, Request, DisposableResponse>)Service$.MODULE$.lift((Function1 & Serializable & scala.Serializable)x$2 -> Retry$.prepareLoop$1(x$2, 1, backoff, client, scheduler, s)), client.copy$default$2());
    }

    private static final Task prepareLoop$1(Request req, int attempts, Function1 backoff$1, Client client$1, Scheduler scheduler$1, Strategy s$1) {
        return ((Task)client$1.open().apply((Object)req)).attempt().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Task task;
            boolean bl = false;
            Right right = null;
            Either either = x0$1;
            if (either instanceof Right) {
                Status status;
                Response response;
                bl = true;
                right = (Right)either;
                DisposableResponse dr = (DisposableResponse)right.value();
                if (dr != null && (response = dr.response()) != null && Retry$.MODULE$.RetriableStatuses.apply((Object)(status = response.status()))) {
                    Task task2;
                    Option option = (Option)backoff$1.apply((Object)BoxesRunTime.boxToInteger((int)attempts));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        FiniteDuration duration = (FiniteDuration)some.value();
                        if (Retry$.MODULE$.logger.isInfoEnabled()) {
                            Retry$.MODULE$.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request ", " has failed on attempt #", " with reason ", ". Retrying after ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{req, BoxesRunTime.boxToInteger((int)attempts), status, duration})));
                        }
                        task2 = dr.dispose().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Retry$.nextAttempt$1(req, attempts, duration, backoff$1, client$1, scheduler$1, s$1));
                        return task2;
                    } else {
                        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                        if (Retry$.MODULE$.logger.isInfoEnabled()) {
                            Retry$.MODULE$.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request ", " has failed on attempt #", " with reason ", ". Giving up."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{req, BoxesRunTime.boxToInteger((int)attempts), status})));
                        }
                        task2 = Task$.MODULE$.now((Object)dr);
                    }
                    return task2;
                }
            }
            if (bl) {
                DisposableResponse dr = (DisposableResponse)right.value();
                return Task$.MODULE$.now((Object)dr);
            }
            if (!(either instanceof Left)) throw new MatchError((Object)either);
            Left left = (Left)either;
            Throwable e = (Throwable)left.value();
            Option option = (Option)backoff$1.apply((Object)BoxesRunTime.boxToInteger((int)attempts));
            if (option instanceof Some) {
                Some some = (Some)option;
                FiniteDuration duration = (FiniteDuration)some.value();
                if (Retry$.MODULE$.logger.isErrorEnabled()) {
                    Retry$.MODULE$.logger.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request ", " threw an exception on attempt #", " attempts. Retrying after ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{req, BoxesRunTime.boxToInteger((int)attempts), duration})), e);
                }
                task = Retry$.nextAttempt$1(req, attempts, duration, backoff$1, client$1, scheduler$1, s$1);
                return task;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                if (Retry$.MODULE$.logger.isInfoEnabled()) {
                    Retry$.MODULE$.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request ", " threw an exception on attempt #", " attempts. Giving up."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{req, BoxesRunTime.boxToInteger((int)attempts)})));
                }
                task = Task$.MODULE$.fail(e);
            }
            return task;
        });
    }

    private static final Task nextAttempt$1(Request req, int attempts, FiniteDuration duration, Function1 backoff$1, Client client$1, Scheduler scheduler$1, Strategy s$1) {
        return Retry$.prepareLoop$1((Request)req.withEmptyBody(), attempts + 1, backoff$1, client$1, scheduler$1, s$1).schedule(duration, s$1, scheduler$1);
    }

    private Retry$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.client.middleware.Retry");
        this.RetriableStatuses = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Status[]{Status$.MODULE$.RequestTimeout(), Status$.MODULE$.InternalServerError(), Status$.MODULE$.ServiceUnavailable(), Status$.MODULE$.BadGateway(), Status$.MODULE$.GatewayTimeout()}));
    }
}

