/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.oauth1;

import cats.data.NonEmptyList;
import fs2.Task;
import fs2.Task$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.http4s.Charset;
import org.http4s.Charset$;
import org.http4s.Credentials;
import org.http4s.Header;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Query;
import org.http4s.Query$;
import org.http4s.Request;
import org.http4s.Uri;
import org.http4s.UrlForm;
import org.http4s.UrlForm$;
import org.http4s.client.oauth1.Consumer;
import org.http4s.client.oauth1.Token;
import org.http4s.headers.Authorization;
import org.http4s.headers.Content;
import org.http4s.internal.parboiled2.CharPredicate;
import org.http4s.syntax.StringOps$;
import org.http4s.syntax.package;
import org.http4s.util.UrlCodingUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class package$ {
    public static package$ MODULE$;
    private final String SHA1;
    private final String OutOfBand;

    static {
        new package$();
    }

    private String SHA1() {
        return this.SHA1;
    }

    private java.nio.charset.Charset UTF_8() {
        return StandardCharsets.UTF_8;
    }

    private String OutOfBand() {
        return this.OutOfBand;
    }

    public Task<Request> signRequest(Request req, Consumer consumer, Option<Uri> callback, Option<String> verifier, Option<Token> token) {
        return this.getUserParams(req).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Request req = (Request)tuple2._1();
            Seq params = (Seq)tuple2._2();
            Authorization auth = MODULE$.genAuthHeader(req.method(), req.uri(), (Seq<Tuple2<String, String>>)params, consumer, callback, verifier, token);
            Request request = (Request)req.putHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{auth}));
            return request;
        });
    }

    public Authorization genAuthHeader(Method method, Uri uri, Seq<Tuple2<String, String>> userParams, Consumer consumer, Option<Uri> callback, Option<String> verifier, Option<Token> token) {
        ListBuffer params = new ListBuffer();
        params.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_consumer_key"), (Object)this.encode(consumer.key())));
        params.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_signature_method"), (Object)"HMAC-SHA1"));
        params.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_timestamp"), (Object)((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() / 1000L))).toString()));
        params.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_nonce"), (Object)((Object)BoxesRunTime.boxToLong((long)System.nanoTime())).toString()));
        params.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_version"), (Object)"1.0"));
        params.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_callback"), callback.map((Function1 & Serializable & scala.Serializable)c -> MODULE$.encode(c.renderString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.OutOfBand())));
        token.foreach((Function1 & Serializable & scala.Serializable)t -> params.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_token"), (Object)MODULE$.encode(t.value()))));
        verifier.foreach((Function1 & Serializable & scala.Serializable)v -> params.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_verifier"), (Object)MODULE$.encode((String)v))));
        List params2 = params.result();
        String baseString = this.genBaseString(method, uri, (Seq<Tuple2<String, String>>)((Seq)params2.$plus$plus((GenTraversableOnce)userParams.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)MODULE$.encode(k), (Object)MODULE$.encode(v));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())));
        String sig = this.makeSHASig(baseString, consumer, token);
        Credentials.AuthParams creds = new Credentials.AuthParams(StringOps$.MODULE$.ci$extension(package.string$.MODULE$.http4sStringSyntax("OAuth")), new NonEmptyList((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_signature"), (Object)this.encode(sig)), params2));
        return new Authorization((Credentials)creds);
    }

    public String makeSHASig(String baseString, Consumer consumer, Option<Token> token) {
        Mac sha1 = Mac.getInstance(this.SHA1());
        String key = this.encode(consumer.secret()) + "&" + token.map((Function1 & Serializable & scala.Serializable)t -> MODULE$.encode(t.secret())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        sha1.init(new SecretKeySpec(this.bytes(key), this.SHA1()));
        byte[] sigBytes = sha1.doFinal(this.bytes(baseString));
        return Base64.getEncoder().encodeToString(sigBytes);
    }

    public String genBaseString(Method method, Uri uri, Seq<Tuple2<String, String>> params) {
        String paramsStr = ((TraversableOnce)((SeqLike)params.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = k + "=" + v;
            return string;
        }, Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("&");
        String[] stringArray = new String[3];
        stringArray[0] = method.name();
        Query x$3 = Query$.MODULE$.empty();
        None$ x$4 = None$.MODULE$;
        Option x$5 = uri.copy$default$1();
        Option x$6 = uri.copy$default$2();
        String x$7 = uri.copy$default$3();
        stringArray[1] = this.encode(uri.copy(x$5, x$6, x$7, x$3, (Option)x$4).renderString());
        stringArray[2] = this.encode(paramsStr);
        return ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])stringArray))).mkString("&");
    }

    public String encode(String str) {
        String x$8 = str;
        boolean x$9 = false;
        CharPredicate x$10 = UrlCodingUtils$.MODULE$.Unreserved();
        java.nio.charset.Charset x$11 = UrlCodingUtils$.MODULE$.urlEncode$default$2();
        return UrlCodingUtils$.MODULE$.urlEncode(x$8, x$11, x$9, (Function1)x$10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Task<Tuple2<Request, Seq<Tuple2<String, String>>>> getUserParams(Request req) {
        IndexedSeq qparams = (IndexedSeq)req.uri().query().map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Option ov = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)k, ov.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
            return tuple22;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Option option = req.contentType();
        if (!(option instanceof Some)) return Task$.MODULE$.now((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)req), (Object)qparams));
        Some some = (Some)option;
        Content.minusType t = (Content.minusType)some.value();
        Method method = req.method();
        Method.Semantics$.Default default_ = Method$.MODULE$.POST();
        if (method == null ? default_ != null : !method.equals(default_)) {
            Method method2 = req.method();
            Method.Semantics$.Idempotent idempotent = Method$.MODULE$.PUT();
            if (method2 == null) {
                if (idempotent != null) {
                    return Task$.MODULE$.now((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)req), (Object)qparams));
                }
            } else if (!method2.equals(idempotent)) return Task$.MODULE$.now((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)req), (Object)qparams));
        }
        MediaType mediaType = t.mediaType();
        MediaType mediaType2 = MediaType$.MODULE$.application$divx$minuswww$minusform$minusurlencoded();
        if (mediaType == null) {
            if (mediaType2 == null) return req.as(UrlForm$.MODULE$.entityDecoder(UrlForm$.MODULE$.entityDecoder$default$1())).flatMap((Function1 & Serializable & scala.Serializable)urlform -> package$.$anonfun$getUserParams$3(req, qparams, ((UrlForm)urlform).values()));
            return Task$.MODULE$.now((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)req), (Object)qparams));
        } else {
            if (!mediaType.equals(mediaType2)) return Task$.MODULE$.now((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)req), (Object)qparams));
            return req.as(UrlForm$.MODULE$.entityDecoder(UrlForm$.MODULE$.entityDecoder$default$1())).flatMap((Function1 & Serializable & scala.Serializable)urlform -> package$.$anonfun$getUserParams$3(req, qparams, ((UrlForm)urlform).values()));
        }
    }

    private byte[] bytes(String str) {
        return str.getBytes(this.UTF_8());
    }

    public static final /* synthetic */ Task $anonfun$getUserParams$3(Request req$1, IndexedSeq qparams$1, Map urlform) {
        Seq bodyparams = (Seq)urlform.toSeq().flatMap((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Seq vs = (Seq)tuple2._2();
            Seq seq = vs.isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)"")})) : (Seq)vs.map((Function1 & Serializable & scala.Serializable)x$1 -> new Tuple2((Object)k, x$1), Seq$.MODULE$.canBuildFrom());
            return seq;
        }, Seq$.MODULE$.canBuildFrom());
        return req$1.withBody((Object)new UrlForm(urlform), UrlForm$.MODULE$.entityEncoder((Charset)req$1.charset().getOrElse((Function0 & Serializable & scala.Serializable)() -> Charset$.MODULE$.UTF$minus8()))).map((Function1 & Serializable & scala.Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$2), qparams$1.$plus$plus((GenTraversableOnce)bodyparams, IndexedSeq$.MODULE$.canBuildFrom())));
    }

    private package$() {
        MODULE$ = this;
        this.SHA1 = "HmacSHA1";
        this.OutOfBand = "oob";
    }
}

