/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.Applicative;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.MonadError;
import cats.effect.Bracket;
import cats.effect.Concurrent;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.Timer;
import cats.syntax.FlatMapOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.http4s.HeaderKey;
import org.http4s.Headers$;
import org.http4s.HttpDate;
import org.http4s.Method;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.headers.Retry;
import org.http4s.headers.Retry$minusAfter$;
import org.http4s.util.CaseInsensitiveString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Retry$ {
    public static Retry$ MODULE$;
    private final Logger logger;

    static {
        new Retry$();
    }

    public <F> Client<F> apply(Function3<Request<F>, Either<Throwable, Response<F>>, Object, Option<FiniteDuration>> policy, Function1<CaseInsensitiveString, Object> redactHeaderWhen, Client<F> client, Concurrent<F> F, Timer<F> T) {
        return Client$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$2 -> Retry$.prepareLoop$1(x$2, 1, F, client, policy, redactHeaderWhen, T), F);
    }

    public <F> Function1<CaseInsensitiveString, Object> apply$default$2() {
        return (Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)Retry$.$anonfun$apply$default$2$1(elem));
    }

    private static final Resource prepareLoop$1(Request req, int attempts, Concurrent F$1, Client client$1, Function3 policy$1, Function1 redactHeaderWhen$1, Timer T$1) {
        return Resource$.MODULE$.suspend(F$1.continual(client$1.run(req).allocated((Bracket)F$1), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Right right;
            Tuple2 tuple2;
            Either either = x0$1;
            if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                Object object2;
                Response response = (Response)tuple2._1();
                Object dispose = tuple2._2();
                Option option = (Option)policy$1.apply((Object)req, (Object)package$.MODULE$.Right().apply((Object)response), (Object)BoxesRunTime.boxToInteger((int)attempts));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FiniteDuration duration = (FiniteDuration)some.value();
                    if (Retry$.MODULE$.logger.isInfoEnabled()) {
                        Retry$.MODULE$.logger.info(new StringBuilder(63).append("Request ").append(Retry$.showRequest$1(req, redactHeaderWhen$1)).append(" has failed on attempt #").append(attempts).append(" with reason ").append(response.status()).append(". Retrying after ").append(duration).append(".").toString());
                    }
                    object2 = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(dispose, (FlatMap)F$1), (Function0 & Serializable & scala.Serializable)() -> F$1.pure((Object)Retry$.nextAttempt$1(req, attempts, duration, Headers$.MODULE$.get$extension0(response.headers(), (HeaderKey.Extractable)Retry$minusAfter$.MODULE$), T$1, F$1, client$1, policy$1, redactHeaderWhen$1)), (FlatMap)F$1);
                } else if (None$.MODULE$.equals(option)) {
                    object2 = F$1.pure((Object)Resource$.MODULE$.make(F$1.pure((Object)response), (Function1 & Serializable & scala.Serializable)x$1 -> dispose, (Functor)F$1));
                } else {
                    throw new MatchError((Object)option);
                }
                object = object2;
            } else if (either instanceof Left) {
                Object object3;
                Left left = (Left)either;
                Throwable e = (Throwable)left.value();
                Option option = (Option)policy$1.apply((Object)req, (Object)package$.MODULE$.Left().apply((Object)e), (Object)BoxesRunTime.boxToInteger((int)attempts));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FiniteDuration duration = (FiniteDuration)some.value();
                    if (Retry$.MODULE$.logger.isInfoEnabled()) {
                        Retry$.MODULE$.logger.info(new StringBuilder(56).append("Request threw an exception on attempt #").append(attempts).append(". Retrying after ").append(duration).toString(), e);
                    }
                    object3 = F$1.pure((Object)Retry$.nextAttempt$1(req, attempts, duration, (Option)None$.MODULE$, T$1, F$1, client$1, policy$1, redactHeaderWhen$1));
                } else if (None$.MODULE$.equals(option)) {
                    if (Retry$.MODULE$.logger.isInfoEnabled()) {
                        Retry$.MODULE$.logger.info(new StringBuilder(52).append("Request ").append(Retry$.showRequest$1(req, redactHeaderWhen$1)).append(" threw an exception on attempt #").append(attempts).append(". Giving up.").toString(), e);
                    }
                    object3 = F$1.pure((Object)Resource$.MODULE$.eval(F$1.raiseError((Object)e), (Applicative)F$1));
                } else {
                    throw new MatchError((Object)option);
                }
                object = object3;
            } else {
                throw new MatchError((Object)either);
            }
            return object;
        }));
    }

    private static final String showRequest$1(Request request, Function1 redactWhen) {
        String headers = Headers$.MODULE$.toList$extension(Headers$.MODULE$.redactSensitive$extension(request.headers(), redactWhen)).mkString(",");
        String uri = request.uri().renderString();
        Method method = request.method();
        return new StringBuilder(21).append("method=").append(method).append(" uri=").append(uri).append(" headers=").append(headers).toString();
    }

    public static final /* synthetic */ long $anonfun$apply$4(Retry.minusAfter h) {
        long l;
        Either either = h.retry();
        if (either instanceof Left) {
            Left left = (Left)either;
            HttpDate d = (HttpDate)left.value();
            l = Instant.now().until(d.toInstant(), ChronoUnit.SECONDS);
        } else if (either instanceof Right) {
            long secs;
            Right right = (Right)either;
            l = secs = BoxesRunTime.unboxToLong((Object)right.value());
        } else {
            throw new MatchError((Object)either);
        }
        return l;
    }

    private static final Resource nextAttempt$1(Request req, int attempts, FiniteDuration duration, Option retryHeader, Timer T$1, Concurrent F$1, Client client$1, Function3 policy$1, Function1 redactHeaderWhen$1) {
        long headerDuration = BoxesRunTime.unboxToLong((Object)retryHeader.map((Function1 & Serializable & scala.Serializable)h -> BoxesRunTime.boxToLong((long)Retry$.$anonfun$apply$4(h))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        FiniteDuration sleepDuration = new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(headerDuration)).seconds().max(duration);
        return (Resource)package.all$.MODULE$.catsSyntaxApply((Object)Resource$.MODULE$.eval(T$1.sleep(sleepDuration), (Applicative)F$1), (Apply)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)F$1)).$times$greater((Object)Retry$.prepareLoop$1(req, attempts + 1, F$1, client$1, policy$1, redactHeaderWhen$1, T$1));
    }

    public static final /* synthetic */ boolean $anonfun$apply$default$2$1(CaseInsensitiveString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains((Object)elem);
    }

    private Retry$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.client.middleware.Retry");
    }
}

