/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.effect.kernel.Async;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Sync;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import org.http4s.Headers$;
import org.http4s.Message;
import org.http4s.Request;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.client.middleware.Logger$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.typelevel.ci.CIString;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;

public final class RequestLogger$
implements Serializable {
    private static final Logger logger;
    private static final String defaultRequestColor;
    public static final RequestLogger$ MODULE$;

    private RequestLogger$() {
    }

    static {
        MODULE$ = new RequestLogger$();
        logger = LoggerFactory.getLogger((String)"org.http4s.client.middleware.RequestLogger");
        defaultRequestColor = "\u001b[34m";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RequestLogger$.class);
    }

    private <F> Object defaultLogAction(String s, Sync<F> evidence$1) {
        return cats.effect.package$.MODULE$.Sync().apply(evidence$1).delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.defaultLogAction$$anonfun$1(s)));
    }

    public <F> Client<F> apply(boolean logHeaders, boolean logBody, Function1<CIString, Object> redactHeadersWhen, Option<Function1<String, Object>> logAction, Client<F> client, Async<F> evidence$2) {
        return this.impl(client, logBody, (Function1 & Serializable)request -> Logger$.MODULE$.logMessage(request, logHeaders, logBody, redactHeadersWhen, (Function1<String, Object>)((Function1)logAction.getOrElse(() -> this.apply$$anonfun$3$$anonfun$2(evidence$2))), evidence$2), evidence$2);
    }

    public <F> Function1<CIString, Object> apply$default$3() {
        return (Function1 & Serializable)elem -> Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    public <F> None$ apply$default$4() {
        return None$.MODULE$;
    }

    public <F> Client<F> logBodyText(boolean logHeaders, Function1<Stream<F, Object>, Option<Object>> logBody, Function1<CIString, Object> redactHeadersWhen, Option<Function1<String, Object>> logAction, Client<F> client, Async<F> evidence$3) {
        return this.impl(client, true, (Function1 & Serializable)request -> org.http4s.internal.Logger$.MODULE$.logMessageWithBodyText((Message)request, logHeaders, logBody, redactHeadersWhen, (Function1)logAction.getOrElse(() -> this.logBodyText$$anonfun$3$$anonfun$2(evidence$3)), (GenConcurrent)evidence$3), evidence$3);
    }

    public <F> Function1<CIString, Object> logBodyText$default$3() {
        return (Function1 & Serializable)elem -> Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    public <F> None$ logBodyText$default$4() {
        return None$.MODULE$;
    }

    public <F> Client<F> customized(Client<F> client, boolean logBody, Option<Function1<String, Object>> logAction, Function1<Request<F>, Object> requestToText, Async<F> evidence$4) {
        return this.impl(client, logBody, (Function1 & Serializable)request -> {
            Function1 log = (Function1)logAction.getOrElse(() -> this.$anonfun$2(evidence$4));
            return package.all$.MODULE$.toFlatMapOps(requestToText.apply(request), (FlatMap)evidence$4).flatMap(log);
        }, evidence$4);
    }

    public boolean customized$default$2() {
        return true;
    }

    public <F> None$ customized$default$3() {
        return None$.MODULE$;
    }

    private <F> Client<F> impl(Client<F> client, boolean logBody, Function1<Request<F>, Object> logMessage, Async<F> F) {
        return Client$.MODULE$.apply((Function1 & Serializable)req -> {
            Resource resource;
            if (!logBody) {
                resource = (Resource)package.all$.MODULE$.catsSyntaxApply((Object)cats.effect.package$.MODULE$.Resource().eval(logMessage.apply(req)), (Apply)Resource$.MODULE$.catsEffectAsyncForResource(F)).$times$greater(client.run((Request)req));
            } else {
                Ref.Make make = cats.effect.package$.MODULE$.Ref().apply(Ref.Make$.MODULE$.concurrentInstance((GenConcurrent)F));
                resource = cats.effect.package$.MODULE$.Resource().suspend(package.all$.MODULE$.toFunctorOps(Ref.ApplyBuilders$.MODULE$.of$extension(make, (Object)package$.MODULE$.Vector().empty()), (Functor)F).map((Function1 & Serializable)vec -> {
                    Stream newBody = Stream$.MODULE$.eval(vec.get()).flatMap((Function1 & Serializable)v -> {
                        Stream stream = Stream$.MODULE$.PureOps(Stream$.MODULE$.emits((Seq)v));
                        return Stream.PureOps$.MODULE$.covary$extension(stream);
                    }, NotGiven$.MODULE$.value()).flatMap((Function1 & Serializable)c -> {
                        Stream stream = Stream$.MODULE$.PureOps(Stream$.MODULE$.chunk(c));
                        return Stream.PureOps$.MODULE$.covary$extension(stream);
                    }, NotGiven$.MODULE$.value());
                    Stream stream = Stream$.MODULE$.InvariantOps(req.body());
                    Object object = package.all$.MODULE$.catsSyntaxApplicativeError(logMessage.apply((Object)req.withBodyStream(newBody)), (ApplicativeError)F);
                    Request changedRequest = (Request)req.withBodyStream(Stream.InvariantOps$.MODULE$.observe$extension(stream, (Function1 & Serializable)_$6 -> _$6.chunks().flatMap((Function1 & Serializable)s -> Stream$.MODULE$.exec(vec.update((Function1 & Serializable)_$7 -> (Vector)_$7.$colon$plus(s))), NotGiven$.MODULE$.value()), (GenConcurrent)F).onFinalizeWeak(package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, (ApplicativeError)F), (FlatMap)F).flatMap((Function1 & Serializable)x$1 -> {
                        Object object;
                        Either either = x$1;
                        if (either instanceof Left) {
                            Throwable t = (Throwable)((Left)either).value();
                            object = F.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.$anonfun$8$$anonfun$1(t)));
                            return object;
                        } else {
                            if (!(either instanceof Right)) throw new MatchError((Object)either);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            Object object2 = ((Right)either).value();
                            if (boxedUnit != null ? !boxedUnit.equals(object2) : object2 != null) throw new MatchError((Object)either);
                            object = F.unit();
                        }
                        return object;
                    }), (Applicative)F));
                    return client.run(changedRequest);
                }));
            }
            return resource;
        }, F);
    }

    public String defaultRequestColor() {
        return defaultRequestColor;
    }

    public <F> Client<F> colored(boolean logHeaders, boolean logBody, Function1<CIString, Object> redactHeadersWhen, String color, Option<Function1<String, Object>> logAction, Client<F> client, Async<F> F) {
        return this.customized(client, logBody, logAction, (Function1 & Serializable)request -> {
            Object object;
            String methodColor = request.method().isSafe() ? color : "\u001b[33m";
            String prelude = "" + request.httpVersion() + " " + methodColor + request.method() + "\u001b[0m" + color + " " + "\u001b[1m" + request.uri() + "\u001b[0m" + color;
            String headers = org.http4s.internal.Logger$.MODULE$.defaultLogHeaders((Message)request, logHeaders, redactHeadersWhen);
            Option option = org.http4s.internal.Logger$.MODULE$.defaultLogBody((Message)request, logBody, (GenConcurrent)F);
            if (option instanceof Some) {
                Object textF = ((Some)option).value();
                object = package.all$.MODULE$.toFunctorOps(textF, (Functor)F).map((Function1 & Serializable)text -> "body=\"" + text + "\"");
            } else if (None$.MODULE$.equals(option)) {
                object = cats.effect.package$.MODULE$.Sync().apply((Sync)F).pure((Object)"");
            } else {
                throw new MatchError((Object)option);
            }
            Object bodyText = object;
            return package.all$.MODULE$.toFunctorOps(bodyText, (Functor)F).map((Function1 & Serializable)body -> "" + color + prelude + this.spaced$1(headers) + this.spaced$1((String)body) + "\u001b[0m");
        }, F);
    }

    public <F> Function1<CIString, Object> colored$default$3() {
        return (Function1 & Serializable)elem -> Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    public <F> String colored$default$4() {
        return this.defaultRequestColor();
    }

    public <F> None$ colored$default$5() {
        return None$.MODULE$;
    }

    private final void defaultLogAction$$anonfun$1(String s$1) {
        Logger Logger_this = logger;
        if (Logger_this.isInfoEnabled()) {
            Logger_this.info(s$1);
        }
    }

    private final Function1 apply$$anonfun$3$$anonfun$2(Async evidence$2$2) {
        return (Function1 & Serializable)s -> this.defaultLogAction((String)s, (Sync)evidence$2$2);
    }

    private final Function1 logBodyText$$anonfun$3$$anonfun$2(Async evidence$3$2) {
        return (Function1 & Serializable)s -> this.defaultLogAction((String)s, (Sync)evidence$3$2);
    }

    private final Function1 $anonfun$2(Async evidence$4$2) {
        return (Function1 & Serializable)s -> this.defaultLogAction((String)s, (Sync)evidence$4$2);
    }

    private final void $anonfun$8$$anonfun$1(Throwable t$1) {
        Logger Logger_this = logger;
        if (Logger_this.isErrorEnabled()) {
            Logger_this.error("Error logging request body", t$1);
        }
    }

    private final String spaced$1(String x) {
        return x.isEmpty() ? x : " " + x;
    }
}

