/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.ApplicativeError;
import cats.FlatMap;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.std.Hotswap;
import cats.effect.std.Hotswap$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpDate;
import org.http4s.Method;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.headers.Retry$minusAfter$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.typelevel.ci.CIString;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Retry$
implements Serializable {
    private static final Logger logger;
    public static final Retry$ MODULE$;

    private Retry$() {
    }

    static {
        MODULE$ = new Retry$();
        logger = LoggerFactory.getLogger((String)"org.http4s.client.middleware.Retry");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Retry$.class);
    }

    public <F> Client<F> apply(Function3<Request<F>, Either<Throwable, Response<F>>, Object, Option<FiniteDuration>> policy, Function1<CIString, Object> redactHeaderWhen, Client<F> client, GenTemporal<F, Throwable> F) {
        return Client$.MODULE$.apply((Function1 & Serializable)req -> Hotswap$.MODULE$.create((GenConcurrent)F).flatMap((Function1 & Serializable)hotswap -> Resource$.MODULE$.eval(this.retryLoop$1(policy, (Function1)redactHeaderWhen, client, F, (Request)req, 1, (Hotswap)hotswap))), F);
    }

    public <F> Function1<CIString, Object> apply$default$2() {
        return (Function1 & Serializable)elem -> Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    private final String showRequest$1(Request request, Function1 redactWhen) {
        String headers = Headers$.MODULE$.redactSensitive$extension(request.headers(), redactWhen).mkString(",");
        String uri = request.uri().renderString();
        Method method = request.method();
        return "method=" + method + " uri=" + uri + " headers=" + headers;
    }

    private final long $anonfun$2() {
        return 0L;
    }

    private final Object nextAttempt$1$$anonfun$1(Function3 policy$2, Function1 redactHeaderWhen$2, Client client$2, GenTemporal F$2, Request req$1, int attempts$1, Hotswap hotswap$1) {
        return this.retryLoop$1(policy$2, redactHeaderWhen$2, client$2, F$2, req$1, attempts$1 + 1, hotswap$1);
    }

    private final Object nextAttempt$2(Function3 policy$1, Function1 redactHeaderWhen$1, Client client$1, GenTemporal F$1, Request req, int attempts, FiniteDuration duration, Option retryHeader, Hotswap hotswap) {
        long headerDuration = BoxesRunTime.unboxToLong((Object)retryHeader.map((Function1 & Serializable)h -> {
            long l;
            Either either = h.retry();
            if (either instanceof Left) {
                HttpDate d = (HttpDate)((Left)either).value();
                l = Instant.now().until(d.toInstant(), ChronoUnit.SECONDS);
            } else if (either instanceof Right) {
                long secs;
                l = secs = BoxesRunTime.unboxToLong((Object)((Right)either).value());
            } else {
                throw new MatchError((Object)either);
            }
            return l;
        }).getOrElse(this::$anonfun$2));
        FiniteDuration sleepDuration = new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(headerDuration)).seconds().max(duration);
        Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(F$1.sleep(sleepDuration), (FlatMap)F$1);
        return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.nextAttempt$1$$anonfun$1(policy$1, redactHeaderWhen$1, client$1, F$1, req, attempts, hotswap), (FlatMap)F$1);
    }

    private final Object retryLoop$1(Function3 policy$3, Function1 redactHeaderWhen$3, Client client$3, GenTemporal F$3, Request req, int attempts, Hotswap hotswap) {
        Resource resource = (Resource)package.all$.MODULE$.catsSyntaxApplicativeError(client$3.run(req), (ApplicativeError)Resource$.MODULE$.catsEffectTemporalForResource(F$3));
        return package.all$.MODULE$.toFlatMapOps(hotswap.swap((Resource)ApplicativeErrorOps$.MODULE$.attempt$extension((Object)resource, (ApplicativeError)Resource$.MODULE$.catsEffectTemporalForResource(F$3))), (FlatMap)F$3).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            Either either = x$1;
            if (either instanceof Right) {
                Response response = (Response)((Right)either).value();
                Option option = (Option)policy$3.apply((Object)req, (Object)package$.MODULE$.Right().apply((Object)response), (Object)BoxesRunTime.boxToInteger((int)attempts));
                if (option instanceof Some) {
                    FiniteDuration duration = (FiniteDuration)((Some)option).value();
                    Logger Logger_this = logger;
                    if (Logger_this.isInfoEnabled()) {
                        Logger_this.info("Request " + this.showRequest$1(req, redactHeaderWhen$3) + " has failed on attempt #" + attempts + " with reason " + response.status() + ". Retrying after " + duration + ".");
                    }
                    object = this.nextAttempt$2(policy$3, redactHeaderWhen$3, client$3, F$3, req, attempts, duration, Headers$.MODULE$.get$extension(response.headers(), Header.Select$.MODULE$.singleHeaders(Retry$minusAfter$.MODULE$.headerInstance())), hotswap);
                    return object;
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    object = F$3.pure((Object)response);
                }
                return object;
            } else {
                if (!(either instanceof Left)) throw new MatchError((Object)either);
                Throwable e = (Throwable)((Left)either).value();
                Option option = (Option)policy$3.apply((Object)req, (Object)package$.MODULE$.Left().apply((Object)e), (Object)BoxesRunTime.boxToInteger((int)attempts));
                if (option instanceof Some) {
                    FiniteDuration duration = (FiniteDuration)((Some)option).value();
                    Logger Logger_this = logger;
                    if (Logger_this.isInfoEnabled()) {
                        Logger_this.info("Request threw an exception on attempt #" + attempts + ". Retrying after " + duration, e);
                    }
                    object = this.nextAttempt$2(policy$3, redactHeaderWhen$3, client$3, F$3, req, attempts, duration, (Option)None$.MODULE$, hotswap);
                    return object;
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    Logger Logger_this = logger;
                    if (Logger_this.isInfoEnabled()) {
                        Logger_this.info("Request " + this.showRequest$1(req, redactHeaderWhen$3) + " threw an exception on attempt #" + attempts + ". Giving up.", e);
                    }
                    object = F$3.raiseError((Object)e);
                }
            }
            return object;
        });
    }
}

