package org.http4s

import org.http4s.dsl.impl._
import org.http4s.headers.`Content-Length`
import scalaz.concurrent.Task

package object dsl extends Http4s {

  val GET: Method.GET.type = Method.GET
  val HEAD: Method.HEAD.type = Method.HEAD
  val POST: Method.POST.type = Method.POST
  val PUT: Method.PUT.type = Method.PUT
  val DELETE: Method.DELETE.type = Method.DELETE
  val CONNECT: Method.CONNECT.type = Method.CONNECT
  val OPTIONS: Method.OPTIONS.type = Method.OPTIONS
  val TRACE: Method.TRACE.type = Method.TRACE
  val PATCH: Method.PATCH.type = Method.PATCH

  val Continue: Status.Continue.type = Status.Continue
  val SwitchingProtocols: Status.SwitchingProtocols.type = Status.SwitchingProtocols
  val Processing: Status.Processing.type = Status.Processing

  val Ok: Status.Ok.type = Status.Ok
  val Created: Status.Created.type = Status.Created
  val Accepted: Status.Accepted.type = Status.Accepted
  val NonAuthoritativeInformation: Status.NonAuthoritativeInformation.type = Status.NonAuthoritativeInformation
  val NoContent: Status.NoContent.type = Status.NoContent
  val ResetContent: Status.ResetContent.type = Status.ResetContent
  val PartialContent: Status.PartialContent.type = Status.PartialContent
  val MultiStatus: Status.MultiStatus.type = Status.MultiStatus
  val AlreadyReported: Status.AlreadyReported.type = Status.AlreadyReported
  val IMUsed: Status.IMUsed.type = Status.IMUsed

  val MultipleChoices: Status.MultipleChoices.type = Status.MultipleChoices
  val MovedPermanently: Status.MovedPermanently.type = Status.MovedPermanently
  val Found: Status.Found.type = Status.Found
  val SeeOther: Status.SeeOther.type = Status.SeeOther
  val NotModified: Status.NotModified.type = Status.NotModified
  val UseProxy: Status.UseProxy.type = Status.UseProxy
  val TemporaryRedirect: Status.TemporaryRedirect.type = Status.TemporaryRedirect
  val PermanentRedirect: Status.PermanentRedirect.type = Status.PermanentRedirect

  val BadRequest: Status.BadRequest.type = Status.BadRequest
  val Unauthorized: Status.Unauthorized.type = Status.Unauthorized
  val PaymentRequired: Status.PaymentRequired.type = Status.PaymentRequired
  val Forbidden: Status.Forbidden.type = Status.Forbidden
  val NotFound: Status.NotFound.type = Status.NotFound
  val MethodNotAllowed: Status.MethodNotAllowed.type = Status.MethodNotAllowed
  val NotAcceptable: Status.NotAcceptable.type = Status.NotAcceptable
  val ProxyAuthenticationRequired: Status.ProxyAuthenticationRequired.type = Status.ProxyAuthenticationRequired
  val RequestTimeout: Status.RequestTimeout.type = Status.RequestTimeout
  val Conflict: Status.Conflict.type = Status.Conflict
  val Gone: Status.Gone.type = Status.Gone
  val LengthRequired: Status.LengthRequired.type = Status.LengthRequired
  val PreconditionFailed: Status.PreconditionFailed.type = Status.PreconditionFailed
  val PayloadTooLarge: Status.PayloadTooLarge.type = Status.PayloadTooLarge
  val UriTooLong: Status.UriTooLong.type = Status.UriTooLong
  val UnsupportedMediaType: Status.UnsupportedMediaType.type = Status.UnsupportedMediaType
  val RangeNotSatisfiable: Status.RangeNotSatisfiable.type = Status.RangeNotSatisfiable
  val ExpectationFailed: Status.ExpectationFailed.type = Status.ExpectationFailed
  val UnprocessableEntity: Status.UnprocessableEntity.type = Status.UnprocessableEntity
  val Locked: Status.Locked.type = Status.Locked
  val FailedDependency: Status.FailedDependency.type = Status.FailedDependency
  val UpgradeRequired: Status.UpgradeRequired.type = Status.UpgradeRequired
  val PreconditionRequired: Status.PreconditionRequired.type = Status.PreconditionRequired
  val TooManyRequests: Status.TooManyRequests.type = Status.TooManyRequests
  val RequestHeaderFieldsTooLarge: Status.RequestHeaderFieldsTooLarge.type = Status.RequestHeaderFieldsTooLarge
  val UnavailableForLegalReasons: Status.UnavailableForLegalReasons.type = Status.UnavailableForLegalReasons

  val InternalServerError: Status.InternalServerError.type = Status.InternalServerError
  val NotImplemented: Status.NotImplemented.type = Status.NotImplemented
  val BadGateway: Status.BadGateway.type = Status.BadGateway
  val ServiceUnavailable: Status.ServiceUnavailable.type = Status.ServiceUnavailable
  val GatewayTimeout: Status.GatewayTimeout.type = Status.GatewayTimeout
  val HttpVersionNotSupported: Status.HttpVersionNotSupported.type = Status.HttpVersionNotSupported
  val VariantAlsoNegotiates: Status.VariantAlsoNegotiates.type = Status.VariantAlsoNegotiates
  val InsufficientStorage: Status.InsufficientStorage.type = Status.InsufficientStorage
  val LoopDetected: Status.LoopDetected.type = Status.LoopDetected
  val NotExtended: Status.NotExtended.type = Status.NotExtended
  val NetworkAuthenticationRequired: Status.NetworkAuthenticationRequired.type = Status.NetworkAuthenticationRequired

  implicit class ContinueSyntax(val status: Continue.type) extends AnyVal with EmptyResponseGenerator
  // TODO support Upgrade header
  implicit class SwitchingProtocolsSyntax(val status: SwitchingProtocols.type) extends AnyVal with EmptyResponseGenerator
  implicit class OkSyntax(val status: Ok.type) extends AnyVal with EntityResponseGenerator

  implicit class CreatedSyntax(val status: Created.type) extends AnyVal with EntityResponseGenerator
  implicit class AcceptedSyntax(val status: Accepted.type) extends AnyVal with EntityResponseGenerator
  implicit class NonAuthoritativeInformationSyntax(val status: NonAuthoritativeInformation.type) extends AnyVal with EntityResponseGenerator
  implicit class NoContentSyntax(val status: NoContent.type) extends AnyVal with EmptyResponseGenerator
  implicit class ResetContentSyntax(val status: ResetContent.type) extends AnyVal with EmptyResponseGenerator {
    override def apply(): Task[Response] =
      Task.now(Response(ResetContent, headers = Headers(`Content-Length`.zero)))
  }
  // TODO helpers for Content-Range and multipart/byteranges
  implicit class PartialContentSyntax(val status: PartialContent.type) extends AnyVal with EntityResponseGenerator
  implicit class Multiyntax(val status: Status.MultiStatus.type) extends AnyVal with EntityResponseGenerator
  implicit class AlreadyReportedSyntax(val status: AlreadyReported.type) extends AnyVal with EntityResponseGenerator
  implicit class IMUsedSyntax(val status: IMUsed.type) extends AnyVal with EntityResponseGenerator

  implicit class MultipleChoicesSyntax(val status: MultipleChoices.type) extends AnyVal with LocationResponseGenerator
  implicit class MovedPermanentlySyntax(val status: MovedPermanently.type) extends AnyVal with LocationResponseGenerator
  implicit class FoundSyntax(val status: Found.type) extends AnyVal with LocationResponseGenerator
  implicit class SeeOtherSyntax(val status: SeeOther.type) extends AnyVal with LocationResponseGenerator
  implicit class NotModifiedSyntax(val status: NotModified.type) extends AnyVal with EmptyResponseGenerator
  // Note: UseProxy is deprecated in RFC7231, so we will not ease its creation here.
  implicit class TemporaryRedirectSyntax(val status: TemporaryRedirect.type) extends AnyVal with LocationResponseGenerator
  implicit class PermanentRedirectSyntax(val status: PermanentRedirect.type) extends AnyVal with LocationResponseGenerator

  implicit class BadRequestSyntax(val status: BadRequest.type) extends AnyVal with EntityResponseGenerator
  implicit class UnauthorizedSyntax(val status: Unauthorized.type) extends AnyVal with WwwAuthenticateResponseGenerator
  implicit class PaymentRequiredSyntax(val status: PaymentRequired.type) extends AnyVal with EntityResponseGenerator
  implicit class ForbiddenSyntax(val status: Forbidden.type) extends AnyVal with EntityResponseGenerator
  implicit class NotFoundSyntax(val status: NotFound.type) extends AnyVal with EntityResponseGenerator
  implicit class MethodNotAllowedSyntax(val status: MethodNotAllowed.type) extends AnyVal with EntityResponseGenerator
  implicit class NotAcceptableSyntax(val status: NotAcceptable.type) extends AnyVal with EntityResponseGenerator
  implicit class ProxyAuthenticationRequiredSyntax(val status: ProxyAuthenticationRequired.type) extends AnyVal with EntityResponseGenerator
  // TODO send Connection: close?
  implicit class RequestTimeoutSyntax(val status: RequestTimeout.type) extends AnyVal with EntityResponseGenerator
  implicit class ConflictSyntax(val status: Conflict.type) extends AnyVal with EntityResponseGenerator
  implicit class GoneSyntax(val status: Gone.type) extends AnyVal with EntityResponseGenerator
  implicit class LengthRequiredSyntax(val status: LengthRequired.type) extends AnyVal with EntityResponseGenerator
  implicit class PreconditionFailedSyntax(val status: PreconditionFailed.type) extends AnyVal with EntityResponseGenerator
  implicit class PayloadTooLargeSyntax(val status: PayloadTooLarge.type) extends AnyVal with EntityResponseGenerator
  implicit class UriTooLongSyntax(val status: UriTooLong.type) extends AnyVal with EntityResponseGenerator
  implicit class UnsupportedMediaTypeSyntax(val status: UnsupportedMediaType.type) extends AnyVal with EntityResponseGenerator
  implicit class RangeNotSatisfiableSyntax(val status: RangeNotSatisfiable.type) extends AnyVal with EntityResponseGenerator
  implicit class ExpectationFailedSyntax(val status: ExpectationFailed.type) extends AnyVal with EntityResponseGenerator
  implicit class UnprocessableEntitySyntax(val status: UnprocessableEntity.type) extends AnyVal with EntityResponseGenerator
  implicit class LockedSyntax(val status: Locked.type) extends AnyVal with EntityResponseGenerator
  implicit class FailedDependencySyntax(val status: FailedDependency.type) extends AnyVal with EntityResponseGenerator
  // TODO Mandatory upgrade field
  implicit class UpgradeRequiredSyntax(val status: UpgradeRequired.type) extends AnyVal with EntityResponseGenerator
  implicit class PreconditionRequiredSyntax(val status: PreconditionRequired.type) extends AnyVal with EntityResponseGenerator
  implicit class TooManyRequestsSyntax(val status: TooManyRequests.type) extends AnyVal with EntityResponseGenerator
  implicit class RequestHeaderFieldsTooLargeSyntax(val status: RequestHeaderFieldsTooLarge.type) extends AnyVal with EntityResponseGenerator
  implicit class UnavailableForLegalReasonsSyntax(val status: UnavailableForLegalReasons.type) extends AnyVal with EntityResponseGenerator

  implicit class InternalServerErrorSyntax(val status: InternalServerError.type) extends AnyVal with EntityResponseGenerator
  implicit class NotImplementedSyntax(val status: NotImplemented.type) extends AnyVal with EntityResponseGenerator
  implicit class BadGatewaySyntax(val status: BadGateway.type) extends AnyVal with EntityResponseGenerator
  implicit class ServiceUnavailableSyntax(val status: ServiceUnavailable.type) extends AnyVal with EntityResponseGenerator
  implicit class GatewayTimeoutSyntax(val status: GatewayTimeout.type) extends AnyVal with EntityResponseGenerator
  implicit class HttpVersionNotSupportedSyntax(val status: HttpVersionNotSupported.type) extends AnyVal with EntityResponseGenerator
  implicit class VariantAlsoNegotiatesSyntax(val status: VariantAlsoNegotiates.type) extends AnyVal with EntityResponseGenerator
  implicit class InsufficientStorageSyntax(val status: InsufficientStorage.type) extends AnyVal with EntityResponseGenerator
  implicit class LoopDetectedSyntax(val status: LoopDetected.type) extends AnyVal with EntityResponseGenerator
  implicit class NotExtendedSyntax(val status: NotExtended.type) extends AnyVal with EntityResponseGenerator
  implicit class NetworkAuthenticationRequiredSyntax(val status: NetworkAuthenticationRequired.type) extends AnyVal with EntityResponseGenerator
  
  implicit class MethodOps(val method: Method) extends AnyVal {
    def | (another: Method) = new MethodConcat(Set(method, another))
  }
  
  implicit class MethodConcatOps(val methods: MethodConcat) extends AnyVal {
    def | (another: Method) = new MethodConcat(methods.methods + another)
  }
}
