/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.client.internal;

import cats.Applicative;
import cats.ApplicativeError;
import cats.ApplicativeError$;
import cats.FlatMap;
import cats.Functor;
import cats.MonadError;
import cats.effect.Clock$;
import cats.effect.Concurrent;
import cats.effect.ContextShift;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.effect.Timer;
import cats.effect.implicits.package$;
import cats.implicits$;
import cats.kernel.Eq;
import cats.syntax.ApplicativeIdOps$;
import fs2.Stream;
import fs2.Stream$;
import fs2.concurrent.SignallingRef;
import fs2.concurrent.SignallingRef$;
import fs2.io.tcp.Socket;
import fs2.io.tcp.SocketGroup;
import fs2.io.tcp.SocketOptionMapping;
import fs2.io.tls.TLSContext;
import fs2.io.tls.TLSParameters$;
import io.chrisdavenport.log4cats.Logger;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SNIHostName;
import org.http4s.Request;
import org.http4s.Uri;
import org.http4s.client.RequestKey;
import org.http4s.client.RequestKey$;
import org.http4s.ember.client.RequestKeySocket;
import org.http4s.ember.core.Encoder$;
import org.http4s.ember.core.Parser;
import org.http4s.ember.core.Util$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ClientHelpers$ {
    public static ClientHelpers$ MODULE$;

    static {
        new ClientHelpers$();
    }

    public <F> Resource<F, RequestKeySocket<F>> requestToSocketWithKey(Request<F> request, Option<TLSContext> tlsContextOpt, SocketGroup sg, List<SocketOptionMapping<?>> additionalSocketOptions, Concurrent<F> evidence$1, Timer<F> evidence$2, ContextShift<F> evidence$3) {
        RequestKey requestKey = RequestKey$.MODULE$.fromRequest(request);
        return this.requestKeyToSocketWithKey(requestKey, tlsContextOpt, sg, additionalSocketOptions, evidence$1, evidence$2, evidence$3);
    }

    public <F> Resource<F, RequestKeySocket<F>> requestKeyToSocketWithKey(RequestKey requestKey, Option<TLSContext> tlsContextOpt, SocketGroup sg, List<SocketOptionMapping<?>> additionalSocketOptions, Concurrent<F> evidence$4, Timer<F> evidence$5, ContextShift<F> evidence$6) {
        return Resource$.MODULE$.liftF(this.getAddress(requestKey, (Sync<F>)evidence$4), evidence$4).flatMap((Function1 & Serializable & scala.Serializable)address -> {
            InetSocketAddress x$1 = address;
            List x$2 = additionalSocketOptions;
            boolean x$3 = sg.client$default$2();
            int x$4 = sg.client$default$3();
            int x$5 = sg.client$default$4();
            boolean x$6 = sg.client$default$5();
            boolean x$7 = sg.client$default$6();
            return sg.client(x$1, x$3, x$4, x$5, x$6, x$7, x$2, evidence$4, evidence$6).flatMap((Function1 & Serializable & scala.Serializable)initSocket -> ((Resource)(implicits$.MODULE$.catsSyntaxEq((Object)requestKey.scheme(), (Eq)Uri.Scheme$.MODULE$.http4sOrderForScheme()).$eq$eq$eq((Object)Uri.Scheme$.MODULE$.https()) ? tlsContextOpt.fold((Function0 & Serializable & scala.Serializable)() -> (Resource)ApplicativeError$.MODULE$.apply((ApplicativeError)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$4)).raiseError((Object)new Throwable("EmberClient Not Configured for Https")), (Function1 & Serializable & scala.Serializable)tlsContext -> {
                Some x$8 = new Some((Object)new .colon.colon((Object)new SNIHostName(address.getHostName()), (List)Nil$.MODULE$));
                Option x$9 = TLSParameters$.MODULE$.apply$default$1();
                Option x$10 = TLSParameters$.MODULE$.apply$default$2();
                Option x$11 = TLSParameters$.MODULE$.apply$default$3();
                Option x$12 = TLSParameters$.MODULE$.apply$default$4();
                Option x$13 = TLSParameters$.MODULE$.apply$default$5();
                Option x$14 = TLSParameters$.MODULE$.apply$default$6();
                Option x$15 = TLSParameters$.MODULE$.apply$default$7();
                Option x$16 = TLSParameters$.MODULE$.apply$default$9();
                boolean x$17 = TLSParameters$.MODULE$.apply$default$10();
                boolean x$18 = TLSParameters$.MODULE$.apply$default$11();
                boolean x$19 = TLSParameters$.MODULE$.apply$default$12();
                return (Resource)implicits$.MODULE$.toFunctorOps((Object)tlsContext.client(initSocket, TLSParameters$.MODULE$.apply(x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option)x$8, x$16, x$17, x$18, x$19), (Option)tlsContext.client$default$3(), evidence$4, evidence$6), (Functor)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$4)).widen();
            }) : ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId(initSocket), (Applicative)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$4)))).map((Function1 & Serializable & scala.Serializable)socket -> new RequestKeySocket(socket, requestKey), (Applicative)evidence$4));
        });
    }

    public <F> F request(Request<F> request, RequestKeySocket<F> requestKeySocket, int chunkSize, int maxResponseHeaderSize, Duration timeout, Logger<F> logger, Concurrent<F> evidence$7, ContextShift<F> evidence$8, Timer<F> T) {
        Object object;
        Duration duration = timeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)duration;
            object = ClientHelpers$.onTimeout$1(requestKeySocket.socket(), finiteDuration, T, evidence$7, request, maxResponseHeaderSize, chunkSize, logger);
        } else {
            object = ClientHelpers$.onNoTimeout$1(requestKeySocket.socket(), maxResponseHeaderSize, chunkSize, request, evidence$7, logger);
        }
        return (F)object;
    }

    private <F> F getAddress(RequestKey requestKey, Sync<F> evidence$9) {
        RequestKey requestKey2 = requestKey;
        if (requestKey2 == null) {
            throw new MatchError((Object)requestKey2);
        }
        Uri.Scheme s = requestKey2.scheme();
        Uri.Authority auth = requestKey2.authority();
        int port = BoxesRunTime.unboxToInt((Object)auth.port().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            Uri.Scheme scheme = s;
            Uri.Scheme scheme2 = Uri.Scheme$.MODULE$.https();
            return !(scheme != null ? !scheme.equals(scheme2) : scheme2 != null) ? 443 : 80;
        }));
        String host = auth.host().value();
        Object object = Sync$.MODULE$.apply(evidence$9).delay((Function0 & Serializable & scala.Serializable)() -> new InetSocketAddress(host, port));
        return (F)object;
    }

    private static final Object onNoTimeout$1(Socket socket, int maxResponseHeaderSize$1, int chunkSize$1, Request request$1, Concurrent evidence$7$1, Logger logger$1) {
        return Parser.Response$.MODULE$.parser(maxResponseHeaderSize$1, Stream$.MODULE$.concurrently$extension(socket.reads(chunkSize$1, (Option)None$.MODULE$), Stream$.MODULE$.drain$extension(Stream$.MODULE$.through$extension(Encoder$.MODULE$.reqToBytes(request$1, (Sync)evidence$7$1), socket.writes((Option)None$.MODULE$))), evidence$7$1), logger$1, (Sync)evidence$7$1);
    }

    public static final /* synthetic */ Object $anonfun$request$4(FiniteDuration fin$1, long start$1, int maxResponseHeaderSize$1, Socket socket$1, SignallingRef timeoutSignal$1, int chunkSize$1, Concurrent evidence$7$1, Timer T$1, Logger logger$1, long sent) {
        FiniteDuration remains = fin$1.$minus(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(sent - start$1)).millis());
        return implicits$.MODULE$.toFlatMapOps(Parser.Response$.MODULE$.parser(maxResponseHeaderSize$1, Util$.MODULE$.readWithTimeout(socket$1, start$1, remains, timeoutSignal$1.get(), chunkSize$1, (ApplicativeError)evidence$7$1, Clock$.MODULE$.extractFromTimer(T$1)), logger$1, (Sync)evidence$7$1), (FlatMap)evidence$7$1).flatMap((Function1 & Serializable & scala.Serializable)resp -> implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toFunctorOps(timeoutSignal$1.set((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Functor)evidence$7$1).void(), (Functor)evidence$7$1).map((Function1 & Serializable & scala.Serializable)_ -> resp));
    }

    public static final /* synthetic */ Object $anonfun$request$1(Request request$1, Concurrent evidence$7$1, Socket socket$1, FiniteDuration fin$1, Timer T$1, int maxResponseHeaderSize$1, int chunkSize$1, Logger logger$1, long start) {
        return implicits$.MODULE$.toFlatMapOps(package$.MODULE$.toConcurrentOps(Stream$.MODULE$.compile$extension(Stream$.MODULE$.through$extension(Encoder$.MODULE$.reqToBytes(request$1, (Sync)evidence$7$1), socket$1.writes((Option)new Some((Object)fin$1))), Stream.Compiler$.MODULE$.syncInstance((Sync)evidence$7$1)).drain(), evidence$7$1).start(), (FlatMap)evidence$7$1).flatMap((Function1 & Serializable & scala.Serializable)_ -> implicits$.MODULE$.toFlatMapOps(SignallingRef$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), evidence$7$1), (FlatMap)evidence$7$1).flatMap((Function1 & Serializable & scala.Serializable)timeoutSignal -> implicits$.MODULE$.toFlatMapOps(T$1.clock().realTime(TimeUnit.MILLISECONDS), (FlatMap)evidence$7$1).flatMap((Function1 & Serializable & scala.Serializable)sent -> ClientHelpers$.$anonfun$request$4(fin$1, start, maxResponseHeaderSize$1, socket$1, timeoutSignal, chunkSize$1, evidence$7$1, T$1, logger$1, BoxesRunTime.unboxToLong((Object)sent)))));
    }

    private static final Object onTimeout$1(Socket socket, FiniteDuration fin, Timer T$1, Concurrent evidence$7$1, Request request$1, int maxResponseHeaderSize$1, int chunkSize$1, Logger logger$1) {
        return implicits$.MODULE$.toFlatMapOps(T$1.clock().realTime(TimeUnit.MILLISECONDS), (FlatMap)evidence$7$1).flatMap((Function1 & Serializable & scala.Serializable)start -> ClientHelpers$.$anonfun$request$1(request$1, evidence$7$1, socket, fin, T$1, maxResponseHeaderSize$1, chunkSize$1, logger$1, BoxesRunTime.unboxToLong((Object)start)));
    }

    private ClientHelpers$() {
        MODULE$ = this;
    }
}

