/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.client.internal;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.MonadError;
import cats.data.NonEmptyList$;
import cats.effect.Clock;
import cats.effect.Clock$;
import cats.effect.Concurrent;
import cats.effect.ContextShift;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.ResourceLike;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.effect.Timer;
import cats.effect.concurrent.Ref;
import cats.effect.implicits.package$;
import cats.effect.syntax.ConcurrentOps$;
import cats.kernel.Eq;
import cats.package;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.IfMOps$;
import cats.syntax.MonadErrorOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.tcp.Socket;
import fs2.io.tcp.SocketGroup;
import fs2.io.tcp.SocketOptionMapping;
import fs2.io.tls.TLSContext;
import fs2.io.tls.TLSParameters$;
import io.chrisdavenport.keypool.KeyPool;
import io.chrisdavenport.keypool.Managed;
import io.chrisdavenport.keypool.Reusable;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SNIHostName;
import org.http4s.Header;
import org.http4s.HeaderKey;
import org.http4s.Headers$;
import org.http4s.HttpDate$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Uri;
import org.http4s.client.RequestKey;
import org.http4s.client.RequestKey$;
import org.http4s.ember.client.EmberConnection;
import org.http4s.ember.client.RequestKeySocket;
import org.http4s.ember.core.EmptyStreamError;
import org.http4s.ember.core.Encoder$;
import org.http4s.ember.core.Parser;
import org.http4s.ember.core.Util$;
import org.http4s.headers.Connection;
import org.http4s.headers.Connection$;
import org.http4s.headers.Date;
import org.http4s.headers.Date$;
import org.http4s.headers.User;
import org.http4s.headers.User$minusAgent$;
import org.http4s.implicits$;
import org.http4s.syntax.StringOps$;
import org.http4s.util.CaseInsensitiveString;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ClientHelpers$ {
    public static ClientHelpers$ MODULE$;

    static {
        new ClientHelpers$();
    }

    public <F> Resource<F, RequestKeySocket<F>> requestToSocketWithKey(Request<F> request2, Option<TLSContext> tlsContextOpt, boolean enableEndpointValiation, SocketGroup sg, List<SocketOptionMapping<?>> additionalSocketOptions, Concurrent<F> evidence$1, Timer<F> evidence$2, ContextShift<F> evidence$3) {
        RequestKey requestKey = RequestKey$.MODULE$.fromRequest(request2);
        return this.requestKeyToSocketWithKey(requestKey, tlsContextOpt, enableEndpointValiation, sg, additionalSocketOptions, evidence$1, evidence$2, evidence$3);
    }

    public <F> Resource<F, RequestKeySocket<F>> requestKeyToSocketWithKey(RequestKey requestKey, Option<TLSContext> tlsContextOpt, boolean enableEndpointValiation, SocketGroup sg, List<SocketOptionMapping<?>> additionalSocketOptions, Concurrent<F> evidence$4, Timer<F> evidence$5, ContextShift<F> evidence$6) {
        return Resource$.MODULE$.eval(this.getAddress(requestKey, (Sync<F>)evidence$4), evidence$4).flatMap((Function1 & Serializable & scala.Serializable)address -> {
            InetSocketAddress x$1 = address;
            List x$2 = additionalSocketOptions;
            boolean x$3 = sg.client$default$2();
            int x$4 = sg.client$default$3();
            int x$5 = sg.client$default$4();
            boolean x$6 = sg.client$default$5();
            boolean x$7 = sg.client$default$6();
            return sg.client(x$1, x$3, x$4, x$5, x$6, x$7, x$2, evidence$4, evidence$6).flatMap((Function1 & Serializable & scala.Serializable)initSocket -> ((ResourceLike)(package.all$.MODULE$.catsSyntaxEq((Object)requestKey.scheme(), (Eq)Uri.Scheme$.MODULE$.http4sOrderForScheme()).$eq$eq$eq((Object)Uri.Scheme$.MODULE$.https()) ? tlsContextOpt.fold((Function0 & Serializable & scala.Serializable)() -> (Resource)package.ApplicativeThrow$.MODULE$.apply((ApplicativeError)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$4)).raiseError((Object)new Throwable("EmberClient Not Configured for Https")), (Function1 & Serializable & scala.Serializable)tlsContext -> {
                Some x$8 = new Some((Object)new .colon.colon((Object)new SNIHostName(address.getHostName()), (List)Nil$.MODULE$));
                None$ x$9 = enableEndpointValiation ? new Some((Object)"HTTPS") : None$.MODULE$;
                Option x$10 = TLSParameters$.MODULE$.apply$default$1();
                Option x$11 = TLSParameters$.MODULE$.apply$default$2();
                Option x$12 = TLSParameters$.MODULE$.apply$default$3();
                Option x$13 = TLSParameters$.MODULE$.apply$default$4();
                Option x$14 = TLSParameters$.MODULE$.apply$default$6();
                Option x$15 = TLSParameters$.MODULE$.apply$default$7();
                Option x$16 = TLSParameters$.MODULE$.apply$default$9();
                boolean x$17 = TLSParameters$.MODULE$.apply$default$10();
                boolean x$18 = TLSParameters$.MODULE$.apply$default$11();
                boolean x$19 = TLSParameters$.MODULE$.apply$default$12();
                Option x$20 = TLSParameters$.MODULE$.apply$default$13();
                return (Resource)package.all$.MODULE$.toFunctorOps((Object)tlsContext.client(initSocket, TLSParameters$.MODULE$.apply(x$10, x$11, x$12, x$13, (Option)x$9, x$14, x$15, (Option)x$8, x$16, x$17, x$18, x$19, x$20), (Option)tlsContext.client$default$3(), evidence$4, evidence$6), (Functor)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$4)).widen();
            }) : ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId(initSocket), (Applicative)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$4)))).map((Function1 & Serializable & scala.Serializable)socket -> new RequestKeySocket(socket, requestKey), (Applicative)evidence$4));
        });
    }

    public <F> F request(Request<F> request2, EmberConnection<F> connection, int chunkSize, int maxResponseHeaderSize, Duration idleTimeout, Duration timeout, Option<User.minusAgent> userAgent, Concurrent<F> evidence$7, ContextShift<F> evidence$8, Timer<F> evidence$9) {
        return (F)MonadErrorOps$.MODULE$.adaptError$extension(package.all$.MODULE$.catsSyntaxMonadError(package.all$.MODULE$.toFlatMapOps(this.preprocessRequest(request2, userAgent, (Monad<F>)evidence$7, (Clock<F>)Clock$.MODULE$.extractFromTimer(evidence$9)), evidence$7).flatMap((Function1 & Serializable & scala.Serializable)processedReq -> ClientHelpers$.writeRead$1(processedReq, connection, idleTimeout, evidence$7, timeout, maxResponseHeaderSize, chunkSize, evidence$9)), evidence$7), (PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof EmptyStreamError) {
                    EmptyStreamError emptyStreamError = (EmptyStreamError)A1;
                    object = new ClosedChannelException(null, emptyStreamError){

                        public String getMessage() {
                            return "Remote Disconnect: Received zero bytes after sending request";
                        }
                        {
                            this.initCause((Throwable)x2$1);
                        }
                    };
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof EmptyStreamError;
                return bl;
            }
        }, evidence$7);
    }

    public <F> F preprocessRequest(Request<F> req, Option<User.minusAgent> userAgent, Monad<F> evidence$10, Clock<F> evidence$11) {
        Connection connection = (Connection)Headers$.MODULE$.get$extension0(req.headers(), (HeaderKey.Extractable)Connection$.MODULE$).fold((Function0 & Serializable & scala.Serializable)() -> new Connection(NonEmptyList$.MODULE$.of((Object)StringOps$.MODULE$.ci$extension(implicits$.MODULE$.http4sStringSyntax("keep-alive")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new CaseInsensitiveString[0]))), (Function1 & Serializable & scala.Serializable)x -> (Connection)Predef$.MODULE$.identity(x));
        Option userAgentHeader = Headers$.MODULE$.get$extension0(req.headers(), (HeaderKey.Extractable)User$minusAgent$.MODULE$).orElse((Function0 & Serializable & scala.Serializable)() -> userAgent);
        return (F)package.all$.MODULE$.toFunctorOps(Headers$.MODULE$.get$extension0(req.headers(), (HeaderKey.Extractable)Date$.MODULE$).fold((Function0 & Serializable & scala.Serializable)() -> package.all$.MODULE$.toFunctorOps(HttpDate$.MODULE$.current((Functor)evidence$10, evidence$11), (Functor)evidence$10).map((Function1 & Serializable & scala.Serializable)x$1 -> new Date(x$1)), (Function1 & Serializable & scala.Serializable)x$2 -> ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId(x$2), (Applicative)evidence$10)), evidence$10).map((Function1 & Serializable & scala.Serializable)date -> (Request)req.putHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{date, connection})).putHeaders(Option$.MODULE$.option2Iterable(userAgentHeader).toSeq()));
    }

    public <F> F postProcessResponse(Request<F> req, Response<F> resp, F drain, Ref<F, byte[]> nextBytes, Ref<F, Reusable> canBeReused, Concurrent<F> F) {
        return (F)package.all$.MODULE$.toFlatMapOps(drain, F).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                byte[] bytes = (byte[])some.value();
                boolean requestClose = Headers$.MODULE$.get$extension0(req.headers(), (HeaderKey.Extractable)Connection$.MODULE$).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.hasClose()));
                boolean responseClose = Headers$.MODULE$.get$extension0(resp.headers(), (HeaderKey.Extractable)Connection$.MODULE$).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.hasClose()));
                object = requestClose || responseClose ? F.unit() : FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(nextBytes.set((Object)bytes), (FlatMap)F), (Function0 & Serializable & scala.Serializable)() -> canBeReused.set((Object)Reusable.Reuse$.MODULE$), (FlatMap)F);
            } else if (None$.MODULE$.equals(option)) {
                object = F.unit();
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    private <F> F getAddress(RequestKey requestKey, Sync<F> evidence$12) {
        RequestKey requestKey2 = requestKey;
        if (requestKey2 == null) {
            throw new MatchError((Object)requestKey2);
        }
        Uri.Scheme s = requestKey2.scheme();
        Uri.Authority auth = requestKey2.authority();
        int port = BoxesRunTime.unboxToInt((Object)auth.port().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            Uri.Scheme scheme = s;
            Uri.Scheme scheme2 = Uri.Scheme$.MODULE$.https();
            return !(scheme != null ? !scheme.equals(scheme2) : scheme2 != null) ? 443 : 80;
        }));
        String host = auth.host().value();
        Object object = Sync$.MODULE$.apply(evidence$12).delay((Function0 & Serializable & scala.Serializable)() -> new InetSocketAddress(host, port));
        return (F)object;
    }

    public <F> Resource<F, Managed<F, EmberConnection<F>>> getValidManaged(KeyPool<F, RequestKey, EmberConnection<F>> pool, Request<F> request2, Sync<F> evidence$13) {
        return pool.take((Object)RequestKey$.MODULE$.fromRequest(request2)).flatMap((Function1 & Serializable & scala.Serializable)managed -> (Resource)IfMOps$.MODULE$.ifM$extension(package.all$.MODULE$.catsSyntaxIfM((Object)Resource$.MODULE$.eval(((EmberConnection)managed.value()).keySocket().socket().isOpen(), (Applicative)evidence$13), (FlatMap)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$13)), (Function0 & Serializable & scala.Serializable)() -> (Resource)ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId(managed), (Applicative)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$13)), (Function0 & Serializable & scala.Serializable)() -> managed.isReused() ? (Resource)FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps((Object)Resource$.MODULE$.eval(managed.canBeReused().set((Object)Reusable.DontReuse$.MODULE$), (Applicative)evidence$13), (FlatMap)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$13)), (Function0 & Serializable & scala.Serializable)() -> MODULE$.getValidManaged(pool, request2, evidence$13), (FlatMap)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$13)) : Resource$.MODULE$.eval(Sync$.MODULE$.apply(evidence$13).raiseError((Object)new SocketException("Fresh connection from pool was not open")), (Applicative)evidence$13), (FlatMap)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$13)));
    }

    private static final Object writeRequestToSocket$1(Request req, Socket socket, Option timeout, Concurrent evidence$7$1) {
        return Stream$.MODULE$.compile$extension(Stream$.MODULE$.through$extension(Encoder$.MODULE$.reqToBytes(req, Encoder$.MODULE$.reqToBytes$default$2(), (Sync)evidence$7$1), socket.writes(timeout)), Stream.Compiler$.MODULE$.syncInstance((Sync)evidence$7$1)).drain();
    }

    private static final Object writeRead$1(Request req, EmberConnection connection$1, Duration idleTimeout$1, Concurrent evidence$7$1, Duration timeout$1, int maxResponseHeaderSize$1, int chunkSize$1, Timer evidence$9$1) {
        return FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(ClientHelpers$.writeRequestToSocket$1(req, connection$1.keySocket().socket(), Util$.MODULE$.durationToFinite(idleTimeout$1), evidence$7$1), (FlatMap)evidence$7$1), (Function0 & Serializable & scala.Serializable)() -> package.all$.MODULE$.toFlatMapOps(connection$1.nextBytes().getAndSet((Object)Array$.MODULE$.emptyByteArray()), (FlatMap)evidence$7$1).flatMap((Function1 & Serializable & scala.Serializable)head -> {
            Option finiteDuration = Util$.MODULE$.durationToFinite(timeout$1);
            Object parse = Parser.Response$.MODULE$.parser(maxResponseHeaderSize$1, head, connection$1.keySocket().socket().read(chunkSize$1, Util$.MODULE$.durationToFinite(idleTimeout$1)), evidence$7$1);
            return finiteDuration.fold((Function0 & Serializable & scala.Serializable)() -> parse, (Function1 & Serializable & scala.Serializable)duration -> ConcurrentOps$.MODULE$.timeoutTo$extension(package$.MODULE$.catsEffectSyntaxConcurrent(parse), duration, package.ApplicativeThrow$.MODULE$.apply((ApplicativeError)evidence$7$1).raiseError((Object)new TimeoutException(new StringBuilder(49).append("Timed Out on EmberClient Header Receive Timeout: ").append(duration).toString())), evidence$7$1, evidence$9$1));
        }), (FlatMap)evidence$7$1);
    }

    private ClientHelpers$() {
        MODULE$ = this;
    }
}

