/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.client.internal;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Defer;
import cats.Defer$;
import cats.FlatMap;
import cats.Foldable;
import cats.Functor;
import cats.Monad;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Clock;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Sync;
import cats.effect.kernel.Sync$;
import cats.kernel.Eq;
import cats.package;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.IfMOps$;
import cats.syntax.MonadErrorOps$;
import cats.syntax.package;
import com.comcast.ip4s.Host;
import com.comcast.ip4s.Host$;
import com.comcast.ip4s.Port;
import com.comcast.ip4s.Port$;
import com.comcast.ip4s.SocketAddress;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.io.ClosedChannelException;
import fs2.io.net.Socket;
import fs2.io.net.SocketException;
import fs2.io.net.SocketException$;
import fs2.io.net.SocketGroup;
import fs2.io.net.SocketOption;
import fs2.io.net.tls.TLSContext;
import fs2.io.net.tls.TLSParameters;
import fs2.io.net.unixsocket.UnixSocketAddress;
import fs2.io.net.unixsocket.UnixSockets;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpDate$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Uri;
import org.http4s.client.RequestKey;
import org.http4s.client.RequestKey$;
import org.http4s.ember.client.EmberConnection;
import org.http4s.ember.client.RequestKeySocket;
import org.http4s.ember.client.internal.ClientHelpersPlatform;
import org.http4s.ember.core.EmberException;
import org.http4s.ember.core.Encoder$;
import org.http4s.ember.core.Parser;
import org.http4s.ember.core.Util$;
import org.http4s.headers.Connection;
import org.http4s.headers.Connection$;
import org.http4s.headers.Date;
import org.http4s.headers.Date$;
import org.http4s.headers.User;
import org.http4s.headers.User$minusAgent$;
import org.typelevel.ci.package$;
import org.typelevel.keypool.KeyPool;
import org.typelevel.keypool.Managed;
import org.typelevel.keypool.Reusable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class ClientHelpers$
implements ClientHelpersPlatform {
    public static final ClientHelpers$ MODULE$ = new ClientHelpers$();

    static {
        ClientHelpersPlatform.$init$(MODULE$);
    }

    @Override
    public TLSParameters mkTLSParameters(Option<SocketAddress<Host>> address, boolean enableEndpointValidation) {
        return ClientHelpersPlatform.mkTLSParameters$(this, address, enableEndpointValidation);
    }

    public <F> Resource<F, RequestKeySocket<F>> requestToSocketWithKey(Request<F> request2, Option<TLSContext<F>> tlsContextOpt, boolean enableEndpointValidation, SocketGroup<F> sg, List<SocketOption> additionalSocketOptions, Sync<F> evidence$1) {
        RequestKey requestKey = RequestKey$.MODULE$.fromRequest(request2);
        return this.requestKeyToSocketWithKey(requestKey, tlsContextOpt, enableEndpointValidation, sg, additionalSocketOptions, evidence$1);
    }

    public <F> Resource<F, RequestKeySocket<F>> unixSocket(Request<F> request2, UnixSockets<F> unixSockets, UnixSocketAddress address, Option<TLSContext<F>> tlsContextOpt, Async<F> evidence$2) {
        RequestKey requestKey = RequestKey$.MODULE$.fromRequest(request2);
        return this.elevateSocket(requestKey, (Resource<F, Socket<F>>)unixSockets.client(address), tlsContextOpt, false, (Option<SocketAddress<Host>>)None$.MODULE$, (Sync<F>)evidence$2);
    }

    public <F> Resource<F, RequestKeySocket<F>> requestKeyToSocketWithKey(RequestKey requestKey, Option<TLSContext<F>> tlsContextOpt, boolean enableEndpointValidation, SocketGroup<F> sg, List<SocketOption> additionalSocketOptions, Sync<F> evidence$3) {
        return Resource$.MODULE$.eval(this.getAddress(requestKey, evidence$3)).flatMap((Function1 & Serializable)address -> {
            Resource s = sg.client(address, additionalSocketOptions);
            return MODULE$.elevateSocket(requestKey, s, tlsContextOpt, enableEndpointValidation, (Option<SocketAddress<Host>>)new Some(address), evidence$3);
        });
    }

    public <F> Resource<F, RequestKeySocket<F>> elevateSocket(RequestKey requestKey, Resource<F, Socket<F>> initSocket, Option<TLSContext<F>> tlsContextOpt, boolean enableEndpointValidation, Option<SocketAddress<Host>> optionNames, Sync<F> evidence$4) {
        return initSocket.flatMap((Function1 & Serializable)iSocket -> ((Resource)(package.all$.MODULE$.catsSyntaxEq((Object)requestKey.scheme(), (Eq)Uri.Scheme$.MODULE$.http4sOrderForScheme()).$eq$eq$eq((Object)Uri.Scheme$.MODULE$.https()) ? tlsContextOpt.fold((Function0 & Serializable)() -> (Resource)package.ApplicativeThrow$.MODULE$.apply((ApplicativeError)Resource$.MODULE$.catsEffectSyncForResource(evidence$4)).raiseError((Object)new Throwable("EmberClient Not Configured for Https")), (Function1 & Serializable)tlsContext -> (Resource)package.all$.MODULE$.toFunctorOps((Object)tlsContext.clientBuilder(iSocket).withParameters(MODULE$.mkTLSParameters(optionNames, enableEndpointValidation)).build(), (Functor)Resource$.MODULE$.catsEffectSyncForResource(evidence$4)).widen()) : ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId(iSocket), (Applicative)Resource$.MODULE$.catsEffectSyncForResource(evidence$4)))).map((Function1 & Serializable)socket -> new RequestKeySocket(socket, requestKey)));
    }

    public <F> F request(Request<F> request2, EmberConnection<F> connection, int chunkSize, int maxResponseHeaderSize, Duration idleTimeout, Duration timeout, Option<User.minusAgent> userAgent, Async<F> evidence$5) {
        return (F)MonadErrorOps$.MODULE$.adaptError$extension(package.all$.MODULE$.catsSyntaxMonadError(package.all$.MODULE$.toFlatMapOps(this.preprocessRequest(request2, userAgent, (Monad<F>)evidence$5, (Clock<F>)evidence$5), evidence$5).flatMap((Function1 & Serializable)processedReq -> ClientHelpers$.writeRead$1(processedReq, connection, evidence$5, maxResponseHeaderSize, chunkSize, idleTimeout, timeout)), evidence$5), (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof EmberException.EmptyStream) {
                    EmberException.EmptyStream emptyStream = (EmberException.EmptyStream)A1;
                    object = new ClosedChannelException(null, emptyStream){

                        public String getMessage() {
                            return "Remote Disconnect: Received zero bytes after sending request";
                        }
                        {
                            this.initCause((Throwable)x2$1);
                        }
                    };
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof EmberException.EmptyStream;
                return bl;
            }
        }, evidence$5);
    }

    public <F> F preprocessRequest(Request<F> req, Option<User.minusAgent> userAgent, Monad<F> evidence$6, Clock<F> evidence$7) {
        Connection connection = (Connection)Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance())).fold((Function0 & Serializable)() -> new Connection(NonEmptyList$.MODULE$.of((Object)package$.MODULE$.CIStringSyntax(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep-alive"}))).ci((Seq)Nil$.MODULE$), (Seq)Nil$.MODULE$)), (Function1 & Serializable)x -> (Connection)Predef$.MODULE$.identity(x));
        Option userAgentHeader = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(User$minusAgent$.MODULE$.headerInstance())).orElse((Function0 & Serializable)() -> userAgent);
        return (F)package.all$.MODULE$.toFunctorOps(Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Date$.MODULE$.headerInstance())).fold((Function0 & Serializable)() -> package.all$.MODULE$.toFunctorOps(HttpDate$.MODULE$.current((Functor)evidence$6, evidence$7), (Functor)evidence$6).map((Function1 & Serializable)x$2 -> new Date(x$2)), (Function1 & Serializable)x$3 -> ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId(x$3), (Applicative)evidence$6)), evidence$6).map((Function1 & Serializable)date -> (Request)req.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw(date, Date$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)connection, Connection$.MODULE$.headerInstance())})).putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.foldablesToRaw((Object)userAgentHeader, (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForOption(), (Function1 & Serializable)h -> Header.ToRaw$.MODULE$.modelledHeadersToRaw(h, User$minusAgent$.MODULE$.headerInstance()))})));
    }

    public <F> F postProcessResponse(Request<F> req, Response<F> resp, F drain, Ref<F, byte[]> nextBytes, Ref<F, Reusable> canBeReused, GenConcurrent<F, Throwable> F) {
        return (F)package.all$.MODULE$.toFlatMapOps(drain, F).flatMap((Function1 & Serializable)x0$1 -> {
            Object object;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                byte[] bytes = (byte[])some.value();
                boolean requestClose = Util$.MODULE$.connectionFor(req.httpVersion(), req.headers()).hasClose();
                boolean responseClose = Util$.MODULE$.connectionFor(resp.httpVersion(), resp.headers()).hasClose();
                object = requestClose || responseClose ? F.unit() : FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(nextBytes.set((Object)bytes), (FlatMap)F), (Function0 & Serializable)() -> canBeReused.set((Object)Reusable.Reuse$.MODULE$), (FlatMap)F);
            } else if (None$.MODULE$.equals(option)) {
                object = F.unit();
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    private <F> F getAddress(RequestKey requestKey, Sync<F> evidence$8) {
        RequestKey requestKey2 = requestKey;
        if (requestKey2 == null) {
            throw new MatchError((Object)requestKey2);
        }
        Uri.Scheme s = requestKey2.scheme();
        Uri.Authority auth = requestKey2.authority();
        int port = BoxesRunTime.unboxToInt((Object)auth.port().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> {
            Uri.Scheme scheme = s;
            Uri.Scheme scheme2 = Uri.Scheme$.MODULE$.https();
            return !(scheme != null ? !scheme.equals(scheme2) : scheme2 != null) ? 443 : 80;
        }));
        String host = auth.host().value();
        Object object = Sync$.MODULE$.apply(evidence$8).delay((Function0 & Serializable)() -> new SocketAddress((Host)Host$.MODULE$.fromString(host).get(), (Port)Port$.MODULE$.fromInt(port).get()));
        return (F)object;
    }

    public <F> Resource<F, Managed<F, EmberConnection<F>>> getValidManaged(KeyPool<F, RequestKey, EmberConnection<F>> pool, Request<F> request2, Sync<F> evidence$9) {
        return pool.take((Object)RequestKey$.MODULE$.fromRequest(request2)).flatMap((Function1 & Serializable)managed -> (Resource)IfMOps$.MODULE$.ifM$extension(package.all$.MODULE$.catsSyntaxIfM((Object)Resource$.MODULE$.eval(((EmberConnection)managed.value()).keySocket().socket().isOpen()), (FlatMap)Resource$.MODULE$.catsEffectSyncForResource(evidence$9)), (Function0 & Serializable)() -> (Resource)ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId(managed), (Applicative)Resource$.MODULE$.catsEffectSyncForResource(evidence$9)), (Function0 & Serializable)() -> managed.isReused() ? (Resource)FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps((Object)Resource$.MODULE$.eval(managed.canBeReused().set((Object)Reusable.DontReuse$.MODULE$)), (FlatMap)Resource$.MODULE$.catsEffectSyncForResource(evidence$9)), (Function0 & Serializable)() -> MODULE$.getValidManaged(pool, request2, evidence$9), (FlatMap)Resource$.MODULE$.catsEffectSyncForResource(evidence$9)) : Resource$.MODULE$.eval(Sync$.MODULE$.apply(evidence$9).raiseError((Object)new SocketException("Fresh connection from pool was not open", SocketException$.MODULE$.$lessinit$greater$default$2()))), (FlatMap)Resource$.MODULE$.catsEffectSyncForResource(evidence$9)));
    }

    private static final Object writeRequestToSocket$1(Request req, Socket socket, Async evidence$5$1, Duration idleTimeout$1) {
        return Encoder$.MODULE$.reqToBytes(req, Encoder$.MODULE$.reqToBytes$default$2(), (ApplicativeError)evidence$5$1).through((Function1 & Serializable)x$1 -> x$1.chunks().foreach((Function1 & Serializable)c -> Util$.MODULE$.timeoutMaybe(socket.write(c), idleTimeout$1, (GenTemporal)evidence$5$1))).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)evidence$5$1))).drain();
    }

    private static final Object writeRead$1(Request req, EmberConnection connection$1, Async evidence$5$1, int maxResponseHeaderSize$1, int chunkSize$1, Duration idleTimeout$1, Duration timeout$1) {
        return FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(ClientHelpers$.writeRequestToSocket$1(req, connection$1.keySocket().socket(), evidence$5$1, idleTimeout$1), (FlatMap)evidence$5$1), (Function0 & Serializable)() -> package.all$.MODULE$.toFlatMapOps(connection$1.nextBytes().getAndSet((Object)Array$.MODULE$.emptyByteArray()), (FlatMap)evidence$5$1).flatMap((Function1 & Serializable)head -> {
            Object parse = Parser.Response$.MODULE$.parser(maxResponseHeaderSize$1, head, Util$.MODULE$.timeoutMaybe(connection$1.keySocket().socket().read(chunkSize$1), idleTimeout$1, (GenTemporal)evidence$5$1), (GenConcurrent)evidence$5$1);
            return Util$.MODULE$.timeoutToMaybe(parse, timeout$1, Defer$.MODULE$.apply((Defer)evidence$5$1).defer((Function0 & Serializable)() -> package.ApplicativeThrow$.MODULE$.apply((ApplicativeError)evidence$5$1).raiseError((Object)new TimeoutException(new StringBuilder(49).append("Timed Out on EmberClient Header Receive Timeout: ").append(timeout$1).toString()))), (GenTemporal)evidence$5$1);
        }), (FlatMap)evidence$5$1);
    }

    private ClientHelpers$() {
    }
}

