/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.client.internal;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Apply;
import cats.Defer;
import cats.Defer$;
import cats.FlatMap;
import cats.Foldable;
import cats.Functor;
import cats.Monad;
import cats.MonadError;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Clock;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Sync;
import cats.effect.kernel.Sync$;
import cats.effect.kernel.syntax.GenTemporalOps$;
import cats.effect.std.Hotswap;
import cats.effect.std.Hotswap$;
import cats.effect.syntax.package;
import cats.kernel.Eq;
import cats.package;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.ApplyOps$;
import cats.syntax.IfMOps$;
import cats.syntax.MonadErrorOps$;
import cats.syntax.MonadErrorRethrowOps$;
import cats.syntax.OptionOps$;
import cats.syntax.package;
import com.comcast.ip4s.Host;
import com.comcast.ip4s.Host$;
import com.comcast.ip4s.Port$;
import com.comcast.ip4s.SocketAddress;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.io.ClosedChannelException;
import fs2.io.net.Socket;
import fs2.io.net.SocketException;
import fs2.io.net.SocketException$;
import fs2.io.net.SocketGroup;
import fs2.io.net.SocketOption;
import fs2.io.net.tls.TLSContext;
import fs2.io.net.unixsocket.UnixSocketAddress;
import fs2.io.net.unixsocket.UnixSockets;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpDate$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Uri;
import org.http4s.client.RequestKey;
import org.http4s.client.RequestKey$;
import org.http4s.ember.client.EmberConnection;
import org.http4s.ember.client.RequestKeySocket;
import org.http4s.ember.client.internal.ClientHelpers;
import org.http4s.ember.core.EmberException;
import org.http4s.ember.core.Encoder$;
import org.http4s.ember.core.Parser;
import org.http4s.ember.core.Util$;
import org.http4s.headers.Connection;
import org.http4s.headers.Connection$;
import org.http4s.headers.Date;
import org.http4s.headers.Date$;
import org.http4s.headers.User;
import org.http4s.headers.User$minusAgent$;
import org.typelevel.ci.package$;
import org.typelevel.keypool.KeyPool;
import org.typelevel.keypool.Managed;
import org.typelevel.keypool.Reusable;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class ClientHelpers$ {
    public static final ClientHelpers$ MODULE$ = new ClientHelpers$();

    public <F> Resource<F, RequestKeySocket<F>> requestToSocketWithKey(Request<F> request2, Option<TLSContext<F>> tlsContextOpt, boolean enableEndpointValidation, boolean enableServerNameIndication, SocketGroup<F> sg, List<SocketOption> additionalSocketOptions, MonadError<F, Throwable> evidence$1) {
        RequestKey requestKey = RequestKey$.MODULE$.fromRequest(request2);
        return this.requestKeyToSocketWithKey(requestKey, tlsContextOpt, enableEndpointValidation, enableServerNameIndication, sg, additionalSocketOptions, evidence$1);
    }

    public <F> Resource<F, RequestKeySocket<F>> unixSocket(Request<F> request2, UnixSockets<F> unixSockets, UnixSocketAddress address, Option<TLSContext<F>> tlsContextOpt, boolean enableEndpointValidation, boolean enableServerNameIndication, MonadError<F, Throwable> evidence$2) {
        RequestKey requestKey = RequestKey$.MODULE$.fromRequest(request2);
        return this.elevateSocket(requestKey, unixSockets.client(address), tlsContextOpt, enableEndpointValidation, enableServerNameIndication, (Option<SocketAddress<Host>>)None$.MODULE$, evidence$2);
    }

    public <F> Resource<F, RequestKeySocket<F>> requestKeyToSocketWithKey(RequestKey requestKey, Option<TLSContext<F>> tlsContextOpt, boolean enableEndpointValidation, boolean enableServerNameIndication, SocketGroup<F> sg, List<SocketOption> additionalSocketOptions, MonadError<F, Throwable> evidence$3) {
        return Resource$.MODULE$.eval(this.getAddress(requestKey, evidence$3)).flatMap((Function1 & Serializable)address -> {
            Resource s = sg.client(address, additionalSocketOptions);
            return MODULE$.elevateSocket(requestKey, s, tlsContextOpt, enableEndpointValidation, enableServerNameIndication, (Option<SocketAddress<Host>>)new Some(address), evidence$3);
        });
    }

    public <F> Resource<F, RequestKeySocket<F>> elevateSocket(RequestKey requestKey, Resource<F, Socket<F>> initSocket, Option<TLSContext<F>> tlsContextOpt, boolean enableEndpointValidation, boolean enableServerNameIndication, Option<SocketAddress<Host>> optionNames, MonadError<F, Throwable> evidence$4) {
        return initSocket.flatMap((Function1 & Serializable)iSocket -> ((Resource)(package.all$.MODULE$.catsSyntaxEq((Object)requestKey.scheme(), (Eq)Uri.Scheme$.MODULE$.http4sOrderForScheme()).$eq$eq$eq((Object)Uri.Scheme$.MODULE$.https()) ? tlsContextOpt.fold((Function0 & Serializable)() -> Resource$.MODULE$.raiseError((Object)new ClientHelpers.MissingTlsContext(), (ApplicativeError)evidence$4), (Function1 & Serializable)x$1 -> (Resource)package.all$.MODULE$.toFunctorOps((Object)x$1.clientBuilder(iSocket).withParameters(Util$.MODULE$.mkClientTLSParameters(optionNames, enableEndpointValidation, enableServerNameIndication)).build(), (Functor)Resource$.MODULE$.catsEffectMonadErrorForResource(evidence$4)).widen()) : ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId(iSocket), (Applicative)Resource$.MODULE$.catsEffectMonadErrorForResource(evidence$4)))).map((Function1 & Serializable)socket -> new RequestKeySocket(socket, requestKey)));
    }

    public <F> F request(Request<F> request2, EmberConnection<F> connection, int chunkSize, int maxResponseHeaderSize, Duration idleTimeout, Duration timeout, Option<User.minusAgent> userAgent, Async<F> evidence$5) {
        return (F)MonadErrorOps$.MODULE$.adaptError$extension(package.all$.MODULE$.catsSyntaxMonadError(package.all$.MODULE$.toFlatMapOps(this.preprocessRequest(request2, userAgent, (Monad<F>)evidence$5, (Clock<F>)evidence$5), evidence$5).flatMap((Function1 & Serializable)processedReq -> ClientHelpers$.writeRead$1(processedReq, connection, evidence$5, idleTimeout, maxResponseHeaderSize, chunkSize, timeout)), evidence$5), (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof EmberException.EmptyStream) {
                    EmberException.EmptyStream emptyStream = (EmberException.EmptyStream)A1;
                    return (B1)new ClosedChannelException(null, emptyStream){

                        public String getMessage() {
                            return "Remote Disconnect: Received zero bytes after sending request";
                        }
                        {
                            this.initCause((Throwable)x2$1);
                        }
                    };
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof EmberException.EmptyStream;
            }
        }, evidence$5);
    }

    public <F> F preprocessRequest(Request<F> req, Option<User.minusAgent> userAgent, Monad<F> evidence$6, Clock<F> evidence$7) {
        Connection connection = (Connection)Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance())).fold((Function0 & Serializable)() -> new Connection(NonEmptyList$.MODULE$.of((Object)package$.MODULE$.CIStringSyntax(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep-alive"}))).ci((Seq)Nil$.MODULE$), (Seq)Nil$.MODULE$)), (Function1 & Serializable)x -> (Connection)Predef$.MODULE$.identity(x));
        Option userAgentHeader = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(User$minusAgent$.MODULE$.headerInstance())).orElse((Function0 & Serializable)() -> userAgent);
        return (F)package.all$.MODULE$.toFunctorOps(Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Date$.MODULE$.headerInstance())).fold((Function0 & Serializable)() -> package.all$.MODULE$.toFunctorOps(HttpDate$.MODULE$.current((Functor)evidence$6, evidence$7), (Functor)evidence$6).map((Function1 & Serializable)x$6 -> new Date(x$6)), (Function1 & Serializable)x$7 -> ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId(x$7), (Applicative)evidence$6)), evidence$6).map((Function1 & Serializable)date -> (Request)req.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw(date, Date$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)connection, Connection$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.foldablesToRaw((Object)userAgentHeader, (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForOption(), (Function1 & Serializable)h -> Header.ToRaw$.MODULE$.modelledHeadersToRaw(h, User$minusAgent$.MODULE$.headerInstance()))})));
    }

    public <F> F postProcessResponse(Request<F> req, Response<F> resp, F drain, Ref<F, byte[]> nextBytes, Ref<F, Reusable> canBeReused, F startNextRead, GenConcurrent<F, Throwable> F) {
        return (F)package.all$.MODULE$.toFlatMapOps(drain, F).flatMap((Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                byte[] bytes = (byte[])some.value();
                boolean requestClose = Util$.MODULE$.connectionFor(req.httpVersion(), req.headers()).hasClose();
                boolean responseClose = Util$.MODULE$.connectionFor(resp.httpVersion(), resp.headers()).hasClose();
                if (requestClose || responseClose) {
                    return F.unit();
                }
                return ApplyOps$.MODULE$.$times$greater$extension(package.all$.MODULE$.catsSyntaxApplyOps(ApplyOps$.MODULE$.$times$greater$extension(package.all$.MODULE$.catsSyntaxApplyOps(nextBytes.set((Object)bytes)), startNextRead, (Apply)F)), canBeReused.set((Object)Reusable.Reuse$.MODULE$), (Apply)F);
            }
            if (None$.MODULE$.equals(option)) {
                return F.unit();
            }
            throw new MatchError((Object)option);
        });
    }

    private <F> F getAddress(RequestKey requestKey, MonadError<F, Throwable> evidence$8) {
        RequestKey requestKey2 = requestKey;
        if (requestKey2 != null) {
            Uri.Scheme s = requestKey2.scheme();
            Uri.Authority auth = requestKey2.authority();
            int port = BoxesRunTime.unboxToInt((Object)auth.port().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> {
                Uri.Scheme scheme = s;
                Uri.Scheme scheme2 = Uri.Scheme$.MODULE$.https();
                if (!(scheme != null ? !scheme.equals(scheme2) : scheme2 != null)) {
                    return 443;
                }
                return 80;
            }));
            String host2 = auth.host().value();
            return (F)package.all$.MODULE$.toFlatMapOps(OptionOps$.MODULE$.liftTo$extension(package.all$.MODULE$.catsSyntaxOption(Host$.MODULE$.fromString(host2))).apply((Function0 & Serializable)() -> new ClientHelpers.MissingOrInvalidHost(host2), evidence$8), evidence$8).flatMap((Function1 & Serializable)host -> package.all$.MODULE$.toFunctorOps(OptionOps$.MODULE$.liftTo$extension(package.all$.MODULE$.catsSyntaxOption(Port$.MODULE$.fromInt(port))).apply((Function0 & Serializable)() -> new ClientHelpers.MissingOrInvalidPort(port), (ApplicativeError)evidence$8), (Functor)evidence$8).map((Function1 & Serializable)port -> new SocketAddress(host, port)));
        }
        throw new MatchError((Object)requestKey2);
    }

    public <F> Resource<F, Managed<F, EmberConnection<F>>> getValidManaged(KeyPool<F, RequestKey, EmberConnection<F>> pool, Request<F> request2, Async<F> evidence$9) {
        return Hotswap$.MODULE$.create(evidence$9).evalMap((Function1 & Serializable)hs -> ClientHelpers$.go$1(hs, pool, request2, evidence$9));
    }

    private static final Object writeRequestToSocket$1(Request req, Socket socket, Async evidence$5$1, Duration idleTimeout$1) {
        return Encoder$.MODULE$.reqToBytes(req, Encoder$.MODULE$.reqToBytes$default$2(), (ApplicativeError)evidence$5$1).through((Function1 & Serializable)x$2 -> x$2.chunks().foreach((Function1 & Serializable)c -> Util$.MODULE$.timeoutMaybe(socket.write(c), idleTimeout$1, (GenTemporal)evidence$5$1))).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)evidence$5$1))).drain();
    }

    private static final Object writeRead$1(Request req, EmberConnection connection$1, Async evidence$5$1, Duration idleTimeout$1, int maxResponseHeaderSize$1, int chunkSize$1, Duration timeout$1) {
        Object parse = package.all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(connection$1.nextBytes().getAndSet((Object)Array$.MODULE$.emptyByteArray()), GenTemporalOps$.MODULE$.timeout$extension(package.all$.MODULE$.genTemporalOps(MonadErrorRethrowOps$.MODULE$.rethrow$extension(package.all$.MODULE$.catsSyntaxMonadErrorRethrow(package.all$.MODULE$.toFlatMapOps(connection$1.nextRead().get(), (FlatMap)evidence$5$1).flatMap((Function1 & Serializable)x$3 -> x$3.get()), (MonadError)evidence$5$1), (MonadError)evidence$5$1), (GenTemporal)evidence$5$1), idleTimeout$1, (GenTemporal)evidence$5$1, (.less.colon.less)$less$colon$less$.MODULE$.refl()))).flatMapN((Function2 & Serializable)(head, firstRead) -> {
            Method method = req.method();
            Method method2 = Method$.MODULE$.HEAD();
            return Parser.Response$.MODULE$.parser(maxResponseHeaderSize$1, !(method != null ? !method.equals(method2) : method2 != null), (byte[])package.all$.MODULE$.toFoldableOps(firstRead, (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForOption()).foldLeft(head, (Function2 & Serializable)(x$4, x$5) -> Util$.MODULE$.concatBytes(x$4, x$5)), Util$.MODULE$.timeoutMaybe(connection$1.keySocket().socket().read(chunkSize$1), idleTimeout$1, (GenTemporal)evidence$5$1), (GenConcurrent)evidence$5$1);
        }, (FlatMap)evidence$5$1);
        return ApplyOps$.MODULE$.productR$extension(package.all$.MODULE$.catsSyntaxApplyOps(ClientHelpers$.writeRequestToSocket$1(req, connection$1.keySocket().socket(), evidence$5$1, idleTimeout$1)), Util$.MODULE$.timeoutToMaybe(parse, timeout$1, Defer$.MODULE$.apply((Defer)evidence$5$1).defer((Function0 & Serializable)() -> package.ApplicativeThrow$.MODULE$.apply((ApplicativeError)evidence$5$1).raiseError((Object)new TimeoutException(new StringBuilder(49).append("Timed Out on EmberClient Header Receive Timeout: ").append(timeout$1).toString()))), (GenTemporal)evidence$5$1), (Apply)evidence$5$1);
    }

    private static final Object go$1(Hotswap hs$1, KeyPool pool$1, Request request$1, Async evidence$9$1) {
        return ApplyOps$.MODULE$.$times$greater$extension(package.all$.MODULE$.catsSyntaxApplyOps(hs$1.clear()), package.all$.MODULE$.toFlatMapOps(hs$1.swap(pool$1.take((Object)RequestKey$.MODULE$.fromRequest(request$1))), (FlatMap)evidence$9$1).flatMap((Function1 & Serializable)managed -> IfMOps$.MODULE$.ifM$extension(package.all$.MODULE$.catsSyntaxIfM(((EmberConnection)managed.value()).isValid(), (FlatMap)evidence$9$1), (Function0 & Serializable)() -> ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId(managed), (Applicative)evidence$9$1), (Function0 & Serializable)() -> {
            if (managed.isReused()) {
                return ApplyOps$.MODULE$.$times$greater$extension(package.all$.MODULE$.catsSyntaxApplyOps(managed.canBeReused().set((Object)Reusable.DontReuse$.MODULE$)), ClientHelpers$.go$1(hs$1, pool$1, request$1, evidence$9$1), (Apply)evidence$9$1);
            }
            return Sync$.MODULE$.apply((Sync)evidence$9$1).raiseError((Object)new SocketException("Fresh connection from pool was not open", SocketException$.MODULE$.$lessinit$greater$default$2()));
        }, (FlatMap)evidence$9$1)), (Apply)evidence$9$1);
    }

    private ClientHelpers$() {
    }
}

