/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.server.internal;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Foldable;
import cats.Functor;
import cats.Invariant$;
import cats.Semigroupal$;
import cats.data.NonEmptyList$;
import cats.effect.Concurrent;
import cats.effect.Sync;
import cats.effect.concurrent.Ref;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.FoldableOps$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Pull;
import fs2.Pull$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.concurrent.Signal;
import fs2.concurrent.Signal$;
import fs2.concurrent.SignallingRef$;
import fs2.internal.FreeC;
import fs2.io.tcp.Socket;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.http4s.EntityEncoder$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Protocol;
import org.http4s.Protocol$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.ember.core.Util$;
import org.http4s.ember.server.internal.ServerHelpers$;
import org.http4s.ember.server.internal.WebSocketHelpers;
import org.http4s.ember.server.internal.WebSocketHelpers$BothClosed$;
import org.http4s.ember.server.internal.WebSocketHelpers$EndpointClosed$;
import org.http4s.ember.server.internal.WebSocketHelpers$KeyNotFound$;
import org.http4s.ember.server.internal.WebSocketHelpers$Open$;
import org.http4s.ember.server.internal.WebSocketHelpers$UpgradeRequired$;
import org.http4s.ember.server.internal.WebSocketHelpers$VersionNotFound$;
import org.http4s.headers.Connection;
import org.http4s.headers.Connection$;
import org.http4s.headers.Sec;
import org.http4s.headers.Sec$minusWebSocket$minusAccept$;
import org.http4s.headers.Sec$minusWebSocket$minusKey$;
import org.http4s.headers.Sec$minusWebSocket$minusVersion$;
import org.http4s.headers.Upgrade;
import org.http4s.headers.Upgrade$;
import org.http4s.syntax.package;
import org.http4s.websocket.FrameTranscoder;
import org.http4s.websocket.Rfc6455$;
import org.http4s.websocket.WebSocket;
import org.http4s.websocket.WebSocketCombinedPipe;
import org.http4s.websocket.WebSocketContext;
import org.http4s.websocket.WebSocketFrame;
import org.http4s.websocket.WebSocketSeparatePipe;
import org.typelevel.ci.CIString;
import org.typelevel.ci.package$;
import org.typelevel.log4cats.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class WebSocketHelpers$ {
    public static final WebSocketHelpers$ MODULE$ = new WebSocketHelpers$();
    private static final long supportedWebSocketVersion = 13L;
    private static final CIString upgradeCi = package$.MODULE$.CIStringSyntax(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"upgrade"}))).ci((Seq)Nil$.MODULE$);
    private static final Protocol webSocketProtocol = new Protocol(package$.MODULE$.CIStringSyntax(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"websocket"}))).ci((Seq)Nil$.MODULE$), (Option)None$.MODULE$);
    private static final Connection connectionUpgrade = new Connection(NonEmptyList$.MODULE$.of((Object)upgradeCi, (Seq)Nil$.MODULE$));
    private static final Upgrade upgradeWebSocket = Upgrade$.MODULE$.apply(webSocketProtocol, (Seq)Nil$.MODULE$);

    public <F> F upgrade(Socket<F> socket, Request<F> req, WebSocketContext<F> ctx, byte[] buffer, int receiveBufferSize, Duration idleTimeout, Function3<Option<Request<F>>, Response<F>, Throwable, F> onWriteFailure, Function1<Throwable, F> errorHandler, Logger<F> logger, Concurrent<F> F) {
        Object object;
        Either<WebSocketHelpers.ClientHandshakeError, String> either = this.clientHandshake(req);
        if (either instanceof Right) {
            Right right = (Right)either;
            String key = (String)right.value();
            object = ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(package.all$.MODULE$.catsSyntaxApplicativeError(package.all$.MODULE$.toFunctorOps(this.serverHandshake(key, (Sync<F>)F), F).map((Function1 & Serializable)hashBytes -> {
                Sec.minusWebSocket.minusAccept secWebSocketAccept = new Sec.minusWebSocket.minusAccept(hashBytes);
                List headers = Headers$.MODULE$.$plus$plus$extension(ctx.headers(), Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)connectionUpgrade, Connection$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)upgradeWebSocket, Upgrade$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)secWebSocketAccept, Sec$minusWebSocket$minusAccept$.MODULE$.headerInstance())})));
                return (Response)Response$.MODULE$.apply(Status$.MODULE$.SwitchingProtocols(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()).withHeaders(headers);
            }), F), errorHandler, F);
        } else if (either instanceof Left) {
            Left left = (Left)either;
            WebSocketHelpers.ClientHandshakeError error = (WebSocketHelpers.ClientHandshakeError)left.value();
            object = ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)Response$.MODULE$.apply(error.status(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()).withEntity((Object)error.message(), EntityEncoder$.MODULE$.stringEncoder(EntityEncoder$.MODULE$.stringEncoder$default$1()))), F);
        } else {
            throw new MatchError(either);
        }
        Object wsResponse = object;
        Object handler = package.all$.MODULE$.toFlatMapOps(wsResponse, F).flatMap((Function1 & Serializable)response -> package.all$.MODULE$.toFlatMapOps(ServerHelpers$.MODULE$.send(socket, new Some((Object)req), response, idleTimeout, onWriteFailure, F), (FlatMap)F).flatMap((Function1 & Serializable)x$2 -> {
            BoxedUnit boxedUnit = x$2;
            Status status = response.status();
            Status status2 = Status$.MODULE$.SwitchingProtocols();
            Object object = !(status != null ? !status.equals(status2) : status2 != null) ? MODULE$.runConnection(socket, ctx, buffer, receiveBufferSize, idleTimeout, F) : F.unit();
            return object;
        }));
        return (F)ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(package.all$.MODULE$.catsSyntaxApplicativeError(handler, F), (Function1 & Serializable)e -> logger.error(e, (Function0 & Serializable)() -> "WebSocket connection terminated with exception"), F);
    }

    private <F> F runConnection(Socket<F> socket, WebSocketContext<F> ctx, byte[] buffer, int receiveBufferSize, Duration idleTimeout, Concurrent<F> F) {
        Object read = socket.read(receiveBufferSize, Util$.MODULE$.durationToFinite(idleTimeout));
        Function1 write = socket.writes(Util$.MODULE$.durationToFinite(idleTimeout));
        FrameTranscoder frameTranscoder = new FrameTranscoder(false);
        FreeC incoming = Stream$.MODULE$.$plus$plus$extension(Stream$.MODULE$.chunk(Chunk$.MODULE$.bytes(buffer)), (Function0 & Serializable)() -> new Stream(WebSocketHelpers$.MODULE$.readStream(read)));
        return (F)package.all$.MODULE$.toFlatMapOps(SignallingRef$.MODULE$.apply((Object)WebSocketHelpers$Open$.MODULE$, F), F).flatMap((Function1 & Serializable)close -> {
            Tuple2 tuple2;
            WebSocket webSocket = ctx.webSocket();
            if (webSocket instanceof WebSocketCombinedPipe) {
                WebSocketCombinedPipe webSocketCombinedPipe = (WebSocketCombinedPipe)webSocket;
                Function1 receiveSend = webSocketCombinedPipe.receiveSend();
                Object onClose = webSocketCombinedPipe.onClose();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Stream(Stream$.MODULE$.through$extension(Stream$.MODULE$.through$extension(Stream$.MODULE$.through$extension(Stream$.MODULE$.through$extension(Stream$.MODULE$.through$extension(incoming, MODULE$.decodeFrames(frameTranscoder, F)), MODULE$.handleIncomingFrames((Function1)write, frameTranscoder, (Ref)close, F)), receiveSend), MODULE$.encodeFrames(frameTranscoder)), write))), onClose);
            } else if (webSocket instanceof WebSocketSeparatePipe) {
                WebSocketSeparatePipe webSocketSeparatePipe = (WebSocketSeparatePipe)webSocket;
                FreeC send = webSocketSeparatePipe.send();
                Function1 receive = webSocketSeparatePipe.receive();
                Object onClose = webSocketSeparatePipe.onClose();
                Object closeFrame = package.all$.MODULE$.toFlatMapOps(close.get(), (FlatMap)F).flatMap((Function1 & Serializable)x0$1 -> {
                    WebSocketHelpers.Close close = x0$1;
                    Object object = WebSocketHelpers$Open$.MODULE$.equals(close) ? package.all$.MODULE$.toFlatMapOps(F.fromEither(WebSocketFrame.Close$.MODULE$.apply(1000)), (FlatMap)F).flatMap((Function1 & Serializable)frame -> package.all$.MODULE$.toFunctorOps(close.update((Function1 & Serializable)x0$2 -> {
                        WebSocketHelpers.Close close = x0$2;
                        WebSocketHelpers.Close close2 = WebSocketHelpers$Open$.MODULE$.equals(close) ? WebSocketHelpers$EndpointClosed$.MODULE$ : WebSocketHelpers$BothClosed$.MODULE$;
                        return close2;
                    }), (Functor)F).map((Function1 & Serializable)x$3 -> new Stream(WebSocketHelpers$.$anonfun$runConnection$6(frame, x$3)))) : F.pure((Object)new Stream(Stream$.MODULE$.empty()));
                    return object;
                });
                FreeC sendWithClose = Stream$.MODULE$.$plus$plus$extension(send, (Function0 & Serializable)() -> new Stream(Stream$.MODULE$.flatten$extension(Stream$.MODULE$.eval(closeFrame), (.less.colon.less)$less$colon$less$.MODULE$.refl())));
                FreeC writer = Stream$.MODULE$.through$extension(Stream$.MODULE$.through$extension(sendWithClose, MODULE$.encodeFrames(frameTranscoder)), write);
                FreeC reader = Stream$.MODULE$.through$extension(Stream$.MODULE$.through$extension(Stream$.MODULE$.through$extension(incoming, MODULE$.decodeFrames(frameTranscoder, F)), MODULE$.handleIncomingFrames((Function1)write, frameTranscoder, (Ref)close, F)), receive);
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Stream(Stream$.MODULE$.concurrently$extension(reader, writer, F))), onClose);
            } else {
                throw new MatchError((Object)webSocket);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            FreeC stream = ((Stream)tuple22._1()).fs2$Stream$$free();
            Object onClose = tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)new Stream(stream), onClose);
            Tuple2 tuple24 = tuple23;
            FreeC stream2 = ((Stream)tuple24._1()).fs2$Stream$$free();
            Object onClose2 = tuple24._2();
            return Stream$.MODULE$.compile$extension(Stream$.MODULE$.onFinalize$extension(Stream$.MODULE$.interruptWhen$extension(stream2, Signal.SignalOps$.MODULE$.map$extension(Signal$.MODULE$.SignalOps((Signal)close), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)WebSocketHelpers$.$anonfun$runConnection$8(x$5)), (Functor)F), F), onClose2, (Applicative)F), Stream.Compiler$.MODULE$.syncInstance((Sync)F)).drain();
        });
    }

    private <F> Function1<Stream<F, WebSocketFrame>, Stream<F, WebSocketFrame>> handleIncomingFrames(Function1<Stream<F, Object>, Stream<F, BoxedUnit>> write, FrameTranscoder frameTranscoder, Ref<F, WebSocketHelpers.Close> closeState, Concurrent<F> F) {
        return (Function1 & Serializable)stream -> new Stream(Stream$.MODULE$.evalMapFilter$extension(((Stream)stream).fs2$Stream$$free(), (Function1 & Serializable)x0$1 -> {
            Object object;
            WebSocketFrame webSocketFrame = x0$1;
            if (webSocketFrame instanceof WebSocketFrame.Ping) {
                WebSocketFrame.Ping ping = (WebSocketFrame.Ping)webSocketFrame;
                ByteVector data = ping.data();
                object = package.all$.MODULE$.toFunctorOps($this.writeFrame$1((WebSocketFrame)new WebSocketFrame.Pong(data), frameTranscoder$2, write$2, F$3), (Functor)F$3).as((Object)None$.MODULE$);
            } else if (webSocketFrame instanceof WebSocketFrame.Close) {
                WebSocketFrame.Close close = (WebSocketFrame.Close)webSocketFrame;
                object = package.all$.MODULE$.toFlatMapOps(closeState$1.get(), (FlatMap)F$3).flatMap((Function1 & Serializable)x0$2 -> {
                    WebSocketHelpers.Close close = x0$2;
                    Object object = WebSocketHelpers$Open$.MODULE$.equals(close) ? package.all$.MODULE$.toFlatMapOps(F$3.fromEither(WebSocketFrame.Close$.MODULE$.apply(close.closeCode())), (FlatMap)F$3).flatMap((Function1 & Serializable)frame -> package.all$.MODULE$.toFlatMapOps($this.writeFrame$1((WebSocketFrame)frame, frameTranscoder$2, write$2, F$3), (FlatMap)F$3).flatMap((Function1 & Serializable)x$7 -> {
                        BoxedUnit boxedUnit = x$7;
                        Object object = package.all$.MODULE$.toFunctorOps(closeState$1.set((Object)WebSocketHelpers$BothClosed$.MODULE$), (Functor)F$3).map((Function1 & Serializable)x$6 -> {
                            BoxedUnit boxedUnit = x$6;
                            None$ none$ = None$.MODULE$;
                            return none$;
                        });
                        return object;
                    })) : F$3.pure((Object)None$.MODULE$);
                    return object;
                });
            } else {
                object = F$3.pure((Object)new Some((Object)webSocketFrame));
            }
            return object;
        }));
    }

    private <F> Function1<Stream<F, WebSocketFrame>, Stream<F, Object>> encodeFrames(FrameTranscoder frameTranscoder) {
        return (Function1 & Serializable)stream -> new Stream(Stream$.MODULE$.flatMap$extension(((Stream)stream).fs2$Stream$$free(), (Function1 & Serializable)frame -> new Stream(WebSocketHelpers$.$anonfun$encodeFrames$2(frameTranscoder$3, frame))));
    }

    private <F> Function1<Stream<F, Object>, Stream<F, WebSocketFrame>> decodeFrames(FrameTranscoder frameTranscoder, Concurrent<F> F) {
        return (Function1 & Serializable)stream -> new Stream(Pull$.MODULE$.stream$extension(Pull$.MODULE$.void$extension(WebSocketHelpers$.go$1(((Stream)stream).fs2$Stream$$free(), Array$.MODULE$.emptyByteArray(), F, frameTranscoder)), (.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private <F> Either<WebSocketHelpers.ClientHandshakeError, String> clientHandshake(Request<F> req) {
        var7_2 = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance()));
        var5_5 /* !! */  = var7_2 instanceof Some != false && (header = (Connection)(var8_3 = (Some)var7_2).value()).hasUpgrade() != false ? EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either())) : scala.package$.MODULE$.Left().apply((Object)WebSocketHelpers$UpgradeRequired$.MODULE$);
        connection = var5_5 /* !! */ ;
        var11_7 = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Upgrade$.MODULE$.headerInstance()));
        var4_10 /* !! */  = var11_7 instanceof Some != false && FoldableOps$.MODULE$.contains_$extension(package.all$.MODULE$.catsSyntaxFoldOps((Object)(header = (Upgrade)(var12_8 = (Some)var11_7).value()).values(), (Foldable)NonEmptyList$.MODULE$.catsDataInstancesForNonEmptyList()), (Object)WebSocketHelpers$.webSocketProtocol, Protocol$.MODULE$.catsEqInstance(), (Foldable)NonEmptyList$.MODULE$.catsDataInstancesForNonEmptyList()) != false ? EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either())) : scala.package$.MODULE$.Left().apply((Object)WebSocketHelpers$UpgradeRequired$.MODULE$);
        upgrade = var4_10 /* !! */ ;
        var15_12 = false;
        var16_13 = null;
        var17_14 = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Sec$minusWebSocket$minusVersion$.MODULE$.headerInstance()));
        if (!(var17_14 instanceof Some)) ** GOTO lbl-1000
        var15_12 = true;
        var16_13 = (Some)var17_14;
        header = (Sec.minusWebSocket.minusVersion)var16_13.value();
        if (header.version() == WebSocketHelpers$.supportedWebSocketVersion) {
            var3_16 = EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()));
        } else if (var15_12) {
            header = (Sec.minusWebSocket.minusVersion)var16_13.value();
            var3_16 = scala.package$.MODULE$.Left().apply((Object)new WebSocketHelpers.UnsupportedVersion(WebSocketHelpers$.supportedWebSocketVersion, header.version()));
        } else if (None$.MODULE$.equals(var17_14)) {
            var3_16 = scala.package$.MODULE$.Left().apply((Object)WebSocketHelpers$VersionNotFound$.MODULE$);
        } else {
            throw new MatchError((Object)var17_14);
        }
        version = var3_16;
        var21_19 = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Sec$minusWebSocket$minusKey$.MODULE$.headerInstance()));
        if (var21_19 instanceof Some) {
            var22_20 = (Some)var21_19;
            header = (Sec.minusWebSocket.minusKey)var22_20.value();
            var2_22 = scala.package$.MODULE$.Right().apply((Object)package.all$.MODULE$.http4sHeaderSyntax((Object)header, Sec$minusWebSocket$minusKey$.MODULE$.headerInstance()).value());
        } else if (None$.MODULE$.equals(var21_19)) {
            var2_22 = scala.package$.MODULE$.Left().apply((Object)WebSocketHelpers$KeyNotFound$.MODULE$);
        } else {
            throw new MatchError((Object)var21_19);
        }
        key = var2_22;
        return (Either)package.all$.MODULE$.catsSyntaxTuple4Semigroupal(new Tuple4((Object)connection, (Object)upgrade, (Object)version, (Object)key)).mapN((Function4)(Function4 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$clientHandshake$1(scala.runtime.BoxedUnit scala.runtime.BoxedUnit scala.runtime.BoxedUnit java.lang.String ), (Lscala/runtime/BoxedUnit;Lscala/runtime/BoxedUnit;Lscala/runtime/BoxedUnit;Ljava/lang/String;)Ljava/lang/String;)(), (Functor)Invariant$.MODULE$.catsMonadErrorForEither(), Semigroupal$.MODULE$.catsSemigroupalForEither());
    }

    private <F> F serverHandshake(String value, Sync<F> F) {
        return (F)F.delay((Function0 & Serializable)() -> {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(value.getBytes(StandardCharsets.US_ASCII));
            crypt.update(Rfc6455$.MODULE$.handshakeMagicBytes());
            byte[] bytes = crypt.digest();
            return ByteVector$.MODULE$.apply(bytes);
        });
    }

    private <F> FreeC<F, Object, BoxedUnit> readStream(F read) {
        return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval(read), (Function1 & Serializable)x0$1 -> new Stream(WebSocketHelpers$.$anonfun$readStream$1(read, x0$1)));
    }

    public static final /* synthetic */ FreeC $anonfun$runConnection$6(WebSocketFrame.Close frame$1, BoxedUnit x$3) {
        BoxedUnit boxedUnit = x$3;
        FreeC freeC = Stream$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new WebSocketFrame.Close[]{frame$1}));
        return freeC;
    }

    public static final /* synthetic */ boolean $anonfun$runConnection$8(WebSocketHelpers.Close x$5) {
        WebSocketHelpers.Close close = x$5;
        WebSocketHelpers$BothClosed$ webSocketHelpers$BothClosed$ = WebSocketHelpers$BothClosed$.MODULE$;
        return !(close != null ? !close.equals(webSocketHelpers$BothClosed$) : webSocketHelpers$BothClosed$ != null);
    }

    private final Object writeFrame$1(WebSocketFrame frame, FrameTranscoder frameTranscoder$2, Function1 write$2, Concurrent F$3) {
        return Stream$.MODULE$.compile$extension(Stream$.MODULE$.through$extension(Stream$.MODULE$.through$extension(Stream.PureOps$.MODULE$.covary$extension(Stream$.MODULE$.PureOps(Stream$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new WebSocketFrame[]{frame})))), this.encodeFrames(frameTranscoder$2)), write$2), Stream.Compiler$.MODULE$.syncInstance((Sync)F$3)).drain();
    }

    public static final /* synthetic */ FreeC $anonfun$encodeFrames$2(FrameTranscoder frameTranscoder$3, WebSocketFrame frame) {
        Chunk[] chunks = (Chunk[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])frameTranscoder$3.frameToBuffer(frame)), (Function1 & Serializable)buffer -> {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            return Chunk$.MODULE$.bytes(bytes);
        }, ClassTag$.MODULE$.apply(Chunk.class));
        return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.iterable((Iterable)Predef$.MODULE$.wrapRefArray((Object[])chunks)), (Function1 & Serializable)x$8 -> new Stream(Stream$.MODULE$.chunk(x$8)));
    }

    public static final /* synthetic */ FreeC $anonfun$decodeFrames$4(ByteBuffer byteBuffer$1, FreeC next$1, byte[] buffer$2, Concurrent F$4, FrameTranscoder frameTranscoder$4, WebSocketFrame value) {
        FreeC freeC;
        if (value != null) {
            byte[] remaining = new byte[byteBuffer$1.remaining()];
            byteBuffer$1.get(remaining);
            freeC = Pull$.MODULE$.$greater$greater$extension(Pull$.MODULE$.output1((Object)value), (Function0 & Serializable)() -> new Pull(WebSocketHelpers$.go$1(next$1, remaining, F$4, frameTranscoder$4)));
        } else {
            freeC = WebSocketHelpers$.go$1(next$1, buffer$2, F$4, frameTranscoder$4);
        }
        return freeC;
    }

    public static final /* synthetic */ FreeC $anonfun$decodeFrames$2(byte[] acc$1, Concurrent F$4, FrameTranscoder frameTranscoder$4, Option x0$1) {
        FreeC freeC;
        Some some;
        Tuple2 tuple2;
        Option option = x0$1;
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Chunk chunk = (Chunk)tuple2._1();
            FreeC next = ((Stream)tuple2._2()).fs2$Stream$$free();
            byte[] buffer = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps(acc$1), chunk.toArray((ClassTag)ClassTag$.MODULE$.Byte()), (ClassTag)ClassTag$.MODULE$.Byte());
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
            freeC = Pull$.MODULE$.flatMap$extension(Pull$.MODULE$.eval(F$4.delay((Function0 & Serializable)() -> frameTranscoder$4.bufferToFrame(byteBuffer))), (Function1 & Serializable)value -> new Pull(WebSocketHelpers$.$anonfun$decodeFrames$4(byteBuffer, next, buffer, F$4, frameTranscoder$4, value)));
        } else if (None$.MODULE$.equals(option)) {
            freeC = Pull$.MODULE$.raiseError((Throwable)new WebSocketHelpers.EndOfStreamError(), RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)F$4));
        } else {
            throw new MatchError((Object)option);
        }
        return freeC;
    }

    private static final FreeC go$1(FreeC rest, byte[] acc, Concurrent F$4, FrameTranscoder frameTranscoder$4) {
        return Pull$.MODULE$.flatMap$extension(Stream.ToPull$.MODULE$.uncons$extension(Stream.InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(rest))), (Function1 & Serializable)x0$1 -> new Pull(WebSocketHelpers$.$anonfun$decodeFrames$2(acc, F$4, frameTranscoder$4, x0$1)));
    }

    public static final /* synthetic */ String $anonfun$clientHandshake$1(BoxedUnit x0$1, BoxedUnit x1$1, BoxedUnit x2$1, String x3$1) {
        String key;
        Tuple4 tuple4 = new Tuple4((Object)x0$1, (Object)x1$1, (Object)x2$1, (Object)x3$1);
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        String string = key = (String)tuple4._4();
        return string;
    }

    public static final /* synthetic */ FreeC $anonfun$readStream$1(Object read$2, Option x0$1) {
        FreeC freeC;
        Option option = x0$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            Chunk bytes = (Chunk)some.value();
            freeC = Stream$.MODULE$.$plus$plus$extension(Stream$.MODULE$.chunk(bytes), (Function0 & Serializable)() -> new Stream(WebSocketHelpers$.MODULE$.readStream(read$2)));
        } else if (None$.MODULE$.equals(option)) {
            freeC = Stream$.MODULE$.empty();
        } else {
            throw new MatchError((Object)option);
        }
        return freeC;
    }

    private WebSocketHelpers$() {
    }
}

