/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.server.internal;

import cats.Applicative;
import cats.Applicative$;
import cats.ApplicativeError;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.Invariant$;
import cats.Monad;
import cats.Semigroupal$;
import cats.data.Kleisli;
import cats.data.NonEmptyList$;
import cats.effect.kernel.Clock;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.EitherIdOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import com.comcast.ip4s.Host;
import com.comcast.ip4s.Port;
import com.comcast.ip4s.SocketAddress;
import com.comcast.ip4s.SocketAddressPlatform;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.net.Socket;
import fs2.io.net.SocketGroup;
import fs2.io.net.SocketOption;
import fs2.io.net.tls.TLSContext;
import fs2.io.net.tls.TLSParameters;
import fs2.io.net.tls.TLSSocket;
import java.io.Serializable;
import java.net.InetSocketAddress;
import org.http4s.HttpDate$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status$;
import org.http4s.ember.core.Encoder$;
import org.http4s.ember.core.Parser;
import org.http4s.ember.core.Util$;
import org.http4s.ember.server.internal.Shutdown;
import org.http4s.headers.Connection;
import org.http4s.headers.Connection$;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Date$;
import org.http4s.internal.tls$;
import org.http4s.server.SecureSession;
import org.http4s.server.SecureSession$;
import org.http4s.server.package;
import org.http4s.v2.Header;
import org.http4s.v2.Headers$;
import org.typelevel.ci.CIString;
import org.typelevel.ci.CIString$;
import org.typelevel.log4cats.Logger;
import org.typelevel.vault.Vault;
import org.typelevel.vault.Vault$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;
import scodec.bits.ByteVector$;

public final class ServerHelpers$
implements Serializable {
    private static final CIString closeCi;
    private static final CIString connectionCi;
    private static final Connection close;
    private static final Connection keepAlive;
    private static final Response<Nothing$> serverFailure;
    public static final ServerHelpers$ MODULE$;

    private ServerHelpers$() {
    }

    static {
        MODULE$ = new ServerHelpers$();
        closeCi = CIString$.MODULE$.apply("close");
        connectionCi = CIString$.MODULE$.apply("connection");
        close = Connection$.MODULE$.apply(NonEmptyList$.MODULE$.of((Object)closeCi, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CIString[0])));
        keepAlive = Connection$.MODULE$.apply(NonEmptyList$.MODULE$.one((Object)CIString$.MODULE$.apply("keep-alive")));
        serverFailure = (Response)Response$.MODULE$.apply(Status$.MODULE$.InternalServerError(), Response$.MODULE$.$lessinit$greater$default$2(), Response$.MODULE$.$lessinit$greater$default$3(), Response$.MODULE$.$lessinit$greater$default$4(), Response$.MODULE$.$lessinit$greater$default$5()).putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusLength$.MODULE$.zero(), Content$minusLength$.MODULE$.headerInstance())}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ServerHelpers$.class);
    }

    public <F> Stream<F, Nothing$> server(Option<Host> host, Port port, List<SocketOption> additionalSocketOptions, SocketGroup<F> sg, Kleisli<F, Request<F>, Response<F>> httpApp, Option<Tuple2<TLSContext<F>, TLSParameters>> tlsInfoOpt, Deferred<F, Either<Throwable, InetSocketAddress>> ready, Shutdown<F> shutdown, Function1<Throwable, Object> errorHandler, Function3<Option<Request<F>>, Response<F>, Throwable, Object> onWriteFailure, int maxConcurrency, int receiveBufferSize, int maxHeaderSize, Duration requestHeaderReceiveTimeout, Duration idleTimeout, Logger<F> logger, GenTemporal<F, Throwable> F) {
        Stream server = Stream$.MODULE$.resource(sg.serverResource(host, (Option)Some$.MODULE$.apply((Object)port), additionalSocketOptions), F).attempt().evalTap((Function1 & Serializable)e -> ready.complete((Object)e.map((Function1 & Serializable)_$2 -> ((SocketAddressPlatform)_$2._1()).toInetSocketAddress((.less.colon.less)$less$colon$less$.MODULE$.refl()))), F).rethrow((.less.colon.less)$less$colon$less$.MODULE$.refl(), RaiseThrowable$.MODULE$.fromApplicativeError(F)).flatMap((Function1 & Serializable)_$3 -> (Stream)_$3._2(), NotGiven$.MODULE$.value());
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(shutdown.signal(), F);
        Stream streams = server.interruptWhen(ApplicativeErrorOps$.MODULE$.attempt$extension(object, F), F).map((Function1 & Serializable)connect -> shutdown.trackConnection().$greater$greater(() -> this.$anonfun$7$$anonfun$2(httpApp, tlsInfoOpt, errorHandler, onWriteFailure, receiveBufferSize, maxHeaderSize, requestHeaderReceiveTimeout, idleTimeout, logger, F, connect), NotGiven$.MODULE$.value()));
        Stream stream = Stream$.MODULE$.NestedStreamOps(streams);
        return Stream.NestedStreamOps$.MODULE$.parJoin$extension(stream, maxConcurrency, F);
    }

    public <F> Resource<F, Socket<F>> upgradeSocket(Socket<F> socketInit, Option<Tuple2<TLSContext<F>, TLSParameters>> tlsInfoOpt, Logger<F> logger, Monad<F> evidence$1) {
        return (Resource)tlsInfoOpt.fold(() -> this.upgradeSocket$$anonfun$1(socketInit, evidence$1), (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TLSContext context = (TLSContext)tuple2._1();
            TLSParameters params = (TLSParameters)tuple2._2();
            Function1 function1 = (Function1)package.all$.MODULE$.catsSyntaxOptionId((Function1 & Serializable)s -> logger.trace(() -> this.upgradeSocket$$anonfun$3$$anonfun$1$$anonfun$1(s)));
            return (Resource)package.all$.MODULE$.toFunctorOps((Object)context.server(socketInit, params, OptionIdOps$.MODULE$.some$extension((Object)function1)), (Functor)Resource$.MODULE$.catsEffectMonadForResource(evidence$1)).widen();
        });
    }

    public <F> Object runApp(byte[] head, Object read, int maxHeaderSize, Duration requestHeaderReceiveTimeout, Kleisli<F, Request<F>, Response<F>> httpApp, Function1<Throwable, Object> errorHandler, Vault requestVault, GenTemporal<F, Throwable> evidence$2) {
        Object parse = Parser.Request$.MODULE$.parser(maxHeaderSize, head, read, evidence$2);
        Object parseWithHeaderTimeout = Util$.MODULE$.timeoutMaybe(parse, requestHeaderReceiveTimeout, evidence$2);
        return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(parseWithHeaderTimeout, evidence$2).map((Function1 & Serializable)tmp -> {
            Tuple2 tuple2 = tmp;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Request req = (Request)tuple2._1();
            Object drain = tuple2._2();
            Tuple2 $1$ = tuple2;
            Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$1$, (Object)req, drain);
            Tuple2 $1$2 = (Tuple2)tuple3._1();
            Request req2 = (Request)tuple3._2();
            Object drain2 = tuple3._3();
            return Tuple2$.MODULE$.apply(tmp, (Object)$1$2);
        }), evidence$2).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._2();
                    Tuple2 tmp = (Tuple2)tuple22._1();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Request req = (Request)tuple2._1();
            Object drain = tuple2._2();
            Object object = package.all$.MODULE$.catsSyntaxApplicativeError(httpApp.run().apply((Object)req.withAttributes(requestVault)), (ApplicativeError)evidence$2);
            Object object2 = package.all$.MODULE$.catsSyntaxApplicativeError(ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(object, errorHandler, (ApplicativeError)evidence$2), (ApplicativeError)evidence$2);
            return package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.handleError$extension(object2, (Function1 & Serializable)_$8 -> (Response)serverFailure.covary(), (ApplicativeError)evidence$2), (FlatMap)evidence$2).flatMap((Function1 & Serializable)resp -> package.all$.MODULE$.toFunctorOps(drain, (Functor)evidence$2).map((Function1 & Serializable)rest -> Tuple3$.MODULE$.apply((Object)req, resp, rest)));
        });
    }

    public <F> Object send(Socket<F> socket, Option<Request<F>> request, Response<F> resp, Duration idleTimeout, Function3<Option<Request<F>>, Response<F>, Throwable, Object> onWriteFailure, GenTemporal<F, Throwable> evidence$3) {
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(Encoder$.MODULE$.respToBytes(resp, Encoder$.MODULE$.respToBytes$default$2()).through((Function1 & Serializable)_$10 -> _$10.chunks().foreach((Function1 & Serializable)c -> Util$.MODULE$.timeoutMaybe(socket.write(c), idleTimeout, evidence$3))).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(evidence$3))).drain(), evidence$3);
        return package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, evidence$3), evidence$3).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            Either either = x$1;
            if (either instanceof Left) {
                Throwable err = (Throwable)((Left)either).value();
                object = onWriteFailure.apply((Object)request, (Object)resp, (Object)err);
                return object;
            } else {
                if (!(either instanceof Right)) throw new MatchError((Object)either);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object2 = ((Right)either).value();
                if (boxedUnit != null ? !boxedUnit.equals(object2) : object2 != null) throw new MatchError((Object)either);
                object = Applicative$.MODULE$.apply((Applicative)evidence$3).unit();
            }
            return object;
        });
    }

    public <F> Object postProcessResponse(Request<F> req, Response<F> resp, GenConcurrent<F, Throwable> evidence$4, Clock<F> evidence$5) {
        boolean reqHasClose = req.headers().exists((Function1 & Serializable)x$1 -> {
            CIString cIString;
            CIString cIString2;
            String values;
            Header.Raw raw = x$1;
            if (raw != null) {
                Header.Raw raw2 = Header.Raw$.MODULE$.unapply(raw);
                CIString cIString3 = raw2._1();
                String string = raw2._2();
                CIString name = cIString3;
                values = string;
                cIString2 = name;
                cIString = connectionCi;
            } else {
                throw new MatchError((Object)raw);
            }
            return !(cIString2 != null ? !cIString2.equals(cIString) : cIString != null) && values.contains(closeCi.toString());
        });
        Connection connection = reqHasClose ? close : keepAlive;
        return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(HttpDate$.MODULE$.current(evidence$4, evidence$5), evidence$4).map((Function1 & Serializable)_$12 -> Date$.MODULE$.apply(_$12)), evidence$4).map((Function1 & Serializable)date -> (Response)resp.withHeaders(Headers$.MODULE$.$plus$plus$extension(Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw(date, Date$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)connection, Connection$.MODULE$.headerInstance())})), resp.headers())));
    }

    public <F> Stream<F, Nothing$> runConnection(Socket<F> socket, Logger<F> logger, Duration idleTimeout, int receiveBufferSize, int maxHeaderSize, Duration requestHeaderReceiveTimeout, Kleisli<F, Request<F>, Response<F>> httpApp, Function1<Throwable, Object> errorHandler, Function3<Option<Request<F>>, Response<F>, Throwable, Object> onWriteFailure, GenTemporal<F, Throwable> evidence$6) {
        Logger<F> logger2 = logger;
        Object read = Util$.MODULE$.timeoutMaybe(socket.read(receiveBufferSize), idleTimeout, evidence$6);
        return Stream$.MODULE$.eval(this.mkRequestVault(socket, (Applicative<F>)evidence$6)).flatMap((Function1 & Serializable)requestVault -> {
            Stream stream = Stream$.MODULE$.unfoldLoopEval((Object)Array$.MODULE$.emptyByteArray(), (Function1 & Serializable)incoming -> {
                Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.runApp((byte[])incoming, read, maxHeaderSize, requestHeaderReceiveTimeout, httpApp, errorHandler, (Vault)requestVault, evidence$6), (ApplicativeError)evidence$6);
                return package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, (ApplicativeError)evidence$6), (Functor)evidence$6).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2;
                    Tuple3 tuple3;
                    Either either = x$1;
                    if (either instanceof Right && (tuple3 = (Tuple3)((Right)either).value()) != null) {
                        Request req = (Request)tuple3._1();
                        Response resp = (Response)tuple3._2();
                        Option rest = (Option)tuple3._3();
                        tuple2 = Tuple2$.MODULE$.apply((Object)package$.MODULE$.Right().apply((Object)Tuple2$.MODULE$.apply((Object)req, (Object)resp)), (Object)rest);
                    } else if (either instanceof Left) {
                        Throwable e = (Throwable)((Left)either).value();
                        tuple2 = Tuple2$.MODULE$.apply((Object)package$.MODULE$.Left().apply((Object)e), (Object)None$.MODULE$);
                    } else {
                        throw new MatchError((Object)either);
                    }
                    return tuple2;
                });
            }).evalMap((Function1 & Serializable)x$1 -> {
                Object object;
                Tuple2 tuple2;
                Either either = x$1;
                if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                    Request req = (Request)tuple2._1();
                    Response resp2 = (Response)tuple2._2();
                    object = package.all$.MODULE$.toFunctorOps(this.postProcessResponse((Request)req, (Response)resp2, (GenConcurrent)evidence$6, (Clock)evidence$6), (Functor)evidence$6).map((Function1 & Serializable)resp -> {
                        Tuple2 tuple2 = (Tuple2)package.all$.MODULE$.catsSyntaxEitherId((Object)Tuple2$.MODULE$.apply((Object)req, resp));
                        return EitherIdOps$.MODULE$.asRight$extension((Object)tuple2);
                    });
                } else {
                    Either other = either;
                    Either either2 = (Either)package.all$.MODULE$.catsSyntaxApplicativeId((Object)other);
                    object = ApplicativeIdOps$.MODULE$.pure$extension((Object)either2, (Applicative)evidence$6);
                }
                return object;
            }).evalTap((Function1 & Serializable)x$1 -> {
                Object object;
                Tuple2 tuple2;
                Either either = x$1;
                if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                    Request request = (Request)tuple2._1();
                    Response response = (Response)tuple2._2();
                    object = this.send(socket, (Option)Some$.MODULE$.apply((Object)request), (Response)response, idleTimeout, onWriteFailure, evidence$6);
                    return object;
                }
                if (!(either instanceof Left)) throw new MatchError((Object)either);
                Throwable err = (Throwable)((Left)either).value();
                Throwable throwable = err;
                if (throwable instanceof Parser.Request$.ReqPrelude$.ParsePreludeError) {
                    Parser.Request$.ReqPrelude$.ParsePreludeError req;
                    Parser.Request$.ReqPrelude$.ParsePreludeError parsePreludeError = req = (Parser.Request$.ReqPrelude$.ParsePreludeError)throwable;
                    Parser.Request$.ReqPrelude$.ParsePreludeError parsePreludeError2 = Parser.Request$.ReqPrelude$.MODULE$.emptyStreamError();
                    if (!(parsePreludeError != null ? !parsePreludeError.equals(parsePreludeError2) : parsePreludeError2 != null)) {
                        object = Applicative$.MODULE$.apply((Applicative)evidence$6).unit();
                        return object;
                    }
                }
                Throwable err2 = throwable;
                Object object2 = package.all$.MODULE$.catsSyntaxApplicativeError(errorHandler.apply((Object)err2), (ApplicativeError)evidence$6);
                object = package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.handleError$extension(object2, (Function1 & Serializable)_$14 -> (Response)serverFailure.covary(), (ApplicativeError)evidence$6), (FlatMap)evidence$6).flatMap((Function1 & Serializable)_$15 -> this.send(socket, (Option)None$.MODULE$, (Response)_$15, idleTimeout, onWriteFailure, evidence$6));
                return object;
            }, (Functor)evidence$6);
            return stream.takeWhile((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                boolean bl;
                Either either = x$1;
                if (either instanceof Left) {
                    bl = false;
                } else if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                    Request req = (Request)tuple2._1();
                    Response resp = (Response)tuple2._2();
                    bl = !Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance())).exists((Function1 & Serializable)_$16 -> _$16.hasClose()) && !Headers$.MODULE$.get$extension(resp.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance())).exists((Function1 & Serializable)_$17 -> _$17.hasClose());
                } else {
                    throw new MatchError((Object)either);
                }
                return bl;
            }, stream.takeWhile$default$2()).drain();
        }, NotGiven$.MODULE$.value());
    }

    private <F> Object mkRequestVault(Socket<F> socket, Applicative<F> evidence$7) {
        return package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(this.mkConnectionInfo(socket, (Apply<F>)evidence$7), this.mkSecureSession(socket, evidence$7))).mapN((Function2 & Serializable)(_$19, _$20) -> _$19.$plus$plus(_$20), evidence$7, evidence$7);
    }

    private <F> Object mkConnectionInfo(Socket<F> socket, Apply<F> evidence$8) {
        return package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(socket.localAddress(), socket.remoteAddress())).mapN((Function2 & Serializable)(x$1, x$2) -> {
            Vault vault;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                SocketAddress local = (SocketAddress)tuple2._1();
                SocketAddress remote = (SocketAddress)tuple2._2();
                vault = Vault$.MODULE$.empty().insert(Request.Keys$.MODULE$.ConnectionInfo(), (Object)Request.Connection$.MODULE$.apply(local, remote, socket instanceof TLSSocket));
            } else {
                vault = Vault$.MODULE$.empty();
            }
            return vault;
        }, evidence$8, evidence$8);
    }

    private <F> Object mkSecureSession(Socket<F> socket, Applicative<F> evidence$9) {
        Object object;
        Socket<F> socket2 = socket;
        if (socket2 instanceof TLSSocket) {
            TLSSocket socket3 = (TLSSocket)socket2;
            object = package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(socket3.session(), evidence$9).map((Function1 & Serializable)session -> (Option)package.all$.MODULE$.catsSyntaxTuple4Semigroupal(Tuple4$.MODULE$.apply((Object)Option$.MODULE$.apply((Object)session.getId()).map((Function1 & Serializable)_$23 -> ByteVector$.MODULE$.apply(_$23).toHex()), (Object)Option$.MODULE$.apply((Object)session.getCipherSuite()), (Object)Option$.MODULE$.apply((Object)session.getCipherSuite()).map((Function1 & Serializable)cipherSuite -> tls$.MODULE$.deduceKeyLength(cipherSuite)), (Object)Some$.MODULE$.apply((Object)tls$.MODULE$.getCertChain(session)))).mapN(this::mkSecureSession$$anonfun$6$$anonfun$adapted$1, (Functor)Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption())), evidence$9).map((Function1 & Serializable)_$24 -> Vault$.MODULE$.empty().insert(package.ServerRequestKeys$.MODULE$.SecureSession(), _$24));
        } else {
            Vault vault = (Vault)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Vault$.MODULE$.empty());
            object = ApplicativeIdOps$.MODULE$.pure$extension((Object)vault, evidence$9);
        }
        return object;
    }

    private final Stream $anonfun$7$$anonfun$2(Kleisli httpApp$2, Option tlsInfoOpt$2, Function1 errorHandler$2, Function3 onWriteFailure$2, int receiveBufferSize$2, int maxHeaderSize$2, Duration requestHeaderReceiveTimeout$2, Duration idleTimeout$2, Logger logger$2, GenTemporal F$2, Socket connect$1) {
        return Stream$.MODULE$.resource(this.upgradeSocket((Socket)connect$1, (Option)tlsInfoOpt$2, (Logger)logger$2, (Monad)F$2), (MonadCancel)F$2).flatMap((Function1 & Serializable)_$4 -> this.runConnection((Socket)_$4, (Logger)logger$2, idleTimeout$2, receiveBufferSize$2, maxHeaderSize$2, requestHeaderReceiveTimeout$2, (Kleisli)httpApp$2, (Function1<Throwable, Object>)errorHandler$2, (Function3)onWriteFailure$2, (GenTemporal)F$2), NotGiven$.MODULE$.value());
    }

    private final Resource upgradeSocket$$anonfun$1(Socket socketInit$1, Monad evidence$1$1) {
        Socket socket = (Socket)package.all$.MODULE$.catsSyntaxApplicativeId((Object)socketInit$1);
        return (Resource)ApplicativeIdOps$.MODULE$.pure$extension((Object)socket, (Applicative)Resource$.MODULE$.catsEffectMonadForResource(evidence$1$1));
    }

    private final String upgradeSocket$$anonfun$3$$anonfun$1$$anonfun$1(String s$1) {
        return s$1;
    }

    private final /* synthetic */ SecureSession mkSecureSession$$anonfun$5$$anonfun$3(String sslSessionId, String cipherSuite, int keySize, List X509Certificate) {
        return SecureSession$.MODULE$.apply(sslSessionId, cipherSuite, keySize, X509Certificate);
    }

    private final SecureSession mkSecureSession$$anonfun$6$$anonfun$adapted$1(Object sslSessionId, Object cipherSuite, Object keySize, Object X509Certificate2) {
        return this.mkSecureSession$$anonfun$5$$anonfun$3((String)sslSessionId, (String)cipherSuite, BoxesRunTime.unboxToInt((Object)keySize), (List)X509Certificate2);
    }
}

