/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.scalaxml;

import cats.Applicative;
import cats.Monad;
import cats.data.EitherT;
import cats.effect.kernel.GenConcurrent;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.http4s.Charset;
import org.http4s.Charset$;
import org.http4s.DecodeFailure;
import org.http4s.DecodeResult$;
import org.http4s.EntityDecoder;
import org.http4s.EntityDecoder$;
import org.http4s.EntityEncoder;
import org.http4s.EntityEncoder$;
import org.http4s.MalformedMessageBodyFailure$;
import org.http4s.MediaRange;
import org.http4s.MediaType$;
import org.http4s.headers.Content$minusType$;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import scala.Function1;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML$;

public interface ElemInstances {
    public SAXParserFactory saxFactory();

    public static EntityEncoder xmlEncoder$(ElemInstances $this, Charset charset) {
        return $this.xmlEncoder(charset);
    }

    default public <F> EntityEncoder<F, Elem> xmlEncoder(Charset charset) {
        return EntityEncoder$.MODULE$.stringEncoder(charset).contramap((Function1 & Serializable)node -> {
            StringWriter sw = new StringWriter();
            XML$.MODULE$.write((Writer)sw, (Node)node, charset.nioCharset().name(), true, null, XML$.MODULE$.write$default$6());
            return sw.toString();
        }).withContentType(Content$minusType$.MODULE$.apply(MediaType$.MODULE$.application().xml()).withCharset(charset));
    }

    public static Charset xmlEncoder$default$1$(ElemInstances $this) {
        return $this.xmlEncoder$default$1();
    }

    default public <F> Charset xmlEncoder$default$1() {
        return Charset$.MODULE$.UTF$minus8();
    }

    public static EntityDecoder xml$(ElemInstances $this, GenConcurrent F) {
        return $this.xml(F);
    }

    default public <F> EntityDecoder<F, Elem> xml(GenConcurrent<F, Throwable> F) {
        return EntityDecoder$.MODULE$.decodeBy((MediaRange)MediaType$.MODULE$.text().xml(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MediaRange[]{MediaType$.MODULE$.text().html(), MediaType$.MODULE$.application().xml()}), (Function1 & Serializable)msg -> {
            InputSource source = new InputSource();
            msg.charset().foreach((Function1)(JProcedure1 & Serializable)cs -> source.setEncoding(cs.nioCharset().name()));
            return EntityDecoder$.MODULE$.collectBinary(msg, F).flatMap((Function1 & Serializable)chunk -> {
                source.setByteStream(new ByteArrayInputStream((byte[])chunk.toArray(ClassTag$.MODULE$.apply(Byte.TYPE))));
                SAXParser saxParser = this.saxFactory().newSAXParser();
                return ElemInstances.liftedTree1$1(F, source, saxParser);
            }, (Monad)F);
        }, F);
    }

    private static EitherT liftedTree1$1(GenConcurrent F$3, InputSource source$3, SAXParser saxParser$1) {
        EitherT eitherT;
        try {
            eitherT = DecodeResult$.MODULE$.successT((Object)XML$.MODULE$.loadXML(source$3, saxParser$1), (Applicative)F$3);
        }
        catch (SAXParseException e) {
            eitherT = DecodeResult$.MODULE$.failureT((DecodeFailure)MalformedMessageBodyFailure$.MODULE$.apply("Invalid XML", (Option)Some$.MODULE$.apply((Object)e)), (Applicative)F$3);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                eitherT = DecodeResult$.MODULE$.apply(F$3.raiseError((Object)e));
            }
            throw throwable;
        }
        return eitherT;
    }
}

