/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import cats.Functor;
import cats.data.Kleisli;
import cats.data.OptionT;
import cats.data.OptionT$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Pull;
import fs2.Pull$;
import fs2.Segment;
import fs2.Stream;
import fs2.Stream$;
import fs2.compress$;
import fs2.internal.FreeC;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.http4s.AttributeMap;
import org.http4s.ContentCoding$;
import org.http4s.Header;
import org.http4s.HeaderKey;
import org.http4s.Headers;
import org.http4s.HttpVersion;
import org.http4s.MediaType$;
import org.http4s.MessageOps;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.headers.Accept;
import org.http4s.headers.Accept$minusEncoding$;
import org.http4s.headers.Content;
import org.http4s.headers.Content$minusEncoding$;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Content$minusType$;
import org.http4s.server.middleware.GZip;
import org.http4s.server.middleware.GZip$TrailerGen$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GZip$ {
    public static GZip$ MODULE$;
    private final Logger logger;
    private final int GZIP_MAGIC_NUMBER;
    private final long GZIP_LENGTH_MOD;
    private final Chunk<Object> header;

    static {
        new GZip$();
    }

    public <F> Kleisli<?, Request<F>, Response<F>> apply(Kleisli<?, Request<F>, Response<F>> service, int bufferSize, int level, Function1<Response<F>, Object> isZippable, Functor<F> evidence$1) {
        return new Kleisli((Function1 & Serializable & scala.Serializable)req -> {
            Some some;
            Accept.minusEncoding acceptEncoding;
            Option option = req.headers().get((HeaderKey.Extractable)Accept$minusEncoding$.MODULE$);
            OptionT optionT = option instanceof Some && MODULE$.satisfiedByGzip(acceptEncoding = (Accept.minusEncoding)(some = (Some)option).value()) ? (OptionT)service.map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.zipOrPass((Response)x$2, bufferSize, level, isZippable, evidence$1), OptionT$.MODULE$.catsDataFunctorForOptionT(evidence$1)).apply(req) : (OptionT)service.apply(req);
            return optionT;
        });
    }

    public <F> int apply$default$2() {
        return 32768;
    }

    public <F> int apply$default$3() {
        return -1;
    }

    public <F> Function1<Response<F>, Object> apply$default$4() {
        return (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GZip$.MODULE$.defaultIsZippable(x$1));
    }

    public <F> boolean defaultIsZippable(Response<F> resp) {
        Option contentType = resp.headers().get((HeaderKey.Extractable)Content$minusType$.MODULE$);
        return resp.headers().get((HeaderKey.Extractable)Content$minusEncoding$.MODULE$).isEmpty() && (contentType.isEmpty() || ((Content.minusType)contentType.get()).mediaType().compressible() || ((Content.minusType)contentType.get()).mediaType() == MediaType$.MODULE$.application$divoctet$minusstream());
    }

    private boolean satisfiedByGzip(Accept.minusEncoding acceptEncoding) {
        return acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.gzip()) || acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.x$minusgzip());
    }

    private <F> Response<F> zipOrPass(Response<F> response, int bufferSize, int level, Function1<Response<F>, Object> isZippable, Functor<F> evidence$2) {
        Response<F> response2 = response;
        Response<F> response3 = BoxesRunTime.unboxToBoolean((Object)isZippable.apply(response2)) ? this.zipResponse(bufferSize, level, response2, evidence$2) : response2;
        return response3;
    }

    private <F> Response<F> zipResponse(int bufferSize, int level, Response<F> resp, Functor<F> evidence$3) {
        this.logger.trace("GZip middleware encoding content");
        GZip.TrailerGen trailerGen = new GZip.TrailerGen(GZip$TrailerGen$.MODULE$.$lessinit$greater$default$1(), GZip$TrailerGen$.MODULE$.$lessinit$greater$default$2());
        FreeC b = Stream.InvariantOps$.MODULE$.$plus$plus$extension(Stream$.MODULE$.InvariantOps(Stream.PureOps$.MODULE$.$plus$plus$extension(Stream$.MODULE$.PureOps(Stream$.MODULE$.chunk(this.header())), (Function0 & Serializable & scala.Serializable)() -> new Stream(Stream.InvariantOps$.MODULE$.through$extension(Stream$.MODULE$.InvariantOps(Stream.InvariantOps$.MODULE$.through$extension(Stream$.MODULE$.InvariantOps(resp.body()), Stream$.MODULE$.covaryPurePipe(GZip$.MODULE$.trailer(trailerGen, bufferSize)))), compress$.MODULE$.deflate(level, true, bufferSize, compress$.MODULE$.deflate$default$4()))))), (Function0 & Serializable & scala.Serializable)() -> new Stream(Stream$.MODULE$.covaryPure(Stream$.MODULE$.chunk(GZip$.MODULE$.trailerFinish(trailerGen)))));
        Response qual$1 = (Response)((MessageOps)resp.removeHeader((HeaderKey)Content$minusLength$.MODULE$, evidence$3)).putHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{new Content.minusEncoding(ContentCoding$.MODULE$.gzip())}), evidence$3);
        FreeC x$4 = b;
        Status x$5 = qual$1.copy$default$1();
        HttpVersion x$6 = qual$1.copy$default$2();
        Headers x$7 = qual$1.copy$default$3();
        AttributeMap x$8 = qual$1.copy$default$5();
        return qual$1.copy(x$5, x$6, x$7, x$4, x$8);
    }

    private int GZIP_MAGIC_NUMBER() {
        return this.GZIP_MAGIC_NUMBER;
    }

    private long GZIP_LENGTH_MOD() {
        return this.GZIP_LENGTH_MOD;
    }

    private Chunk<Object> header() {
        return this.header;
    }

    private <F> Function1<FreeC<?, BoxedUnit>, FreeC<?, BoxedUnit>> trailer(GZip.TrailerGen gen, long maxReadLimit) {
        return (Function1 & Serializable & scala.Serializable)x$3 -> new Stream(Pull$.MODULE$.stream$extension(Pull$.MODULE$.flatMap$extension(Stream.ToPull$.MODULE$.unconsLimit$extension(Stream.InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(((Stream)x$3).fs2$Stream$$free())), maxReadLimit), GZip$.MODULE$.trailerStep(gen, maxReadLimit))));
    }

    private Function1<Option<Tuple2<Segment<Object, BoxedUnit>, FreeC<?, BoxedUnit>>>, FreeC<?, Option<FreeC<?, BoxedUnit>>>> trailerStep(GZip.TrailerGen gen, long maxReadLimit) {
        return (Function1 & Serializable & scala.Serializable)x0$1 -> new Pull(GZip$.$anonfun$trailerStep$1(gen, maxReadLimit, x0$1));
    }

    private Chunk<Object> trailerFinish(GZip.TrailerGen gen) {
        return Chunk$.MODULE$.bytes(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putInt((int)gen.crc().getValue()).putInt((int)((long)gen.inputLength() % this.GZIP_LENGTH_MOD())).array());
    }

    public static final /* synthetic */ void $anonfun$trailerStep$2(GZip.TrailerGen gen$2, Chunk c) {
        Chunk.Bytes byteChunk = c.toBytes(Predef.$eq$colon$eq$.MODULE$.tpEquals());
        gen$2.crc().update(byteChunk.values(), byteChunk.offset(), byteChunk.length());
        gen$2.inputLength_$eq(gen$2.inputLength() + byteChunk.length());
    }

    public static final /* synthetic */ FreeC $anonfun$trailerStep$1(GZip.TrailerGen gen$2, long maxReadLimit$2, Option x0$1) {
        Some some;
        Tuple2 tuple2;
        FreeC freeC;
        Option option = x0$1;
        if (None$.MODULE$.equals(option)) {
            freeC = Pull$.MODULE$.pure((Object)None$.MODULE$);
        } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Segment segment = (Segment)tuple2._1();
            FreeC stream = ((Stream)tuple2._2()).fs2$Stream$$free();
            Segment.Force$.MODULE$.foreachChunk$extension(segment.force(), (Function1 & Serializable & scala.Serializable)c -> {
                GZip$.$anonfun$trailerStep$2(gen$2, c);
                return BoxedUnit.UNIT;
            });
            freeC = Pull$.MODULE$.$greater$greater$extension(Pull$.MODULE$.output(segment), (Function0 & Serializable & scala.Serializable)() -> new Pull(Pull$.MODULE$.flatMap$extension(Stream.ToPull$.MODULE$.unconsLimit$extension(Stream.InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(stream)), maxReadLimit$2), GZip$.MODULE$.trailerStep(gen$2, maxReadLimit$2))));
        } else {
            throw new MatchError((Object)option);
        }
        return freeC;
    }

    private GZip$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.server.middleware.GZip");
        this.GZIP_MAGIC_NUMBER = 35615;
        this.GZIP_LENGTH_MOD = (long)Math.pow(2.0, 32.0);
        this.header = Chunk$.MODULE$.bytes(new byte[]{(byte)this.GZIP_MAGIC_NUMBER(), (byte)(this.GZIP_MAGIC_NUMBER() >> 8), (byte)8, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0});
    }
}

