/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.staticcontent;

import cats.Applicative;
import cats.Functor;
import cats.Monad;
import cats.data.Kleisli;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.Effect;
import java.io.Serializable;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.StaticFile$;
import org.http4s.server.staticcontent.PathNormalizer$;
import org.http4s.server.staticcontent.WebjarService;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;

public final class WebjarService$ {
    public static WebjarService$ MODULE$;

    static {
        new WebjarService$();
    }

    public <F> Kleisli<?, Request<F>, Response<F>> apply(WebjarService.Config<F> config, Effect<F> evidence$1) {
        return new Kleisli((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Request request = x0$1;
            Method method = request.method();
            Method.Semantics$.Safe safe = Method$.MODULE$.GET();
            OptionT optionT = !(method != null ? !method.equals(safe) : safe != null) ? OptionT.PurePartiallyApplied$.MODULE$.apply$extension(OptionT$.MODULE$.pure(), (Object)request.pathInfo(), (Applicative)evidence$1).map((Function1 & Serializable & scala.Serializable)path -> PathNormalizer$.MODULE$.removeDotSegments((String)path), (Functor)evidence$1).subflatMap((Function1 & Serializable & scala.Serializable)subPath -> MODULE$.toWebjarAsset((String)subPath), (Functor)evidence$1).filter(config.filter(), (Functor)evidence$1).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.serveWebjarAsset(config, (Request)request, (WebjarService.WebjarAsset)x$2, evidence$1), (Monad)evidence$1) : OptionT$.MODULE$.none((Applicative)evidence$1);
            return optionT;
        });
    }

    private Option<WebjarService.WebjarAsset> toWebjarAsset(String subPath) {
        return Option$.MODULE$.apply((Object)subPath).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.split("/", 4)).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends String[], B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = Array$.MODULE$.unapplySeq(A1);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(4) == 0) {
                    String string = (String)((SeqLike)option.get()).apply(0);
                    String library = (String)((SeqLike)option.get()).apply(1);
                    String version = (String)((SeqLike)option.get()).apply(2);
                    String asset = (String)((SeqLike)option.get()).apply(3);
                    if ("".equals(string) && new StringOps(Predef$.MODULE$.augmentString(library)).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(version)).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(asset)).nonEmpty()) {
                        object = new WebjarService.WebjarAsset(library, version, asset);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(String[] x1) {
                String[] stringArray = x1;
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (option.isEmpty()) return false;
                if (option.get() == null) return false;
                if (((SeqLike)option.get()).lengthCompare(4) != 0) return false;
                String string = (String)((SeqLike)option.get()).apply(0);
                String library = (String)((SeqLike)option.get()).apply(1);
                String version = (String)((SeqLike)option.get()).apply(2);
                String asset = (String)((SeqLike)option.get()).apply(3);
                if (!"".equals(string)) return false;
                if (!new StringOps(Predef$.MODULE$.augmentString(library)).nonEmpty()) return false;
                if (!new StringOps(Predef$.MODULE$.augmentString(version)).nonEmpty()) return false;
                if (!new StringOps(Predef$.MODULE$.augmentString(asset)).nonEmpty()) return false;
                return true;
            }
        });
    }

    private <F> OptionT<F, Response<F>> serveWebjarAsset(WebjarService.Config<F> config, Request<F> request, WebjarService.WebjarAsset webjarAsset, Effect<F> evidence$2) {
        return StaticFile$.MODULE$.fromResource(webjarAsset.pathInJar(), (Option)new Some(request), StaticFile$.MODULE$.fromResource$default$3(), evidence$2).semiflatMap((Function1 & Serializable & scala.Serializable)x$4 -> config.cacheStrategy().cache(request.pathInfo(), x$4, evidence$2), evidence$2);
    }

    private WebjarService$() {
        MODULE$ = this;
    }
}

