/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server;

import com.comcast.ip4s.Host;
import com.comcast.ip4s.Ipv4Address;
import com.comcast.ip4s.Ipv6Address;
import com.comcast.ip4s.SocketAddress;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u2Qa\u0002\u0005\u0002\u0002=AQA\u0006\u0001\u0005\u0002]A\u0001B\u0007\u0001C\u0002\u0013\u0005\u0001b\u0007\u0005\u0007E\u0001\u0001\u000b\u0011\u0002\u000f\t\u000b\r\u0002a\u0011\u0001\u0013\t\u000bI\u0002A\u0011A\u001a\t\u000ba\u0002a\u0011A\u001d\u0003\rM+'O^3s\u0015\tI!\"\u0001\u0004tKJ4XM\u001d\u0006\u0003\u00171\ta\u0001\u001b;uaR\u001a(\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00021A\u0011\u0011\u0004A\u0007\u0002\u0011\u00051An\\4hKJ,\u0012\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0003?1\tQ\u0001\\8hiML!!\t\u0010\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\nq!\u00193ee\u0016\u001c8/F\u0001&!\r1SfL\u0007\u0002O)\u0011\u0001&K\u0001\u0005SB$4O\u0003\u0002+W\u000591m\\7dCN$(\"\u0001\u0017\u0002\u0007\r|W.\u0003\u0002/O\ti1k\\2lKR\fE\r\u001a:fgN\u0004\"A\n\u0019\n\u0005E:#\u0001\u0002%pgR\fqAY1tKV\u0013\u0018.F\u00015!\t)d'D\u0001\u000b\u0013\t9$BA\u0002Ve&\f\u0001\"[:TK\u000e,(/Z\u000b\u0002uA\u0011\u0011cO\u0005\u0003yI\u0011qAQ8pY\u0016\fg\u000e")
public abstract class Server {
    private final Logger logger = LoggerFactory.getLogger(Server.class);

    public Logger logger() {
        return this.logger;
    }

    public abstract SocketAddress<Host> address();

    public Uri baseUri() {
        Uri.Ipv4Address ipv4Address;
        Some some = new Some((Object)(this.isSecure() ? Uri.Scheme$.MODULE$.https() : Uri.Scheme$.MODULE$.http()));
        Host host = this.address().host();
        if (host instanceof Ipv4Address) {
            Ipv4Address ipv4Address2 = (Ipv4Address)host;
            ipv4Address = new Uri.Ipv4Address(ipv4Address2);
        } else if (host instanceof Ipv6Address) {
            Ipv6Address ipv6Address = (Ipv6Address)host;
            ipv4Address = new Uri.Ipv6Address(ipv6Address);
        } else {
            if (this.logger().isWarnEnabled()) {
                this.logger().warn(new StringBuilder(26).append("Unexpected address type ").append(host.getClass()).append(": ").append(host).toString());
            }
            ipv4Address = Uri.RegName$.MODULE$.apply(host.toString());
        }
        Uri.Ipv4Address x$1 = ipv4Address;
        Some x$2 = new Some((Object)BoxesRunTime.boxToInteger((int)this.address().port().value()));
        Option x$3 = Uri.Authority$.MODULE$.apply$default$1();
        return new Uri((Option)some, (Option)new Some((Object)new Uri.Authority(x$3, (Uri.Host)x$1, (Option)x$2)), Uri.Path$.MODULE$.Root(), Uri$.MODULE$.apply$default$4(), Uri$.MODULE$.apply$default$5());
    }

    public abstract boolean isSecure();
}

