/*
 * Decompiled with CFR 0.152.
 */
package org.httpobjects.jetty;

import java.io.IOException;
import junit.framework.Assert;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.httpobjects.HttpObject;
import org.httpobjects.Representation;
import org.httpobjects.Request;
import org.httpobjects.Response;
import org.httpobjects.header.DefaultHeaderFieldVisitor;
import org.httpobjects.header.HeaderField;
import org.httpobjects.header.HeaderFieldVisitor;
import org.httpobjects.header.request.AuthorizationField;
import org.httpobjects.header.request.Cookie;
import org.httpobjects.header.request.CookieField;
import org.httpobjects.header.request.credentials.BasicCredentials;
import org.httpobjects.header.response.LocationField;
import org.httpobjects.header.response.WWWAuthenticateField;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class IntegrationTest {
    protected abstract void serve(int var1, HttpObject ... var2);

    protected abstract void stopServing();

    @Before
    public void setup() {
        this.serve(8080, new HttpObject("/app/inbox"){

            public Response post(Request req) {
                return 1.OK((Representation)1.Text((String)"Message Received"), (HeaderField[])new HeaderField[0]);
            }
        }, new HttpObject("/app/inbox/abc"){

            public Response put(Request req) {
                return 2.OK((Representation)req.representation(), (HeaderField[])new HeaderField[0]);
            }
        }, new HttpObject("/app"){

            public Response get(Request req) {
                return 3.OK((Representation)3.Text((String)"Welcome to the app"), (HeaderField[])new HeaderField[0]);
            }
        }, new HttpObject("/app/message"){

            public Response post(Request req) {
                return 4.SEE_OTHER((LocationField)4.Location((String)"/app"), (HeaderField[])new HeaderField[]{4.SetCookie((String)"name", (String)"frank")});
            }
        }, new HttpObject("/nothing", null){}, new HttpObject("/secure"){

            public Response get(Request req) {
                BasicCredentials creds;
                AuthorizationField authorization = req.header().authorization();
                if (authorization != null && authorization.method() == WWWAuthenticateField.Method.Basic && (creds = authorization.basicCredentials()).user().equals("Aladdin") && creds.password().equals("open sesame")) {
                    return 6.OK((Representation)6.Text((String)"You're In!"), (HeaderField[])new HeaderField[0]);
                }
                return 6.UNAUTHORIZED((WWWAuthenticateField)6.BasicAuthentication((String)"secure area"), (Representation)6.Text((String)"You must first log-in"));
            }
        }, new HttpObject("/echoCookies"){

            public Response get(Request req) {
                final StringBuffer text = new StringBuffer();
                for (HeaderField next : req.header().fields()) {
                    next.accept((HeaderFieldVisitor)new DefaultHeaderFieldVisitor<Void>(){

                        public Void visit(CookieField cookieField) {
                            for (Cookie cookie : cookieField.cookies()) {
                                text.append(cookie.name + "=" + cookie.value);
                            }
                            return null;
                        }
                    });
                }
                return 7.OK((Representation)7.Text((String)text.toString()), (HeaderField[])new HeaderField[0]);
            }
        });
    }

    @Test
    public void requestCookiesAreTranslated() {
        GetMethod get = new GetMethod("http://localhost:8080/echoCookies");
        get.setRequestHeader("Cookie", "Larry=Moe");
        this.assertResource((HttpMethod)get, "Larry=Moe", 200, new HeaderSpec[0]);
    }

    @Test
    public void basicAuthentication() {
        this.assertResource((HttpMethod)new GetMethod("http://localhost:8080/secure"), "You must first log-in", 401, new HeaderSpec("WWW-Authenticate", "Basic realm=secure area"));
        GetMethod get = new GetMethod("http://localhost:8080/secure");
        get.setRequestHeader("Authorization", "Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        this.assertResource((HttpMethod)get, "You're In!", 200, new HeaderSpec[0]);
    }

    @Test
    public void nullResponsesAreTreatedAsNotFound() {
        this.assertResource((HttpMethod)new GetMethod("http://localhost:8080/nothing"), 404, new HeaderSpec[0]);
    }

    @Test
    public void returnsNotFoundIfThereIsNoMatchingPattern() {
        this.assertResource((HttpMethod)new GetMethod("http://localhost:8080/bob"), 404, new HeaderSpec[0]);
    }

    @Test
    public void happyPathForGet() {
        this.assertResource((HttpMethod)new GetMethod("http://localhost:8080/app"), "Welcome to the app", 200, new HeaderSpec[0]);
    }

    @Test
    public void happyPathForPost() {
        this.assertResource((HttpMethod)new PostMethod("http://localhost:8080/app/inbox"), "Message Received", 200, new HeaderSpec[0]);
    }

    @Test
    public void happyPathForPut() {
        this.assertResource((HttpMethod)IntegrationTest.withBody(new PutMethod("http://localhost:8080/app/inbox/abc"), "hello world"), "hello world", 200, new HeaderSpec[0]);
    }

    @Test
    public void methodNotAllowed() {
        this.assertResource((HttpMethod)new GetMethod("http://localhost:8080/app/inbox"), "Error: Method not allowed.", 405, new HeaderSpec[0]);
    }

    @Test
    public void redirectsAndSetsCookies() {
        this.assertResource((HttpMethod)new PostMethod("http://localhost:8080/app/message"), 303, new HeaderSpec("Location", "/app"), new HeaderSpec("Set-Cookie", "name=frank"));
    }

    private static <T extends EntityEnclosingMethod> T withBody(T m, String body) {
        m.setRequestBody(body);
        return m;
    }

    private void assertResource(HttpMethod method, int expectedResponseCode, HeaderSpec ... header) {
        this.assertResource(method, null, expectedResponseCode, header);
    }

    private void assertResource(HttpMethod method, String expectedBody, int expectedResponseCode, HeaderSpec ... header) {
        try {
            HttpClient client = new HttpClient();
            int response = client.executeMethod(method);
            Assert.assertEquals((int)expectedResponseCode, (int)response);
            if (expectedBody != null) {
                Assert.assertEquals((String)expectedBody, (String)method.getResponseBodyAsString());
            }
            if (header != null) {
                for (HeaderSpec next : header) {
                    Header h = method.getResponseHeader(next.name);
                    Assert.assertNotNull((String)("Expected a \"" + next.name + "\" value of \"" + next.value + "\""), (Object)h);
                    Assert.assertEquals((String)next.value, (String)h.getValue());
                }
            }
        }
        catch (HttpException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @After
    public void tearDown() throws Exception {
        this.stopServing();
    }

    private class HeaderSpec {
        final String name;
        final String value;

        private HeaderSpec(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

