/*
 * Decompiled with CFR 0.152.
 */
package org.httpobjects.tck;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.httpobjects.ConnectionInfo;
import org.httpobjects.HttpObject;
import org.httpobjects.Query;
import org.httpobjects.Representation;
import org.httpobjects.Request;
import org.httpobjects.Response;
import org.httpobjects.header.DefaultHeaderFieldVisitor;
import org.httpobjects.header.GenericHeaderField;
import org.httpobjects.header.HeaderField;
import org.httpobjects.header.HeaderFieldVisitor;
import org.httpobjects.header.request.AuthorizationField;
import org.httpobjects.header.request.Cookie;
import org.httpobjects.header.request.CookieField;
import org.httpobjects.header.request.credentials.BasicCredentials;
import org.httpobjects.header.response.LocationField;
import org.httpobjects.header.response.SetCookieField;
import org.httpobjects.header.response.WWWAuthenticateField;
import org.httpobjects.path.Path;
import org.httpobjects.util.HttpObjectUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class IntegrationTest {
    protected abstract void serve(int var1, HttpObject ... var2);

    protected abstract void stopServing();

    @Before
    public void setup() {
        this.serve(8080, new HttpObject("/app/inbox"){

            public Response post(Request req) {
                return 1.OK((Representation)1.Text((String)"Message Received"), (HeaderField[])new HeaderField[0]);
            }
        }, new HttpObject("/app/inbox/abc"){

            public Response put(Request req) {
                return 2.OK((Representation)req.representation(), (HeaderField[])new HeaderField[0]);
            }
        }, new HttpObject("/app"){

            public Response get(Request req) {
                return 3.OK((Representation)3.Text((String)"Welcome to the app"), (HeaderField[])new HeaderField[0]);
            }
        }, new HttpObject("/app/message"){

            public Response post(Request req) {
                return 4.SEE_OTHER((LocationField)4.Location((String)"/app"), (HeaderField[])new HeaderField[]{4.SetCookie((String)"name", (String)"frank")});
            }
        }, new HttpObject("/nothing", null){}, new HttpObject("/secure"){

            public Response get(Request req) {
                BasicCredentials creds;
                AuthorizationField authorization = req.header().authorization();
                if (authorization != null && authorization.method() == WWWAuthenticateField.Method.Basic && (creds = authorization.basicCredentials()).user().equals("Aladdin") && creds.password().equals("open sesame")) {
                    return 6.OK((Representation)6.Text((String)"You're In!"), (HeaderField[])new HeaderField[0]);
                }
                return 6.UNAUTHORIZED((WWWAuthenticateField)6.BasicAuthentication((String)"secure area"), (Representation)6.Text((String)"You must first log-in"));
            }
        }, new HttpObject("/echoUrl/{id}/{name}"){

            public Response get(Request req) {
                try {
                    String query = req.query().toString();
                    return 7.OK((Representation)7.Text((String)(req.path().toString() + query)), (HeaderField[])new HeaderField[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 7.INTERNAL_SERVER_ERROR((Throwable)e);
                }
            }
        }, new HttpObject("/echoQuery"){

            public Response get(Request req) {
                StringBuffer text = new StringBuffer();
                Query query = req.query();
                for (String name : query.paramNames()) {
                    if (text.length() > 0) {
                        text.append('\n');
                    }
                    text.append(name + "=" + query.valueFor(name));
                }
                return 8.OK((Representation)8.Text((String)text.toString()), (HeaderField[])new HeaderField[0]);
            }
        }, new HttpObject("/echoCookies"){

            public Response get(Request req) {
                final StringBuffer text = new StringBuffer();
                for (HeaderField next : req.header().fields()) {
                    next.accept((HeaderFieldVisitor)new DefaultHeaderFieldVisitor<Void>(){

                        public Void visit(CookieField cookieField) {
                            for (Cookie cookie : cookieField.cookies()) {
                                text.append(cookie.name + "=" + cookie.value);
                            }
                            return null;
                        }
                    });
                }
                return 9.OK((Representation)9.Text((String)text.toString()), (HeaderField[])new HeaderField[0]);
            }
        }, new HttpObject("/cookieSetter"){

            public Response get(Request req) {
                return 10.OK((Representation)10.Text((String)"Here are some cookies!"), (HeaderField[])new HeaderField[]{new SetCookieField("name", "cookie monster", "sesamestreet.com"), new SetCookieField("specialGuest", "mr rogers", "mrrogers.com", "/myNeighborhood", "Wed, 13-Jan-2021 22:23:01 GMT", Boolean.valueOf(true)), new SetCookieField("oldInsecureCookie", "yes", "the90sIntranet.com", "/images/animatedGifs", "Wed, 13-Jan-1999 22:23:01 GMT", Boolean.valueOf(false))});
            }
        }, new HttpObject("/subpathEcho/{subPath*}"){

            public Response get(Request req) {
                return 11.OK((Representation)11.Text((String)req.path().valueFor("subPath")), (HeaderField[])new HeaderField[0]);
            }
        }, new HttpObject("/echoHasRepresentation"){

            public Response post(Request req) {
                return 12.OK((Representation)12.Text((String)(req.hasRepresentation() ? "yes" : "no")), (HeaderField[])new HeaderField[0]);
            }
        }, new HttpObject("/pows/{name}/{rank}/{serialnumber}"){

            public Response get(Request req) {
                Path path = req.path();
                return 13.OK((Representation)13.Text((String)(path.valueFor("rank") + " " + path.valueFor("name") + ", " + path.valueFor("serialnumber"))), (HeaderField[])new HeaderField[0]);
            }
        }, new HttpObject("/immutablecopy/{subpath*}"){

            public Response post(Request req) {
                Request r = req.immutableCopy();
                String firstPass = this.toString(r);
                String secondPass = this.toString(r);
                return 14.OK((Representation)14.Text((String)secondPass), (HeaderField[])new HeaderField[0]);
            }

            private <T> List<T> sorted(List<T> items, Comparator<T> comparator) {
                ArrayList<T> sorted = new ArrayList<T>(items);
                Collections.sort(sorted, comparator);
                return sorted;
            }

            private String toString(Request r) {
                return "URI: " + r.path().toString() + "?" + r.query().toString() + "\n" + this.toString(r.header().fields()) + HttpObjectUtil.toAscii((Representation)r.representation());
            }

            private String toString(List<HeaderField> fields) {
                StringBuffer text = new StringBuffer();
                for (HeaderField field : this.sorted(fields, new HeadersByName())) {
                    text.append(field.name() + "=" + field.value() + "\n");
                }
                return text.toString();
            }

            class HeadersByName
            implements Comparator<HeaderField> {
                HeadersByName() {
                }

                @Override
                public int compare(HeaderField o1, HeaderField o2) {
                    return o1.name().compareTo(o2.name());
                }
            }
        }, new HttpObject("/patchme"){

            public Response patch(Request req) {
                try {
                    String input = new String(HttpObjectUtil.toByteArray((Representation)req.representation()), "UTF-8");
                    return 15.OK((Representation)15.Text((String)("You told me to patch!" + input)), (HeaderField[])new HeaderField[0]);
                }
                catch (UnsupportedEncodingException e) {
                    return 15.INTERNAL_SERVER_ERROR((Throwable)e);
                }
            }
        }, new HttpObject("/connectionInfo"){

            public Response get(Request req) {
                ConnectionInfo connection = req.connectionInfo();
                return 16.OK((Representation)16.Text((String)("Local " + connection.localAddress + ":" + connection.localPort + ", " + "Remote " + connection.remoteAddress + ":" + connection.remotePort)), (HeaderField[])new HeaderField[0]);
            }
        }, new HttpObject("/head"){

            public Response head(Request req) {
                return 17.OK((Representation)17.Text((String)""), (HeaderField[])new HeaderField[]{new GenericHeaderField("foo", "bar")});
            }
        }, new HttpObject("/options"){

            public Response options(Request req) {
                return 18.OK((Representation)18.Text((String)""), (HeaderField[])new HeaderField[]{new GenericHeaderField("foo", "bar")});
            }
        });
    }

    @Test
    public void supportsHead() throws Exception {
        HttpClient client = new HttpClient();
        HeadMethod request = new HeadMethod("http://127.0.0.2:8080/head");
        int responseCode = client.executeMethod((HttpMethod)request);
        Assert.assertEquals((long)200L, (long)responseCode);
        Assert.assertEquals((Object)"bar", (Object)request.getResponseHeader("foo").getValue());
    }

    @Test
    public void supportsOptions() throws Exception {
        HttpClient client = new HttpClient();
        OptionsMethod request = new OptionsMethod("http://127.0.0.2:8080/options");
        int responseCode = client.executeMethod((HttpMethod)request);
        Assert.assertEquals((long)200L, (long)responseCode);
        Assert.assertEquals((Object)"bar", (Object)request.getResponseHeader("foo").getValue());
    }

    @Test
    public void returnsConnectionInfo() throws Exception {
        String url = "http://127.0.0.2:8080/connectionInfo";
        String result = this.getFrom("127.0.0.3", url);
        Pattern expectedPattern = Pattern.compile("Local 127.0.0.2:8080, Remote 127.0.0.3:([0-9].*)");
        Assert.assertTrue((String)("'" + result + " should match '" + expectedPattern), (boolean)expectedPattern.matcher(result).matches());
    }

    @Test
    public void hasRepresentation() throws Exception {
        PostMethod request = new PostMethod("http://localhost:8080/echoHasRepresentation");
        request.setRequestEntity((RequestEntity)new StringRequestEntity("foo bar", "text/plain", "UTF-8"));
        this.assertResource((HttpMethod)request, "yes", 200, new HeaderSpec[0]);
    }

    @Test
    public void immutableCopies() throws Exception {
        PostMethod request = new PostMethod("http://localhost:8080/immutablecopy/no/mutation/allowed");
        request.setRequestEntity((RequestEntity)new StringRequestEntity("foo bar", "text/plain", "UTF-8"));
        this.assertResource((HttpMethod)request, "URI: /immutablecopy/no/mutation/allowed?\nContent-Length=7\nContent-Type=text/plain; charset=UTF-8\nHost=localhost:8080\nUser-Agent=Jakarta Commons-HttpClient/3.1\nfoo bar", 200, new HeaderSpec[0]);
    }

    @Test
    public void parsesPathVars() throws Exception {
        GetMethod request = new GetMethod("http://localhost:8080/pows/marty/private/abc123");
        this.assertResource((HttpMethod)request, "private marty, abc123", 200, new HeaderSpec[0]);
    }

    @Test
    public void parsesSubpaths() throws Exception {
        GetMethod request = new GetMethod("http://localhost:8080/subpathEcho/i/am/my/own/grandpa");
        this.assertResource((HttpMethod)request, "i/am/my/own/grandpa", 200, new HeaderSpec[0]);
    }

    @Test
    public void supportsPatch() throws Exception {
        PatchMethod request = new PatchMethod("http://localhost:8080/patchme");
        request.setRequestEntity((RequestEntity)new StringRequestEntity(" foo bar", "text/plain", "UTF-8"));
        this.assertResource((HttpMethod)request, "You told me to patch! foo bar", 200, new HeaderSpec[0]);
    }

    @Test
    public void setCookieHeadersAreTranslated() throws Exception {
        GetMethod request = new GetMethod("http://localhost:8080/cookieSetter");
        HttpClient client = new HttpClient();
        int response = client.executeMethod((HttpMethod)request);
        Assert.assertEquals((long)200L, (long)response);
        List<Header> setCookies = this.sortByValue(Arrays.asList(request.getResponseHeaders("Set-Cookie")));
        Assert.assertEquals((long)3L, (long)setCookies.size());
        String value = setCookies.get(0).getValue();
        SetCookieField cookie = SetCookieField.fromHeaderValue((String)value);
        Assert.assertEquals((Object)"name", (Object)cookie.name);
        Assert.assertEquals((Object)"cookie monster", (Object)cookie.value);
        Assert.assertEquals((Object)"sesamestreet.com", (Object)cookie.domain);
        value = setCookies.get(1).getValue();
        cookie = SetCookieField.fromHeaderValue((String)value);
        Assert.assertEquals((Object)"oldInsecureCookie", (Object)cookie.name);
        Assert.assertEquals((Object)"yes", (Object)cookie.value);
        Assert.assertEquals((Object)"the90sintranet.com", (Object)cookie.domain.toLowerCase());
        Assert.assertEquals((Object)"/images/animatedGifs", (Object)cookie.path);
        Assert.assertEquals(null, (Object)cookie.secure);
        value = setCookies.get(2).getValue();
        cookie = SetCookieField.fromHeaderValue((String)value);
        Assert.assertEquals((Object)"specialGuest", (Object)cookie.name);
        Assert.assertEquals((Object)"mr rogers", (Object)cookie.value);
        Assert.assertEquals((Object)"mrrogers.com", (Object)cookie.domain);
        Assert.assertEquals((Object)"/myNeighborhood", (Object)cookie.path);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)cookie.secure);
    }

    private List<Header> sortByValue(List<Header> cookies) {
        ArrayList<Header> result = new ArrayList<Header>(cookies);
        Collections.sort(result, new Comparator<Header>(){

            @Override
            public int compare(Header o1, Header o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        return result;
    }

    @Test
    public void requestCookiesAreTranslated() throws Exception {
        GetMethod get = new GetMethod("http://localhost:8080/echoCookies");
        get.setRequestHeader("Cookie", "Larry=Moe");
        this.assertResource((HttpMethod)get, "Larry=Moe", 200, new HeaderSpec[0]);
    }

    @Test
    public void basicAuthentication() {
        this.assertResource((HttpMethod)new GetMethod("http://localhost:8080/secure"), "You must first log-in", 401, new HeaderSpec("WWW-Authenticate", "Basic realm=secure area"));
        GetMethod get = new GetMethod("http://localhost:8080/secure");
        get.setRequestHeader("Authorization", "Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        this.assertResource((HttpMethod)get, "You're In!", 200, new HeaderSpec[0]);
    }

    @Test
    public void nullResponsesAreTreatedAsNotFound() {
        this.assertResource((HttpMethod)new GetMethod("http://localhost:8080/nothing"), 404, new HeaderSpec[0]);
    }

    @Test
    public void returnsNotFoundIfThereIsNoMatchingPattern() {
        this.assertResource((HttpMethod)new GetMethod("http://localhost:8080/bob"), 404, new HeaderSpec[0]);
    }

    @Test
    public void happyPathForGet() {
        this.assertResource((HttpMethod)new GetMethod("http://localhost:8080/app"), "Welcome to the app", 200, new HeaderSpec[0]);
    }

    @Test
    public void happyPathForPost() {
        this.assertResource((HttpMethod)new PostMethod("http://localhost:8080/app/inbox"), "Message Received", 200, new HeaderSpec[0]);
    }

    @Test
    public void happyPathForPut() {
        this.assertResource((HttpMethod)IntegrationTest.withBody(new PutMethod("http://localhost:8080/app/inbox/abc"), "hello world"), "hello world", 200, new HeaderSpec[0]);
    }

    @Test
    public void queryParameters() {
        this.assertResource((HttpMethod)new GetMethod("http://localhost:8080/echoQuery?a=1&b=2"), "a=1\nb=2", 200, new HeaderSpec[0]);
    }

    @Test
    public void urlToString() {
        this.assertResource((HttpMethod)new GetMethod("http://localhost:8080/echoUrl/34/marty?a=1&b=2"), "/echoUrl/34/marty?a=1&b=2", 200, new HeaderSpec[0]);
        this.assertResource((HttpMethod)new GetMethod("http://localhost:8080/echoUrl/44/foo"), "/echoUrl/44/foo", 200, new HeaderSpec[0]);
    }

    @Test
    public void methodNotAllowed() {
        this.assertResource((HttpMethod)new GetMethod("http://localhost:8080/app/inbox"), "405 Client Error: Method Not Allowed", 405, new HeaderSpec[0]);
    }

    @Test
    public void redirectsAndSetsCookies() {
        this.assertResource((HttpMethod)new PostMethod("http://localhost:8080/app/message"), 303, new HeaderSpec("Location", "/app"), new HeaderSpec("Set-Cookie", "name=frank"));
    }

    private static <T extends EntityEnclosingMethod> T withBody(T m, String body) {
        m.setRequestBody(body);
        return m;
    }

    private void assertResource(HttpMethod method, int expectedResponseCode, HeaderSpec ... header) {
        this.assertResource(method, null, expectedResponseCode, header);
    }

    private void assertResource(HttpMethod method, String expectedBody, int expectedResponseCode, HeaderSpec ... header) {
        try {
            HttpClient client = new HttpClient();
            int response = client.executeMethod(method);
            Assert.assertEquals((long)expectedResponseCode, (long)response);
            if (expectedBody != null) {
                Assert.assertEquals((Object)expectedBody, (Object)method.getResponseBodyAsString());
            }
            if (header != null) {
                for (HeaderSpec next : header) {
                    Header h = method.getResponseHeader(next.name);
                    Assert.assertNotNull((String)("Expected a \"" + next.name + "\" value of \"" + next.value + "\""), (Object)h);
                    Assert.assertEquals((Object)next.value, (Object)h.getValue());
                }
            }
        }
        catch (HttpException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getFrom(String address, String url) {
        try {
            HttpClient client = new HttpClient();
            client.getHostConfiguration().setLocalAddress(InetAddress.getByName(address));
            GetMethod request = new GetMethod(url);
            int responseCode = client.executeMethod((HttpMethod)request);
            String result = request.getResponseBodyAsString();
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String get(String url) throws IOException, HttpException {
        HttpClient client = new HttpClient();
        GetMethod request = new GetMethod(url);
        int responseCode = client.executeMethod((HttpMethod)request);
        String result = request.getResponseBodyAsString();
        return result;
    }

    @After
    public void tearDown() throws Exception {
        this.stopServing();
    }

    private class HeaderSpec {
        final String name;
        final String value;

        private HeaderSpec(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    class PatchMethod
    extends EntityEnclosingMethod {
        public PatchMethod(String uri) {
            super(uri);
        }

        public String getName() {
            return "PATCH";
        }
    }
}

