/*
 * Decompiled with CFR 0.152.
 */
package org.httprpc.kilo;

import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.ResourceBundle;
import org.httprpc.kilo.WebService;
import org.httprpc.kilo.beans.BeanAdapter;
import org.httprpc.kilo.io.JSONEncoder;
import org.httprpc.kilo.io.TemplateEncoder;
import org.httprpc.kilo.util.Collections;
import org.httprpc.kilo.util.ResourceBundleAdapter;

public class IndexServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Object serviceDescriptors = BeanAdapter.adapt(WebService.getServiceDescriptors());
        String accept = request.getHeader("Accept");
        if (accept != null && accept.equalsIgnoreCase("application/json")) {
            response.setContentType("application/json;charset=UTF-8");
            JSONEncoder jsonEncoder = new JSONEncoder();
            jsonEncoder.write(serviceDescriptors, (OutputStream)response.getOutputStream());
        } else {
            response.setContentType("text/html;charset=UTF-8");
            TemplateEncoder templateEncoder = new TemplateEncoder(WebService.class.getResource("index.html"));
            ResourceBundle resourceBundle = ResourceBundle.getBundle(WebService.class.getPackage().getName() + ".index", request.getLocale());
            templateEncoder.write((Object)Collections.mapOf((Map.Entry[])new Map.Entry[]{Collections.entry((Object)"labels", (Object)new ResourceBundleAdapter(resourceBundle)), Collections.entry((Object)"contextPath", (Object)request.getContextPath()), Collections.entry((Object)"services", (Object)serviceDescriptors)}), (OutputStream)response.getOutputStream());
        }
    }
}

