/*
 * Decompiled with CFR 0.152.
 */
package org.httprpc.kilo;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import org.httprpc.kilo.Content;
import org.httprpc.kilo.Description;
import org.httprpc.kilo.Internal;
import org.httprpc.kilo.Keys;
import org.httprpc.kilo.RequestMethod;
import org.httprpc.kilo.Required;
import org.httprpc.kilo.ResourcePath;
import org.httprpc.kilo.beans.BeanAdapter;
import org.httprpc.kilo.io.JSONDecoder;
import org.httprpc.kilo.io.JSONEncoder;
import org.httprpc.kilo.io.TemplateEncoder;
import org.httprpc.kilo.util.Collections;
import org.httprpc.kilo.util.Optionals;

public abstract class WebService
extends HttpServlet {
    private Resource root = null;
    private ThreadLocal<HttpServletRequest> request = new ThreadLocal();
    private ThreadLocal<HttpServletResponse> response = new ThreadLocal();
    private ThreadLocal<List<String>> keyList = new ThreadLocal();
    private ThreadLocal<Map<String, String>> keyMap = new ThreadLocal();
    private ThreadLocal<Object> body = new ThreadLocal();
    private ServiceDescriptor serviceDescriptor = null;
    private static final Map<Class<? extends WebService>, WebService> instances = new HashMap<Class<? extends WebService>, WebService>();
    private static final String UTF_8 = "UTF-8";

    public static synchronized <T extends WebService> T getInstance(Class<T> type) {
        return (T)((Object)instances.get(type));
    }

    public static synchronized List<ServiceDescriptor> getServiceDescriptors() {
        return instances.values().stream().map(WebService::getServiceDescriptor).sorted(Comparator.comparing(ServiceDescriptor::getPath)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() throws ServletException {
        Class<?> type = ((Object)((Object)this)).getClass();
        WebServlet webServlet = type.getAnnotation(WebServlet.class);
        String[] urlPatterns = webServlet.urlPatterns();
        if (urlPatterns.length == 0) {
            throw new ServletException("At least one URL pattern is required.");
        }
        String path = urlPatterns[0];
        if (!path.startsWith("/") && (path.length() == 1 || path.endsWith("/*"))) {
            throw new ServletException("Invalid URL pattern.");
        }
        path = path.substring(0, path.length() - 2);
        this.root = new Resource();
        Method[] methods = ((Object)((Object)this)).getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String verb;
            List<Handler> handlerList;
            Method method = methods[i];
            RequestMethod requestMethod = method.getAnnotation(RequestMethod.class);
            if (requestMethod == null) continue;
            Handler handler = new Handler(method);
            Resource resource = this.root;
            ResourcePath resourcePath = method.getAnnotation(ResourcePath.class);
            if (resourcePath != null) {
                String[] components = resourcePath.value().split("/");
                for (int j = 0; j < components.length; ++j) {
                    Resource child;
                    String component = components[j];
                    if (component.length() == 0) continue;
                    if (component.startsWith("?")) {
                        String key;
                        int k = "?".length();
                        if (component.length() > k) {
                            if (component.charAt(k++) != ':') {
                                throw new ServletException("Invalid path variable.");
                            }
                            key = component.substring(k);
                            component = "?";
                        } else {
                            key = null;
                        }
                        handler.keys.add(key);
                    }
                    if ((child = resource.resources.get(component)) == null) {
                        child = new Resource();
                        resource.resources.put(component, child);
                    }
                    resource = child;
                }
            }
            if ((handlerList = resource.handlerMap.get(verb = requestMethod.value().toLowerCase())) == null) {
                handlerList = new LinkedList<Handler>();
                resource.handlerMap.put(verb, handlerList);
            }
            handlerList.add(handler);
        }
        WebService.sort(this.root);
        this.serviceDescriptor = new ServiceDescriptor(path, type);
        this.describeResource(path, this.root);
        if (((Object)((Object)this)).getClass().getAnnotation(WebServlet.class) == null) return;
        Class<WebService> clazz = WebService.class;
        synchronized (WebService.class) {
            instances.put(type, this);
            // ** MonitorExit[var6_7] (shouldn't be in output)
            return;
        }
    }

    private static void sort(Resource root) {
        for (List<Handler> handlers : root.handlerMap.values()) {
            Comparator<Handler> methodNameComparator = Comparator.comparing(handler -> handler.method.getName());
            Comparator<Handler> methodParameterCountComparator = Comparator.comparing(handler -> handler.method.getParameterCount());
            handlers.sort(methodNameComparator.thenComparing(methodParameterCountComparator.reversed()));
        }
        for (Resource resource : root.resources.values()) {
            WebService.sort(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object result;
        Object body;
        Object[] arguments;
        Handler handler;
        List<Handler> handlerList;
        String api;
        String verb = request.getMethod().toLowerCase();
        String pathInfo = request.getPathInfo();
        if (verb.equals("get") && pathInfo == null && (api = request.getParameter("api")) != null) {
            String accept = request.getHeader("Accept");
            if (accept != null && accept.equalsIgnoreCase("application/json")) {
                response.setContentType(String.format("application/json;charset=%s", UTF_8));
                JSONEncoder jsonEncoder = new JSONEncoder();
                jsonEncoder.write((Object)new BeanAdapter((Object)this.serviceDescriptor), (OutputStream)response.getOutputStream());
            } else {
                response.setContentType(String.format("text/html;charset=%s", UTF_8));
                URL url = WebService.class.getResource("api.html");
                ResourceBundle resourceBundle = ResourceBundle.getBundle(WebService.class.getName(), request.getLocale());
                TemplateEncoder templateEncoder = new TemplateEncoder(url, resourceBundle);
                templateEncoder.write((Object)Collections.mapOf((Map.Entry[])new Map.Entry[]{Collections.entry((Object)"contextPath", (Object)request.getContextPath()), Collections.entry((Object)"service", (Object)new BeanAdapter((Object)this.serviceDescriptor))}), (OutputStream)response.getOutputStream());
            }
            response.flushBuffer();
            return;
        }
        Resource resource = this.root;
        ArrayList<String> keyList = new ArrayList<String>();
        if (pathInfo != null) {
            String[] components = pathInfo.split("/");
            for (int i = 0; i < components.length; ++i) {
                String component = components[i];
                if (component.length() == 0) continue;
                Resource child = resource.resources.get(component);
                if (child == null) {
                    child = resource.resources.get("?");
                    if (child == null) {
                        super.service(request, response);
                        return;
                    }
                    keyList.add(component);
                }
                resource = child;
            }
        }
        if ((handlerList = resource.handlerMap.get(verb)) == null) {
            super.service(request, response);
            return;
        }
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding(UTF_8);
        }
        HashMap parameterMap = new HashMap();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            parameterMap.put(name, Arrays.asList(request.getParameterValues(name)));
        }
        String contentType = request.getContentType();
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            for (Part part : request.getParts()) {
                String submittedFileName = part.getSubmittedFileName();
                if (submittedFileName == null || submittedFileName.length() == 0) continue;
                String name = part.getName();
                ArrayList<URL> values = (ArrayList<URL>)parameterMap.get(name);
                if (values == null) {
                    values = new ArrayList<URL>();
                    parameterMap.put(name, values);
                }
                values.add(new URL("part", null, -1, submittedFileName, new PartURLStreamHandler(part)));
            }
        }
        if ((handler = WebService.getHandler(handlerList, parameterMap)) == null) {
            response.setStatus(405);
            return;
        }
        if (!this.isAuthorized(request, handler.method)) {
            response.setStatus(403);
            return;
        }
        HashMap<String, String> keyMap = new HashMap<String, String>();
        int n = keyList.size();
        for (int i = 0; i < n; ++i) {
            String key = handler.keys.get(i);
            if (key == null) continue;
            keyMap.put(key, (String)keyList.get(i));
        }
        try {
            arguments = WebService.getArguments(handler.method, parameterMap);
        }
        catch (Exception exception) {
            this.sendError(response, 403, exception);
            return;
        }
        Content content = handler.method.getAnnotation(Content.class);
        if (content != null) {
            Class<?> type = content.type();
            if (type.getTypeParameters().length > 0) {
                throw new ServletException("Unsupported content type.");
            }
            try {
                body = this.decodeBody(request, type, content.multiple());
            }
            catch (Exception exception) {
                this.sendError(response, 400, exception);
                return;
            }
            if (body == null) {
                response.setStatus(403);
                return;
            }
        } else {
            body = null;
        }
        this.request.set(request);
        this.response.set(response);
        this.keyList.set(keyList);
        this.keyMap.set(keyMap);
        this.body.set(body);
        try {
            result = handler.method.invoke((Object)this, arguments);
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            if (response.isCommitted()) {
                throw new ServletException((Throwable)exception);
            }
            Throwable cause = exception.getCause();
            if (cause == null) {
                throw new ServletException((Throwable)exception);
            }
            int status = cause instanceof IllegalArgumentException || cause instanceof UnsupportedOperationException ? 403 : (cause instanceof NoSuchElementException ? 404 : (cause instanceof IllegalStateException ? 409 : 500));
            this.sendError(response, status, cause);
            return;
        }
        finally {
            this.request.remove();
            this.response.remove();
            this.keyList.remove();
            this.keyMap.remove();
            this.body.remove();
        }
        if (response.isCommitted()) {
            return;
        }
        Class<?> returnType = handler.method.getReturnType();
        if (returnType == Void.TYPE || returnType == Void.class) {
            response.setStatus(204);
        } else if (result == null) {
            response.setStatus(404);
        } else {
            this.encodeResult(request, response, result);
        }
    }

    private static Handler getHandler(List<Handler> handlerList, Map<String, List<?>> parameterMap) {
        Handler handler = null;
        int n = parameterMap.size();
        int i = Integer.MAX_VALUE;
        for (Handler option : handlerList) {
            Parameter[] parameters = option.method.getParameters();
            if (parameters.length < n) continue;
            int j = 0;
            for (int k = 0; k < parameters.length; ++k) {
                String name = parameters[k].getName();
                if (parameterMap.containsKey(name)) continue;
                ++j;
            }
            if (parameters.length - j != n || j >= i) continue;
            handler = option;
            i = j;
        }
        return handler;
    }

    private static Object[] getArguments(Method method, Map<String, List<?>> parameterMap) {
        Parameter[] parameters = method.getParameters();
        Object[] arguments = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Object argument;
            Parameter parameter = parameters[i];
            String name = parameter.getName();
            Class<?> type = parameter.getType();
            List<?> values = parameterMap.get(name);
            if (type == List.class) {
                List list;
                if (values != null) {
                    Type elementType = ((ParameterizedType)parameter.getParameterizedType()).getActualTypeArguments()[0];
                    list = (List)BeanAdapter.coerce(values, List.class, (Type[])new Type[]{elementType});
                } else {
                    list = Collections.listOf((Object[])new Object[0]);
                }
                argument = list;
            } else {
                Object value = values != null ? values.get(values.size() - 1) : null;
                if (parameter.getAnnotation(Required.class) != null && value == null) {
                    throw new IllegalArgumentException(String.format("Parameter \"%s\" is required.", name));
                }
                argument = BeanAdapter.coerce(value, type, (Type[])new Type[0]);
            }
            arguments[i] = argument;
        }
        return arguments;
    }

    private void sendError(HttpServletResponse response, int status, Throwable cause) throws IOException {
        response.setStatus(status);
        String message = cause.getMessage();
        if (message != null) {
            response.setContentType(String.format("text/plain;charset=%s", UTF_8));
            response.getWriter().append(message);
            response.flushBuffer();
        }
    }

    protected HttpServletRequest getRequest() {
        return this.request.get();
    }

    protected HttpServletResponse getResponse() {
        return this.response.get();
    }

    protected String getKey(int index) {
        return this.getKey(index, String.class);
    }

    protected <T> T getKey(int index, Class<T> type) {
        return (T)BeanAdapter.coerce((Object)this.keyList.get().get(index), type, (Type[])new Type[0]);
    }

    protected String getKey(String name) {
        return this.getKey(name, String.class);
    }

    protected <T> T getKey(String name, Class<T> type) {
        return (T)BeanAdapter.coerce((Object)this.keyMap.get().get(name), type, (Type[])new Type[0]);
    }

    protected Object getBody() {
        return this.body.get();
    }

    protected boolean isAuthorized(HttpServletRequest request, Method method) {
        return true;
    }

    protected Object decodeBody(HttpServletRequest request, Class<?> type, boolean multiple) throws IOException {
        JSONDecoder jsonDecoder = new JSONDecoder();
        Object body = jsonDecoder.read((InputStream)request.getInputStream());
        if (multiple) {
            return BeanAdapter.coerce((Object)body, List.class, (Type[])new Type[]{type});
        }
        return BeanAdapter.coerce((Object)body, type, (Type[])new Type[0]);
    }

    protected void encodeResult(HttpServletRequest request, HttpServletResponse response, Object result) throws IOException {
        response.setContentType(String.format("application/json;charset=%s", UTF_8));
        JSONEncoder jsonEncoder = new JSONEncoder(this.isCompact());
        jsonEncoder.write(BeanAdapter.adapt((Object)result), (OutputStream)response.getOutputStream());
    }

    protected boolean isCompact() {
        return false;
    }

    public ServiceDescriptor getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    private void describeResource(String path, Resource resource) {
        if (!resource.handlerMap.isEmpty()) {
            EndpointDescriptor endpoint = new EndpointDescriptor(path);
            for (Map.Entry<String, List<Handler>> entry : resource.handlerMap.entrySet()) {
                for (Handler handler : entry.getValue()) {
                    OperationDescriptor operation = new OperationDescriptor(entry.getKey().toUpperCase(), handler);
                    operation.internal |= this.serviceDescriptor.internal;
                    operation.deprecated |= this.serviceDescriptor.deprecated;
                    Content content = handler.method.getAnnotation(Content.class);
                    if (content != null) {
                        operation.consumes = content.multiple() ? this.describeType(BeanAdapter.typeOf(List.class, (Type[])new Type[]{content.type()})) : this.describeType(content.type());
                    }
                    operation.produces = this.describeType(handler.method.getGenericReturnType());
                    Parameter[] parameters = handler.method.getParameters();
                    for (int i = 0; i < parameters.length; ++i) {
                        Parameter parameter = parameters[i];
                        VariableDescriptor parameterDescriptor = new VariableDescriptor(parameter);
                        parameterDescriptor.type = this.describeType(parameter.getParameterizedType());
                        operation.parameters.add(parameterDescriptor);
                    }
                    endpoint.operations.add(operation);
                }
            }
            this.serviceDescriptor.endpoints.add(endpoint);
        }
        for (Map.Entry<String, Resource> entry : resource.resources.entrySet()) {
            this.describeResource(path + "/" + entry.getKey(), entry.getValue());
        }
    }

    private TypeDescriptor describeType(Type type) {
        if (type instanceof Class) {
            return this.describeType((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (rawType instanceof Class && Iterable.class.isAssignableFrom((Class)rawType)) {
                return new IterableTypeDescriptor(this.describeType(actualTypeArguments[0]));
            }
            if (rawType == Map.class) {
                return new MapTypeDescriptor(this.describeType(actualTypeArguments[0]), this.describeType(actualTypeArguments[1]));
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    private TypeDescriptor describeType(Class<?> type) {
        block12: {
            block11: {
                if (type.isArray()) {
                    throw new IllegalArgumentException();
                }
                if (type.isPrimitive() || type == Object.class || type == Boolean.class || Number.class.isAssignableFrom(type) || CharSequence.class.isAssignableFrom(type) || type == Void.class || Date.class.isAssignableFrom(type) || type == Instant.class || type == LocalDate.class || type == LocalTime.class || type == LocalDateTime.class || type == Duration.class || type == Period.class || type == UUID.class || type == URL.class) {
                    return new TypeDescriptor(type, true);
                }
                if (Iterable.class.isAssignableFrom(type)) {
                    return this.describeType(BeanAdapter.typeOf(Iterable.class, (Type[])new Type[]{Object.class}));
                }
                if (Map.class.isAssignableFrom(type)) {
                    return this.describeType(BeanAdapter.typeOf(Map.class, (Type[])new Type[]{Object.class, Object.class}));
                }
                if (!type.isEnum()) break block11;
                EnumerationDescriptor enumeration = this.serviceDescriptor.enumerations.get(type);
                if (enumeration != null) break block12;
                enumeration = new EnumerationDescriptor(type);
                this.serviceDescriptor.enumerations.put(type, enumeration);
                Field[] fields = type.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    if (!field.isEnumConstant()) continue;
                    enumeration.values.add(new ConstantDescriptor(field));
                }
                break block12;
            }
            StructureDescriptor structure = this.serviceDescriptor.structures.get(type);
            if (structure == null) {
                structure = new StructureDescriptor(type);
                this.serviceDescriptor.structures.put(type, structure);
                if (type.isInterface()) {
                    Class<?>[] interfaces = type.getInterfaces();
                    for (int i = 0; i < interfaces.length; ++i) {
                        structure.supertypes.add(this.describeType(interfaces[i]));
                    }
                } else {
                    Class<?> baseType = type.getSuperclass();
                    if (baseType != Object.class) {
                        structure.supertypes.add(this.describeType(baseType));
                    }
                }
                for (Map.Entry entry : BeanAdapter.getProperties(type).entrySet()) {
                    Method accessor = ((BeanAdapter.Property)entry.getValue()).getAccessor();
                    if (accessor == null || accessor.getDeclaringClass() != type) continue;
                    VariableDescriptor propertyDescriptor = new VariableDescriptor((String)entry.getKey(), accessor);
                    propertyDescriptor.type = this.describeType(accessor.getGenericReturnType());
                    structure.properties.add(propertyDescriptor);
                }
            }
        }
        return new TypeDescriptor(type, false);
    }

    private static String getTypeName(Class<?> type) {
        return type.getCanonicalName().substring(type.getPackageName().length() + 1);
    }

    private static class Resource {
        static List<String> order = Collections.listOf((Object[])new String[]{"get", "post", "put", "delete"});
        final Map<String, List<Handler>> handlerMap = new TreeMap<String, List<Handler>>((verb1, verb2) -> {
            int i1 = order.indexOf(verb1);
            int i2 = order.indexOf(verb2);
            return Integer.compare(i1 == -1 ? order.size() : i1, i2 == -1 ? order.size() : i2);
        });
        final Map<String, Resource> resources = new TreeMap<String, Resource>();

        private Resource() {
        }
    }

    public static class ServiceDescriptor {
        private String path;
        private String description;
        private boolean internal;
        private boolean deprecated;
        private List<EndpointDescriptor> endpoints = new LinkedList<EndpointDescriptor>();
        private Map<Class<?>, EnumerationDescriptor> enumerations = new TreeMap<Class, EnumerationDescriptor>(Comparator.comparing(x$0 -> WebService.getTypeName(x$0)));
        private Map<Class<?>, StructureDescriptor> structures = new TreeMap<Class, StructureDescriptor>(Comparator.comparing(x$0 -> WebService.getTypeName(x$0)));

        private ServiceDescriptor(String path, Class<? extends WebService> type) {
            this.path = path;
            this.description = (String)Optionals.map((Object)type.getAnnotation(Description.class), Description::value);
            this.internal = type.getAnnotation(Internal.class) != null;
            this.deprecated = type.getAnnotation(Deprecated.class) != null;
        }

        public String getPath() {
            return this.path;
        }

        public String getDescription() {
            return this.description;
        }

        public Iterable<EndpointDescriptor> getEndpoints() {
            return this.endpoints;
        }

        public Iterable<EnumerationDescriptor> getEnumerations() {
            return this.enumerations.values();
        }

        public Iterable<StructureDescriptor> getStructures() {
            return this.structures.values();
        }
    }

    private static class Handler {
        final Method method;
        final List<String> keys = new ArrayList<String>();

        Handler(Method method) {
            this.method = method;
        }
    }

    private static class PartURLStreamHandler
    extends URLStreamHandler {
        Part part;

        PartURLStreamHandler(Part part) {
            this.part = part;
        }

        @Override
        protected URLConnection openConnection(URL url) {
            return new PartURLConnection(url, this.part);
        }
    }

    public static class EndpointDescriptor {
        private String path;
        private List<OperationDescriptor> operations = new LinkedList<OperationDescriptor>();

        private EndpointDescriptor(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public Iterable<OperationDescriptor> getOperations() {
            return this.operations;
        }
    }

    public static class OperationDescriptor {
        private String method;
        private String description;
        private Iterable<String> keys;
        private boolean internal;
        private boolean deprecated;
        private TypeDescriptor consumes = null;
        private TypeDescriptor produces = null;
        private List<VariableDescriptor> parameters = new LinkedList<VariableDescriptor>();

        private OperationDescriptor(String method, Handler handler) {
            this.method = method;
            this.description = (String)Optionals.map((Object)handler.method.getAnnotation(Description.class), Description::value);
            this.keys = (Iterable)Optionals.map((Object)handler.method.getAnnotation(Keys.class), keys -> Arrays.asList(keys.value()));
            this.internal = handler.method.getAnnotation(Internal.class) != null;
            this.deprecated = handler.method.getAnnotation(Deprecated.class) != null;
        }

        public String getMethod() {
            return this.method;
        }

        public String getDescription() {
            return this.description;
        }

        public Iterable<String> getKeys() {
            return this.keys;
        }

        public boolean isInternal() {
            return this.internal;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public TypeDescriptor getConsumes() {
            return this.consumes;
        }

        public TypeDescriptor getProduces() {
            return this.produces;
        }

        public Iterable<VariableDescriptor> getParameters() {
            return this.parameters;
        }
    }

    public static class TypeDescriptor {
        private Class<?> type;
        private boolean intrinsic;

        private TypeDescriptor(Class<?> type, boolean intrinsic) {
            this.type = type;
            this.intrinsic = intrinsic;
        }

        public String getName() {
            if (this.type.isPrimitive()) {
                return this.type.getName();
            }
            return WebService.getTypeName(this.type);
        }

        public boolean isIntrinsic() {
            return this.intrinsic;
        }

        public boolean isIterable() {
            return false;
        }

        public TypeDescriptor getElementType() {
            return null;
        }

        public boolean isMap() {
            return false;
        }

        public TypeDescriptor getKeyType() {
            return null;
        }

        public TypeDescriptor getValueType() {
            return null;
        }
    }

    public static class VariableDescriptor {
        private String name;
        private boolean required;
        private String description;
        private TypeDescriptor type = null;

        private VariableDescriptor(Parameter parameter) {
            this.name = parameter.getName();
            this.required = parameter.getType() == List.class ? true : parameter.getAnnotation(Required.class) != null;
            this.description = (String)Optionals.map((Object)parameter.getAnnotation(Description.class), Description::value);
        }

        private VariableDescriptor(String name, Method accessor) {
            this.name = name;
            this.required = accessor.getAnnotation(Required.class) != null;
            this.description = (String)Optionals.map((Object)accessor.getAnnotation(Description.class), Description::value);
        }

        public String getName() {
            return this.name;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String getDescription() {
            return this.description;
        }

        public TypeDescriptor getType() {
            return this.type;
        }
    }

    public static class IterableTypeDescriptor
    extends TypeDescriptor {
        private TypeDescriptor elementType;

        private IterableTypeDescriptor(TypeDescriptor elementType) {
            super(Iterable.class, true);
            this.elementType = elementType;
        }

        @Override
        public boolean isIterable() {
            return true;
        }

        @Override
        public TypeDescriptor getElementType() {
            return this.elementType;
        }
    }

    public static class MapTypeDescriptor
    extends TypeDescriptor {
        private TypeDescriptor keyType;
        private TypeDescriptor valueType;

        private MapTypeDescriptor(TypeDescriptor keyType, TypeDescriptor valueType) {
            super(Map.class, true);
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        public boolean isMap() {
            return true;
        }

        @Override
        public TypeDescriptor getKeyType() {
            return this.keyType;
        }

        @Override
        public TypeDescriptor getValueType() {
            return this.valueType;
        }
    }

    public static class EnumerationDescriptor {
        private String name;
        private String description;
        private List<ConstantDescriptor> values = new LinkedList<ConstantDescriptor>();

        private EnumerationDescriptor(Class<?> type) {
            this.name = WebService.getTypeName(type);
            this.description = (String)Optionals.map((Object)type.getAnnotation(Description.class), Description::value);
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Iterable<ConstantDescriptor> getValues() {
            return this.values;
        }
    }

    public static class ConstantDescriptor {
        private String name;
        private String description;

        private ConstantDescriptor(Field field) {
            Object constant;
            try {
                constant = field.get(null);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
            this.name = constant.toString();
            this.description = (String)Optionals.map((Object)field.getAnnotation(Description.class), Description::value);
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class StructureDescriptor {
        private String name;
        private String description;
        private List<TypeDescriptor> supertypes = new LinkedList<TypeDescriptor>();
        private List<VariableDescriptor> properties = new LinkedList<VariableDescriptor>();

        private StructureDescriptor(Class<?> type) {
            this.name = WebService.getTypeName(type);
            this.description = (String)Optionals.map((Object)type.getAnnotation(Description.class), Description::value);
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Iterable<TypeDescriptor> getSupertypes() {
            return this.supertypes;
        }

        public Iterable<VariableDescriptor> getProperties() {
            return this.properties;
        }
    }

    private static class PartURLConnection
    extends URLConnection {
        Part part;

        PartURLConnection(URL url, Part part) {
            super(url);
            this.part = part;
        }

        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.part.getInputStream();
        }
    }
}

